/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.ICheckedOutResource;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IFile;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.CollectionImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.FileImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.IActivityContentMember;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.util.ResourceTypeProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityContent;
import com.tssap.dtr.client.lib.deltavlib.xcm.IClosedResource;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICreatedResource;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.io.InputStream;

class ActivityContent
implements IActivityContent {
    public static final IActivityContent EMPTY_CONTENT = new ActivityContent();
    private IActivityContentMember[] resources;
    private int coIndex = 0;
    private int createdIndex = 0;
    private int closedIndex = 0;
    private int coCount = 0;
    private int createdCount = 0;
    private int closedCount = 0;

    public static ICreatedResource createNewFile(int conTemplID, String filePath, InputStream content, String contentType, long contentLength) throws VcmFailure {
        return AddedFile.create(conTemplID, filePath, content, contentType, contentLength);
    }

    public static ICreatedResource createNewCollection(int conTemplID, String collectionPath) throws VcmFailure {
        return AddedCollection.create(conTemplID, collectionPath);
    }

    private ActivityContent() {
        this.resources = new IActivityContentMember[0];
    }

    public ActivityContent(IActivityContentMember[] content) throws VcmFailure {
        this.resources = content;
        this.initialize();
    }

    private void initialize() throws VcmFailure {
        int i = 0;
        while (i < this.resources.length) {
            if (this.resources[i].isClosedMember()) {
                ++this.closedCount;
            } else if (this.resources[i].isCheckedOutMember()) {
                ++this.coCount;
            } else {
                ++this.createdCount;
            }
            ++i;
        }
    }

    public ICheckedOutResource nextCheckOutResource() throws VcmFailure {
        while (this.coIndex < this.resources.length && !this.resources[this.coIndex].isCheckedOutMember()) {
            ++this.coIndex;
        }
        ICheckedOutResource next = null;
        if (this.coIndex < this.resources.length) {
            next = this.resources[this.coIndex].getMemberAsCheckedOut();
            ++this.coIndex;
        }
        return next;
    }

    public ICreatedResource nextCreatedResource() throws VcmFailure {
        while (this.createdIndex < this.resources.length && !this.resources[this.createdIndex].isCreatedMember()) {
            ++this.createdIndex;
        }
        ICreatedResource next = null;
        if (this.createdIndex < this.resources.length) {
            next = this.resources[this.createdIndex].getMemberAsCreated();
            ++this.createdIndex;
        }
        return next;
    }

    public int createdCount() {
        return this.createdCount;
    }

    public int checkedOutCount() {
        return this.coCount;
    }

    public void reset() {
        this.coIndex = 0;
        this.createdIndex = 0;
        this.closedIndex = 0;
    }

    public IClosedResource nextClosedResource() throws VcmFailure {
        while (this.closedIndex < this.resources.length && !this.resources[this.closedIndex].isClosedMember()) {
            ++this.closedIndex;
        }
        IClosedResource next = null;
        if (this.closedIndex < this.resources.length) {
            next = this.resources[this.closedIndex].getMemberAsClosed();
            ++this.closedIndex;
        }
        return next;
    }

    public int closedCount() {
        return this.closedCount;
    }

    static class AddedFile
    extends FileImpl
    implements ICreatedResource {
        public static ICreatedResource create(int conTemplID, String filePath, InputStream content, String contentType, long contentLength) throws VcmFailure {
            try {
                AddedFile newFile = new AddedFile(conTemplID, Encoder.encodePath((String)filePath));
                newFile.setContent(content, contentType, contentLength);
                IProperty typeProp = ResourceTypeProperty.TYPE_FILE.toProperty("DAV", DAV.RESOURCETYPE.localName);
                newFile.localSetProperties(new IProperty[]{typeProp});
                return newFile;
            }
            catch (InvalidPathException e) {
                throw new VcmFailure(e.getMessage(), e);
            }
        }

        private AddedFile(int conTemplID, String encResourcePath) throws InvalidPathException {
            super(conTemplID, encResourcePath);
        }

        public String getXCMPath() throws VcmFailure {
            return this.getPropertyStringValue(XCM.PATH.qualifiedName);
        }

        public ICollection getAsCollection() throws VcmFailure {
            return null;
        }

        public boolean isCollection() throws VcmFailure {
            return false;
        }

        public IFile getAsFile() throws VcmFailure {
            return this;
        }

        public boolean isFile() throws VcmFailure {
            return true;
        }

        public boolean isVersioned() throws VcmFailure {
            return false;
        }
    }

    static class AddedCollection
    extends CollectionImpl
    implements ICreatedResource {
        public static ICreatedResource create(int conTemplID, String collectionPath) throws VcmFailure {
            try {
                String encodedPath = Encoder.encodePath((String)collectionPath);
                CollectionImpl.mkCollection(conTemplID, encodedPath);
                AddedCollection collection = new AddedCollection(conTemplID, encodedPath);
                IProperty typeProp = ResourceTypeProperty.TYPE_COLLECTION.toProperty("DAV", DAV.RESOURCETYPE.localName);
                collection.localSetProperties(new IProperty[]{typeProp});
                return collection;
            }
            catch (InvalidPathException e) {
                throw new VcmFailure(e.getMessage(), e);
            }
        }

        private AddedCollection(int conTemplID, String encResourcePath) throws InvalidPathException {
            super(conTemplID, encResourcePath);
        }

        public String getXCMPath() throws VcmFailure {
            return this.getPropertyStringValue(XCM.PATH.qualifiedName);
        }

        public ICollection getAsCollection() throws VcmFailure {
            return this;
        }

        public boolean isCollection() throws VcmFailure {
            return true;
        }

        public IFile getAsFile() {
            return null;
        }

        public boolean isFile() {
            return false;
        }

        public boolean isVersioned() throws VcmFailure {
            return false;
        }
    }
}

