/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.ICheckedOutResource;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.AbstractCompositeLoader;
import com.tssap.dtr.client.lib.deltavlib.impl.ActivityComposite;
import com.tssap.dtr.client.lib.deltavlib.impl.ActivityContent;
import com.tssap.dtr.client.lib.deltavlib.impl.IActivityContentMember;
import com.tssap.dtr.client.lib.deltavlib.impl.ResourceMetaClass;
import com.tssap.dtr.client.lib.deltavlib.impl.util.EmptyArray;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyUtil;
import com.tssap.dtr.client.lib.deltavlib.xcm.ActivityCompositeDef;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityComposite;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyDef;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyReport;
import com.tssap.dtr.client.lib.protocol.requests.xcm.ActivityReport;
import java.util.BitSet;

public abstract class ActivityCompositeLoader
extends AbstractCompositeLoader {
    protected static final State CHECKOUT_STATE = new State(){

        public void storeComponent(ActivityComposite composite, IResource[] component) {
            composite.checkoutSet = (ICheckedOutResource[])component;
        }
    };
    protected static final State VER_STATE = new State(){

        public void storeComponent(ActivityComposite composite, IResource[] component) {
            composite.versionSet = (IVersion[])component;
        }
    };
    protected static final State VCR_STATE = new State(){

        public void storeComponent(ActivityComposite composite, IResource[] component) {
            composite.addToVcrSet((IVersionControlledResource)component[0]);
        }
    };
    protected static final State CONTENT_STATE = new State(){

        public void storeComponent(ActivityComposite composite, IResource[] component) {
            try {
                composite.activityContent = new ActivityContent((IActivityContentMember[])component);
            }
            catch (VcmFailure e) {
                throw new IllegalStateException();
            }
        }
    };
    protected static final State WS_STATE = new State(){

        public void storeComponent(ActivityComposite composite, IResource[] component) {
            composite.workspaceSet = (IWorkspace[])component;
        }
    };
    protected static final State SUBACT_STATE = new State(){

        public void storeComponent(ActivityComposite composite, IResource[] component) {
            composite.subactivitySet = (IActivity[])component;
        }
    };
    private State state;
    protected ActivityComposite composite;
    protected ActivityCompositeDef definition;

    public ActivityCompositeLoader(int conTemplID) {
        super(conTemplID);
    }

    private AbstractCompositeLoader.ComponentDef addExpandedProperty(PropertyUtil.QualifiedName expandedProperty, String[] propsToGet, String[] implicitProps) {
        AbstractCompositeLoader.ComponentDef componentDef = null;
        componentDef = expandedProperty.namespaceUri == null ? new AbstractCompositeLoader.ComponentDef(expandedProperty.name) : new AbstractCompositeLoader.ComponentDef(expandedProperty.name, expandedProperty.namespaceUri);
        componentDef.addPropertySet(propsToGet);
        if (implicitProps != null) {
            this.ensureDefaultPropertiesAdded(componentDef, implicitProps);
        }
        this.addComponentDef(componentDef);
        return componentDef;
    }

    private void addSecondLevelExpandedProperty(AbstractCompositeLoader.ComponentDef parentComponentDef, PropertyUtil.QualifiedName expandedProperty, String[] propsToGet, String[] implicitProps) {
        AbstractCompositeLoader.ComponentDef componentDef = null;
        componentDef = expandedProperty.namespaceUri == null ? new AbstractCompositeLoader.ComponentDef(expandedProperty.name) : new AbstractCompositeLoader.ComponentDef(expandedProperty.name, expandedProperty.namespaceUri);
        componentDef.addPropertySet(propsToGet);
        if (implicitProps != null) {
            this.ensureDefaultPropertiesAdded(componentDef, implicitProps);
        }
        this.addSecondLevelComponentDef(componentDef, parentComponentDef);
    }

    public void setCompositeDefinition(ActivityCompositeDef compositeDef) {
        if (compositeDef == null) {
            throw new NullPointerException();
        }
        this.definition = compositeDef;
        this.composite = new ActivityComposite();
        PropertyUtil.QualifiedName componentRef = new PropertyUtil.QualifiedName();
        AbstractCompositeLoader.ComponentDef componentDef = null;
        if (compositeDef.checkedOutSetProperties != null) {
            componentRef.name = DAV.ACTIVITY_CHECKOUT_SET.localName;
            componentRef.namespaceUri = null;
            this.addExpandedProperty(componentRef, compositeDef.checkedOutSetProperties, new String[]{DAV.RESOURCETYPE.localName, DAV.AUTO_UPDATE.localName});
            this.composite.checkoutSet = EmptyArray.CHECKOUT_SET;
        }
        if (compositeDef.versionSetProperties != null) {
            componentRef.name = XCM.VERSION_SET.localName;
            componentRef.namespaceUri = XCM.NAMESPACE_URI;
            this.addExpandedProperty(componentRef, compositeDef.versionSetProperties, null);
            this.composite.versionSet = EmptyArray.VERSION_SET;
        }
        if (compositeDef.currentWorkspaceSetProperties != null) {
            componentDef = new AbstractCompositeLoader.ComponentDef(DAV.CURRENT_WORKSPACE_SET.localName);
            componentDef.addPropertySet(compositeDef.currentWorkspaceSetProperties);
            this.addComponentDef(componentDef);
            this.composite.workspaceSet = EmptyArray.WORKSPACE_SET;
        }
        if (compositeDef.subActivityProperties != null) {
            componentRef.name = DAV.SUBACTIVITY_SET.localName;
            componentRef.namespaceUri = null;
            this.addExpandedProperty(componentRef, compositeDef.subActivityProperties, null);
            this.composite.subactivitySet = EmptyArray.ACTIVITY_SET;
        }
        AbstractCompositeLoader.ComponentDef activityContentSetDef = null;
        if (compositeDef.activityContentProperties != null) {
            componentRef.name = XCM.ACTIVITY_CONTENT_SET.localName;
            componentRef.namespaceUri = XCM.NAMESPACE_URI;
            activityContentSetDef = this.addExpandedProperty(componentRef, compositeDef.activityContentProperties, new String[]{XCM.PATH.qualifiedName, DAV.RESOURCETYPE.localName, DAV.AUTO_UPDATE.localName});
            this.composite.activityContent = ActivityContent.EMPTY_CONTENT;
        }
        if (compositeDef.vcrProperties != null) {
            componentRef.name = DAV.AUTO_UPDATE.localName;
            componentRef.namespaceUri = "DAV:";
            this.addSecondLevelExpandedProperty(activityContentSetDef, componentRef, compositeDef.vcrProperties, new String[]{XCM.PATH.qualifiedName, DAV.RESOURCETYPE.localName});
        }
        if (compositeDef.activityProperties != null) {
            int i = 0;
            while (i < compositeDef.activityProperties.length) {
                String propName = compositeDef.activityProperties[i];
                this.addCompositeProperty(propName);
                ++i;
            }
        }
    }

    protected abstract void addCompositeProperty(String var1);

    protected ResourceMetaClass onGetComponentType(PropertyElement nextProp) {
        ResourceMetaClass metaClass = null;
        if ("DAV:".equals(nextProp.getNamespaceURI())) {
            if (DAV.CURRENT_WORKSPACE_SET.localName.equals(nextProp.getName())) {
                this.state = WS_STATE;
                metaClass = ResourceMetaClass.MC_WORKSPACE;
            } else if (DAV.ACTIVITY_VERSION_SET.localName.equals(nextProp.getName())) {
                this.state = VER_STATE;
                metaClass = ResourceMetaClass.MC_VERSION;
            } else if (DAV.ACTIVITY_CHECKOUT_SET.localName.equals(nextProp.getName())) {
                this.state = CHECKOUT_STATE;
                metaClass = ResourceMetaClass.MC_WORKING_RESOURCE;
            } else if (DAV.SUBACTIVITY_SET.localName.equals(nextProp.getName())) {
                this.state = SUBACT_STATE;
                metaClass = ResourceMetaClass.MC_ACTIVITY;
            } else if (DAV.AUTO_UPDATE.localName.equals(nextProp.getName())) {
                this.state = VCR_STATE;
                metaClass = ResourceMetaClass.MC_VCR;
            }
        } else if (XCM.NAMESPACE_URI.equals(nextProp.getNamespaceURI())) {
            if (XCM.ACTIVITY_CONTENT_SET.localName.equals(nextProp.getName())) {
                this.state = CONTENT_STATE;
                metaClass = ResourceMetaClass.MC_ACTIVITY_CONTENT_MEMBER;
            } else if (XCM.VERSION_SET.localName.equals(nextProp.getName())) {
                this.state = VER_STATE;
                metaClass = ResourceMetaClass.MC_VERSION;
            }
        }
        if (metaClass != null) {
            return metaClass;
        }
        throw new IllegalStateException();
    }

    protected void onStoreComponent(IResource[] component) {
        this.state.storeComponent(this.composite, component);
    }

    protected void onCompositeLoaded(ResourceElement compositeResource) throws VcmFailure {
        super.onCompositeLoaded(compositeResource);
    }

    protected void onStoreComposite(IResource compositeResource) {
        this.composite.activity = (IActivity)compositeResource;
    }

    protected ResourceMetaClass onGetCompositeType() {
        return ResourceMetaClass.MC_ACTIVITY;
    }

    private void ensureDefaultPropertiesAdded(AbstractCompositeLoader.ComponentDef componentDef, String[] defaultProps) {
        BitSet flags = new BitSet(defaultProps.length);
        ExpandPropertyDef child = componentDef.firstChild;
        int i = 0;
        while (child != null) {
            int pos = PropertyUtil.searchProperty(defaultProps, child.name, child.namespaceURI);
            if (pos >= 0) {
                flags.set(pos);
            }
            child = child.next;
            ++i;
        }
        int i2 = 0;
        while (i2 < defaultProps.length) {
            if (!flags.get(i2)) {
                componentDef.addChild(new ExpandPropertyDef(defaultProps[i2], PropertyUtil.getNamespaceURI(defaultProps[i2])));
            }
            ++i2;
        }
    }

    public static class ActivityReportResultLoader
    extends ActivityCompositeLoader {
        private ActivityReport report;
        private ActivityComposite[] reportResult;
        private int currentCompositeIndex = -1;

        public ActivityReportResultLoader(int conTemplID, ActivityReport report) {
            super(conTemplID);
            this.report = report;
        }

        protected void onReceivedResponse(MultiStatusEntity response) {
            this.reportResult = new ActivityComposite[response.countResources()];
            int i = 0;
            while (i < this.reportResult.length) {
                this.reportResult[i] = this.composite.createShallowCopy();
                ++i;
            }
        }

        public IActivityComposite[] execute() throws VcmFailure {
            this.execute((IRequest)this.report);
            this.currentCompositeIndex = -1;
            this.composite = null;
            return this.reportResult;
        }

        protected void onCompositeLoaded(ResourceElement compositeResource) throws VcmFailure {
            this.composite = this.reportResult[++this.currentCompositeIndex];
            super.onCompositeLoaded(compositeResource);
        }

        public void addComponentDef(AbstractCompositeLoader.ComponentDef component) {
            this.report.addPropertyExpand((ExpandPropertyDef)component, null);
        }

        protected void addCompositeProperty(String compositeProperty) {
            if (compositeProperty == null) {
                throw new NullPointerException();
            }
            this.report.addPropertyExpand(compositeProperty, PropertyUtil.getNamespaceURI(compositeProperty), null);
        }

        public void addSecondLevelComponentDef(AbstractCompositeLoader.ComponentDef componentDef, AbstractCompositeLoader.ComponentDef parentComponentDef) {
            this.report.addPropertyExpand((ExpandPropertyDef)componentDef, (ExpandPropertyDef)parentComponentDef);
        }
    }

    public static class ActivityExpandLoader
    extends ActivityCompositeLoader {
        private ExpandPropertyReport report;

        public ActivityExpandLoader(int conTemplID, ExpandPropertyReport report) {
            super(conTemplID);
            this.report = report;
        }

        public IActivityComposite execute() throws VcmFailure {
            this.execute((IRequest)this.report);
            return this.composite;
        }

        public void addComponentDef(AbstractCompositeLoader.ComponentDef component) {
            this.report.addPropertyExpand((ExpandPropertyDef)component, null);
        }

        protected void addCompositeProperty(String compositeProperty) {
            if (compositeProperty == null) {
                throw new NullPointerException();
            }
            this.report.addPropertyExpand(compositeProperty, PropertyUtil.getNamespaceURI(compositeProperty), null);
        }

        public void addSecondLevelComponentDef(AbstractCompositeLoader.ComponentDef componentDef, AbstractCompositeLoader.ComponentDef parentComponentDef) {
            this.report.addPropertyExpand((ExpandPropertyDef)componentDef, (ExpandPropertyDef)parentComponentDef);
        }
    }

    static interface State {
        public void storeComponent(ActivityComposite var1, IResource[] var2);
    }
}

