/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.BaseResource;
import com.tssap.dtr.client.lib.deltavlib.impl.DefaultCachedPropertyManager;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.impl.IProtocolPropertyProvider;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.ResourceMetaClass;
import com.tssap.dtr.client.lib.deltavlib.impl.util.PropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyUtil;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractResourceLoader
implements IProtocolPropertyProvider {
    private Iterator loadedResources;
    private ResourceElement resource;
    private int size = 0;

    private void setupPropertiesToLoad(IPropertyNameIterator propNames) {
        String nextName = null;
        String namespaceUri = null;
        while (propNames.hasNext()) {
            nextName = propNames.next();
            namespaceUri = PropertyUtil.getNamespaceURI(nextName);
            if (namespaceUri != null) {
                this.addPropertyNS(PropertyUtil.getNamespacePrefix(nextName), namespaceUri);
            }
            this.addPropertyToLoad(nextName);
        }
    }

    protected abstract ResourceMetaClass getResourceMetaClass();

    protected abstract void addPropertyToLoad(String var1);

    protected abstract void addPropertyNS(String var1, String var2);

    protected abstract IRequest getRequest();

    protected void setSize(int size) {
        this.size = size;
    }

    protected Iterator setResponseResources(MultiStatusEntity responseEntity) {
        this.size = responseEntity.countResources();
        return responseEntity.getResources();
    }

    protected IPropertyNameIterator getPropertiesToLoad() {
        DefaultCachedPropertyManager manager = DefaultCachedPropertyManager.getInstance();
        IPropertyNameIterator propIt = manager.getResourceCachedProperties(this.getMetaClass().resourceType());
        if (propIt == null) {
            return new PropertyNameIterator(new String[0]);
        }
        return propIt;
    }

    protected void execute(int conTemplID, IPropertyNameIterator propertyNames) throws VcmFailure {
        MultiStatusEntity entity;
        this.setupPropertiesToLoad(propertyNames);
        IResponse response = DeltavCommand.execute(conTemplID, this.getRequest());
        if (response.getStatus() == 207) {
            MultiStatusEntity multiStatusEntity = entity = "MultiStatusEntity".equals(response.getEntityType()) ? (MultiStatusEntity)response.getEntity() : null;
            if (entity == null) {
                this.size = 0;
                this.resource = null;
                this.loadedResources = null;
                throw new VcmFailure("Received invalid response entity");
            }
        } else {
            throw new VcmFailure("Invalid response entity: multistatus expected");
        }
        this.loadedResources = this.setResponseResources(entity);
    }

    public void execute(int conTemplID) throws VcmFailure {
        this.execute(conTemplID, this.getPropertiesToLoad());
    }

    public IResource[] loadResources(int conTemplID) throws VcmFailure {
        this.execute(conTemplID);
        IResource[] resources = (IResource[])Array.newInstance(this.getResourceMetaClass().resourceType(), this.size);
        if (resources.length == 0) {
            return resources;
        }
        AbstractResourceLoader provider = this;
        int i = 0;
        while (this.hasMoreResources()) {
            ResourceElement nextResource = this.getNextResource();
            try {
                BaseResource resourceBase = this.getResourceMetaClass().newInstance(conTemplID, nextResource.getPath());
                resourceBase.initialize(provider);
                resources[i] = resourceBase;
            }
            catch (InvalidPathException e) {
                throw new VcmFailure("Received invalid href from server");
            }
            ++i;
        }
        return resources;
    }

    public Iterator getResourceProperties() {
        return this.getResource().getProperties();
    }

    public ResourceElement getResource() {
        if (this.resource == null) {
            if (this.hasMoreResources()) {
                this.resource = (ResourceElement)this.loadedResources.next();
            } else {
                throw new NoSuchElementException();
            }
        }
        return this.resource;
    }

    public int size() {
        return this.size;
    }

    public ResourceElement getNextResource() {
        if (this.loadedResources != null) {
            this.resource = (ResourceElement)this.loadedResources.next();
            return this.resource;
        }
        throw new NoSuchElementException();
    }

    public boolean hasMoreResources() {
        return this.loadedResources != null && this.loadedResources.hasNext();
    }

    public IProtocolPropertyProvider getAsProvider() {
        return this;
    }

    public Iterator getProperties() {
        return this.getResourceProperties();
    }

    public ResourceMetaClass getMetaClass() {
        return this.getResourceMetaClass();
    }

    public String getEncodedPath() {
        return this.getResource().getPath();
    }
}

