/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.ConnectionPool;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactoryManager;
import com.tssap.dtr.client.lib.deltavlib.PathUtil;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.DefaultCachedPropertyManager;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.impl.IProtocolPropertyProvider;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.PropertyFactoryImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.PropertyFlyweight;
import com.tssap.dtr.client.lib.deltavlib.impl.ResFactoryMgrImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.cache.HashmapPropCache;
import com.tssap.dtr.client.lib.deltavlib.impl.cache.IConvertableCachedObj;
import com.tssap.dtr.client.lib.deltavlib.impl.cache.IPropertyCache;
import com.tssap.dtr.client.lib.deltavlib.impl.cache.IPropertyCacheHandler;
import com.tssap.dtr.client.lib.deltavlib.impl.cache.ISelectivePropertyLoader;
import com.tssap.dtr.client.lib.deltavlib.impl.util.CacheableDate;
import com.tssap.dtr.client.lib.deltavlib.impl.util.DataUtil;
import com.tssap.dtr.client.lib.deltavlib.impl.util.EmptyArray;
import com.tssap.dtr.client.lib.deltavlib.properties.Converter;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.ICachedPropertyManager;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyCacheControl;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyFactory;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixBindingException;
import com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixToUriMap;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyFormatException;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyUtil;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.Depth;
import com.tssap.dtr.client.lib.protocol.requests.dav.PropfindRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.ProppatchRequest;
import com.tssap.dtr.client.lib.protocol.templates.InvalidTemplateIDException;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Iterator;

abstract class AbstractResource
implements IPropertyCacheHandler {
    private static final Location LOC = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$deltavlib$impl$AbstractResource == null ? (class$com$tssap$dtr$client$lib$deltavlib$impl$AbstractResource = AbstractResource.class$("com.tssap.dtr.client.lib.deltavlib.impl.AbstractResource")) : class$com$tssap$dtr$client$lib$deltavlib$impl$AbstractResource));
    private int connectionTemplID = -1;
    private String encodedPath;
    private String decodedPath;
    private IPropertyCache propCache;
    protected static final ICachedPropertyManager PROPERTY_MANAGER = DefaultCachedPropertyManager.getInstance();
    protected static final IPropertyFactory PROPERTY_FACTORY = PropertyFactoryImpl.getInstance();
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$impl$AbstractResource;

    protected abstract boolean isInitialized();

    protected abstract IPropertyNameIterator getInitialPropertyNames();

    protected abstract boolean usePathTrailSlash();

    protected abstract void setInitialized(boolean var1);

    protected AbstractResource(int conTemplID, String resourcePath) throws InvalidPathException {
        this.connectionTemplID = conTemplID;
        this.setPath(resourcePath);
    }

    protected AbstractResource(AbstractResource resource) {
        this.connectionTemplID = resource.connectionTemplID;
        this.encodedPath = this.usePathTrailSlash() ? AbstractResource.ensureTrailSlash(resource.encodedPath) : resource.encodedPath;
        this.propCache = resource.propCache;
    }

    protected void initializePropertyCache(Iterator propertyElementIt) {
        this.propCache = HashmapPropCache.createInstance(propertyElementIt, this);
        this.setInitialized(true);
    }

    protected final void localSetProperty(PropertyElement prop) {
        if (this.propCache != null) {
            this.propCache.storeProperty(prop, this);
        } else {
            this.getPropertyCache().storeProperty(prop, this);
        }
    }

    protected String validatePath(String validatedPath) throws InvalidPathException {
        String urlPath;
        String string = urlPath = validatedPath != null ? validatedPath.trim() : null;
        if (urlPath == null || !urlPath.startsWith("/") || urlPath.indexOf("//") >= 0) {
            throw new InvalidPathException("Invalid resource path: " + urlPath);
        }
        if (this.usePathTrailSlash()) {
            if (!urlPath.endsWith("/")) {
                StringBuffer buf = new StringBuffer(urlPath.length() + 1);
                buf.append(urlPath);
                buf.append('/');
                return buf.toString();
            }
            return urlPath;
        }
        if (urlPath.endsWith("/")) {
            return urlPath.substring(0, urlPath.length() - 1);
        }
        return urlPath;
    }

    protected IResourceFactoryManager getResourceFactoryManager() {
        return ResFactoryMgrImpl.getInstance();
    }

    protected final void setPath(String path) throws InvalidPathException {
        this.encodedPath = this.validatePath(path);
        this.decodedPath = null;
    }

    protected IResponse executeRequest(IRequest request) throws VcmFailure {
        return DeltavCommand.execute(this.connectionTemplID, request);
    }

    protected IResponse performCheckedProppath(ProppatchRequest proppatch) throws VcmFailure {
        Iterator props;
        ResourceElement resource;
        IResponse response = this.executeRequest((IRequest)proppatch);
        if (response.getStatus() == 207 && (resource = proppatch.getResource(0)) != null && (props = resource.getProperties()) != null) {
            while (props.hasNext()) {
                PropertyElement nextProp = (PropertyElement)props.next();
                if (nextProp.getStatusCode() == 200) continue;
                if (LOC.beError()) {
                    Object[] args = new String[]{nextProp.getQualifiedName(), nextProp.getErrorCondition(), nextProp.getStatusDescription()};
                    String msg = "Failed proppatch property: {0} ({1}, {2})";
                    LOC.errorT(msg, args);
                }
                String respDesc = nextProp.getErrorCondition();
                throw new VcmFailure(nextProp.getStatusDescription(), nextProp.getStatusCode(), respDesc == null ? nextProp.getExtendedCondition() : respDesc);
            }
        }
        return response;
    }

    protected static String ensureTrailSlash(String sourcePath) {
        String resultPath;
        String string = resultPath = sourcePath != null ? sourcePath.trim() : null;
        if (resultPath == null || !resultPath.startsWith("/") || resultPath.indexOf("//") >= 0) {
            throw new IllegalArgumentException("Invalid resource path:" + resultPath);
        }
        if (!resultPath.endsWith("/")) {
            StringBuffer buf = new StringBuffer(resultPath.length() + 1);
            buf.append(resultPath);
            buf.append('/');
            return buf.toString();
        }
        return resultPath;
    }

    protected void remoteRemoveProperties(String[] propertyNames) throws VcmFailure {
        ProppatchRequest ppatch = new ProppatchRequest(this.getEncodedPath());
        int i = 0;
        while (i < propertyNames.length) {
            String nsPrefix = PropertyUtil.getNamespacePrefix(propertyNames[i]);
            if (nsPrefix != null) {
                String nsUri = PropertyUtil.getNamespaceURI(propertyNames[i]);
                ppatch.addNamespace(nsPrefix, nsUri);
            }
            ppatch.addPropertyRemove(propertyNames[i]);
            ++i;
        }
        this.performCheckedProppath(ppatch);
        IPropertyCacheControl cacheControl = this.getPropertyCacheControl();
        int i2 = 0;
        while (i2 < propertyNames.length) {
            cacheControl.clearProperty(propertyNames[i2]);
            ++i2;
        }
    }

    protected void localRemoveProperties(String[] propertyNames) {
        IPropertyCacheControl cacheControl = this.getPropertyCacheControl();
        int i = 0;
        while (i < propertyNames.length) {
            cacheControl.clearProperty(propertyNames[i]);
            ++i;
        }
    }

    protected void remoteSetProperties(IProperty[] properties) throws VcmFailure {
        final ProppatchRequest ppatch = new ProppatchRequest(this.getEncodedPath());
        StringBuffer buf = new StringBuffer();
        DataUtil.INSPrefixResolver nsListener = null;
        int i = 0;
        while (i < properties.length) {
            IProperty nextProperty = properties[i];
            buf.setLength(0);
            String qualifiedPropName = nextProperty.getQualifiedName(buf).toString();
            if (nextProperty.getChildCount() > 0) {
                if (nsListener == null) {
                    Object unregPrefix = null;
                    nsListener = new DataUtil.INSPrefixResolver(){

                        public String onNamespacePrefix(String prefix) {
                            String uri = NSPrefixToUriMap.getUriForPrefix(prefix);
                            if (uri != null) {
                                ppatch.addNamespace(prefix, uri);
                                return uri;
                            }
                            return null;
                        }
                    };
                }
                try {
                    PropertyElement element = DataUtil.apiToProtocolProperty(nextProperty, buf, nsListener);
                    ppatch.addPropertySet((Element)element);
                }
                catch (NSPrefixBindingException e) {
                    String msg = "A namespace prefix not bound in property " + qualifiedPropName;
                    throw new VcmFailure(msg, e);
                }
            } else {
                String nsUri = NSPrefixToUriMap.getUriForPrefix(nextProperty.getNamespace());
                if (nsUri == null) {
                    String msg = "Namespace prefix " + nextProperty.getNamespace() + " not bound in property  " + qualifiedPropName;
                    throw new VcmFailure(msg);
                }
                ppatch.addNamespace(nextProperty.getNamespace(), nsUri);
                ppatch.addPropertySet(qualifiedPropName, nextProperty.getValue());
            }
            ++i;
        }
        this.performCheckedProppath(ppatch);
    }

    protected void localSetProperties(IProperty[] propertyNames) throws VcmFailure {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < propertyNames.length) {
            this.localSetProperty(DataUtil.apiToProtocolProperty(propertyNames[i], buf));
            ++i;
        }
    }

    protected void remoteSetProperty(String propertyName, String value) throws VcmFailure {
        ProppatchRequest ppatch = new ProppatchRequest(this.getEncodedPath());
        String prefix = PropertyUtil.getNamespacePrefix(propertyName);
        if (prefix != null) {
            ppatch.addNamespace(prefix, PropertyUtil.getNamespaceURI(propertyName));
            String nsUri = NSPrefixToUriMap.getUriForPrefix(prefix);
            if (nsUri == null) {
                String msg = "Namespace prefix " + propertyName + " not bound in property  " + propertyName;
                throw new VcmFailure(msg);
            }
        }
        ppatch.addPropertySet(propertyName, value);
        this.performCheckedProppath(ppatch);
    }

    public void initialize(IProtocolPropertyProvider provider) {
        if (provider == null) {
            throw new NullPointerException();
        }
        Iterator props = provider.getProperties();
        PropertyElement nextProp = null;
        while (props.hasNext()) {
            nextProp = (PropertyElement)props.next();
            this.localSetProperty(nextProp);
        }
        this.setInitialized(true);
    }

    protected boolean isPropertyInitialized(String propertyName) {
        int stateInCache = this.getPropertyCacheControl().getPropertyState(propertyName);
        return stateInCache == 1;
    }

    protected void setPropertyValue(String propertyName, IConvertableCachedObj cachedObj) {
        this.getPropertyCache().setDirectCachedValue(propertyName, cachedObj == null ? IPropertyCacheHandler.NULL_PROPERTY_VALUE : cachedObj);
    }

    protected void setPropertyStringValue(String name, String val) {
        this.getPropertyCache().setDirectCachedValue(name, val == null ? IPropertyCacheHandler.NULL_PROPERTY_VALUE : val);
    }

    protected void setPropertyHrefValue(String propertyName, String href) {
        Object hrefObj = href == null ? IPropertyCacheHandler.NULL_PROPERTY_VALUE : new PropertyFlyweight.SingleDavHrefElement(href);
        this.getPropertyCache().setDirectCachedValue(propertyName, hrefObj);
    }

    protected void setPropertyHrefSetValue(String propertyName, String[] hrefValues) {
        this.getPropertyCache().setDirectCachedValue(propertyName, hrefValues != null ? hrefValues.clone() : IPropertyCacheHandler.NULL_PROPERTY_VALUE);
    }

    protected String getPropertyStringValue(String propertyName) throws VcmFailure {
        Object value = this.getPropertyCache().getPropertyValue(propertyName, this);
        if (value == IPropertyCacheHandler.NULL_PROPERTY_VALUE) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value == null ? null : value.toString();
    }

    public int getConnectionTemplID() {
        return this.connectionTemplID;
    }

    public String getName() {
        return PathUtil.getNameFromPath(this.getDecodedPath());
    }

    public String getPath() {
        return this.getDecodedPath();
    }

    public String getDecodedPath() {
        if (this.decodedPath == null) {
            this.decodedPath = Encoder.decodePath((String)this.encodedPath);
            if (this.decodedPath.equals(this.encodedPath)) {
                this.decodedPath = this.encodedPath;
            }
        }
        return this.decodedPath;
    }

    public String getEncodedPath() {
        return this.encodedPath;
    }

    public String getResourceURL() {
        try {
            StringBuffer url = this.writeWebLocator(new StringBuffer());
            return url.append(this.encodedPath).toString();
        }
        catch (InvalidTemplateIDException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public void refresh() throws VcmFailure {
        this.getPropertyCache().refresh(this);
        this.setInitialized(true);
    }

    public IProperty getProperty(String propertyName) throws VcmFailure {
        IPropertyCache cache = this.getPropertyCache();
        Object val = cache.getPropertyValue(propertyName, this);
        if (val != null) {
            return this.convertFromCachedObject(PropertyUtil.getNamespacePrefix(propertyName), PropertyUtil.getLocalName(propertyName), val);
        }
        return null;
    }

    protected StringBuffer writeWebLocator(StringBuffer locatorBuf) throws InvalidTemplateIDException {
        IConnectionTemplate conTemplate = ConnectionPool.getTemplateProvider().getConnectionTemplate(this.getConnectionTemplID());
        locatorBuf.setLength(0);
        locatorBuf.append(conTemplate.getProtocol()).append("://").append(conTemplate.getHost()).append(':').append(conTemplate.getPort());
        return locatorBuf;
    }

    protected final IPropertyCache getPropertyCache() {
        if (this.propCache == null) {
            this.propCache = HashmapPropCache.createInstance(this.getInitialPropertyNames());
        }
        return this.propCache;
    }

    public IPropertyCacheControl getPropertyCacheControl() {
        return this.getPropertyCache().getCacheControl();
    }

    public final IProperty convertFromCachedObject(String namespace, String name, Object val) {
        if (IPropertyCacheHandler.NULL_PROPERTY_VALUE == val) {
            return PROPERTY_FACTORY.createEmptyProperty(namespace, name);
        }
        if (val instanceof String) {
            return PROPERTY_FACTORY.createStringProperty(namespace, name, (String)val);
        }
        if (val instanceof PropertyFlyweight.SingleDavHrefElement) {
            return new PropertyFlyweight.SingleDavHrefProperty(namespace, name, (PropertyFlyweight.SingleDavHrefElement)val);
        }
        if (val instanceof String[]) {
            return PROPERTY_FACTORY.createDavHrefSetProperty(namespace, name, (String[])val);
        }
        if (val instanceof IProperty) {
            return (IProperty)val;
        }
        if (val instanceof IConvertableCachedObj) {
            return ((IConvertableCachedObj)val).toProperty(namespace, name);
        }
        LOC.errorT("Invalid object type in property cache");
        throw new IllegalStateException();
    }

    public ISelectivePropertyLoader getPropertyLoader() {
        return new PropFinder(this.getConnectionTemplID(), this.getEncodedPath());
    }

    protected abstract IConvertableCachedObj onSetDAVResourceType(PropertyElement var1);

    protected abstract IConvertableCachedObj onSetNonPrimitiveCachedProperty(PropertyElement var1);

    public final Object convertToCachedObject(PropertyElement property) {
        Element child = property.firstChild();
        if (child == null) {
            String val = property.getValue();
            if (val == null) {
                if (DAV.RESOURCETYPE.localName.equals(property.getName()) && "DAV:".equals(property.getNamespaceURI())) {
                    IConvertableCachedObj cached = this.onSetDAVResourceType(property);
                    return cached != null ? cached : DataUtil.protocolToApiProperty(property);
                }
                if (DAV.AUTO_UPDATE.localName.equals(property.getName()) && "DAV:".equals(property.getNamespaceURI())) {
                    if (property.countExpandedResources() == 1) {
                        String Href = ((ResourceElement)property.getExpandedResources().next()).getPath();
                        return new PropertyFlyweight.SingleDavHrefElement(Href);
                    }
                } else {
                    return IPropertyCacheHandler.NULL_PROPERTY_VALUE;
                }
            }
            return val;
        }
        String hrefName = DAV.HREF.localName;
        if (hrefName.equals(child.getName())) {
            int chidrenNum = property.countChildren();
            if (chidrenNum > 1) {
                String[] hrefVals = new String[chidrenNum];
                hrefVals[0] = child.getValue();
                int i = 1;
                while (i < chidrenNum) {
                    if (!hrefName.equals((child = child.next()).getName())) {
                        IConvertableCachedObj cached = this.onSetNonPrimitiveCachedProperty(property);
                        return cached != null ? cached : DataUtil.protocolToApiProperty(property);
                    }
                    hrefVals[i] = child.getValue();
                    ++i;
                }
                return hrefVals;
            }
            return new PropertyFlyweight.SingleDavHrefElement(child.getValue());
        }
        if (DAV.RESOURCETYPE.localName.equals(property.getName()) && "DAV:".equals(property.getNamespaceURI())) {
            IConvertableCachedObj cached = this.onSetDAVResourceType(property);
            return cached != null ? cached : DataUtil.protocolToApiProperty(property);
        }
        IConvertableCachedObj cached = this.onSetNonPrimitiveCachedProperty(property);
        return cached != null ? cached : DataUtil.protocolToApiProperty(property);
    }

    public void uncachedPropertyAccess(String propertyName) {
        if (LOC.beDebug()) {
            String msg = "performance! - accessing uncached property: " + propertyName;
            Exception logException = new Exception(msg){

                public String toString() {
                    return this.getMessage();
                }
            };
            StringWriter writer = new StringWriter();
            logException.printStackTrace(new PrintWriter(writer));
            StringBuffer stackTraceBuf = writer.getBuffer();
            LOC.warningT(stackTraceBuf.toString());
        } else if (LOC.beWarning()) {
            String msg = "performance! - accessing uncached property: {0}";
            LOC.warningT(msg, (Object[])new String[]{propertyName});
        }
    }

    protected IProperty[] getPropertyObjects(String[] propertyNames) throws VcmFailure {
        return this.getPropertyCache().getPropertyObjects(propertyNames, this);
    }

    protected Object getPropertyValueObj(String propertyName) throws VcmFailure {
        return this.getPropertyCache().getPropertyValue(propertyName, this);
    }

    protected String[] getPropertyHrefSetValue(String propertyName) throws VcmFailure {
        Object value = this.getPropertyCache().getPropertyValue(propertyName, this);
        if (IPropertyCacheHandler.NULL_PROPERTY_VALUE == value) {
            return EmptyArray.STRING_ARRAY;
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof PropertyFlyweight.SingleDavHrefElement) {
            return new String[]{((PropertyFlyweight.SingleDavHrefElement)value).value};
        }
        if (null == value) {
            return null;
        }
        LOC.errorT("queried property is not DAV:href type");
        throw new VcmFailure("client internal error");
    }

    protected String getPropertyHrefValue(String propertyName) throws VcmFailure {
        Object value = this.getPropertyCache().getPropertyValue(propertyName, this);
        if (value == null) {
            return null;
        }
        if (value instanceof PropertyFlyweight.SingleDavHrefElement) {
            return ((PropertyFlyweight.SingleDavHrefElement)value).value;
        }
        LOC.errorT("queried property is not DAV:href type");
        throw new VcmFailure("client internal error");
    }

    protected Date getPropertyDateValue(String propertyName) throws VcmFailure {
        IPropertyCache cache = this.getPropertyCache();
        Object value = cache.getPropertyValue(propertyName, this);
        if (value instanceof CacheableDate) {
            return (Date)((CacheableDate)value).getDateObject().clone();
        }
        if (value instanceof String) {
            try {
                CacheableDate cachedDate = new CacheableDate((String)value);
                cache.setDirectCachedValue(propertyName, cachedDate);
                return (Date)cachedDate.getDateObject().clone();
            }
            catch (PropertyFormatException e) {
                LOC.errorT("Error in parsing HTTP date property value");
                throw new VcmFailure("internal error", e);
            }
        }
        if (value == IPropertyCacheHandler.NULL_PROPERTY_VALUE || value == null) {
            return null;
        }
        LOC.errorT("Error in parsing HTTP date property value");
        throw new VcmFailure("internal error");
    }

    protected Boolean getPropertyBooleanValue(String propertyName) throws VcmFailure {
        String strVal = this.getPropertyStringValue(propertyName);
        if (strVal != null) {
            try {
                return Converter.stringToBoolean(strVal) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (PropertyFormatException e) {
                LOC.errorT("queried property is not boolean type {0}", new Object[]{e});
                throw new VcmFailure("client internal error", e);
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class PropFinder
    implements ISelectivePropertyLoader {
        private PropfindRequest pfind;
        private String requestUri;
        private int conTemplID;

        PropFinder(int conTemplateID, String requestUri) {
            this.requestUri = requestUri;
            this.conTemplID = conTemplateID;
        }

        public void clearProperties() {
            if (this.pfind != null) {
                String path = this.pfind.getPath();
                this.pfind.clear();
                this.pfind.setPath(path);
            }
        }

        public void addPropertyToLoad(String propertyName) {
            if (this.pfind == null) {
                this.pfind = new PropfindRequest(this.requestUri, Depth.DEPTH_0);
            }
            this.pfind.addPropertyGet(propertyName, PropertyUtil.getNamespaceURI(propertyName));
        }

        public Iterator load() throws VcmFailure {
            if (this.pfind == null) {
                this.pfind = new PropfindRequest(this.requestUri, Depth.DEPTH_0);
            }
            IResponse response = DeltavCommand.execute(this.conTemplID, (IRequest)this.pfind);
            MultiStatusEntity responseEntity = (MultiStatusEntity)this.pfind.getResponseEntity();
            if (responseEntity == null) {
                throw new VcmFailure("Unexpected empty result: " + response.getStatus() + " " + response.getStatusDescription());
            }
            ResourceElement resource = responseEntity.getResource(0);
            this.pfind = null;
            if (resource != null) {
                return resource.getProperties();
            }
            return null;
        }
    }
}

