/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.BaseResource;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.ResourceMetaClass;
import com.tssap.dtr.client.lib.deltavlib.impl.util.DataUtil;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyUtil;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyDef;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Iterator;

abstract class AbstractCompositeLoader {
    private int conTemplID = -1;

    protected int getConTemplID() {
        return this.conTemplID;
    }

    protected static BaseResource initializeResource(BaseResource resource, Iterator propertyIt) {
        while (propertyIt.hasNext()) {
            PropertyElement nextProp = (PropertyElement)propertyIt.next();
            resource.localSetProperty(nextProp);
        }
        return resource;
    }

    protected void initializeResources(PropertyElement property) throws InvalidPathException {
        Object vcr = null;
        IResource[] apiResources = null;
        int expandedNum = property.countExpandedResources();
        Iterator resourceIt = property.getExpandedResources();
        int i = 0;
        while (i < expandedNum) {
            ResourceElement nextResource = (ResourceElement)resourceIt.next();
            Iterator resourcePropIt = nextResource.getProperties();
            while (resourcePropIt.hasNext()) {
                PropertyElement nextResourceProp = (PropertyElement)resourcePropIt.next();
                if (nextResourceProp.countExpandedResources() != 1) continue;
                IResource nextApiResource = this.initializeSecondLevelResource(nextResourceProp);
            }
            ResourceMetaClass metaClass = this.onGetComponentType(property);
            if (metaClass != null) {
                if (apiResources == null) {
                    apiResources = (IResource[])Array.newInstance(metaClass.resourceType(), expandedNum);
                }
                BaseResource base = metaClass.newInstance(this.conTemplID, nextResource.getPath());
                base.initializePropertyCache(nextResource.getProperties());
                apiResources[i] = base;
            }
            ++i;
        }
        this.onStoreComponent(apiResources);
    }

    protected IResource initializeSecondLevelResource(PropertyElement property) throws InvalidPathException {
        IResource[] apiResources = null;
        BaseResource base = null;
        int expandedNum = property.countExpandedResources();
        if (expandedNum == 1) {
            ResourceElement nextResource = (ResourceElement)property.getExpandedResources().next();
            ResourceMetaClass metaClass = this.onGetComponentType(property);
            if (metaClass == null) {
                return null;
            }
            apiResources = (IResource[])Array.newInstance(metaClass.resourceType(), expandedNum);
            base = metaClass.newInstance(this.conTemplID, nextResource.getPath());
            base.initializePropertyCache(nextResource.getProperties());
            apiResources[0] = base;
            this.onStoreComponent(apiResources);
        }
        return base;
    }

    protected abstract ResourceMetaClass onGetComponentType(PropertyElement var1);

    protected abstract ResourceMetaClass onGetCompositeType();

    protected abstract void onStoreComponent(IResource[] var1);

    protected void onReceivedResponse(MultiStatusEntity response) {
    }

    protected abstract void onStoreComposite(IResource var1);

    protected void onCompositeLoaded(ResourceElement compositeResource) throws VcmFailure {
        Iterator compositePropIt = compositeResource.getProperties();
        try {
            BaseResource compositeBase = this.onGetCompositeType().newInstance(this.conTemplID, compositeResource.getPath());
            int notExpandedNum = 0;
            while (compositePropIt.hasNext()) {
                PropertyElement nextProp = (PropertyElement)compositePropIt.next();
                int expandedNum = nextProp.countExpandedResources();
                if (expandedNum > 0) {
                    this.initializeResources(nextProp);
                    continue;
                }
                if (notExpandedNum == 0) {
                    ++notExpandedNum;
                    compositeBase.initializePropertyCache(Collections.EMPTY_LIST.iterator());
                }
                compositeBase.localSetProperty(nextProp);
            }
            if (compositeBase != null) {
                this.onStoreComposite(compositeBase);
            }
        }
        catch (InvalidPathException e) {
            throw new VcmFailure("Received invalid resource href", e);
        }
    }

    public AbstractCompositeLoader(int connectionTemplID) {
        this.conTemplID = connectionTemplID;
    }

    public abstract void addComponentDef(ComponentDef var1);

    public abstract void addSecondLevelComponentDef(ComponentDef var1, ComponentDef var2);

    /*
     * Unable to fully structure code
     */
    public void execute(IRequest request) throws VcmFailure {
        block1: {
            response = DeltavCommand.execute(this.conTemplID, request);
            if (!response.isMultiStatus()) break block1;
            entity = (MultiStatusEntity)response.getEntity();
            this.onReceivedResponse(entity);
            nextComposite = null;
            compositeResourceIt = entity.getResources();
            if (compositeResourceIt != null) ** GOTO lbl11
            return;
lbl-1000:
            // 1 sources

            {
                nextComposite = (ResourceElement)compositeResourceIt.next();
                this.onCompositeLoaded(nextComposite);
lbl11:
                // 2 sources

                ** while (compositeResourceIt.hasNext())
            }
        }
    }

    public static class ComponentDef
    extends ExpandPropertyDef {
        public ComponentDef(String name, String namespaceUri) {
            super(name, namespaceUri);
        }

        public ComponentDef(String name) {
            super(name);
        }

        public void addPropertySet(String[] propertySet) {
            DataUtil.checkArrayForNull(propertySet);
            int i = 0;
            while (i < propertySet.length) {
                String propName = propertySet[i];
                if (propName != null) {
                    this.addChild(new ExpandPropertyDef(propName, PropertyUtil.getNamespaceURI(propName)));
                }
                ++i;
            }
        }
    }
}

