/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.factory;

import com.tssap.dtr.client.lib.deltavlib.ConnectionPool;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IRepositoryFunctionality;
import com.tssap.dtr.client.lib.deltavlib.IRepositoryOptions;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.PropertyFactoryAccess;
import com.tssap.dtr.client.lib.deltavlib.factory.RepositoryOptionsAccess;
import com.tssap.dtr.client.lib.deltavlib.impl.NameServerConfigImpl;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.xcm.INameServerConfig;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.Protocol;
import com.tssap.dtr.client.lib.protocol.templates.InvalidTemplateIDException;
import java.util.ArrayList;

public class NameServerConfigManager {
    private static String findDelimiter(INameServerConfig[] configs) {
        String[] delimiterArray = new String[]{"\n", "!", "\u00c2\u00a7", "$", "%", "&", "{", "}", "[", "]", "=", "?", "~", "\u00c2\u00b0", "@", "<", ">", "*", ";"};
        StringBuffer configsAsStringBuffer = new StringBuffer();
        int i = 0;
        while (i < configs.length) {
            INameServerConfig nextConfig = configs[i];
            configsAsStringBuffer.append(nextConfig.getURL());
            configsAsStringBuffer.append(nextConfig.getUser());
            configsAsStringBuffer.append(nextConfig.getPassword());
            configsAsStringBuffer.append(nextConfig.getTrustStore());
            configsAsStringBuffer.append(nextConfig.getKeyStore());
            ++i;
        }
        String configsAsString = configsAsStringBuffer.toString();
        int i2 = 0;
        while (i2 < delimiterArray.length) {
            String nextDelimiter = delimiterArray[i2];
            if (configsAsString.indexOf(nextDelimiter) == -1) {
                return nextDelimiter;
            }
            ++i2;
        }
        return null;
    }

    private static String getConfigStringValue(String delimiter, INameServerConfig config) {
        StringBuffer propertyStringValue = new StringBuffer();
        propertyStringValue.append(config.getURL());
        propertyStringValue.append(delimiter);
        propertyStringValue.append(config.getUser());
        propertyStringValue.append(delimiter);
        propertyStringValue.append(config.getPassword());
        propertyStringValue.append(delimiter);
        propertyStringValue.append(config.getTrustStore());
        propertyStringValue.append(delimiter);
        propertyStringValue.append(config.getKeyStore());
        propertyStringValue.append(delimiter);
        return propertyStringValue.toString();
    }

    private static String getNameServerConfigPropertyStringValue(INameServerConfig[] configs) throws VcmFailure {
        String delimiter = NameServerConfigManager.findDelimiter(configs);
        if (delimiter == null) {
            throw new VcmFailure("Unable to find Delimiter for property");
        }
        StringBuffer propertyStringValue = new StringBuffer(delimiter);
        int i = 0;
        while (i < configs.length) {
            INameServerConfig nextConfig = configs[i];
            propertyStringValue.append(NameServerConfigManager.getConfigStringValue(delimiter, nextConfig));
            ++i;
        }
        return propertyStringValue.toString().substring(0, propertyStringValue.length() - 1);
    }

    private static boolean usesHTTPS(int connectionTemplId) {
        try {
            IConnectionTemplate template = ConnectionPool.getTemplateProvider().getConnectionTemplate(connectionTemplId);
            return template.getProtocol().equals(Protocol.HTTPS);
        }
        catch (InvalidTemplateIDException e) {
            return false;
        }
    }

    public static void setNameServerConfigurations(ICollection rootCollection, INameServerConfig[] configs) throws VcmFailure {
        if (configs == null) {
            throw new VcmFailure("Invalid parameter value for Name-Server-Config property");
        }
        if (!rootCollection.isRootCollection()) {
            throw new VcmFailure("Name-Server-Config property can only be set on the Root Collection");
        }
        String propertyString = null;
        propertyString = configs.length == 0 ? "#" : NameServerConfigManager.getNameServerConfigPropertyStringValue(configs);
        if (propertyString == null) {
            throw new VcmFailure("Unable to construct Name-Server-Config property String value");
        }
        IMutableProperty property = PropertyFactoryAccess.getFactory().createProperty(XCM.NAMESPACE_PREFIX, XCM.NAME_SERVER_CONFIG.localName);
        property.setValue(propertyString);
        rootCollection.setProperties(new IProperty[]{property});
    }

    public static INameServerConfig[] getNameServerConfigurations(ICollection rootCollection) throws VcmFailure {
        if (!rootCollection.isRootCollection()) {
            throw new VcmFailure("Name-Server-Config property can only be retrieved from the Root Collection");
        }
        if (!NameServerConfigManager.readableOptionSupported(rootCollection.getConnectionTemplID())) {
            throw new VcmFailure("DTR Server does not support option to read Name-Server-Config property");
        }
        rootCollection.getPropertyCacheControl().resetProperty(XCM.NAME_SERVER_CONFIG.qualifiedName);
        IProperty property = rootCollection.getProperty(XCM.NAME_SERVER_CONFIG.qualifiedName);
        String nameServerConfig = property.getValue();
        return NameServerConfigManager.constructNameServerConfigsFromString(nameServerConfig);
    }

    private static INameServerConfig[] constructNameServerConfigsFromString(String nameServerConfigValue) {
        ArrayList nameServerConfigs = new ArrayList();
        if (nameServerConfigValue != null) {
            String delimiter = nameServerConfigValue.substring(0, 1);
            String remainingValue = nameServerConfigValue;
            while (remainingValue.length() > 1) {
                remainingValue = NameServerConfigManager.getNextElement(remainingValue, delimiter, nameServerConfigs);
            }
        }
        return nameServerConfigs.toArray(new INameServerConfig[nameServerConfigs.size()]);
    }

    private static String getNextElement(String value, String delimiter, ArrayList nameServerConfigs) {
        String url = null;
        String user = null;
        String passwd = null;
        String trustStore = null;
        String keyStore = null;
        int firstPos = 0;
        int nextPos = 0;
        int i = 0;
        while (i < 5) {
            firstPos = nextPos;
            if ((nextPos = value.indexOf(delimiter, firstPos + 1)) == -1) {
                nextPos = value.length();
            }
            String nextPart = value.substring(firstPos + 1, nextPos);
            switch (i) {
                case 0: {
                    url = nextPart;
                    break;
                }
                case 1: {
                    user = nextPart;
                    break;
                }
                case 2: {
                    passwd = nextPart;
                    break;
                }
                case 3: {
                    trustStore = nextPart;
                    break;
                }
                case 4: {
                    keyStore = nextPart;
                }
            }
            ++i;
        }
        NameServerConfigImpl nextConfig = new NameServerConfigImpl(url, user, passwd, trustStore, keyStore);
        nameServerConfigs.add(nextConfig);
        return value.substring(nextPos);
    }

    public static void removeNameServerConfiguration(ICollection rootCollection, String url) throws VcmFailure {
        if (!rootCollection.isRootCollection()) {
            throw new VcmFailure("Name-Server-Config property can only be set on the Root Collection");
        }
        INameServerConfig[] currentConfigs = NameServerConfigManager.getNameServerConfigurations(rootCollection);
        ArrayList<INameServerConfig> newConfigs = new ArrayList<INameServerConfig>();
        int i = 0;
        while (i < currentConfigs.length) {
            INameServerConfig thisConfig = currentConfigs[i];
            if (!url.equalsIgnoreCase(thisConfig.getURL())) {
                newConfigs.add(thisConfig);
            }
            ++i;
        }
        NameServerConfigManager.setNameServerConfigurations(rootCollection, newConfigs.toArray(new INameServerConfig[newConfigs.size()]));
    }

    public static void addNameServerConfiguration(ICollection rootCollection, INameServerConfig[] configs) throws VcmFailure {
        if (!rootCollection.isRootCollection()) {
            throw new VcmFailure("Name-Server-Config property can only be set on the Root Collection");
        }
        ArrayList<INameServerConfig> allConfigs = new ArrayList<INameServerConfig>();
        INameServerConfig[] currentConfigs = NameServerConfigManager.getNameServerConfigurations(rootCollection);
        int i = 0;
        while (i < currentConfigs.length) {
            allConfigs.add(currentConfigs[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < configs.length) {
            allConfigs.add(configs[i2]);
            ++i2;
        }
        NameServerConfigManager.setNameServerConfigurations(rootCollection, allConfigs.toArray(new INameServerConfig[allConfigs.size()]));
    }

    public static INameServerConfig createNameServerConfiguration(String URL2, String user, String password, String trustStore, String keyStore) {
        return new NameServerConfigImpl(URL2, user, password, trustStore, keyStore);
    }

    private static boolean readableOptionSupported(int connectionTemplId) throws VcmFailure {
        IRepositoryOptions dvOptions = RepositoryOptionsAccess.getInstance();
        IRepositoryFunctionality dvRepositoryFunctionality = dvOptions.getFunctionality(connectionTemplId, "XCM:name-server-config");
        if (dvRepositoryFunctionality != null) {
            return dvRepositoryFunctionality.containsOption("readable");
        }
        return false;
    }
}

