/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import com.tssap.dtr.client.lib.protocol.templates.ITemplateProvider;
import com.tssap.dtr.client.lib.protocol.templates.InvalidTemplateIDException;
import com.tssap.dtr.client.lib.protocol.templates.TemplateException;
import com.tssap.dtr.client.lib.protocol.templates.TemplateSerializer;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.config.impl.SessionContextBag;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class TemplateProvider
implements ITemplateProvider {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$deltavlib$TemplateProvider == null ? (class$com$tssap$dtr$client$lib$deltavlib$TemplateProvider = TemplateProvider.class$("com.tssap.dtr.client.lib.deltavlib.TemplateProvider")) : class$com$tssap$dtr$client$lib$deltavlib$TemplateProvider));
    private List _templatesById = new ArrayList();
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$TemplateProvider;

    public TemplateProvider() {
        String METHOD = "TemplateProvider";
        LOCATION.debugT("TemplateProvider", "Constructing ''{0}''.", new Object[]{this});
    }

    public synchronized int addConnectionTemplate(IConnectionTemplate connectionTemplate) {
        String METHOD = "addConnectionTemplate";
        LOCATION.infoT("addConnectionTemplate", "ADDING TEMPLATE ''{0}''.", new Object[]{connectionTemplate});
        if (connectionTemplate == null) {
            throw new IllegalArgumentException("Parameter 'connectionTemplate' must be non-null.");
        }
        this._templatesById.add(connectionTemplate);
        LOCATION.infoT("addConnectionTemplate", "REGISTRERED TEMPLATES:");
        if (this._templatesById.size() == 0) {
            LOCATION.errorT("addConnectionTemplate", "TEMPLATE PROVIDER IS EMPTY");
            throw new IllegalStateException("TEMPLATE PROVIDER IS EMPTY");
        }
        int i = 0;
        while (i < this._templatesById.size()) {
            LOCATION.infoT("addConnectionTemplate", "\t{0}", new Object[]{this._templatesById.get(i)});
            ++i;
        }
        return this._templatesById.size() - 1;
    }

    public synchronized IConnectionTemplate getConnectionTemplate(int templateId) throws InvalidTemplateIDException {
        String METHOD = "getConnectionTemplate(int)";
        if (this._templatesById.size() == 0) {
            LOCATION.warningT("getConnectionTemplate(int)", "TEMPLATE PROVIDER IS EMPTY");
        }
        return (IConnectionTemplate)this._templatesById.get(templateId);
    }

    public synchronized IConnectionTemplate getConnectionTemplate(String serverUrl) {
        int[] matches;
        String METHOD = "getConnectionTemplate(String)";
        if (this._templatesById.size() == 0) {
            LOCATION.warningT("getConnectionTemplate(String)", "TEMPLATE PROVIDER IS EMPTY");
        }
        return (matches = this.searchTemplate(serverUrl)).length > 0 ? (IConnectionTemplate)this._templatesById.get(matches[0]) : null;
    }

    public synchronized int[] searchTemplate(String url) {
        String urlToFind = this.canonicalizeUrl(url);
        int count = 0;
        int n = this._templatesById.size();
        BitSet resultSet = new BitSet(n);
        int i = 0;
        while (i < n) {
            IConnectionTemplate template = (IConnectionTemplate)this._templatesById.get(i);
            if (template != null && this.canonicalizeUrl(template.getUrl()).equals(urlToFind)) {
                resultSet.set(i);
                ++count;
            }
            ++i;
        }
        int[] result = new int[count];
        if (count == 1) {
            result[0] = resultSet.length() - 1;
        } else if (count > 1) {
            int i2 = 0;
            int j = 0;
            while (i2 < n) {
                if (resultSet.get(i2)) {
                    result[j++] = i2;
                }
                ++i2;
            }
        }
        return result;
    }

    public synchronized int replaceConnectionTemplate(IConnectionTemplate newConnectionTemplate) {
        String METHOD = "replaceConnectionTemplate";
        LOCATION.warningT("replaceConnectionTemplate", "REPLACING TEMPLATE ''{0}''.", new Object[]{newConnectionTemplate});
        int result = 0;
        int oldId = this.removeConnectionTemplate(newConnectionTemplate);
        if (oldId >= 0) {
            this._templatesById.set(oldId, newConnectionTemplate);
            result = oldId;
        } else {
            this._templatesById.add(newConnectionTemplate);
            result = this._templatesById.size() - 1;
        }
        LOCATION.infoT("replaceConnectionTemplate", "REGISTRERED TEMPLATES:");
        if (this._templatesById.size() == 0) {
            LOCATION.errorT("replaceConnectionTemplate", "TEMPLATE PROVIDER IS EMPTY");
            throw new IllegalStateException("TEMPLATE PROVIDER IS EMPTY");
        }
        int i = 0;
        while (i < this._templatesById.size()) {
            LOCATION.infoT("replaceConnectionTemplate", "\t{0}", new Object[]{this._templatesById.get(i)});
            ++i;
        }
        return result;
    }

    public synchronized int replaceConnectionTemplate(IConnectionTemplate oldTemplate, IConnectionTemplate newConnectionTemplate) {
        String METHOD = "replaceConnectionTemplate(old,new)";
        LOCATION.warningT("replaceConnectionTemplate(old,new)", "REPLACING TEMPLATE ''{0}'' by ''{1}''.", new Object[]{oldTemplate, newConnectionTemplate});
        int result = 0;
        int oldId = this.removeConnectionTemplate(oldTemplate);
        if (oldId >= 0) {
            this._templatesById.set(oldId, newConnectionTemplate);
            result = oldId;
        } else {
            this._templatesById.add(newConnectionTemplate);
            result = this._templatesById.size() - 1;
        }
        LOCATION.infoT("replaceConnectionTemplate(old,new)", "REGISTRERED TEMPLATES:");
        if (this._templatesById.size() == 0) {
            LOCATION.errorT("replaceConnectionTemplate(old,new)", "TEMPLATE PROVIDER IS EMPTY");
            throw new IllegalStateException("TEMPLATE PROVIDER IS EMPTY");
        }
        int i = 0;
        while (i < this._templatesById.size()) {
            LOCATION.infoT("replaceConnectionTemplate(old,new)", "\t{0}", new Object[]{this._templatesById.get(i)});
            ++i;
        }
        return result;
    }

    public synchronized int removeConnectionTemplate(IConnectionTemplate connectionTemplate) {
        String METHOD = "removeConnectionTemplate";
        LOCATION.warningT("removeConnectionTemplate", "REMOVING TEMPLATE ''{0}''.", new Object[]{connectionTemplate});
        if (connectionTemplate == null) {
            return -1;
        }
        String serverUrl = this.canonicalizeUrl(connectionTemplate.getUrl());
        int[] ids = this.searchTemplate(serverUrl);
        int result = -1;
        if (ids != null && ids.length == 1) {
            this._templatesById.set(ids[0], null);
            result = ids[0];
        } else {
            LOCATION.warningT("removeConnectionTemplate", "No template ID found for template \"{0}\"", new Object[]{connectionTemplate});
        }
        if (this._templatesById.size() == 0) {
            LOCATION.warningT("removeConnectionTemplate", "TEMPLATE PROVIDER IS EMPTY");
        }
        return result;
    }

    public synchronized Iterator iterator() {
        ArrayList result = new ArrayList();
        Iterator iter = this._templatesById.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o == null) continue;
            result.add(o);
        }
        return result.iterator();
    }

    public List listConnectionTemplates() {
        return Collections.unmodifiableList(this._templatesById);
    }

    public synchronized void persist(OutputStream outputStream) throws IOException {
        new TemplateSerializer((ITemplateProvider)this).serialize(outputStream);
    }

    public synchronized void depersist(InputStream inputStream, SessionContextBag sessionContexts) {
        try {
            new TemplateSerializer((ITemplateProvider)this).initialize(inputStream);
            Iterator iter = this._templatesById.iterator();
            while (iter.hasNext()) {
                IConnectionTemplate template = (IConnectionTemplate)iter.next();
                String serverUrl = this.canonicalizeUrl(template.getUrl());
                ISessionContext ctx = sessionContexts.getSessionContextForServer(serverUrl);
                if (ctx == null && (ctx = sessionContexts.getDefaultSessionContext()) == null) {
                    ctx = new SessionContext();
                    try {
                        sessionContexts.setSessionContextForServer(serverUrl, ctx);
                    }
                    catch (MalformedURLException e) {
                        LogUtil.logException((Location)LOCATION, (Throwable)e);
                    }
                }
                String user = ctx.getUser();
                String password = ctx.getPassword();
                template.getSessionContext().setUser(user);
                template.getSessionContext().setPassword(password);
            }
        }
        catch (IOException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
        catch (TemplateException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private String canonicalizeUrl(String url) {
        if (url != null) ** GOTO lbl4
        return url;
lbl-1000:
        // 1 sources

        {
            url = url.concat("/");
lbl4:
            // 2 sources

            ** while (!url.endsWith((String)"/"))
        }
lbl5:
        // 1 sources

        return url;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

