/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib;

import com.tssap.dtr.client.lib.protocol.util.Encoder;

public abstract class PathUtil {
    private PathUtil() {
    }

    public static String getNameFromPath(String path) {
        int startPos = -1;
        int length = path.length();
        startPos = path.endsWith("/") ? path.lastIndexOf(47, --length - 1) : path.lastIndexOf(47);
        if (startPos < 0) {
            return null;
        }
        return path.substring(startPos + 1, length);
    }

    public static String getParentPath(String path) {
        int pos = path.lastIndexOf(47);
        if (path.length() - pos == 1) {
            pos = path.lastIndexOf(47, pos - 1);
        }
        if (pos < 0) {
            return null;
        }
        return path.substring(0, ++pos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean equalWebDAVpaths(String path1, String path2) {
        int length1 = path1.length();
        int length2 = path2.length();
        int delta = length1 - length2;
        int intersection = 0;
        if (delta == 0) {
            return path1.equals(path2);
        }
        if (delta == -1) {
            if (path2.charAt(length1) != '/') return false;
            intersection = length1;
            return path1.regionMatches(0, path2, 0, intersection);
        } else {
            if (delta != 1) return false;
            if (path1.charAt(length2) != '/') return false;
            intersection = length2;
        }
        return path1.regionMatches(0, path2, 0, intersection);
    }

    public static String[] encodePathSet(String[] decodedPathSet) {
        if (decodedPathSet == null) {
            throw new NullPointerException("null path-set to encode");
        }
        String[] encodedHrefs = new String[decodedPathSet.length];
        int i = 0;
        while (i < decodedPathSet.length) {
            if (decodedPathSet[i] == null) {
                throw new NullPointerException("null element in path-set");
            }
            encodedHrefs[i] = Encoder.encodePath((String)decodedPathSet[i]);
            ++i;
        }
        return encodedHrefs;
    }

    public static String[] decodePathSet(String[] encodedPathSet) {
        if (encodedPathSet == null) {
            throw new NullPointerException("null path-set to decode");
        }
        String[] decodedHrefs = new String[encodedPathSet.length];
        int i = 0;
        while (i < encodedPathSet.length) {
            if (encodedPathSet[i] == null) {
                throw new NullPointerException("null element in path-set");
            }
            decodedHrefs[i] = Encoder.decodePath((String)encodedPathSet[i]);
            ++i;
        }
        return decodedHrefs;
    }

    public static String composePath(String[] pathElements) {
        StringBuffer pathBuf = new StringBuffer();
        boolean isEndedWithTrailSlash = false;
        int i = 0;
        while (i < pathElements.length) {
            if (isEndedWithTrailSlash) {
                if (pathElements[i].startsWith("/")) {
                    pathBuf.append(pathElements[i].substring(1));
                } else {
                    pathBuf.append(pathElements[i]);
                }
            } else if (pathElements[i].startsWith("/")) {
                pathBuf.append(pathElements[i]);
            } else {
                pathBuf.append('/').append(pathElements[i]);
            }
            isEndedWithTrailSlash = pathElements[i].endsWith("/");
            ++i;
        }
        return pathBuf.toString();
    }

    public static StringBuffer appendPathElement(StringBuffer parentPathBuf, String pathElement) {
        int buflen = parentPathBuf.length();
        int destDelimiterPos = buflen - 1;
        if (destDelimiterPos < 0) {
            return parentPathBuf.append(pathElement);
        }
        int srcDelimiterPos = pathElement.length() - 1;
        if (srcDelimiterPos < 0) {
            return parentPathBuf;
        }
        int delimiterCount = 0;
        if ('/' == parentPathBuf.charAt(destDelimiterPos)) {
            ++delimiterCount;
        }
        if ('/' == pathElement.charAt(0)) {
            ++delimiterCount;
        }
        if (delimiterCount == 0) {
            return parentPathBuf.append('/').append(pathElement);
        }
        if (delimiterCount == 1) {
            return parentPathBuf.append(pathElement);
        }
        parentPathBuf.setLength(buflen - 1);
        return parentPathBuf.append(pathElement);
    }
}

