/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.CommunicationException;
import com.tssap.dtr.client.lib.deltavlib.TemplateProvider;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.pool.IConnectionPool;
import com.tssap.dtr.client.lib.protocol.pool.OutOfConnectionsException;
import com.tssap.dtr.client.lib.protocol.requests.http.OptionsRequest;
import com.tssap.dtr.client.lib.protocol.templates.ITemplateProvider;
import com.tssap.dtr.client.lib.protocol.templates.TemplateException;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import java.io.IOException;

public class ConnectionPool {
    private static final Location LOC = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$deltavlib$ConnectionPool == null ? (class$com$tssap$dtr$client$lib$deltavlib$ConnectionPool = ConnectionPool.class$("com.tssap.dtr.client.lib.deltavlib.ConnectionPool")) : class$com$tssap$dtr$client$lib$deltavlib$ConnectionPool));
    private static IConnectionPoolProvider CON_FACTORY_PROVIDER;
    private static final TemplateProvider TEMPLATE_PROVIDER;
    private static boolean _multiThreadingMode;
    private static IConnectionPool G_CON_POOL;
    private static ThreadLocal TLS_CON_POOL;
    public static final String CON_FACTORY_PROVIDER_NAME = "deltavlib.connection.factoryprovider";
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$ConnectionPool;

    public static IConnectionPool getInstance() {
        return ConnectionPool.getConnectionPoolProviderInstance().getPool();
    }

    public static Class getConnectionPoolProvider() {
        return ConnectionPool.getConnectionPoolProviderInstance().getClass();
    }

    public static void setMultiThreadingModeForDefaultPoolProvider(boolean mode) {
        _multiThreadingMode = mode;
        ConnectionPool.initializeConnectionPoolProvider();
    }

    public static boolean isMultiThreadingModeForDefaultPoolProvider() {
        return _multiThreadingMode;
    }

    public static TemplateProvider getTemplateProvider() {
        return TEMPLATE_PROVIDER;
    }

    private static void initializeConnectionPoolProvider() {
        block7: {
            try {
                String providerClassName = System.getProperty(CON_FACTORY_PROVIDER_NAME);
                if (providerClassName != null) {
                    try {
                        Class<?> providerClass = Class.forName(providerClassName);
                        if (providerClass == null) {
                            throw new ClassNotFoundException(providerClassName);
                        }
                        Object provider = providerClass.newInstance();
                        if (provider instanceof IConnectionPoolProvider) {
                            CON_FACTORY_PROVIDER = (IConnectionPoolProvider)provider;
                            break block7;
                        }
                        CON_FACTORY_PROVIDER = new DefaultPoolProvider();
                        String msg = providerClassName + ": custom factory provider not found. Using default";
                        LOC.errorT(msg);
                    }
                    catch (ClassNotFoundException e) {
                        CON_FACTORY_PROVIDER = new DefaultPoolProvider();
                        String msg = providerClassName + ": custom factory provider not found. Using default";
                        LOC.errorT(msg);
                    }
                    break block7;
                }
                CON_FACTORY_PROVIDER = new DefaultPoolProvider();
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOC, (Throwable)e);
                throw new RuntimeException("failed to load custom connection factory provider");
            }
        }
    }

    private static IConnectionPoolProvider getConnectionPoolProviderInstance() {
        return CON_FACTORY_PROVIDER;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void enableSingleActivityTrace(int connectionTemplID, String id, String level) throws VcmFailure {
        IConnectionPool connectionPool = ConnectionPool.getInstance();
        IConnection connection = null;
        try {
            block5: {
                try {
                    connection = connectionPool.acquireConnection(connectionTemplID);
                    ISessionContext sessionContext = connection.getSessionContext();
                    if (sessionContext == null) break block5;
                    sessionContext.enableServerSessionTrace(id, level);
                }
                catch (OutOfConnectionsException e) {
                    throw new CommunicationException("Failed to acquire connection", e);
                }
                catch (TemplateException e) {
                    throw new CommunicationException("Failed to acquire connection", e);
                }
            }
            Object var8_7 = null;
            if (connection == null) return;
            connectionPool.releaseConnection(connection, false);
            return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (connection == null) throw throwable;
            connectionPool.releaseConnection(connection, false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void disableSingleActivityTrace(int connectionTemplID) throws VcmFailure {
        IConnectionPool connectionPool = ConnectionPool.getInstance();
        IConnection connection = null;
        try {
            try {
                connection = connectionPool.acquireConnection(connectionTemplID);
                ISessionContext sessionContext = connection.getSessionContext();
                if (sessionContext != null) {
                    sessionContext.closeSession();
                }
                OptionsRequest optionsRequest = new OptionsRequest("");
                optionsRequest.perform(connection, true);
            }
            catch (OutOfConnectionsException e) {
                throw new CommunicationException("Failed to acquire connection", e);
            }
            catch (TemplateException e) {
                throw new CommunicationException("Failed to acquire connection", e);
            }
            catch (IOException e) {
                LogUtil.traceCaughtException((Location)LOC, (Throwable)e, (int)300);
                Object var8_8 = null;
                if (connection == null) return;
                connectionPool.releaseConnection(connection, false);
                return;
            }
            catch (HTTPException e) {
                LogUtil.traceCaughtException((Location)LOC, (Throwable)e, (int)300);
                Object var8_9 = null;
                if (connection == null) return;
                connectionPool.releaseConnection(connection, false);
                return;
            }
            Object var8_7 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (connection == null) throw throwable;
            connectionPool.releaseConnection(connection, false);
            throw throwable;
        }
        connectionPool.releaseConnection(connection, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TEMPLATE_PROVIDER = new TemplateProvider();
        _multiThreadingMode = false;
        G_CON_POOL = new com.tssap.dtr.client.lib.protocol.pool.ConnectionPool((ITemplateProvider)TEMPLATE_PROVIDER);
        ((com.tssap.dtr.client.lib.protocol.pool.ConnectionPool)G_CON_POOL).setDefaultLimit(1);
        TLS_CON_POOL = new ThreadLocal(){

            protected Object initialValue() {
                com.tssap.dtr.client.lib.protocol.pool.ConnectionPool pool = new com.tssap.dtr.client.lib.protocol.pool.ConnectionPool((ITemplateProvider)TEMPLATE_PROVIDER);
                pool.setDefaultLimit(1);
                return pool;
            }
        };
        ConnectionPool.initializeConnectionPoolProvider();
    }

    private static class DefaultPoolProvider
    implements IConnectionPoolProvider {
        private DefaultPoolProvider() {
        }

        public IConnectionPool getPool() {
            if (_multiThreadingMode) {
                return (IConnectionPool)TLS_CON_POOL.get();
            }
            return G_CON_POOL;
        }
    }

    public static interface IConnectionPoolProvider {
        public IConnectionPool getPool();
    }
}

