/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.cms;

import com.tssap.dtr.client.lib.cms.DTRException;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.entities.ErrorEntity;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.Depth;
import com.tssap.dtr.client.lib.protocol.requests.dav.MkColRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.MkWorkspaceRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.PropfindRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.ProppatchRequest;
import com.tssap.dtr.client.lib.protocol.requests.http.OptionsRequest;
import com.tssap.dtr.client.lib.protocol.util.Tokenizer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.util.List;

public class DTR {
    private ISessionContext context;
    private String repositoryURL;
    private Connection connection;
    private static final String WORKSPACE_ROOT = "ws/";

    private DTR() {
    }

    public static DTR getInstance() {
        return new DTR();
    }

    public void connect(String respositoryURL, ISessionContext context) throws MalformedURLException, DTRException {
        this.repositoryURL = respositoryURL;
        this.context = context;
        this.connection = new Connection(respositoryURL, context);
        this.connection.setFollowRedirects(false);
        OptionsRequest request = new OptionsRequest("");
        IResponse response = this.execute((IRequest)request);
        int status = response.getStatus();
        if (status == 401) {
            throw new DTRException("User" + (context.getUser() != null ? " \"" + context.getUser() + "\"" : "") + " is not authorized to access repository \"" + respositoryURL + "\"");
        }
        if (status >= 300 && status < 399) {
            throw new DTRException("User" + (context.getUser() != null ? " \"" + context.getUser() + "\"" : "") + " is not authorized to access repository \"" + respositoryURL + "\" with initial password. " + " Please change your password in the user management system.");
        }
        if (status != 200) {
            throw new DTRException("Repository failed to properly respond on request \"" + request.getMethod() + " /\" [" + response.getStatusLine() + "]");
        }
    }

    public void disconnect() {
        this.connection.close();
        this.connection = null;
    }

    public String createWorkspace(String workspacePath) throws DTRException {
        List parts = Tokenizer.partsOf((String)workspacePath, (String)"/");
        String path = "/";
        if (parts.size() > 1) {
            int i = 0;
            while (i < parts.size() - 1) {
                path = path + (String)parts.get(i) + "/";
                this.makeCol(path);
                ++i;
            }
            this.enableWorkspaceCol(path);
        }
        path = path + (String)parts.get(parts.size() - 1) + "/";
        this.makeWorkspace(path);
        return this.getWorkspaceID(path);
    }

    public boolean existsWorkspace(String workspacePath) throws DTRException {
        String remotePath = this.getAbsolutePath(workspacePath);
        PropfindRequest request = new PropfindRequest(remotePath);
        request.setDepth(Depth.DEPTH_0);
        request.addPropertyGet("XCM:oid", com.tssap.dtr.client.lib.protocol.XCM.NAMESPACE);
        IResponse response = this.execute((IRequest)request);
        if (response.getStatus() == 404) {
            return false;
        }
        if (response.getStatus() == 403) {
            throw new DTRException("User" + (this.context.getUser() != null ? " \"" + this.context.getUser() + "\"" : "") + " has no read access privileges for workspace \"" + remotePath + ".");
        }
        if (response.getStatus() == 207) {
            PropertyElement prop = this.getPropertyFromResponse(response, "XCM:oid", com.tssap.dtr.client.lib.protocol.XCM.NAMESPACE);
            return prop != null && prop.getStatusCode() == 200;
        }
        throw new DTRException("Repository failed to properly respond to request \"" + request.getMethod() + " /\" [" + response.getStatusLine() + "]");
    }

    public String getWorkspaceID(String workspacePath) throws DTRException {
        String workspaceID = this.getProperty(workspacePath, "XCM:oid", com.tssap.dtr.client.lib.protocol.XCM.NAMESPACE);
        if (workspaceID == null) {
            String remotePath = this.getAbsolutePath(workspacePath);
            throw new DTRException("Workspace \"" + remotePath + "\" has no valid ID. " + "[property \"" + "XCM:oid" + "\" is not set on this workspace]");
        }
        return workspaceID;
    }

    public String getProperty(String workspacePath, String property, String namespaceURI) throws DTRException {
        String remotePath = this.getAbsolutePath(workspacePath);
        PropfindRequest request = new PropfindRequest(remotePath);
        request.setDepth(Depth.DEPTH_0);
        request.addPropertyGet(property, namespaceURI);
        IResponse response = this.execute((IRequest)request);
        if (response.getStatus() == 404) {
            throw new DTRException("Workspace \"" + remotePath + "\" does not exist.");
        }
        if (response.getStatus() == 403) {
            throw new DTRException("User" + (this.context.getUser() != null ? " \"" + this.context.getUser() + "\"" : "") + " has no read access privileges for workspace \"" + remotePath + ".");
        }
        if (response.getStatus() == 207) {
            PropertyElement prop = this.getPropertyFromResponse(response, property, namespaceURI);
            if (prop.getStatusCode() == 200) {
                return prop.getValue();
            }
            if (prop.getStatusCode() == 404) {
                return null;
            }
            throw new DTRException("Retrieving property \"" + property + "\" on workspace \"" + remotePath + "\" failed. [" + prop.getStatusCode() + " " + prop.getStatusDescription() + "]");
        }
        throw new DTRException("Repository failed to properly respond to request \"" + request.getMethod() + " /\" [" + response.getStatusLine() + "]");
    }

    public void setProperty(String workspacePath, String property, String value, String namespaceURI) throws DTRException {
        this.assertConnectionOpen();
        String remotePath = this.getAbsolutePath(workspacePath);
        ProppatchRequest request = new ProppatchRequest(remotePath);
        request.addPropertySet(property, value, namespaceURI);
        IResponse response = this.execute((IRequest)request);
        if (response.getStatus() == 404) {
            throw new DTRException("Workspace \"" + remotePath + "\" does not exist.");
        }
        if (response.getStatus() == 403) {
            throw new DTRException("User" + (this.context.getUser() != null ? " \"" + this.context.getUser() + "\"" : "") + " has no write access privileges for workspace \"" + remotePath + ".");
        }
        if (response.getStatus() == 207) {
            PropertyElement prop = this.getPropertyFromResponse(response, property, namespaceURI);
            String errorCondition = this.getErrorCondition(prop);
            if (prop.getStatusCode() == 403 && "cannot-modify-protected-property".equals(errorCondition)) {
                throw new DTRException("Setting property \"" + property + "\" on workspace \"" + remotePath + "\" failed. This property is read-only.");
            }
            throw new DTRException("Setting property \"" + property + "\" on workspace \"" + remotePath + "\" failed. [" + prop.getStatusCode() + " " + prop.getStatusDescription() + "]");
        }
        if (response.getStatus() != 200) {
            throw new DTRException("Repository failed to properly respond to request \"" + request.getMethod() + " /\" [" + response.getStatusLine() + "]");
        }
    }

    public void removeProperty(String workspacePath, String property, String namespaceURI) throws DTRException {
        this.assertConnectionOpen();
        String remotePath = this.getAbsolutePath(workspacePath);
        ProppatchRequest request = new ProppatchRequest(remotePath);
        request.addPropertyRemove(property, namespaceURI);
        IResponse response = this.execute((IRequest)request);
        if (response.getStatus() == 404) {
            throw new DTRException("Workspace \"" + workspacePath + "\" does not exist.");
        }
        if (response.getStatus() == 403) {
            throw new DTRException("User" + (this.context.getUser() != null ? " \"" + this.context.getUser() + "\"" : "") + " has no write access privileges for workspace \"" + remotePath + ".");
        }
        if (response.getStatus() == 207) {
            PropertyElement prop = this.getPropertyFromResponse(response, property, namespaceURI);
            if (prop.getStatusCode() == 403 && "cannot-modify-protected-property".equals(prop.getErrorCondition())) {
                throw new DTRException("Removing property \"" + property + "\" on workspace \"" + remotePath + "\" failed. This property is read-only.");
            }
            throw new DTRException("Removing property \"" + property + "\" on workspace \"" + remotePath + "\" failed. [" + prop.getStatusCode() + " " + prop.getStatusDescription() + "]");
        }
        if (response.getStatus() != 200) {
            throw new DTRException("Repository failed to properly respond to request \"" + request.getMethod() + " /\" [" + response.getStatusLine() + "]");
        }
    }

    public void removeWorkspaceOwnership(String workspacePath) throws DTRException {
        this.removeProperty(workspacePath, "XCM:cbs-owner-buildspace", com.tssap.dtr.client.lib.protocol.XCM.NAMESPACE);
    }

    private void makeWorkspace(String path) throws DTRException {
        String remotePath = this.getAbsolutePath(path);
        MkWorkspaceRequest request = new MkWorkspaceRequest(remotePath);
        IResponse response = this.execute((IRequest)request);
        int status = response.getStatus();
        if (status == 201) {
            return;
        }
        if (status == 409) {
            ErrorEntity entity = (ErrorEntity)response.getEntity();
            if (entity != null && entity.getExtendedCondition().endsWith("name-conflict")) {
                throw new DTRException("Workspace \"" + remotePath + "\" already exists.");
            }
        } else if (status == 403) {
            throw new DTRException("User" + (this.context.getUser() != null ? " \"" + this.context.getUser() + "\"" : "") + " has not enough privileges to create workspace \"" + remotePath + ".");
        }
        throw new DTRException("Creation of workspace \"" + remotePath + "\" failed. [" + response.getStatusLine() + "]");
    }

    private void makeCol(String path) throws DTRException {
        String remotePath = this.getAbsolutePath(path);
        MkColRequest request = new MkColRequest(remotePath);
        IResponse response = this.execute((IRequest)request);
        int status = response.getStatus();
        if (status == 201) {
            return;
        }
        if (status == 409) {
            ErrorEntity entity = (ErrorEntity)response.getEntity();
            if (entity != null && entity.getExtendedCondition().endsWith("name-conflict")) {
                return;
            }
        } else {
            if (status == 403) {
                throw new DTRException("User" + (this.context.getUser() != null ? " \"" + this.context.getUser() + "\"" : "") + " has not enough privileges to create workspace folder \"" + remotePath + "\".");
            }
            throw new DTRException("Creation of workspace folder \"" + remotePath + "\" failed. [" + response.getStatusLine() + "]");
        }
    }

    private void enableWorkspaceCol(String path) throws DTRException {
        String remotePath = this.getAbsolutePath(path);
        ProppatchRequest request = new ProppatchRequest(remotePath);
        request.addPropertySet("XCM:workspace-enabled", "T", com.tssap.dtr.client.lib.protocol.XCM.NAMESPACE);
        IResponse response = this.execute((IRequest)request);
        int status = response.getStatus();
        if (response.getStatus() == 404) {
            throw new DTRException("Workspace folder \"" + remotePath + "\" does not exist.");
        }
        if (status == 403) {
            throw new DTRException("Folder \"" + remotePath + "\" cannot be " + "used for the creation of a workspace.");
        }
        if (response.getStatus() == 207) {
            PropertyElement prop = this.getPropertyFromResponse(response, "XCM:workspace-enabled", com.tssap.dtr.client.lib.protocol.XCM.NAMESPACE);
            String errorCondition = this.getExtendedCondition(prop);
            if (prop.getStatusCode() == 409 && "must-be-empty-non-versioned-collection-under-workspace-root-set".equals(errorCondition)) {
                throw new DTRException("Folder \"" + remotePath + "\" cannot be " + "used for the creation of a workspace [precondition violated: " + "must-be-empty-non-versioned-collection-under-workspace-root-set" + "]");
            }
            throw new DTRException("Setting property \"XCM:workspace-enabled\" on workspace \"" + remotePath + "\" failed. [" + prop.getStatusCode() + " " + prop.getStatusDescription() + "]");
        }
        if (response.getStatus() != 200) {
            throw new DTRException("Repository failed to properly respond to request \"" + request.getMethod() + " /\" [" + response.getStatusLine() + "]");
        }
    }

    private PropertyElement getPropertyFromResponse(IResponse response, String property, String namespaceURI) {
        MultiStatusEntity entity;
        PropertyElement result = null;
        if (response.isMultiStatus() && (entity = (MultiStatusEntity)response.getEntity()).countResources() > 0) {
            ResourceElement workspace = entity.getResource(0);
            result = workspace.getProperty(property, namespaceURI);
        }
        return result;
    }

    private String getAbsolutePath(String workspacePath) {
        if (workspacePath.startsWith("/")) {
            return WORKSPACE_ROOT + workspacePath.substring(1);
        }
        return WORKSPACE_ROOT + workspacePath;
    }

    private void assertConnectionOpen() throws DTRException {
        if (this.connection == null) {
            throw new DTRException("Not connected to repository.");
        }
    }

    private String getErrorCondition(PropertyElement prop) {
        String s = prop.getErrorCondition();
        if (s == null) {
            return null;
        }
        int n = s.indexOf(58);
        return n > 0 ? s.substring(n + 1) : s;
    }

    private String getExtendedCondition(PropertyElement prop) {
        String s = prop.getExtendedCondition();
        if (s == null) {
            return null;
        }
        int n = s.indexOf(58);
        return n > 0 ? s.substring(n + 1) : s;
    }

    private IResponse execute(IRequest request) throws DTRException {
        this.assertConnectionOpen();
        IResponse response = this.uncheckedExecute(request);
        if (response == null) {
            throw new DTRException("No valid response returned from repository for request \"" + request.getMethod() + " " + request.getPath() + "\".");
        }
        return response;
    }

    private IResponse uncheckedExecute(IRequest request) throws DTRException {
        try {
            IResponse response = request.perform((IConnection)this.connection);
            int status = response.getStatus();
            if (status == 503) {
                throw new DTRException("Repository \"" + this.repositoryURL + "\" currently is not " + "available. Please try again later.");
            }
            if (status >= 500) {
                throw new DTRException("Repository \"" + this.repositoryURL + "\"  failed to properly " + "respond to request \"" + request.getMethod() + " " + request.getPath() + "\" [" + response.getStatusLine() + "]");
            }
            return response;
        }
        catch (ConnectException e) {
            throw new DTRException("Unable to connect to repository \"" + this.repositoryURL + "\". The server is down.");
        }
        catch (InterruptedIOException e) {
            throw new DTRException("A timeout occured while reading from repository \"" + this.repositoryURL + "\". The repository probably is too busy to serve " + "your requests now. Please try again later.");
        }
        catch (IOException e) {
            throw new DTRException("Communication problems occured with repository \"" + this.repositoryURL + "\".", e);
        }
        catch (HTTPException e) {
            throw new DTRException("Protocol problems occured with repository \"" + this.repositoryURL + "\".", e);
        }
    }

    public static class XCM
    implements com.tssap.dtr.client.lib.protocol.XCM {
        public static final String WORKSPACE_ID = "XCM:oid";
        public static final String RESOURCE_TYPE = "XCM:resource-type";
        public static final String CHANGE_MODEL = "XCM:change-management-model";
        private static final String WORKSPACE_ENABLED = "XCM:workspace-enabled";
        private static final String NAME_CONFLICT = "name-conflict";
        private static final String OWNER_BUILDSPACE = "XCM:cbs-owner-buildspace";
        private static final String WS_FOLDER_NOT_VALID = "must-be-empty-non-versioned-collection-under-workspace-root-set";
    }

    public static class DAV
    implements com.tssap.dtr.client.lib.protocol.DAV {
        public static final String PREFIX = "DAV:";
        public static final String DISPLAY_NAME = "DAV:displayname";
        public static final String COMMENT = "DAV:comment";
        public static final String CREATOR = "DAV:creator-displayname";
        public static final String CREATION_DATE = "DAV:creation-date";
        public static final String LAST_MODIFIED = "DAV:getlastmodified";
        public static final String CANNOT_MODIFY_PROTECTED_PROPERTY = "cannot-modify-protected-property";
        private static final String TRUE = "T";
    }
}

