/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.acl.impl;

import com.tssap.dtr.client.lib.acl.ACLException;
import com.tssap.dtr.client.lib.acl.IACL;
import com.tssap.dtr.client.lib.acl.impl.ACL;
import com.tssap.dtr.client.lib.acl.impl.ACLContentHandler;
import com.tssap.dtr.client.lib.acl.impl.ACLErrorHandler;
import com.tssap.dtr.client.lib.acl.impl.IACLParser;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class ACLParser
implements IACLParser {
    private IACL acl = null;
    private InputStream inputStream = null;
    private XMLReader parser = null;
    private String xmlReader = "org.apache.xerces.parsers.SAXParser";

    ACLParser() {
    }

    ACLParser(ACL acl) throws ACLException {
        this.acl = acl;
        this.createXMLReader();
        this.parser.setContentHandler(new ACLContentHandler(acl));
        this.parser.setErrorHandler(new ACLErrorHandler(acl));
    }

    public void setACL(ACL acl) {
        this.acl = acl;
    }

    public void setInput(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void parse() throws ACLException {
        try {
            if (this.inputStream != null) {
                InputSource inputSource = new InputSource(this.inputStream);
                this.parser.parse(inputSource);
            }
        }
        catch (IOException e) {
            throw new ACLException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new ACLException(e.getMessage(), e);
        }
    }

    private void createXMLReader() throws ACLException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            }
            catch (SAXException e) {
                throw new ACLException("Getting XML parser failed", e);
            }
            catch (FactoryConfigurationError e) {
                throw new ACLException("Getting XML parser factory failed", e);
            }
            catch (ParserConfigurationException e) {
                throw new ACLException("Getting XML parser failed", e);
            }
            Object var6_2 = null;
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (Throwable throwable) {
            Object var6_3 = null;
            Thread.currentThread().setContextClassLoader(cl);
            throw throwable;
        }
    }
}

