/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.acl.impl;

import com.tssap.dtr.client.lib.acl.ACLException;
import com.tssap.dtr.client.lib.acl.IACE;
import com.tssap.dtr.client.lib.acl.IACL;
import com.tssap.dtr.client.lib.acl.IACLListener;
import com.tssap.dtr.client.lib.acl.IACLManager;
import com.tssap.dtr.client.lib.acl.IInheritanceAwareACLListener;
import com.tssap.dtr.client.lib.acl.impl.ACE;
import com.tssap.dtr.client.lib.acl.impl.ACL;
import com.tssap.dtr.client.lib.acl.impl.InheritedAce;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.util.URLUtilities;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsManagerListener;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VersionedFileSystemFactory;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import com.tssap.dtr.client.lib.vfs.fileservice.IFileService;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ACLManager
implements IACLManager {
    private static final String ACL_BASE_PATH_PROPERTY = "XCM:acl-base-path";
    private static final String ACL_RELATIVE_PATH_BYPATH = "XCM:acl-relative-path-bypath";
    private static final String BASE_PATH_LOCATION_RESOURCE = "/";
    private static final String ACL_REL_REMOTE_ROOT = "";
    private static final String ACL_ABS_LOCAL_ROOT = "C:/temp";
    private static final String ACL_FILE_NAME = "acl.xml";
    private static final String ACL_ACCESSMODE_PATH_SEPARATOR = "byPath";
    private static final String WORKSPACE_PREFIX = "/ws";
    private static final String DEFAULT_ACTIVITY_NAME = "ACL Maintenance";
    private String aclBasePath = "/system/config/active/ACLs";
    private static HashMap _aclManagers = new HashMap();
    private static HashMap _activities = new HashMap();
    private HashSet _aclListeners = new HashSet();
    private String aclFilesRootPath;
    private IVersionedFileSystemManager vfsManager;
    private HashMap aclsByResourcePath = new HashMap();
    private boolean _invalid = false;

    private ACLManager(IVersionedFileSystemManager vfsManager) throws ACLException {
        this.vfsManager = vfsManager;
        VersionedFileSystemManager.addVfsManagerListener(new VfsManagerListener());
        this.readBasePaths();
        this.modifyVfsManager();
        this.aclFilesRootPath = WORKSPACE_PREFIX + PathUtilities.assureTrailingSeparator(this.aclBasePath, PathUtilities.REMOTE_FILESERVICE) + PathUtilities.preventTrailingSeparator(ACL_ACCESSMODE_PATH_SEPARATOR, PathUtilities.REMOTE_FILESERVICE);
    }

    public static IACLManager getACLManager(IVersionedFileSystemManager vfsManager) throws ACLException {
        return ACLManager.getACLManager(vfsManager.getCurrentContext());
    }

    public static IACLManager getACLManager(ILogicalSystem logicalSystem) throws ACLException {
        return ACLManager.getACLManager(logicalSystem, ACL_ABS_LOCAL_ROOT);
    }

    public static IACLManager getACLManager(IVfsContext context) throws ACLException {
        try {
            if (context == null) {
                return null;
            }
            if (_aclManagers.containsKey(context)) {
                return (IACLManager)_aclManagers.get(context);
            }
            IVersionedFileSystemManager vfsManager = VersionedFileSystemManager.getVersionedFileSystemManager(context);
            ACLManager aclManager = new ACLManager(vfsManager);
            _aclManagers.put(context, aclManager);
            return aclManager;
        }
        catch (VfsException e) {
            throw new ACLException(e);
        }
    }

    public static IACLManager getACLManager(ILogicalSystem logicalSystem, String localRoot) throws ACLException {
        if (logicalSystem == null || localRoot == null) {
            return null;
        }
        IClient client = ACLManager.getClient(logicalSystem, localRoot);
        IVfsContext context = client.getContext();
        return ACLManager.getACLManager(context);
    }

    public static void releaseACLManager(IACLManager aclManager) {
        ACLManager manager = (ACLManager)aclManager;
        IVersionedFileSystemManager vfsManager = manager.getVfsManager();
        _aclManagers.remove(vfsManager);
        VersionedFileSystemFactory.releaseVersionedFileSystemManager(vfsManager);
        manager.setVfsManager(null);
        manager.setInvalid();
    }

    public IACL getACL(IVfsFolderItem vfsFolderItem) throws ACLException {
        this.checkState();
        if (vfsFolderItem == null) {
            return null;
        }
        try {
            return this.getACL(vfsFolderItem.getUrl());
        }
        catch (VfsException e) {
            throw new ACLException(e);
        }
    }

    public IACL getACL(String resourceURL) throws ACLException {
        this.checkState();
        if (this.aclsByResourcePath.containsKey(resourceURL)) {
            return (ACL)this.aclsByResourcePath.get(resourceURL);
        }
        ACL acl = new ACL(this, resourceURL);
        this.aclsByResourcePath.put(resourceURL, acl);
        return acl;
    }

    public List getAces(String resourceUrl, boolean onlyInherited) throws ACLException {
        this.checkState();
        ArrayList inheritedAces = new ArrayList();
        String currentResourceUrl = resourceUrl;
        String rootUrl = this.getRepositoryURL(currentResourceUrl);
        if (!currentResourceUrl.startsWith(rootUrl)) {
            throw new ACLException("Cannot determine inherited ACEs for resource \"" + resourceUrl + "\". Path does not start with repository URL \"" + rootUrl + "\"");
        }
        IACL actACL = this.getACL(resourceUrl);
        if (!onlyInherited) {
            inheritedAces.addAll(actACL.getLocalAces());
        }
        boolean accumulateWithParentPermissions = actACL.getInheritanceType() != 3;
        while (!currentResourceUrl.equals(rootUrl)) {
            actACL = this.getACL(currentResourceUrl = PathUtilities.getParentPath(currentResourceUrl, PathUtilities.REMOTE_FILESERVICE, false));
            if (actACL.getInheritanceType() == 4) {
                inheritedAces.clear();
                accumulateWithParentPermissions = true;
            }
            if (accumulateWithParentPermissions) {
                inheritedAces.addAll(this.markAsInherited(actACL.getLocalAces()));
            }
            if (actACL.getInheritanceType() != 3) continue;
            accumulateWithParentPermissions = false;
        }
        return inheritedAces;
    }

    public List getInheritedAces(String resourceUrl) throws ACLException {
        return this.getAces(resourceUrl, true);
    }

    /*
     * Unable to fully structure code
     */
    public List getParentACLs(String resourceUrl) throws ACLException {
        this.checkState();
        parentACLs = new ArrayList<IACL>();
        currentResourceUrl = resourceUrl;
        rootUrl = this.getRepositoryURL(currentResourceUrl);
        if (currentResourceUrl.startsWith(rootUrl)) ** GOTO lbl10
        throw new ACLException("Cannot determine parent ACLs for resource \"" + resourceUrl + "\". Path does not start with repository URL \"" + rootUrl + "\"");
lbl-1000:
        // 1 sources

        {
            currentResourceUrl = PathUtilities.getParentPath(currentResourceUrl, PathUtilities.REMOTE_FILESERVICE, false);
            parentACLs.add(this.getACL(currentResourceUrl));
lbl10:
            // 2 sources

            ** while (!currentResourceUrl.equals((Object)rootUrl))
        }
lbl11:
        // 1 sources

        return parentACLs;
    }

    private List markAsInherited(List aces) {
        if (aces.isEmpty()) {
            return aces;
        }
        ArrayList<InheritedAce> result = new ArrayList<InheritedAce>(aces.size());
        Iterator iterator = aces.iterator();
        while (iterator.hasNext()) {
            IACE ace = (IACE)iterator.next();
            result.add(new InheritedAce(ace));
        }
        return result;
    }

    public IVersionedFileSystemManager getVfsManager() {
        this.checkState();
        return this.vfsManager;
    }

    private static IClient getClient(ILogicalSystem logicalSystem, String localRoot) throws ACLException {
        if (logicalSystem == null || localRoot == null) {
            return null;
        }
        String clientName = ACLManager.getClientName(logicalSystem);
        IConfiguration config = Configuration.getConfiguration();
        IClient client = config.getClient(clientName);
        if (client == null) {
            client = config.createClient(clientName, localRoot, logicalSystem);
            Iterator it = logicalSystem.repositoryServers();
            while (it.hasNext()) {
                IRepositoryServer server = (IRepositoryServer)it.next();
                client.createMountPoint(server, ACLManager.getRelRemoteRoot(server), ACLManager.getRelLocalRoot(server));
            }
        }
        return client;
    }

    public boolean isReleased() {
        return this._invalid;
    }

    private void setInvalid() {
        Iterator it = this.aclsByResourcePath.keySet().iterator();
        while (it.hasNext()) {
            ACL acl = (ACL)it.next();
            this.releaseACL(acl);
        }
        this._invalid = true;
    }

    private void setVfsManager(IVersionedFileSystemManager vfsManager) {
        this.vfsManager = vfsManager;
    }

    private void checkState() {
        if (this._invalid) {
            throw new IllegalStateException("ACL manager was released");
        }
    }

    private static String getRelRemoteRoot(IRepositoryServer server) {
        return ACL_REL_REMOTE_ROOT;
    }

    private static String getRelLocalRoot(IRepositoryServer server) throws ACLException {
        if (server == null) {
            return null;
        }
        String[] urlFragments = URLUtilities.chopURL(server.getUrl());
        if (urlFragments == null) {
            throw new ACLException("Creating relative local root failed");
        }
        return urlFragments[1] + BASE_PATH_LOCATION_RESOURCE + urlFragments[2] + urlFragments[3];
    }

    private static String getClientName(ILogicalSystem logicalSystem) {
        return "acl_maintenance_" + logicalSystem.getName();
    }

    public void releaseACL(IACL acl) {
        ((ACL)acl).releaseACL();
        this.aclsByResourcePath.remove(acl.getResourceURL());
    }

    IVfsFile getACLFileForResource(IVfsFolderItem resource, boolean forceCreate) throws ACLException {
        try {
            return this.getACLFileForResource(resource.getUrl(), forceCreate);
        }
        catch (VfsException e) {
            throw new ACLException("Getting ACL file failed" + e.getMessage(), e);
        }
    }

    IVfsFile getACLFileForResource(String resourceURL, boolean forceCreate) throws ACLException {
        try {
            String urlOfACLFile = this.getURLOfACLFile(resourceURL);
            if (urlOfACLFile == null) {
                throw new ACLException("Location of ACL file failed. Mismatched URL?");
            }
            IVfsRemoteLocator remoteLocator = this.vfsManager.getCurrentContext().getRemoteLocatorFromUrl(urlOfACLFile);
            if (remoteLocator == null) {
                throw new ACLException("Getting ACL file failed: no remote location");
            }
            String browsePathOfACLFile = this.vfsManager.getCurrentContext().getBrowsePath(remoteLocator);
            String absoluteLocalPath = this.vfsManager.getCurrentContext().getAbsoluteLocalPath(remoteLocator.getConnectionTemplateId(), remoteLocator.getAbsoluteRemotePath());
            IVfsFolderItem aclFolderItem = this.vfsManager.getFolderItemByBrowsePath(browsePathOfACLFile);
            if (aclFolderItem == null && forceCreate) {
                IFileService fileService = this.vfsManager.getCurrentContext().getFileService();
                IVirtualFile virtualACLFile = fileService.constructFile(absoluteLocalPath);
                if (virtualACLFile.getParentFile() != null) {
                    virtualACLFile.getParentFile().mkdirs();
                }
                virtualACLFile.createNewFile();
                aclFolderItem = this.vfsManager.getFolderItemByBrowsePath(browsePathOfACLFile);
            }
            if (aclFolderItem == null) {
                return null;
            }
            IVfsFile aclFile = aclFolderItem.asFile();
            if (aclFile == null) {
                throw new ACLException("Getting ACL file failed: acl.xml is not a file");
            }
            aclFile.sync();
            return aclFile;
        }
        catch (VfsException e) {
            throw new ACLException("Getting ACL file failed" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ACLException("Creating new ACL file failed" + e.getMessage(), e);
        }
    }

    private void readBasePaths() throws ACLException {
    }

    String getURLOfACLFile(String resourceURL) {
        if (resourceURL == null) {
            return null;
        }
        String urlOfACLFile = PathUtilities.preventTrailingSeparator(this.getRepositoryURL(resourceURL), PathUtilities.REMOTE_FILESERVICE);
        if (urlOfACLFile == null) {
            return null;
        }
        urlOfACLFile = urlOfACLFile + this.aclFilesRootPath + PathUtilities.assureTrailingSeparator(this.getResourcePathForURL(resourceURL), PathUtilities.REMOTE_FILESERVICE) + ACL_FILE_NAME;
        return urlOfACLFile;
    }

    String getResourcePathForURL(String resourceURL) {
        String repositoryURL = this.getRepositoryURL(resourceURL);
        if (repositoryURL != null && resourceURL.startsWith(repositoryURL)) {
            return BASE_PATH_LOCATION_RESOURCE + resourceURL.substring(repositoryURL.length());
        }
        return null;
    }

    private String getRepositoryURL(String resourceURL) {
        if (resourceURL == null) {
            return null;
        }
        IVfsContext context = this.vfsManager.getCurrentContext();
        IVfsRemoteLocator rLOfResource = context.getRemoteLocatorFromUrl(resourceURL);
        if (rLOfResource == null) {
            return null;
        }
        IVfsRemoteLocator[] rLOfRepositories = context.getRootRemoteLocators();
        String repositoryURL = null;
        int i = 0;
        while (i < rLOfRepositories.length) {
            if (rLOfRepositories[i].getConnectionTemplateId() == rLOfResource.getConnectionTemplateId()) {
                repositoryURL = context.getUrl(rLOfRepositories[i]);
            }
            ++i;
        }
        return repositoryURL;
    }

    IVfsActivity getActivity(IVfsWorkspace workspace) throws ACLException {
        try {
            if (_activities.containsKey(workspace)) {
                return (IVfsActivity)_activities.get(workspace);
            }
            IVfsActivity[] openActivities = workspace.getActivities(VfsActivityState.OPEN);
            if (openActivities.length != 0) {
                return openActivities[0];
            }
            return workspace.createActivity(DEFAULT_ACTIVITY_NAME);
        }
        catch (VfsException e) {
            throw new ACLException("Getting activity failed", e);
        }
    }

    IVfsActivity getActivity(IVfsFile file) throws ACLException {
        if (file == null) {
            throw new ACLException("Cannot get activity for null file");
        }
        try {
            if (_activities.containsKey(file.getWorkspace())) {
                return (IVfsActivity)_activities.get(file.getWorkspace());
            }
            IVfsActivity[] openActivities = file.getWorkspace().getActivities(VfsActivityState.OPEN);
            int i = 0;
            while (i < openActivities.length) {
                IVfsActivity activity = openActivities[i];
                IVfsActivityRecordedFolderItem[] folderItems = activity.getElementsFromOpenActivity();
                int j = 0;
                while (j < folderItems.length) {
                    if (folderItems[j] == file) {
                        return activity;
                    }
                    ++j;
                }
                ++i;
            }
            return file.getWorkspace().createActivity(DEFAULT_ACTIVITY_NAME);
        }
        catch (VfsException e) {
            throw new ACLException("Getting activity failed", e);
        }
    }

    private void modifyVfsManager() throws ACLException {
        IConfiguration config = Configuration.getConfiguration();
        IVfsContext context = this.vfsManager.getCurrentContext();
        IClient client = config.getClient(context.getClientName());
        ILogicalSystem logicalSystem = client.getLogicalSystem();
        Iterator it = logicalSystem.repositoryServers();
        IRepositoryServer server = null;
        while (it.hasNext()) {
            if (server == null) {
                server = (IRepositoryServer)it.next();
                continue;
            }
            throw new ACLException("Only one repository server in configuration supported.");
        }
        IVfsRemoteLocator[] browseRootRemoteLocators = context.getBrowseRootRemoteLocators();
        IVfsRemoteLocator[] rootRemoteLocators = context.getRootRemoteLocators();
        String browseRemoteRoot = null;
        int i = 0;
        while (i < browseRootRemoteLocators.length) {
            if (browseRootRemoteLocators[i].getConnectionTemplateId() == server.getConnectionTemplateId()) {
                browseRemoteRoot = PathUtilities.preventTrailingSeparator(browseRootRemoteLocators[i].getCanonicalAbsoluteRemotePath(), PathUtilities.REMOTE_FILESERVICE);
            }
            ++i;
        }
        if (browseRemoteRoot == null) {
            throw new ACLException("Unable to find browse remote root for server.");
        }
        String remoteRoot = null;
        int i2 = 0;
        while (i2 < rootRemoteLocators.length) {
            if (rootRemoteLocators[i2].getConnectionTemplateId() == server.getConnectionTemplateId()) {
                remoteRoot = PathUtilities.preventTrailingSeparator(rootRemoteLocators[i2].getCanonicalAbsoluteRemotePath(), PathUtilities.REMOTE_FILESERVICE);
            }
            ++i2;
        }
        if (remoteRoot == null) {
            throw new ACLException("Unable to find remote root for server.");
        }
        String workspaceRoot = browseRemoteRoot.substring(remoteRoot.length(), browseRemoteRoot.length());
        IVfsContext.MountpointRelation mountpointRelation = context.getMountpointRelation(PathUtilities.assureTrailingSeparator(browseRemoteRoot + this.aclBasePath, PathUtilities.REMOTE_FILESERVICE));
        try {
            if (mountpointRelation == null) {
                client.createMountPoint(server, workspaceRoot + this.aclBasePath, this.aclBasePath);
                config.saveAll();
                VersionedFileSystemFactory.releaseVersionedFileSystemManager(this.vfsManager);
                this.vfsManager = VersionedFileSystemFactory.getVersionedFileSystemManager(context);
                return;
            }
            if (mountpointRelation.equals(IVfsContext.MountpointRelation.MOUNTPOINT)) {
                return;
            }
            if (mountpointRelation.equals(IVfsContext.MountpointRelation.BELOW_MOUNTPOINT)) {
                return;
            }
            if (mountpointRelation.equals(IVfsContext.MountpointRelation.ABOVE_MOUNTPOINT)) {
                throw new ACLException("Found conflicting mount point for absolute remote path " + this.aclBasePath);
            }
            throw new ACLException("Mountpoint generation failed unexpectedly.");
        }
        catch (IOException e) {
            throw new ACLException("Unable to persist new configuration", e);
        }
        catch (VfsException e) {
            throw new ACLException("Unable to recreate VfsManager", e);
        }
        catch (IllegalStateException e) {
            throw new ACLException("Unable to recreate VfsManager", e);
        }
    }

    public void addACLListener(IACLListener aclListener) {
        this.checkState();
        this._aclListeners.add(aclListener);
    }

    public void removeACLListener(IACLListener aclListener) {
        this.checkState();
        if (this._aclListeners.contains(aclListener)) {
            this._aclListeners.remove(aclListener);
        }
    }

    void fireEventInheritanceChanged(ACL acl, int inheritanceType) {
        Iterator it = this._aclListeners.iterator();
        while (it.hasNext()) {
            IInheritanceAwareACLListener aclListener = (IInheritanceAwareACLListener)it.next();
            aclListener.inheritanceChanged(acl, inheritanceType);
        }
    }

    void fireEventACEAdded(ACL acl, ACE ace) {
        Iterator it = this._aclListeners.iterator();
        while (it.hasNext()) {
            IACLListener aclListener = (IACLListener)it.next();
            aclListener.aceAdded(acl, ace);
        }
    }

    void fireEventACEChanged(ACL acl, ACE ace) {
        Iterator it = this._aclListeners.iterator();
        while (it.hasNext()) {
            IACLListener aclListener = (IACLListener)it.next();
            aclListener.aceChanged(acl, ace);
        }
    }

    void fireEventACERemoved(ACL acl, ACE ace) {
        Iterator it = this._aclListeners.iterator();
        while (it.hasNext()) {
            IACLListener aclListener = (IACLListener)it.next();
            aclListener.aceRemoved(acl, ace);
        }
    }

    void fireEventDeleted(ACL acl) {
        Iterator it = this._aclListeners.iterator();
        while (it.hasNext()) {
            IACLListener aclListener = (IACLListener)it.next();
            aclListener.deleted(acl);
        }
    }

    void fireEventSaved(ACL acl) {
        Iterator it = this._aclListeners.iterator();
        while (it.hasNext()) {
            IACLListener aclListener = (IACLListener)it.next();
            aclListener.saved(acl);
        }
    }

    void fireEventActivated(ACL acl) {
        Iterator it = this._aclListeners.iterator();
        while (it.hasNext()) {
            IACLListener aclListener = (IACLListener)it.next();
            aclListener.activated(acl);
        }
    }

    void fireEventAdded(ACL acl) {
        Iterator it = this._aclListeners.iterator();
        while (it.hasNext()) {
            IACLListener aclListener = (IACLListener)it.next();
            aclListener.added(acl);
        }
    }

    void fireEventRefreshed(ACL acl) {
        Iterator it = this._aclListeners.iterator();
        while (it.hasNext()) {
            IACLListener aclListener = (IACLListener)it.next();
            aclListener.refreshed(acl);
        }
    }

    public void activate(Set acls) throws ACLException {
        HashSet<IVfsActivity> activities = new HashSet<IVfsActivity>();
        Iterator iter = acls.iterator();
        while (iter.hasNext()) {
            IACL acl = (IACL)iter.next();
            acl.save();
            activities.add(acl.getActivity());
        }
        Iterator iter2 = activities.iterator();
        while (iter2.hasNext()) {
            IVfsActivity activity = (IVfsActivity)iter2.next();
            try {
                activity.checkIn();
            }
            catch (VfsException e) {
                throw new ACLException("Saving of ACL failed", e);
            }
        }
    }

    private class VfsManagerListener
    implements IVfsManagerListener {
        private VfsManagerListener() {
        }

        public void created(IVersionedFileSystemManager vfsManager) {
        }

        public void released(IVersionedFileSystemManager vfsManager) {
            if (ACLManager.this.vfsManager == vfsManager) {
                ACLManager.this.setInvalid();
            }
        }
    }
}

