/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.acl.impl;

import com.tssap.dtr.client.lib.acl.ACLException;
import com.tssap.dtr.client.lib.acl.ACLInheritanceTypes;
import com.tssap.dtr.client.lib.acl.PrivilegeTypes;
import com.tssap.dtr.client.lib.acl.impl.ACE;
import com.tssap.dtr.client.lib.acl.impl.ACL;
import com.tssap.dtr.client.lib.acl.impl.ACLManager;
import com.tssap.dtr.client.lib.um.IPrincipal;
import com.tssap.dtr.client.lib.um.IPrincipalManager;
import com.tssap.dtr.client.lib.um.PrincipalException;
import com.tssap.dtr.client.lib.um.PrincipalFactory;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.util.PathUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class ACLContentHandler
implements ContentHandler {
    private Locator locator;
    private ACL acl = null;
    private ACE currentACE = null;
    private String currentResource = null;
    private int currentInheritance = 1;
    private IPrincipal currentPrincipal = null;
    private short currentPrincipalType = 1;
    private String currentPrincipalName = "";
    private static final short NONE = 0;
    private static final short ACL = 1;
    private static final short ACL_RESOURCE = 2;
    private static final short ACL_ACE = 3;
    private static final short ACL_ACE_PRINCIPAL = 4;
    private static final short ACL_ACE_PRINCIPAL_HREF = 5;
    private static final short ACL_ACE_GRANT = 6;
    private static final short ACL_ACE_DENY = 8;
    private static final short ACL_ACE_FORCEDENY = 10;
    private static final short ACL_ACE_DESCRIPTION = 12;
    private static final short ACL_ACE_PRINCIPAL_ALL = 13;
    private static final short ACL_ACE_GRANT_PRIVILEGE = 14;
    private static final short ACL_ACE_DENY_PRIVILEGE = 15;
    private static final short ACL_ACE_FORCEDENY_PRIVILEGE = 16;
    private static final short ACLS = 20;
    private static final short ACL_INHERITANCE = 21;
    private short status = 0;
    private String pcData = null;

    public ACLContentHandler(ACL acl) {
        this.acl = acl;
    }

    public void characters(char[] ch, int start, int length) {
        String pcData = new String(ch, start, length);
        switch (this.status) {
            case 2: {
                if (!PathUtilities.preventTrailingSeparator(this.acl.getResourcePath(), PathUtilities.REMOTE_FILESERVICE).equals(PathUtilities.preventTrailingSeparator(pcData, PathUtilities.REMOTE_FILESERVICE))) {
                    this.printWarning("Resource path does not match location of ACL in repository");
                }
                this.currentResource = pcData;
                break;
            }
            case 21: {
                this.currentInheritance = ACLInheritanceTypes.getInheritanceTypeByName(pcData);
                break;
            }
            case 4: {
                this.currentPrincipalName = pcData;
                break;
            }
            case 12: {
                this.currentACE.setDescriptionInternal(pcData);
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                int currentPrivilege = PrivilegeTypes.getPrivilegeByName(pcData);
                if (PrivilegeTypes.privilegeMatch(currentPrivilege, this.currentACE.getPrivilege())) break;
                this.currentACE.setPrivilegeInternal(this.currentACE.getPrivilege() + currentPrivilege);
                break;
            }
        }
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (this.status) {
            case 0: {
                break;
            }
            case 20: {
                this.status = 0;
                break;
            }
            case 1: {
                if (!qName.equals("acl")) break;
                if (this.currentResource == null) {
                    this.printWarning("Element resource missing");
                }
                this.status = (short)20;
                break;
            }
            case 2: {
                if (!qName.equals("resource")) break;
                this.status = 1;
                break;
            }
            case 21: {
                if (!qName.equals("inheritance")) break;
                try {
                    this.acl.setInheritanceTypeInternal(this.currentInheritance);
                }
                catch (ACLException e) {
                    this.printWarning("Setting the inheritance failed. Exception: " + e.getMessage());
                }
                this.status = 1;
                break;
            }
            case 3: {
                if (!qName.equals("ace")) break;
                if ((this.currentPrincipalType == 1 || this.currentPrincipalType == 2) && this.currentPrincipalName == "") {
                    this.printWarning("Principal missing");
                }
                try {
                    IPrincipalManager principalManager = PrincipalFactory.getPrincipalManager(((ACLManager)this.acl.getACLManager()).getVfsManager());
                    this.currentACE.setPrincipalInternal(principalManager.getPrincipalForName(this.currentPrincipalName, this.currentPrincipalType));
                }
                catch (PrincipalException e) {
                    this.printWarning("Could not evaluate Principal");
                }
                if (this.currentACE.getGrantType() == 0) {
                    this.printWarning("Privileges missing");
                }
                this.currentPrincipalName = "";
                this.currentPrincipalType = 1;
                this.status = 1;
                break;
            }
            case 4: {
                if (!qName.equals("principal")) break;
                this.status = (short)3;
                break;
            }
            case 13: {
                if (!qName.equals("all")) break;
                this.status = (short)4;
                break;
            }
            case 6: {
                if (!qName.equals("grant")) break;
                this.status = (short)3;
                break;
            }
            case 14: {
                if (!qName.equals("privilege")) break;
                this.status = (short)6;
                break;
            }
            case 8: {
                if (!qName.equals("deny")) break;
                this.status = (short)3;
                break;
            }
            case 15: {
                if (!qName.equals("privilege")) break;
                this.status = (short)8;
                break;
            }
            case 10: {
                if (!qName.equals("finalDeny")) break;
                this.status = (short)3;
                break;
            }
            case 16: {
                if (!qName.equals("privilege")) break;
                this.status = (short)10;
                break;
            }
            case 12: {
                if (!qName.equals("description")) break;
                this.status = (short)3;
                break;
            }
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            switch (this.status) {
                case 0: {
                    if (qName.equals("acl")) {
                        this.status = 1;
                        break;
                    }
                    if (!qName.equals("acls")) break;
                    this.status = (short)20;
                    break;
                }
                case 20: {
                    if (!qName.equals("acl")) break;
                    this.status = 1;
                    this.currentInheritance = 1;
                    break;
                }
                case 1: {
                    if (qName.equals("resource")) {
                        this.status = (short)2;
                        break;
                    }
                    if (qName.equals("inheritance")) {
                        this.status = (short)21;
                        break;
                    }
                    if (!qName.equals("ace")) break;
                    this.currentACE = this.acl.createACEInternal();
                    this.status = (short)3;
                    break;
                }
                case 3: {
                    if (qName.equals("principal")) {
                        if (this.currentACE.getPrincipal() == null) {
                            this.status = (short)4;
                            break;
                        }
                        this.printWarning("Only one principal for ACE allowed");
                        break;
                    }
                    if (qName.equals("isgroup")) {
                        this.currentPrincipalType = (short)2;
                        break;
                    }
                    if (qName.equals("all")) {
                        this.currentPrincipalType = (short)3;
                        break;
                    }
                    if (qName.equals("grant")) {
                        if (this.currentACE.getGrantType() == 0) {
                            this.currentACE.setGrantTypeInternal(1);
                            this.currentACE.setPrivilegeInternal(0);
                            this.status = (short)6;
                            break;
                        }
                        this.printWarning("Only one grant type for ACE allowed");
                        break;
                    }
                    if (qName.equals("deny")) {
                        if (this.currentACE.getGrantType() == 0) {
                            this.currentACE.setGrantTypeInternal(2);
                            this.currentACE.setPrivilegeInternal(0);
                            this.status = (short)8;
                            break;
                        }
                        this.printWarning("Only one grant type for ACE allowed");
                        break;
                    }
                    if (qName.equals("finalDeny")) {
                        if (this.currentACE.getGrantType() == 0) {
                            this.currentACE.setGrantTypeInternal(3);
                            this.currentACE.setPrivilegeInternal(0);
                            this.status = (short)10;
                            break;
                        }
                        this.printWarning("Only one grant type for ACE allowed");
                        break;
                    }
                    if (!qName.equals("description")) break;
                    this.status = (short)12;
                    break;
                }
                case 4: {
                    if (this.currentACE.getPrincipal() == null) break;
                    this.printWarning("Only one principal allowed");
                    break;
                }
                case 6: {
                    if (!qName.equals("privilege")) break;
                    this.status = (short)14;
                    break;
                }
                case 8: {
                    if (!qName.equals("privilege")) break;
                    this.status = (short)15;
                    break;
                }
                case 10: {
                    if (!qName.equals("privilege")) break;
                    this.status = (short)16;
                    break;
                }
            }
        }
        catch (ACLException e) {
            throw new SAXException(e.getMessage());
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private void printWarning(String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ACL error [Line ");
        buffer.append(this.locator.getLineNumber());
        buffer.append("]: ");
        buffer.append(message);
        Logbook.getWarnChapter(3).println(buffer.toString());
    }
}

