/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.acl.impl;

import com.tssap.dtr.client.lib.acl.ACLException;
import com.tssap.dtr.client.lib.acl.ACLInheritanceTypes;
import com.tssap.dtr.client.lib.acl.IACE;
import com.tssap.dtr.client.lib.acl.PrivilegeTypes;
import com.tssap.dtr.client.lib.acl.impl.ACE;
import com.tssap.dtr.client.lib.acl.impl.ACL;
import com.tssap.dtr.client.lib.acl.impl.IACLAssembler;
import com.tssap.dtr.client.lib.um.IPrincipal;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

class ACLAssembler
implements IACLAssembler {
    private OutputStream outputStream = null;
    private ACL acl = null;
    private BufferedWriter streamWriter = null;
    private static final String XML_DECL = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String ACLS_START_TAG = "<acls>";
    private static final String ACLS_END_TAG = "</acls>";
    private static final String ACL_START_TAG = "<acl>";
    private static final String ACL_END_TAG = "</acl>";
    private static final String RESOURCE_START_TAG = "  <resource>";
    private static final String RESOURCE_END_TAG = "</resource>";
    private static final String INHERITANCE_START_TAG = "  <inheritance>";
    private static final String INHERITANCE_END_TAG = "</inheritance>";
    private static final String ACE_START_TAG = "  <ace>";
    private static final String ACE_END_TAG = "  </ace>";
    private static final String PRINCIPAL_START_TAG = "    <principal>";
    private static final String PRINCIPAL_END_TAG = "    </principal>";
    private static final String PRINCIPAL_END_TAG_2 = "</principal>";
    private static final String PRINCIPAL_ISGROUP_TAG = "    <isgroup />";
    private static final String HREF_START_TAG = "      <href>";
    private static final String HREF_END_TAG = "</href>";
    private static final String ALL_TAG = "    <all />";
    private static final String GRANT_START_TAG = "    <grant>";
    private static final String GRANT_END_TAG = "    </grant>";
    private static final String DENY_START_TAG = "    <deny>";
    private static final String DENY_END_TAG = "    </deny>";
    private static final String FORCEDENY_START_TAG = "    <finalDeny>";
    private static final String FORCEDENY_END_TAG = "    </finalDeny>";
    private static final String DESCRIPTION_START_TAG = "    <description>";
    private static final String DESCRIPTION_END_TAG = "</description>";
    private static final String PRIVILEGE_START_TAG = "      <privilege>";
    private static final String PRIVILEGE_END_TAG = "</privilege>";
    private static final String ACCESS_TAG = "access";
    private static final String READ_TAG = "read";
    private static final String WRITE_TAG = "write";
    private static final String CHECKIN_TAG = "checkin";
    private static final String INTEGRATE_TAG = "integrate";
    private static final String EXPORT_TAG = "export";
    private static final String IMPORT_TAG = "import";
    private static final String ADMINA_TAG = "adminA";
    private static final String ADMINX_TAG = "adminX";
    private static final String WORKSPACE_PREFIX = "/ws";

    public ACLAssembler() {
    }

    public ACLAssembler(ACL acl) {
        this.acl = acl;
    }

    public void assemble() throws ACLException {
        try {
            if (this.outputStream != null && this.acl != null) {
                this.streamWriter = new BufferedWriter(new OutputStreamWriter(this.outputStream, "UTF-8"));
                this.writeProlog();
                this.writeACLs();
                this.streamWriter.close();
            }
        }
        catch (IOException e) {
            throw new ACLException(e.getMessage(), e);
        }
        catch (VfsException e) {
            throw new ACLException(e.getMessage(), e);
        }
    }

    public void setACL(ACL acl) {
        this.acl = acl;
    }

    public void setOutput(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    private void writeProlog() throws IOException {
        this.streamWriter.write(XML_DECL);
        this.streamWriter.newLine();
    }

    private void writeACLs() throws IOException, VfsException, ACLException {
        this.streamWriter.write(ACLS_START_TAG);
        this.streamWriter.newLine();
        this.writeACL();
        this.streamWriter.write(ACLS_END_TAG);
        this.streamWriter.newLine();
    }

    private void writeACL() throws IOException, VfsException, ACLException {
        this.streamWriter.write(ACL_START_TAG);
        this.streamWriter.newLine();
        this.writeResource();
        this.writeInheritanceType();
        List aces = this.acl.getLocalAces();
        Iterator it = aces.iterator();
        while (it.hasNext()) {
            this.writeACE((ACE)it.next());
        }
        this.streamWriter.write(ACL_END_TAG);
        this.streamWriter.newLine();
    }

    private void writeResource() throws IOException, VfsException, ACLException {
        if (this.acl.getResourcePath() != null) {
            this.streamWriter.write(RESOURCE_START_TAG);
            this.streamWriter.write(this.acl.getResourcePath());
            this.streamWriter.write(RESOURCE_END_TAG);
            this.streamWriter.newLine();
        }
    }

    private void writeInheritanceType() throws IOException, VfsException, ACLException {
        int inheritance = this.acl.getInheritanceType();
        if (inheritance != 1) {
            this.streamWriter.write(INHERITANCE_START_TAG);
            this.streamWriter.write(ACLInheritanceTypes.getInheritanceTypeByInt(inheritance));
            this.streamWriter.write(INHERITANCE_END_TAG);
            this.streamWriter.newLine();
        }
    }

    private void writeACE(IACE ace) throws IOException {
        if (!ace.isInherited()) {
            this.streamWriter.write(ACE_START_TAG);
            this.streamWriter.newLine();
            this.writePrincipal(ace);
            this.writePrivileges(ace);
            this.writeDescription(ace);
            this.streamWriter.write(ACE_END_TAG);
            this.streamWriter.newLine();
        }
    }

    private void writePrincipal(IACE ace) throws IOException {
        IPrincipal principal = ace.getPrincipal();
        if (principal != null) {
            if (principal.getType() == 2) {
                this.streamWriter.write(PRINCIPAL_ISGROUP_TAG);
                this.streamWriter.newLine();
            }
            switch (principal.getType()) {
                case 3: {
                    this.streamWriter.write(ALL_TAG);
                    this.streamWriter.newLine();
                    break;
                }
                case 1: 
                case 2: {
                    this.streamWriter.write(PRINCIPAL_START_TAG);
                    this.streamWriter.write(principal.getName());
                    this.streamWriter.write(PRINCIPAL_END_TAG_2);
                    this.streamWriter.newLine();
                    break;
                }
            }
        }
    }

    private void writePrivileges(IACE ace) throws IOException {
        switch (ace.getGrantType()) {
            case 1: {
                this.streamWriter.write(GRANT_START_TAG);
                this.streamWriter.newLine();
                this.writePrivilege(ace.getPrivilege());
                this.streamWriter.write(GRANT_END_TAG);
                this.streamWriter.newLine();
                break;
            }
            case 2: {
                this.streamWriter.write(DENY_START_TAG);
                this.streamWriter.newLine();
                this.writePrivilege(ace.getPrivilege());
                this.streamWriter.write(DENY_END_TAG);
                this.streamWriter.newLine();
                break;
            }
            case 3: {
                this.streamWriter.write(FORCEDENY_START_TAG);
                this.streamWriter.newLine();
                this.writePrivilege(ace.getPrivilege());
                this.streamWriter.write(FORCEDENY_END_TAG);
                this.streamWriter.newLine();
                break;
            }
        }
    }

    private void writePrivilege(int privilege) throws IOException {
        Vector privilegeNames = PrivilegeTypes.getPrivilegeNamesByInt(privilege);
        if (privilegeNames != null) {
            Iterator it = ((AbstractList)privilegeNames).iterator();
            while (it.hasNext()) {
                this.streamWriter.write(PRIVILEGE_START_TAG);
                switch (PrivilegeTypes.getPrivilegeByName((String)it.next())) {
                    case 1: {
                        this.streamWriter.write(ACCESS_TAG);
                        break;
                    }
                    case 2: {
                        this.streamWriter.write(READ_TAG);
                        break;
                    }
                    case 4: {
                        this.streamWriter.write(WRITE_TAG);
                        break;
                    }
                    case 8: {
                        this.streamWriter.write(CHECKIN_TAG);
                        break;
                    }
                    case 64: {
                        this.streamWriter.write(INTEGRATE_TAG);
                        break;
                    }
                    case 16: {
                        this.streamWriter.write(IMPORT_TAG);
                        break;
                    }
                    case 32: {
                        this.streamWriter.write(EXPORT_TAG);
                        break;
                    }
                    case 128: {
                        this.streamWriter.write(ADMINA_TAG);
                        break;
                    }
                    case 256: {
                        this.streamWriter.write(ADMINX_TAG);
                    }
                }
                this.streamWriter.write(PRIVILEGE_END_TAG);
                this.streamWriter.newLine();
            }
        }
    }

    private void writeDescription(IACE ace) throws IOException {
        if (ace.getDescription() != null) {
            this.streamWriter.write(DESCRIPTION_START_TAG);
            this.streamWriter.write(ace.getDescription());
            this.streamWriter.write(DESCRIPTION_END_TAG);
            this.streamWriter.newLine();
        }
    }
}

