/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.acl.impl;

import com.tssap.dtr.client.lib.acl.ACLException;
import com.tssap.dtr.client.lib.acl.IACE;
import com.tssap.dtr.client.lib.acl.IACL;
import com.tssap.dtr.client.lib.acl.IACLManager;
import com.tssap.dtr.client.lib.acl.IModifiable;
import com.tssap.dtr.client.lib.acl.impl.ACE;
import com.tssap.dtr.client.lib.acl.impl.ACLManager;
import com.tssap.dtr.client.lib.acl.impl.ACLObject;
import com.tssap.dtr.client.lib.acl.impl.ACLParserFactory;
import com.tssap.dtr.client.lib.acl.impl.IACLAssembler;
import com.tssap.dtr.client.lib.acl.impl.IACLParser;
import com.tssap.dtr.client.lib.um.IPrincipal;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityListener;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItemListener;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.fileservice.IFileService;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ACL
extends ACLObject
implements IACL {
    private List aces = new ArrayList();
    private String resourceURL = null;
    private String resourcePath = null;
    private IVfsFile aclFile = null;
    private ACLManager aclManager = null;
    private IVfsActivity activity = null;
    private int inheritType = 1;
    private boolean reactOnActivityEvents = true;
    private IModifiable state = null;
    private IModifiable new_ = null;
    private IModifiable modified = null;
    private IModifiable saved = null;
    private IModifiable checkedIn = null;
    private IModifiable deleted = null;

    private IModifiable getNew() {
        if (this.new_ == null) {
            this.new_ = new New();
        }
        return this.new_;
    }

    private IModifiable getCheckedIn() {
        if (this.checkedIn == null) {
            this.checkedIn = new CheckedIn();
        }
        return this.checkedIn;
    }

    private IModifiable getModified() {
        if (this.modified == null) {
            this.modified = new Modified();
        }
        return this.modified;
    }

    private IModifiable getSaved() {
        if (this.saved == null) {
            this.saved = new Saved();
        }
        return this.saved;
    }

    private IModifiable getDeleted() {
        if (this.deleted == null) {
            this.deleted = new Deleted();
        }
        return this.deleted;
    }

    private boolean aclFileLocationStateEquals(VfsFolderItemLocationState locationState) {
        return this.aclFile != null && locationState != null && this.aclFile.getLocationState() == locationState;
    }

    private boolean aclFileActivityStateEquals(VfsFolderItemActivityState activityState) {
        return this.aclFile != null && activityState != null && this.aclFile.getActivityState() == activityState;
    }

    private boolean notAclFileLocationStateEquals(VfsFolderItemLocationState locationState) {
        return this.aclFile != null && !this.aclFileLocationStateEquals(locationState);
    }

    private boolean notAclFileActivityStateEquals(VfsFolderItemActivityState activityState) {
        return this.aclFile != null && !this.aclFileActivityStateEquals(activityState);
    }

    private void replaceAces(List newAces) throws ACLException {
        this.deleteAllAces(true);
        this.aces = newAces;
        Iterator iter = newAces.iterator();
        while (iter.hasNext()) {
            this.aclManager.fireEventACEAdded(this, (ACE)iter.next());
        }
    }

    ACL(ACLManager aclManager, String resourceURL) throws ACLException {
        this.resourceURL = resourceURL;
        this.aclManager = aclManager;
        this.inheritType = 1;
        this.resourcePath = aclManager.getResourcePathForURL(resourceURL);
        this.aclFile = aclManager.getACLFileForResource(resourceURL, false);
        this.initializeState();
        aclManager.getVfsManager().addActivityListener(new ACLVfsActivityListener());
        aclManager.getVfsManager().addFolderItemListener(new ACLVfsFolderItemListener());
    }

    private void initializeState() throws ACLException {
        try {
            block7: {
                try {
                    this.reactOnActivityEvents = false;
                    if (this.getACLFile() == null || this.aclFile.getLocalFile().length() == 0L) {
                        if (!this.getDeleted().equals(this.state)) {
                            this.state = this.getNew();
                        }
                        break block7;
                    }
                    this.read();
                    if (this.aclFileLocationStateEquals(VfsFolderItemLocationState.LOCAL_ONLY)) {
                        this.checkOut();
                        this.state = this.getSaved();
                        break block7;
                    }
                    this.state = this.getCheckedIn();
                }
                catch (Exception e) {
                    throw new ACLException("Error during initialization of ACL", e);
                }
            }
            Object var3_1 = null;
            this.reactOnActivityEvents = true;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.reactOnActivityEvents = true;
            throw throwable;
        }
    }

    private void assureFileNotCheckedOutByOthers() throws ACLException {
        String[] otherCheckouters = this.aclFile.getOtherCheckouters();
        if (otherCheckouters.length > 0) {
            throw new ACLException("ACL file is already checked out by other user(s): " + otherCheckouters);
        }
    }

    private void attachToActivity() throws ACLException {
        if (this.aclFile == null) {
            this.aclFile = this.aclManager.getACLFileForResource(this.resourceURL, true);
        }
        this.assureFileNotCheckedOutByOthers();
        this.activity = this.getActivity(this.aclFile);
    }

    private void checkOut() throws ACLException {
        block7: {
            this.reactOnActivityEvents = false;
            try {
                try {
                    if (this.aclFileActivityStateEquals(VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE)) {
                        this.aclFile.uncheckout();
                        this.read();
                    }
                    this.attachToActivity();
                    if (!this.aclFileActivityStateEquals(VfsFolderItemActivityState.NOT_CHECKED_OUT)) break block7;
                    if (this.aclFileLocationStateEquals(VfsFolderItemLocationState.LOCAL_ONLY)) {
                        this.aclFile.createAndCheckout(this.activity);
                        Object var3_1 = null;
                        this.reactOnActivityEvents = true;
                        return;
                    }
                    if (this.aclFileLocationStateEquals(VfsFolderItemLocationState.SYNCED_TO_LATEST)) {
                        this.aclFile.checkOutForEdit(this.activity, true);
                        break block7;
                    }
                    throw new ACLException("Unable to check out file of ACL for \"" + this.resourcePath + "\". Could not sync." + (this.aclFile == null ? "aclFile == null" : "Activity State = \"" + this.aclFile.getActivityState().getText() + "\", Location State = \"" + this.aclFile.getLocationState() + "\""));
                }
                catch (VfsException e) {
                    throw new ACLException("Error during check-out", e);
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.reactOnActivityEvents = true;
                throw throwable;
            }
        }
        Object var3_2 = null;
        this.reactOnActivityEvents = true;
    }

    private void checkOutForDelete() throws ACLException {
        this.attachToActivity();
        try {
            this.aclFile.checkOutAndDelete(this.activity);
        }
        catch (VfsException e) {
            throw new ACLException("Error during check-out for deletion", e);
        }
    }

    private void unCheckOut() throws ACLException {
        this.reactOnActivityEvents = false;
        try {
            block4: {
                try {
                    if (!this.notAclFileActivityStateEquals(VfsFolderItemActivityState.NOT_CHECKED_OUT)) break block4;
                    this.aclFile.uncheckout();
                    this.uncheckoutFolder(this.aclFile, this.activity);
                    this.deleteActivity(this.activity);
                }
                catch (VfsException e) {
                    throw new ACLException("Error while reverting ACL", e);
                }
            }
            Object var3_1 = null;
            this.reactOnActivityEvents = true;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.reactOnActivityEvents = true;
            throw throwable;
        }
    }

    private void uncheckoutFolder(IVfsFile file, IVfsActivity activity) throws ACLException {
        try {
            if (file != null) {
                IVfsFolder folder = file.getParent().asFolder();
                while (folder != null && !folder.hasCheckedOutFolderItems()) {
                    IVfsActivity[] activities = folder.getOpenActivities();
                    int i = 0;
                    while (i < activities.length) {
                        if (activities[i] == activity) {
                            folder.uncheckout(activity);
                        }
                        ++i;
                    }
                    folder = folder.getParent().asFolder();
                }
            }
        }
        catch (VfsException e) {
            throw new ACLException(e.getMessage(), e);
        }
    }

    private void deleteActivity(IVfsActivity activity) throws ACLException {
        try {
            if (activity != null && activity.isEmpty()) {
                activity.delete();
            }
        }
        catch (VfsException e) {
            throw new ACLException(e);
        }
    }

    private IVfsActivity getActivity(IVfsFile referenceFile) throws ACLException {
        if (this.aclManager != null && referenceFile != null) {
            return this.aclManager.getActivity(referenceFile.getWorkspace());
        }
        return null;
    }

    public IVfsActivity getActivity() throws ACLException {
        return this.getActivity(this.aclFile);
    }

    private void printWarning(String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(message);
        Logbook.getWarnChapter(3).println(buffer.toString());
    }

    void releaseACL() {
        this.resourcePath = null;
        this.resourceURL = null;
        Iterator it = this.aces.iterator();
        while (it.hasNext()) {
            ACE ace = (ACE)it.next();
            ace.releaseACE();
        }
        super.setInvalid();
    }

    private IVfsFile getACLFile() throws ACLException {
        if (this.aclFile == null) {
            this.aclFile = this.aclManager.getACLFileForResource(this.resourceURL, false);
        }
        return this.aclFile;
    }

    public void delete() throws ACLException {
        this.state.delete();
    }

    public void refresh() throws ACLException {
        if (this.reactOnActivityEvents) {
            this.deleteAllAces();
            this.initializeState();
            this.aclManager.fireEventRefreshed(this);
        }
    }

    private void refresh(IVfsFolderItem folderItem) {
        if (folderItem == this.aclFile && this.reactOnActivityEvents) {
            try {
                this.refresh();
            }
            catch (ACLException e) {
                this.printWarning("Unable to refresh ACL" + e.getMessage());
            }
        }
    }

    public void revert() throws ACLException {
        this.unCheckOut();
        this.refresh();
    }

    public void modify() throws ACLException {
        this.state.modify();
    }

    public void save() throws ACLException {
        this.state.save();
    }

    public String toString() {
        return this.resourcePath + " (" + this.state.toString() + ")";
    }

    public IACLManager getACLManager() {
        return this.aclManager;
    }

    public List getLocalAces() {
        return this.aces;
    }

    public IACE[] getInheritedAces() throws ACLException {
        return this.aclManager.getInheritedAces(this.resourceURL).toArray(new IACE[0]);
    }

    public IACL[] getParentACLs() throws ACLException {
        return this.aclManager.getParentACLs(this.resourceURL).toArray(new IACL[0]);
    }

    public IACE[] getACEs() throws ACLException {
        List result = this.aclManager.getAces(this.resourceURL, false);
        return result.toArray(new IACE[result.size()]);
    }

    public String getResourceURL() {
        return this.resourceURL;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void check() throws ACLException {
        if (this.aclFileActivityStateEquals(VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE)) {
            return;
        }
        StringBuffer result = new StringBuffer();
        if (this.resourceURL == null || this.resourceURL.equals("")) {
            result.append("ACL error: resource missing. ");
            result.append('\n');
        }
        if (this.aces.size() == 0) {
            result.append("ACL error: ACEs missing.");
            result.append('\n');
        }
        int i = 0;
        while (i < this.aces.size()) {
            result.append(((ACE)this.aces.get(i)).check());
            ++i;
        }
        String resultString = result.toString();
        if (resultString != null && !resultString.equals("")) {
            throw new ACLException(resultString, this);
        }
    }

    private void deleteAllAces() {
        this.deleteAllAces(false);
    }

    private void deleteAllAces(boolean fireEvents) {
        if (fireEvents) {
            Iterator iter = this.aces.iterator();
            while (iter.hasNext()) {
                this.aclManager.fireEventACERemoved(this, (ACE)iter.next());
            }
        }
        this.aces.clear();
    }

    public IACE createACE(IPrincipal principal, String description, int grantType, int privileges) throws ACLException {
        ACE newACE = this.createACEInternal();
        newACE.setPropertiesInternal(principal, description, grantType, privileges);
        this.modify();
        this.aclManager.fireEventACEAdded(this, newACE);
        return newACE;
    }

    ACE createACEInternal() throws ACLException {
        ACE newACE = new ACE(this);
        this.aces.add(newACE);
        return newACE;
    }

    public IACE[] getACEs(IPrincipal principal) {
        return null;
    }

    public boolean isAllowed(IPrincipal principal, int privilege) {
        return false;
    }

    public boolean isChangeable() {
        return false;
    }

    public boolean isChanged() {
        return this.state == this.modified || this.state == this.deleted;
    }

    public boolean isDeleted() {
        return this.state == this.deleted;
    }

    public void removeACE(IACE ace) throws ACLException {
        if (ace.isInherited()) {
            throw new ACLException("Deletion of inherited ACE is forbidden. Delete from defining ACL (" + ace.getResourcePath() + ")");
        }
        this.modify();
        this.removeACEInternal(ace);
        this.aclManager.fireEventACERemoved(this, (ACE)ace);
    }

    private void removeACEInternal(IACE ace) throws ACLException {
        if (this.aces.contains(ace)) {
            ((ACE)ace).setInvalid();
            this.aces.remove(ace);
        }
    }

    public int size() {
        return this.aces.size();
    }

    private void read(boolean forceUpdate) throws ACLException {
        if (this.aclFileActivityStateEquals(VfsFolderItemActivityState.NOT_CHECKED_OUT) && this.notAclFileLocationStateEquals(VfsFolderItemLocationState.LOCAL_ONLY)) {
            try {
                if (forceUpdate) {
                    this.aclFile.syncForce();
                } else {
                    this.aclFile.sync();
                }
            }
            catch (VfsException e) {
                throw new ACLException(e);
            }
        }
        if (this.aclFile.getActivityState() != VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
            this.parse();
        }
    }

    private void read() throws ACLException {
        this.read(false);
    }

    private void parse() throws ACLException {
        try {
            if (this.aclFile == null || this.aclFile.getLength() == 0L) {
                return;
            }
            IACLParser aclParser = ACLParserFactory.getACLParser(this);
            aclParser.setInput(this.aclFile.getContent());
            aclParser.parse();
        }
        catch (VfsException e) {
            throw new ACLException(e);
        }
    }

    private void writeToFile() throws ACLException {
        if (this.aclFile == null) {
            throw new ACLException("Attempt to write empty ACL file");
        }
        try {
            IVirtualFile localFile = this.aclFile.getLocalFile();
            IFileService fileService = this.aclFile.getVersionedFileSystemManager().getCurrentContext().getFileService();
            OutputStream outputStream = fileService.constructFileOutputStream(localFile);
            IACLAssembler aclAssembler = ACLParserFactory.getACLAssembler(this);
            aclAssembler.setOutput(outputStream);
            aclAssembler.assemble();
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            throw new ACLException("Saving of ACL failed", e);
        }
        catch (IOException e) {
            throw new ACLException("Saving of ACL failed", e);
        }
    }

    private void deleteAclFile() throws ACLException {
        IVirtualFile localFile = this.aclFile.getLocalFile();
        localFile.delete();
        this.aclFile = null;
    }

    private void deleteInternal() throws ACLException {
        this.reactOnActivityEvents = false;
        this.deleteAllAces();
        VfsFolderItemActivityState activityState = this.aclFile.getActivityState();
        this.unCheckOut();
        if (activityState.equals(VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE)) {
            this.deleteAclFile();
            this.state = this.getNew();
        } else if (activityState.equals(VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT)) {
            this.checkOutForDelete();
            this.state = this.getDeleted();
        } else {
            throw new IllegalStateException("Unexpected activity state during delete: " + this.aclFile.getActivityState());
        }
        this.aclManager.fireEventDeleted(this);
        this.reactOnActivityEvents = true;
    }

    public boolean isRefreshable() {
        return !this.state.equals(this.modified);
    }

    public boolean isRevertable() {
        return this.state.equals(this.checkedIn) || this.state.equals(this.new_);
    }

    public boolean isActive() {
        return this.state == this.checkedIn;
    }

    public int getInheritanceType() {
        return this.inheritType;
    }

    void setInheritanceTypeInternal(int type) throws ACLException {
        this.inheritType = type;
    }

    public void setInheritanceType(int type) throws ACLException {
        this.setInheritanceTypeInternal(type);
        this.modify();
        this.aclManager.fireEventInheritanceChanged(this, type);
    }

    private class Deleted
    implements IModifiable {
        private Deleted() {
        }

        public void modify() throws ACLException {
            ACL.this.reactOnActivityEvents = false;
            ArrayList newAces = new ArrayList(ACL.this.aces);
            ACL.this.revert();
            ACL.this.replaceAces(newAces);
            ACL.this.state = ACL.this.getCheckedIn();
            ACL.this.modify();
            ACL.this.reactOnActivityEvents = true;
        }

        public void save() throws ACLException {
        }

        public void delete() throws ACLException {
        }
    }

    private class CheckedIn
    extends New {
        private CheckedIn() {
        }

        public void delete() throws ACLException {
            ACL.this.checkOutForDelete();
            ACL.this.deleteAllAces();
            ACL.this.state = ACL.this.getDeleted();
            ACL.this.aclManager.fireEventDeleted(ACL.this);
        }
    }

    private class Saved
    implements IModifiable {
        private Saved() {
        }

        public void modify() throws ACLException {
            ACL.this.state = ACL.this.getModified();
        }

        public void delete() throws ACLException {
            ACL.this.deleteInternal();
        }

        public void save() throws ACLException {
        }
    }

    private class Modified
    extends Saved {
        private Modified() {
        }

        public void save() throws ACLException {
            ACL.this.check();
            ACL.this.writeToFile();
            ACL.this.state = ACL.this.getSaved();
            ACL.this.aclManager.fireEventSaved(ACL.this);
        }
    }

    private class New
    implements IModifiable {
        private New() {
        }

        public void modify() throws ACLException {
            ACL.this.checkOut();
            ACL.this.state = ACL.this.getModified();
        }

        public void save() throws ACLException {
        }

        public void delete() throws ACLException {
        }
    }

    private class ACLVfsActivityListener
    implements IVfsActivityListener {
        private ACLVfsActivityListener() {
        }

        public void beforeCheckin(IVfsActivity activity) {
        }

        public void created(IVfsActivity activity) {
        }

        public void deleted(IVfsActivity activity, VfsActivityState oldState) {
        }

        public void itemsAddedOrRemoved(IVfsActivity activity) {
        }

        public void nameOrDescriptionChanged(IVfsActivity activity) {
        }

        public void stateChanged(IVfsActivity activity, VfsActivityState oldState) {
            try {
                if (this.isMyActivity(activity) && activity.getState() == VfsActivityState.CLOSED) {
                    ACL.this.state = ACL.this.getCheckedIn();
                }
            }
            catch (VfsException e) {
                ACL.this.printWarning("Could not get state of activity \"" + activity.getName() + "\": " + e.getMessage());
            }
        }

        private boolean isMyActivity(IVfsActivity activity) {
            return activity != null && activity.equals(ACL.this.activity);
        }
    }

    private class ACLVfsFolderItemListener
    implements IVfsFolderItemListener {
        private ACLVfsFolderItemListener() {
        }

        public void activityStateChanged(IVfsActivityRecordedFolderItem folderItem, VfsFolderItemActivityState oldState) {
            ACL.this.refresh(folderItem);
        }

        public void itemsAddedOrRemoved(IVfsGenericFolder folder) {
        }

        public void locationStateChanged(IVfsFolderItem folderItem, VfsFolderItemLocationState oldState) {
            ACL.this.refresh(folderItem);
        }
    }
}

