/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.acl.impl;

import com.tssap.dtr.client.lib.acl.ACLException;
import com.tssap.dtr.client.lib.acl.GrantTypes;
import com.tssap.dtr.client.lib.acl.IACE;
import com.tssap.dtr.client.lib.acl.IACL;
import com.tssap.dtr.client.lib.acl.PrivilegeTypes;
import com.tssap.dtr.client.lib.acl.impl.ACL;
import com.tssap.dtr.client.lib.acl.impl.ACLManager;
import com.tssap.dtr.client.lib.acl.impl.ACLObject;
import com.tssap.dtr.client.lib.um.IPrincipal;
import com.tssap.dtr.client.lib.um.PrincipalException;

class ACE
extends ACLObject
implements IACE {
    private ACL acl = null;
    private IPrincipal principal = null;
    private int grantType = 0;
    private int privilege = 0;
    private String resourceURL = null;
    private String resourcePath = null;
    private String description = "";

    ACE(ACL acl) {
        this.acl = acl;
    }

    public void setPrincipal(IPrincipal principal) throws ACLException {
        if (this.principal == null || !this.principal.equals(principal)) {
            this.setPrincipalInternal(principal);
            this.fireEventAceChanged();
        }
    }

    private void fireEventAceChanged() throws ACLException {
        if (this.acl != null) {
            this.acl.modify();
            ((ACLManager)this.acl.getACLManager()).fireEventACEChanged(this.acl, this);
        }
    }

    void setPrincipalInternal(IPrincipal principal) {
        this.principal = principal;
    }

    public IPrincipal getPrincipal() {
        return this.principal;
    }

    public void setPrivilege(int privilege) throws ACLException {
        if (this.privilege != privilege) {
            if (PrivilegeTypes.isAllowedType(privilege)) {
                this.setPrivilegeInternal(privilege);
                this.fireEventAceChanged();
            } else {
                throw new IllegalArgumentException("Privilege is not valid");
            }
        }
    }

    void setPrivilegeInternal(int privilege) {
        this.privilege = privilege;
    }

    public int getPrivilege() {
        return this.privilege;
    }

    public IACL getACL() {
        return this.acl;
    }

    public int getGrantType() {
        return this.grantType;
    }

    public String getResourceURL() {
        if (this.acl == null) {
            return this.resourceURL;
        }
        return this.acl.getResourceURL();
    }

    public String getResourcePath() {
        if (this.acl == null) {
            return this.resourcePath;
        }
        return this.acl.getResourcePath();
    }

    public boolean isInherited() {
        return false;
    }

    public void setGrantType(int grantType) throws ACLException {
        if (this.grantType != grantType) {
            if (GrantTypes.isAllowedType(grantType)) {
                this.setGrantTypeInternal(grantType);
                this.fireEventAceChanged();
            } else {
                throw new IllegalArgumentException("GrantType is not valid");
            }
        }
    }

    void setGrantTypeInternal(int grantType) {
        this.grantType = grantType;
    }

    void setACL(ACL acl) {
        this.acl = acl;
    }

    void setResource(String resourceURL) {
        this.resourceURL = resourceURL;
    }

    protected void setInvalid() {
        this.acl = null;
        this.principal = null;
        this.resourceURL = null;
        this.resourcePath = null;
        super.setInvalid();
    }

    void releaseACE() {
        this.setInvalid();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) throws ACLException {
        if (description == null) {
            description = "";
        }
        if (!this.description.equals(description)) {
            this.setDescriptionInternal(description);
            this.fireEventAceChanged();
        }
    }

    void setDescriptionInternal(String description) {
        this.description = description;
    }

    public String check() {
        StringBuffer result = new StringBuffer();
        if (this.getPrincipal() == null) {
            result.append("Principal missing");
        }
        if (this.getPrincipal() != null && this.getPrincipal().getType() == 0) {
            result.append("Principal type missing");
        }
        if (this.getPrincipal() != null && this.getPrincipal().getType() == 0) {
            try {
                this.getPrincipal().getURL();
            }
            catch (PrincipalException e) {
                result.append("Could not get URL for principal");
            }
        }
        if (this.getGrantType() == 0) {
            result.append("Grant type missing");
        }
        if (result.length() > 0) {
            result.insert(0, "Error: ");
            result.append(" in ACE ");
            result.append(this.toString());
        }
        return result.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("<");
        result.append("resource path = ");
        result.append(this.quote(this.resourcePath));
        result.append(", principal = ");
        result.append(this.quote(this.principal.getName()));
        result.append(", privilege = ");
        result.append(GrantTypes.getGrantTypeByInt(this.grantType));
        result.append(" ");
        result.append(PrivilegeTypes.getPrivilegeNamesByInt(this.privilege));
        result.append(">");
        return result.toString();
    }

    private String quote(String string) {
        return '\"' + string + '\"';
    }

    public void setProperties(IPrincipal principal, String description, int grantType, int privileges) throws ACLException {
        this.setPropertiesInternal(principal, description, grantType, privileges);
        this.fireEventAceChanged();
    }

    void setPropertiesInternal(IPrincipal principal, String description, int grantType, int privileges) {
        this.setPrincipalInternal(principal);
        this.setDescriptionInternal(description);
        this.setGrantTypeInternal(grantType);
        this.setPrivilegeInternal(privileges);
    }

    public IACE getSourceAce() {
        return this;
    }
}

