/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.acl;

import java.util.HashMap;
import java.util.Vector;

public class PrivilegeTypes {
    public static final int ACCESS = 1;
    public static final int READ = 2;
    public static final int WRITE = 4;
    public static final int CHECKIN = 8;
    public static final int IMPORT = 16;
    public static final int EXPORT = 32;
    public static final int INTEGRATE = 64;
    public static final int ADMINA = 128;
    public static final int ADMINX = 256;
    public static final int READ_ACL = 512;
    public static final int WRITE_ACL = 1024;
    public static final int READ_CURRENT_USER_PRIVILEGE_SET = 2048;
    public static final int LOCK = 4096;
    public static final int CHECKOUT_CHECKIN = 8192;
    public static final int BASELINE_CONTROL = 16384;
    public static final int VERSION_CONTROL = 32768;
    public static final int JOIN_ACTIVITY = 65536;
    public static final int NO_PRIVILEGES = 0;
    public static final int OWNER = 15;
    public static final int ADMIN = 511;
    public static final int ALL_PRIVILEGES = 131071;
    public static HashMap privSet = new HashMap();
    public static Vector privVector;

    private PrivilegeTypes() {
    }

    public static int getPrivilegeByName(String name) {
        Integer priv = (Integer)privSet.get(name);
        if (priv == null) {
            return 0;
        }
        return priv;
    }

    public static Vector getPrivilegeNamesByInt(int privilege) {
        if (privilege >= 0) {
            Vector<String> result = new Vector<String>();
            int i = 0;
            while (i <= 16) {
                if ((privilege >> i) % 2 != 0) {
                    result.add((String)privVector.get(i));
                }
                ++i;
            }
            return result;
        }
        return null;
    }

    public static boolean privilegeMatch(int privilegeToTest, int privilegeAgainstTest) {
        return (privilegeToTest & privilegeAgainstTest) == privilegeToTest;
    }

    public static boolean isAllowedType(int privilege) {
        return privilege >= 0 && privilege < 131072;
    }

    static {
        privSet.put("access", new Integer(1));
        privSet.put("read", new Integer(2));
        privSet.put("write", new Integer(4));
        privSet.put("owner", new Integer(15));
        privSet.put("checkin", new Integer(8));
        privSet.put("export", new Integer(32));
        privSet.put("import", new Integer(16));
        privSet.put("integrate", new Integer(64));
        privSet.put("adminA", new Integer(128));
        privSet.put("adminX", new Integer(256));
        privSet.put("admin", new Integer(511));
        privSet.put("read-acl", new Integer(512));
        privSet.put("write-acl", new Integer(1024));
        privSet.put("read-current-user-privilege-set", new Integer(2048));
        privSet.put("lock", new Integer(4096));
        privSet.put("checkout-checkin", new Integer(8192));
        privSet.put("baseline-control", new Integer(16384));
        privSet.put("version-control", new Integer(32768));
        privSet.put("join-activity", new Integer(65536));
        privSet.put("all", new Integer(131071));
        privVector = new Vector();
        privVector.add(0, "access");
        privVector.add(1, "read");
        privVector.add(2, "write");
        privVector.add(3, "checkin");
        privVector.add(4, "import");
        privVector.add(5, "export");
        privVector.add(6, "integrate");
        privVector.add(7, "adminA");
        privVector.add(8, "adminX");
        privVector.add(9, "read-acl");
        privVector.add(10, "write-acl");
        privVector.add(11, "read-current-user-privilege-set");
        privVector.add(12, "lock");
        privVector.add(13, "checkout-checkin");
        privVector.add(14, "baseline-control");
        privVector.add(15, "version-control");
        privVector.add(16, "join-activity");
    }
}

