/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.acl;

public class GrantTypes {
    public static final int NONE = 0;
    public static final int GRANT = 1;
    public static final int DENY = 2;
    public static final int FORCEDENY = 3;

    private GrantTypes() {
    }

    public static final int getGrantTypeByName(String name) {
        if (name.compareTo("none") == 0) {
            return 0;
        }
        if (name.compareTo("grant") == 0) {
            return 1;
        }
        if (name.compareTo("deny") == 0) {
            return 2;
        }
        if (name.compareTo("finalDeny") == 0) {
            return 3;
        }
        return -1;
    }

    public static final String getGrantTypeByInt(int grantType) {
        switch (grantType) {
            case 0: {
                return "none";
            }
            case 1: {
                return "grant";
            }
            case 2: {
                return "deny";
            }
            case 3: {
                return "finalDeny";
            }
        }
        return null;
    }

    public static final boolean isAllowedType(int grantType) {
        return 0 <= grantType && grantType <= 3;
    }
}

