/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.acl;

public class ACLInheritanceTypes {
    public static final int PROPAGATE = 1;
    public static final int COPY = 2;
    public static final int IGNORE = 3;
    public static final int FINAL = 4;
    public static final int DEFAULT = 1;

    private ACLInheritanceTypes() {
    }

    public static boolean isAllowedType(int inheritanceType) {
        return inheritanceType >= 0 && inheritanceType <= 4 && inheritanceType != 2;
    }

    public static final int getInheritanceTypeByName(String name) {
        if (name.compareTo("default") == 0) {
            return 1;
        }
        if (name.compareTo("propagate") == 0) {
            return 1;
        }
        if (name.compareTo("copy") == 0) {
            return 2;
        }
        if (name.compareTo("ignore") == 0) {
            return 3;
        }
        if (name.compareTo("final") == 0) {
            return 4;
        }
        return -1;
    }

    public static final String getInheritanceTypeByInt(int grantType) {
        switch (grantType) {
            case 0: {
                return "default";
            }
            case 1: {
                return "propagate";
            }
            case 2: {
                return "copy";
            }
            case 3: {
                return "ignore";
            }
            case 4: {
                return "final";
            }
        }
        return null;
    }
}

