/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.languages;

import com.sap.caf.mp.core.languages.ILanguageManager;
import java.util.Enumeration;
import java.util.Hashtable;

public class LanguageInfo {
    private String m_language;
    private Hashtable m_texts;
    private ILanguageManager m_manager;

    public LanguageInfo(String language, ILanguageManager manager) {
        this.m_language = language = language.toLowerCase();
        this.m_texts = new Hashtable();
        this.m_manager = manager;
    }

    public void addDisplayText(String language, String text) {
        language = language.toLowerCase();
        this.m_texts.put(language, text);
    }

    public Enumeration getLanguages() {
        return this.m_texts.keys();
    }

    public String resolveDisplayText(String language) {
        String text = (String)this.m_texts.get(language = language.toLowerCase());
        if (text != null) {
            return text;
        }
        String fallback = this.m_manager.getFallbackLanguage();
        text = (String)this.m_texts.get(fallback);
        if (text != null) {
            return text;
        }
        text = (String)this.m_texts.get(this.m_language);
        if (text != null) {
            return text;
        }
        if (this.m_texts.size() > 0) {
            return (String)this.m_texts.elements().nextElement();
        }
        return this.m_language;
    }

    public String getId() {
        return this.m_language;
    }
}

