/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.values.base;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.values.api.IElementValue;
import com.sap.caf.mp.core.data.values.api.ITypeValue;
import com.sap.caf.mp.core.data.values.base.StructureValue;
import java.util.Enumeration;
import java.util.Vector;

public class ElementValue
extends StructureValue
implements IElementValue {
    private IElement m_element;
    private Vector m_vector = new Vector();

    public ElementValue(IElement element) throws InvocationException {
        super(element);
    }

    public void addTypeValue(ITypeValue value) throws InvocationException {
        if (value == null) {
            throw new InvocationException("TypeValue invalid");
        }
        IType l_type = value.getType();
        if (l_type == null) {
            throw new InvocationException("Type of TypeValue invalid");
        }
        if (l_type != this.getElement().getType()) {
            throw new InvocationException("Type of TypeValue mismatching");
        }
        this.m_vector.add(value);
    }

    public IElement getElement() {
        return (IElement)this.getStructure();
    }

    public ITypeValue getTypeValue(int index) {
        ITypeValue l_value;
        try {
            l_value = (ITypeValue)this.m_vector.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException l_exception) {
            l_value = null;
        }
        return l_value;
    }

    public int getTypeValueCount() {
        return this.m_vector.size();
    }

    public Enumeration getTypeValueEnumeration() {
        return this.m_vector.elements();
    }
}

