/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.values.base;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.util.Hashvector;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.values.api.IComplexTypeValue;
import com.sap.caf.mp.core.data.values.api.IElementValue;
import com.sap.caf.mp.core.data.values.base.TypeValue;
import java.util.Enumeration;

public class ComplexTypeValue
extends TypeValue
implements IComplexTypeValue {
    private Hashvector m_hashvector = new Hashvector();

    public ComplexTypeValue(IComplexType type) throws InvocationException {
        super(type);
    }

    public IElementValue addElementValue(IElementValue value) throws InvocationException {
        if (value == null) {
            throw new InvocationException("ElementValue invalid");
        }
        IElement l_element = value.getElement();
        if (l_element == null) {
            throw new InvocationException("Element of ElementValue invalid");
        }
        String l_name = l_element.getName();
        if (l_name == null) {
            throw new InvocationException("Name of Element of ElementValue invalid");
        }
        if (l_element != this.getComplexType().getElement(l_name)) {
            throw new InvocationException("Element of ElementValue mismatching");
        }
        return (IElementValue)this.m_hashvector.addValue((Object)l_name, (Object)value);
    }

    public IComplexType getComplexType() {
        return (IComplexType)this.getType();
    }

    public IElementValue getElementValue(String name) {
        return (IElementValue)this.m_hashvector.getValue((Object)name);
    }

    public IElementValue getElementValue(int index) {
        return (IElementValue)this.m_hashvector.getValue(index);
    }

    public int getElementValueCount() {
        return this.m_hashvector.getValueCount();
    }

    public Enumeration getElementValueEnumeration() {
        return this.m_hashvector.getValueEnumeration();
    }
}

