/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.types.base;

import com.sap.caf.mp.core.data.service.interfce.api.IOperation;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import java.util.Enumeration;
import java.util.HashSet;

public class MessageUtils {
    public static String dumpMessageValue(IMessage msg) {
        StringBuffer result = new StringBuffer();
        result.append("<mp:Message name=\"" + msg.getName() + "\">\r\n");
        Enumeration enumeration = msg.getMessagepartEnumeration();
        while (enumeration.hasMoreElements()) {
            IMessagepart partdef = (IMessagepart)enumeration.nextElement();
            MessageUtils.appendPartDef(partdef, result);
        }
        MessageUtils.appendClosingTag("mp:Message", result);
        result.append("\r\n");
        return result.toString();
    }

    private static void appendPartDef(IMessagepart partDef, StringBuffer value) {
        value.append("<mp:MessagePart name=\"" + partDef.getName() + "\">\r\n");
        IStructure structure = partDef.getStructure();
        if (structure instanceof IElement) {
            IElement elementDef = (IElement)partDef.getStructure();
            MessageUtils.appendElementDef(elementDef, value);
        } else if (structure instanceof IComplexType) {
            IComplexType complexValue = (IComplexType)partDef.getStructure();
            MessageUtils.appendComplexTypeDef(complexValue, value);
        } else if (structure instanceof ISimpleType) {
            ISimpleType simpleValue = (ISimpleType)structure;
            MessageUtils.appendSimpleTypeDef(simpleValue, value);
        }
        MessageUtils.appendClosingTag("mp:MessagePart", value);
        value.append("\r\n");
    }

    private static void appendElementDef(IElement elementDef, StringBuffer value) {
        value.append("<mp:Element name=\"" + elementDef.getName() + "\" minOccurs=\"" + elementDef.getMinOccurs() + "\" maxOccurs=\"" + elementDef.getMaxOccurs() + "\">\r\n");
        IType typeDef = elementDef.getType();
        if (typeDef instanceof IComplexType) {
            MessageUtils.appendComplexTypeDef((IComplexType)typeDef, value);
        } else {
            MessageUtils.appendSimpleTypeDef((ISimpleType)typeDef, value);
        }
        MessageUtils.appendClosingTag("mp:Element", value);
        value.append("\r\n");
    }

    private static void appendComplexTypeDef(IComplexType typeDef, StringBuffer value) {
        MessageUtils.appendOpeningTag("mp:ComplexType", value);
        value.append("\r\n");
        Enumeration enumeration = typeDef.getElementEnumeration();
        while (enumeration.hasMoreElements()) {
            IElement elementDef = (IElement)enumeration.nextElement();
            MessageUtils.appendElementDef(elementDef, value);
        }
        MessageUtils.appendClosingTag("mp:ComplexType", value);
        value.append("\r\n");
    }

    private static void appendSimpleTypeDef(ISimpleType typeDef, StringBuffer value) {
        value.append("<mp:SimpleType base=\"" + typeDef.getBase() + "\"/>\r\n");
    }

    private static void appendOpeningTag(String tag, StringBuffer value) {
        value.append("<" + tag + ">");
    }

    private static void appendClosingTag(String tag, StringBuffer value) {
        value.append("</" + tag + ">");
    }

    public static boolean hasCircles(IPorttype porttype) {
        for (int i = 0; i < porttype.getOperationCount(); ++i) {
            IOperation operation = porttype.getOperation(i);
            if (operation == null) continue;
            if (operation.getInputOperationpart() != null && MessageUtils.hasCircles(operation.getInputOperationpart().getMessage())) {
                return true;
            }
            if (operation.getOutputOperationpart() != null && MessageUtils.hasCircles(operation.getOutputOperationpart().getMessage())) {
                return true;
            }
            for (int j = 0; j < operation.getFaultOperationpartCount(); ++j) {
                if (operation.getFaultOperationpart(j) == null || !MessageUtils.hasCircles(operation.getFaultOperationpart(j).getMessage())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasCircles(IMessage message) {
        if (message != null) {
            for (int i = 0; i < message.getMessagepartCount(); ++i) {
                IMessagepart messagePart = message.getMessagepart(i);
                if (!MessageUtils.isStructureWithCircles(messagePart.getStructure(), new HashSet())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isStructureWithCircles(IStructure structure, HashSet set) {
        if (structure != null) {
            IType type = null;
            switch (structure.getStructureCast()) {
                case 1: {
                    type = ((IElement)structure).getType();
                    if (type == null) break;
                    return MessageUtils.isStructureWithCircles(type, set);
                }
                case 2: {
                    type = (IType)structure;
                    switch (type.getTypeCast()) {
                        case 2: {
                            return false;
                        }
                        case 1: {
                            IComplexType complexType = (IComplexType)structure;
                            if (set.contains(complexType)) {
                                return true;
                            }
                            set.add(complexType);
                            for (int i = 0; i < complexType.getElementCount(); ++i) {
                                if (!MessageUtils.isStructureWithCircles(complexType.getElement(i), set)) continue;
                                return true;
                            }
                            set.remove(complexType);
                        }
                    }
                }
            }
        }
        return false;
    }
}

