/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.types.base;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.util.Hashvector;
import com.sap.caf.mp.base.uuid.BaseUUIDManager;
import com.sap.caf.mp.core.bag.ITextbag;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import java.util.Enumeration;

public class Message
implements IMessage {
    private String m_uuid;
    private String m_name;
    private ITextbag m_textbag;
    private Hashvector m_hashvector;

    public Message(String name) throws InvocationException {
        this.initialize(BaseUUIDManager.getUUIDStringFromBytes((byte[])BaseUUIDManager.generateUUID(), (boolean)false), name);
    }

    public Message(String uuid, String name) throws InvocationException {
        if (uuid == null) {
            throw new InvocationException("Uuid Invalid");
        }
        this.initialize(uuid, name);
    }

    public IMessagepart addMessagepart(IMessagepart messagepart) throws InvocationException {
        return (IMessagepart)this.m_hashvector.addValue((Object)messagepart.getName(), (Object)messagepart);
    }

    public IMessagepart getMessagepart(String name) {
        return (IMessagepart)this.m_hashvector.getValue((Object)name);
    }

    public IMessagepart getMessagepart(int index) {
        return (IMessagepart)this.m_hashvector.getValue(index);
    }

    public int getMessagepartCount() {
        return this.m_hashvector.getValueCount();
    }

    public Enumeration getMessagepartEnumeration() {
        return this.m_hashvector.getValueEnumeration();
    }

    public String getName() {
        return this.m_name;
    }

    public ITextbag getTextbag() {
        return this.m_textbag;
    }

    public String getUuid() {
        return this.m_uuid;
    }

    private void initialize(String uuid, String name) throws InvocationException {
        if (name == null) {
            throw new InvocationException("Name invalid");
        }
        this.m_uuid = uuid;
        this.m_name = name;
        this.m_hashvector = new Hashvector();
    }

    public void setTextbag(ITextbag textbag) throws InvocationException {
        this.m_textbag = textbag;
    }
}

