/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.registry;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.data.service.IDataServiceFactory;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import com.sap.caf.mp.core.data.service.registry.IServiceDefinition;
import com.sap.caf.mp.core.data.service.registry.types.IOperationParameterDef;
import com.sap.caf.mp.core.data.service.registry.types.IServiceProviderTypeDef;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ServiceDefinition
implements IServiceDefinition {
    private String m_typeName;
    private String m_id;
    private String m_portTypeId;
    private Properties m_portTypeProperties;
    private Hashtable m_operationProperties;
    private IDataServiceFactory m_dataServiceFactory;
    private IPorttype m_portType;
    private String m_creator;
    private Date m_created;
    private String m_changer;
    private Date m_changed;

    public ServiceDefinition(String typeName, String id, String creator, Date created, String changer, Date changed, IDataServiceFactory dataServiceFactory) {
        this.m_typeName = typeName;
        this.m_id = id;
        this.m_portTypeId = null;
        this.m_dataServiceFactory = dataServiceFactory;
        this.resetProperties();
        this.m_portType = null;
        this.m_creator = creator;
        this.m_created = created;
        this.m_changer = changer;
        this.m_changed = changed;
    }

    public void resetProperties() {
        this.m_operationProperties = new Hashtable();
        this.m_portTypeProperties = new Properties();
    }

    public void setPortType(IPorttype portType) {
        this.m_portType = portType;
        this.m_portTypeId = portType.getUuid();
    }

    public void setPortTypeId(String portTypeId) {
        this.m_portTypeId = portTypeId;
    }

    public void setProperty(String name, String value) {
        this.m_portTypeProperties.put(name, value);
    }

    public void setProperty(String operationName, String name, String value) {
        if (!this.m_operationProperties.containsKey(operationName)) {
            this.m_operationProperties.put(operationName, new Properties());
        }
        Properties props = (Properties)this.m_operationProperties.get(operationName);
        props.put(name, value);
    }

    public void setPortTypeProperties(Properties portTypeProps) {
        this.m_portTypeProperties = portTypeProps;
    }

    public void setOperationProperties(Hashtable operationProps) {
        this.m_operationProperties = operationProps;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public String getId() {
        return this.m_id;
    }

    public String getPortTypeId() {
        return this.m_portTypeId;
    }

    public Properties getPortTypeProperties() {
        return this.m_portTypeProperties;
    }

    public Properties getOperationProperties(String operationId) throws EngineException {
        if (!this.m_operationProperties.containsKey(operationId)) {
            return new Properties();
        }
        return (Properties)this.m_operationProperties.get(operationId);
    }

    public Properties resolveOperationProperties(String operationId) throws EngineException {
        IServiceProviderTypeDef def = this.m_dataServiceFactory.getServicesRegistry().getServiceProviderTypeDefs().getServiceProviderDef(this.m_typeName);
        if (def == null) {
            throw new EngineException("A service provider type definition with this name is not registered.");
        }
        Properties props = this.getOperationProperties(operationId);
        Enumeration enumeration = def.getOperationParameterList().elements();
        while (enumeration.hasMoreElements()) {
            IOperationParameterDef paramDef = (IOperationParameterDef)enumeration.nextElement();
            if (props.containsKey(paramDef.getName()) && (!paramDef.isInherited() || paramDef.isChangeable()) || !paramDef.isInherited() || !this.m_portTypeProperties.containsKey(paramDef.getName())) continue;
            props.put(paramDef.getName(), this.m_portTypeProperties.get(paramDef.getName()));
        }
        return props;
    }

    public IPorttype getPortType() throws EngineException {
        if (this.m_portType == null) {
            try {
                this.m_portType = this.m_dataServiceFactory.getServiceDescriptionPersistence().readPorttype(this.m_portTypeId);
            }
            catch (InvocationException ex) {
                ex.printStackTrace();
                throw new EngineException((Exception)((Object)ex));
            }
        }
        return this.m_portType;
    }

    public Date getChanged() {
        return this.m_changed;
    }

    public String getChanger() {
        return this.m_changer;
    }

    public Date getCreated() {
        return this.m_created;
    }

    public String getCreator() {
        return this.m_creator;
    }

    public Hashtable getOperationProperties() throws EngineException {
        return this.m_operationProperties;
    }
}

