/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.interfce.base;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.util.Hashvector;
import com.sap.caf.mp.base.uuid.BaseUUIDManager;
import com.sap.caf.mp.core.bag.ITextbag;
import com.sap.caf.mp.core.data.service.interfce.api.IOperation;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class Porttype
implements IPorttype {
    private String m_uuid;
    private String m_name;
    private ITextbag m_textbag;
    private Map m_namespaces;
    private Hashvector m_hashvector;

    public Porttype(String name) throws InvocationException {
        this.initialize(BaseUUIDManager.getUUIDStringFromBytes((byte[])BaseUUIDManager.generateUUID(), (boolean)false), name);
    }

    public Porttype(String uuid, String name) throws InvocationException {
        if (uuid == null) {
            throw new InvocationException("Uuid invalid");
        }
        this.initialize(uuid, name);
    }

    public IOperation addOperation(IOperation operation) throws InvocationException {
        if (operation == null) {
            throw new InvocationException("Operation invalid");
        }
        return (IOperation)this.m_hashvector.addValue((Object)operation.getName(), (Object)operation);
    }

    public String getName() {
        return this.m_name;
    }

    public Map getNamespaces() {
        return this.m_namespaces;
    }

    public IOperation getOperation(String name) {
        return (IOperation)this.m_hashvector.getValue((Object)name);
    }

    public IOperation getOperation(int index) {
        return (IOperation)this.m_hashvector.getValue(index);
    }

    public int getOperationCount() {
        return this.m_hashvector.getValueCount();
    }

    public Enumeration getOperationEnumeration() {
        return this.m_hashvector.getValueEnumeration();
    }

    public ITextbag getTextbag() {
        return this.m_textbag;
    }

    public String getUuid() {
        return this.m_uuid;
    }

    private void initialize(String uuid, String name) throws InvocationException {
        if (name == null) {
            throw new InvocationException("Name invalid");
        }
        this.m_uuid = uuid;
        this.m_name = name;
        this.m_textbag = null;
        this.m_namespaces = new HashMap();
        this.m_hashvector = new Hashvector();
    }

    public void addNamespace(String prefix, String namespace) throws InvocationException {
        this.m_namespaces.put(prefix, namespace);
    }

    public void setTextbag(ITextbag textbag) throws InvocationException {
        this.m_textbag = textbag;
    }
}

