/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.persistence.base;

import com.sap.caf.mp.base.db.ConnectionPoolOpenSQLStandalone;
import com.sap.caf.mp.base.db.ICNConnectionPool;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.ICoreFactory;
import com.sap.caf.mp.core.bag.IBagFactory;
import com.sap.caf.mp.core.bag.ITextbag;
import com.sap.caf.mp.core.bag.ITextbagEntry;
import com.sap.caf.mp.core.data.persistence.api.IServiceDescriptionPersistence;
import com.sap.caf.mp.core.data.persistence.base.PersistenceContext;
import com.sap.caf.mp.core.data.service.interfce.api.IOperation;
import com.sap.caf.mp.core.data.service.interfce.api.IOperationpart;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import com.sap.caf.mp.core.data.service.interfce.base.Operation;
import com.sap.caf.mp.core.data.service.interfce.base.Operationpart;
import com.sap.caf.mp.core.data.service.interfce.base.Porttype;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.types.base.ComplexType;
import com.sap.caf.mp.core.data.types.base.Element;
import com.sap.caf.mp.core.data.types.base.Message;
import com.sap.caf.mp.core.data.types.base.MessageUtils;
import com.sap.caf.mp.core.data.types.base.Messagepart;
import com.sap.caf.mp.core.data.types.base.SimpleType;
import com.sap.caf.mp.core.data.types.meta.api.ILayoutNode;
import com.sap.caf.mp.core.data.types.meta.api.ITypeFactory;
import com.sap.caf.mp.core.data.types.meta.api.ITypeLayout;
import com.sap.caf.mp.core.data.values.api.ISimpleTypeValue;
import com.sap.caf.mp.core.data.values.meta.api.ITypeValueFactory;
import com.sap.caf.mp.core.svc.persist.INumberRange;
import com.sap.caf.mp.core.svc.persist.IPersistenceManagers;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;

public class ServiceDescriptionPersistence
implements IServiceDescriptionPersistence {
    private static final String TABLE_TYPCEL = "CAF_RT_TYPCEL";
    private static final String TABLE_TYPCOT = "CAF_RT_TYPCOT";
    private static final String TABLE_TYPELE = "CAF_RT_TYPELE";
    private static final String TABLE_TYPMES = "CAF_RT_TYPMES";
    private static final String TABLE_TYPMMP = "CAF_RT_TYPMMP";
    private static final String TABLE_TYPMPA = "CAF_RT_TYPMPA";
    private static final String TABLE_TYPOFO = "CAF_RT_TYPOFO";
    private static final String TABLE_TYPOPE = "CAF_RT_TYPOPE";
    private static final String TABLE_TYPOPA = "CAF_RT_TYPOPA";
    private static final String TABLE_TYPPOP = "CAF_RT_TYPPOP";
    private static final String TABLE_TYPPTY = "CAF_RT_TYPPTY";
    private static final String TABLE_TYPNSP = "CAF_RT_TYPNSP";
    private static final String TABLE_TYPSCO = "CAF_RT_TYPSCO";
    private static final String TABLE_TYPSIT = "CAF_RT_TYPSIT";
    private static final String TABLE_TYPSPA = "CAF_RT_TYPSPA";
    private static final String TABLE_TYPTEN = "CAF_RT_TYPTEN";
    private static final String TABLE_TYPTEX = "CAF_RT_TYPTEX";
    private static final String FIELD_TYPCEL_PTY_GUID = "PTY_GUID";
    private static final String FIELD_TYPCEL_COT_LUID = "COT_LUID";
    private static final String FIELD_TYPCEL_ELE_NUMB = "ELE_NUMB";
    private static final String FIELD_TYPCEL_ELE_LUID = "ELE_LUID";
    private static final String FIELD_TYPCOT_PTY_GUID = "PTY_GUID";
    private static final String FIELD_TYPCOT_COT_LUID = "COT_LUID";
    private static final String FIELD_TYPCOT_COT_MODE = "COT_MODE";
    private static final String FIELD_TYPELE_PTY_GUID = "PTY_GUID";
    private static final String FIELD_TYPELE_ELE_LUID = "ELE_LUID";
    private static final String FIELD_TYPELE_ELE_NAME = "ELE_NAME";
    private static final String FIELD_TYPELE_ELE_OMIN = "ELE_OMIN";
    private static final String FIELD_TYPELE_ELE_OMAX = "ELE_OMAX";
    private static final String FIELD_TYPELE_TYP_CAST = "TYP_CAST";
    private static final String FIELD_TYPELE_TYP_LUID = "TYP_LUID";
    private static final String FIELD_TYPELE_TEX_LUID = "TEX_LUID";
    private static final String FIELD_TYPMES_PTY_GUID = "PTY_GUID";
    private static final String FIELD_TYPMES_MES_LUID = "MES_LUID";
    private static final String FIELD_TYPMES_MES_UUID = "MES_UUID";
    private static final String FIELD_TYPMES_MES_NAME = "MES_NAME";
    private static final String FIELD_TYPMES_TEX_LUID = "TEX_LUID";
    private static final String FIELD_TYPMMP_PTY_GUID = "PTY_GUID";
    private static final String FIELD_TYPMMP_MES_LUID = "MES_LUID";
    private static final String FIELD_TYPMMP_MPA_NUMB = "MPA_NUMB";
    private static final String FIELD_TYPMMP_MPA_LUID = "MPA_LUID";
    private static final String FIELD_TYPMPA_PTY_GUID = "PTY_GUID";
    private static final String FIELD_TYPMPA_MPA_LUID = "MPA_LUID";
    private static final String FIELD_TYPMPA_MPA_NAME = "MPA_NAME";
    private static final String FIELD_TYPMPA_STR_CAST = "STR_CAST";
    private static final String FIELD_TYPMPA_STR_LUID = "STR_LUID";
    private static final String FIELD_TYPMPA_TEX_LUID = "TEX_LUID";
    private static final String FIELD_TYPOFO_PTY_GUID = "PTY_GUID";
    private static final String FIELD_TYPOFO_OPE_LUID = "OPE_LUID";
    private static final String FIELD_TYPOFO_FOP_NUMB = "FOP_NUMB";
    private static final String FIELD_TYPOFO_FOP_LUID = "FOP_LUID";
    private static final String FIELD_TYPOPA_PTY_GUID = "PTY_GUID";
    private static final String FIELD_TYPOPA_OPA_LUID = "OPA_LUID";
    private static final String FIELD_TYPOPA_OPA_NAME = "OPA_NAME";
    private static final String FIELD_TYPOPA_MES_LUID = "MES_LUID";
    private static final String FIELD_TYPOPA_TEX_LUID = "TEX_LUID";
    private static final String FIELD_TYPOPE_PTY_GUID = "PTY_GUID";
    private static final String FIELD_TYPOPE_OPE_LUID = "OPE_LUID";
    private static final String FIELD_TYPOPE_OPE_NAME = "OPE_NAME";
    private static final String FIELD_TYPOPE_IOP_LUID = "IOP_LUID";
    private static final String FIELD_TYPOPE_OOP_LUID = "OOP_LUID";
    private static final String FIELD_TYPOPE_TEX_LUID = "TEX_LUID";
    private static final String FIELD_TYPPOP_PTY_GUID = "PTY_GUID";
    private static final String FIELD_TYPPOP_OPE_NUMB = "OPE_NUMB";
    private static final String FIELD_TYPPOP_OPE_LUID = "OPE_LUID";
    private static final String FIELD_TYPPTY_PTY_GUID = "PTY_GUID";
    private static final String FIELD_TYPPTY_PTY_UUID = "PTY_UUID";
    private static final String FIELD_TYPPTY_PTY_NAME = "PTY_NAME";
    private static final String FIELD_TYPPTY_TEX_LUID = "TEX_LUID";
    private static final String FIELD_TYPNSP_PTY_GUID = "PTY_GUID";
    private static final String FIELD_TYPNSP_NSP_PREFIX = "NSP_PREFIX";
    private static final String FIELD_TYPNSP_NSP_URI = "NSP_URI";
    private static final String FIELD_TYPSCO_PTY_GUID = "PTY_GUID";
    private static final String FIELD_TYPSCO_SIT_LUID = "SIT_LUID";
    private static final String FIELD_TYPSCO_CON_NUMB = "CON_NUMB";
    private static final String FIELD_TYPSCO_CON_DATA = "CON_DATA";
    private static final String FIELD_TYPSIT_PTY_GUID = "PTY_GUID";
    private static final String FIELD_TYPSIT_SIT_LUID = "SIT_LUID";
    private static final String FIELD_TYPSIT_SIT_BASE = "SIT_BASE";
    private static final String FIELD_TYPSIT_SIT_SMIN = "SIT_SMIN";
    private static final String FIELD_TYPSIT_SIT_SMAX = "SIT_SMAX";
    private static final String FIELD_TYPSIT_SIT_DFRA = "SIT_DFRA";
    private static final String FIELD_TYPSIT_SIT_DTOT = "SIT_DTOT";
    private static final String FIELD_TYPSPA_PTY_GUID = "PTY_GUID";
    private static final String FIELD_TYPSPA_SIT_LUID = "SIT_LUID";
    private static final String FIELD_TYPSPA_PAT_NUMB = "PAT_NUMB";
    private static final String FIELD_TYPSPA_PAT_DATA = "PAT_DATA";
    private static final String FIELD_TYPTEN_PTY_GUID = "PTY_GUID";
    private static final String FIELD_TYPTEN_TEX_LUID = "TEX_LUID";
    private static final String FIELD_TYPTEN_TEN_LANG = "TEN_LANG";
    private static final String FIELD_TYPTEN_TEN_DATA = "TEN_DATA";
    private static final String FIELD_TYPTEX_PTY_GUID = "PTY_GUID";
    private static final String FIELD_TYPTEX_TEX_LUID = "TEX_LUID";
    private static final String FIELD_TYPTEX_TEN_LANG = "TEN_LANG";
    private static final Integer ID_DELETE_TYPCEL_PTY = new Integer(1);
    private static final Integer ID_DELETE_TYPCOT_PTY = new Integer(2);
    private static final Integer ID_DELETE_TYPELE_PTY = new Integer(3);
    private static final Integer ID_DELETE_TYPMES_PTY = new Integer(4);
    private static final Integer ID_DELETE_TYPMMP_PTY = new Integer(5);
    private static final Integer ID_DELETE_TYPMPA_PTY = new Integer(6);
    private static final Integer ID_DELETE_TYPOFO_PTY = new Integer(7);
    private static final Integer ID_DELETE_TYPOPA_PTY = new Integer(8);
    private static final Integer ID_DELETE_TYPOPE_PTY = new Integer(9);
    private static final Integer ID_DELETE_TYPPOP_PTY = new Integer(10);
    private static final Integer ID_DELETE_TYPPTY_PTY = new Integer(11);
    private static final Integer ID_DELETE_TYPSCO_PTY = new Integer(12);
    private static final Integer ID_DELETE_TYPSIT_PTY = new Integer(13);
    private static final Integer ID_DELETE_TYPSPA_PTY = new Integer(14);
    private static final Integer ID_DELETE_TYPTEN_PTY = new Integer(15);
    private static final Integer ID_DELETE_TYPTEX_PTY = new Integer(16);
    private static final Integer ID_DELETE_TYPNSP_PTY = new Integer(17);
    private static final Integer ID_INSERT_TYPCEL = new Integer(101);
    private static final Integer ID_INSERT_TYPCOT = new Integer(102);
    private static final Integer ID_INSERT_TYPELE = new Integer(103);
    private static final Integer ID_INSERT_TYPMES = new Integer(104);
    private static final Integer ID_INSERT_TYPMMP = new Integer(105);
    private static final Integer ID_INSERT_TYPMPA = new Integer(106);
    private static final Integer ID_INSERT_TYPOFO = new Integer(107);
    private static final Integer ID_INSERT_TYPOPA = new Integer(108);
    private static final Integer ID_INSERT_TYPOPE = new Integer(109);
    private static final Integer ID_INSERT_TYPPOP = new Integer(110);
    private static final Integer ID_INSERT_TYPPTY = new Integer(111);
    private static final Integer ID_INSERT_TYPSCO = new Integer(112);
    private static final Integer ID_INSERT_TYPSIT = new Integer(113);
    private static final Integer ID_INSERT_TYPSPA = new Integer(114);
    private static final Integer ID_INSERT_TYPTEN = new Integer(115);
    private static final Integer ID_INSERT_TYPTEX = new Integer(116);
    private static final Integer ID_INSERT_TYPNSP = new Integer(117);
    private static final Integer ID_SELECT_TYPCEL_LIST = new Integer(201);
    private static final Integer ID_SELECT_TYPCOT_KEY = new Integer(202);
    private static final Integer ID_SELECT_TYPELE_KEY = new Integer(203);
    private static final Integer ID_SELECT_TYPMES_GUID = new Integer(204);
    private static final Integer ID_SELECT_TYPMES_KEY = new Integer(205);
    private static final Integer ID_SELECT_TYPMMP_LIST = new Integer(206);
    private static final Integer ID_SELECT_TYPMPA_KEY = new Integer(207);
    private static final Integer ID_SELECT_TYPOFO_LIST = new Integer(208);
    private static final Integer ID_SELECT_TYPOPA_KEY = new Integer(209);
    private static final Integer ID_SELECT_TYPOPE_KEY = new Integer(210);
    private static final Integer ID_SELECT_TYPPOP_LIST = new Integer(211);
    private static final Integer ID_SELECT_TYPPTY_GUID = new Integer(212);
    private static final Integer ID_SELECT_TYPPTY_KEY = new Integer(213);
    private static final Integer ID_SELECT_TYPSCO_LIST = new Integer(214);
    private static final Integer ID_SELECT_TYPSIT_KEY = new Integer(215);
    private static final Integer ID_SELECT_TYPSPA_LIST = new Integer(216);
    private static final Integer ID_SELECT_TYPTEN_LIST = new Integer(217);
    private static final Integer ID_SELECT_TYPTEX_KEY = new Integer(218);
    private static final Integer ID_SELECT_TYPNSP_KEY = new Integer(219);
    private static final String STATEMENT_DELETE_TYPCEL_PTY = "DELETE FROM CAF_RT_TYPCEL WHERE PTY_GUID=?";
    private static final String STATEMENT_DELETE_TYPCOT_PTY = "DELETE FROM CAF_RT_TYPSIT WHERE PTY_GUID=?";
    private static final String STATEMENT_DELETE_TYPELE_PTY = "DELETE FROM CAF_RT_TYPELE WHERE PTY_GUID=?";
    private static final String STATEMENT_DELETE_TYPMES_PTY = "DELETE FROM CAF_RT_TYPMES WHERE PTY_GUID=?";
    private static final String STATEMENT_DELETE_TYPMMP_PTY = "DELETE FROM CAF_RT_TYPMMP WHERE PTY_GUID=?";
    private static final String STATEMENT_DELETE_TYPMPA_PTY = "DELETE FROM CAF_RT_TYPMPA WHERE PTY_GUID=?";
    private static final String STATEMENT_DELETE_TYPOFO_PTY = "DELETE FROM CAF_RT_TYPOFO WHERE PTY_GUID=?";
    private static final String STATEMENT_DELETE_TYPOPA_PTY = "DELETE FROM CAF_RT_TYPOPA WHERE PTY_GUID=?";
    private static final String STATEMENT_DELETE_TYPOPE_PTY = "DELETE FROM CAF_RT_TYPOPE WHERE PTY_GUID=?";
    private static final String STATEMENT_DELETE_TYPPOP_PTY = "DELETE FROM CAF_RT_TYPPOP WHERE PTY_GUID=?";
    private static final String STATEMENT_DELETE_TYPPTY_PTY = "DELETE FROM CAF_RT_TYPPTY WHERE PTY_GUID=?";
    private static final String STATEMENT_DELETE_TYPNSP_PTY = "DELETE FROM CAF_RT_TYPNSP WHERE PTY_GUID=?";
    private static final String STATEMENT_DELETE_TYPSCO_PTY = "DELETE FROM CAF_RT_TYPSCO WHERE PTY_GUID=?";
    private static final String STATEMENT_DELETE_TYPSIT_PTY = "DELETE FROM CAF_RT_TYPSIT WHERE PTY_GUID=?";
    private static final String STATEMENT_DELETE_TYPSPA_PTY = "DELETE FROM CAF_RT_TYPSPA WHERE PTY_GUID=?";
    private static final String STATEMENT_DELETE_TYPTEN_PTY = "DELETE FROM CAF_RT_TYPTEN WHERE PTY_GUID=?";
    private static final String STATEMENT_DELETE_TYPTEX_PTY = "DELETE FROM CAF_RT_TYPTEX WHERE PTY_GUID=?";
    private static final String STATEMENT_INSERT_TYPCEL = "INSERT INTO CAF_RT_TYPCEL(PTY_GUID,COT_LUID,ELE_NUMB,ELE_LUID) values (?,?,?,?)";
    private static final String STATEMENT_INSERT_TYPCOT = "INSERT INTO CAF_RT_TYPCOT(PTY_GUID,COT_LUID,COT_MODE) values (?,?,?)";
    private static final String STATEMENT_INSERT_TYPELE = "INSERT INTO CAF_RT_TYPELE(PTY_GUID,ELE_LUID,ELE_NAME,ELE_OMIN,ELE_OMAX,TYP_CAST,TYP_LUID,TEX_LUID) values (?,?,?,?,?,?,?,?)";
    private static final String STATEMENT_INSERT_TYPMES = "INSERT INTO CAF_RT_TYPMES(PTY_GUID,MES_LUID,MES_UUID,MES_NAME,TEX_LUID) values (?,?,?,?,?)";
    private static final String STATEMENT_INSERT_TYPMMP = "INSERT INTO CAF_RT_TYPMMP(PTY_GUID,MES_LUID,MPA_NUMB,MPA_LUID) values (?,?,?,?)";
    private static final String STATEMENT_INSERT_TYPMPA = "INSERT INTO CAF_RT_TYPMPA(PTY_GUID,MPA_LUID,MPA_NAME,STR_CAST,STR_LUID,TEX_LUID) values (?,?,?,?,?,?)";
    private static final String STATEMENT_INSERT_TYPOFO = "INSERT INTO CAF_RT_TYPOFO(PTY_GUID,OPE_LUID,FOP_NUMB,FOP_LUID) values (?,?,?,?)";
    private static final String STATEMENT_INSERT_TYPOPA = "INSERT INTO CAF_RT_TYPOPA(PTY_GUID,OPA_LUID,OPA_NAME,MES_LUID,TEX_LUID) values (?,?,?,?,?)";
    private static final String STATEMENT_INSERT_TYPOPE = "INSERT INTO CAF_RT_TYPOPE(PTY_GUID,OPE_LUID,OPE_NAME,IOP_LUID,OOP_LUID,TEX_LUID) values (?,?,?,?,?,?)";
    private static final String STATEMENT_INSERT_TYPPOP = "INSERT INTO CAF_RT_TYPPOP(PTY_GUID,OPE_NUMB,OPE_LUID) values (?,?,?)";
    private static final String STATEMENT_INSERT_TYPPTY = "INSERT INTO CAF_RT_TYPPTY(PTY_GUID,PTY_UUID,PTY_NAME,TEX_LUID) values (?,?,?,?)";
    private static final String STATEMENT_INSERT_TYPNSP = "INSERT INTO CAF_RT_TYPNSP(PTY_GUID,NSP_PREFIX,NSP_URI) values (?,?,?)";
    private static final String STATEMENT_INSERT_TYPSCO = "INSERT INTO CAF_RT_TYPSCO(PTY_GUID,SIT_LUID,CON_NUMB,CON_DATA) values (?,?,?,?)";
    private static final String STATEMENT_INSERT_TYPSIT = "INSERT INTO CAF_RT_TYPSIT(PTY_GUID,SIT_LUID,SIT_BASE,SIT_SMIN,SIT_SMAX,SIT_DFRA,SIT_DTOT) values (?,?,?,?,?,?,?)";
    private static final String STATEMENT_INSERT_TYPSPA = "INSERT INTO CAF_RT_TYPSPA(PTY_GUID,SIT_LUID,PAT_NUMB,PAT_DATA) values (?,?,?,?)";
    private static final String STATEMENT_INSERT_TYPTEN = "INSERT INTO CAF_RT_TYPTEN(PTY_GUID,TEX_LUID,TEN_LANG,TEN_DATA) values (?,?,?,?)";
    private static final String STATEMENT_INSERT_TYPTEX = "INSERT INTO CAF_RT_TYPTEX(PTY_GUID,TEX_LUID,TEN_LANG) values (?,?,?)";
    private static final String STATEMENT_SELECT_TYPCEL_LIST = "SELECT ELE_NUMB,ELE_LUID FROM CAF_RT_TYPCEL WHERE PTY_GUID=? AND COT_LUID=?";
    private static final String STATEMENT_SELECT_TYPCOT_KEY = "SELECT COT_MODE FROM CAF_RT_TYPCOT WHERE PTY_GUID=? AND COT_LUID=?";
    private static final String STATEMENT_SELECT_TYPELE_KEY = "SELECT ELE_NAME,ELE_OMIN,ELE_OMAX,TYP_CAST,TYP_LUID,TEX_LUID FROM CAF_RT_TYPELE WHERE PTY_GUID=? AND ELE_LUID=?";
    private static final String STATEMENT_SELECT_TYPMES_GUID = "SELECT PTY_GUID,MES_LUID,MES_NAME,TEX_LUID FROM CAF_RT_TYPMES WHERE MES_UUID=?";
    private static final String STATEMENT_SELECT_TYPMES_KEY = "SELECT MES_UUID,MES_NAME,TEX_LUID FROM CAF_RT_TYPMES WHERE PTY_GUID=? AND MES_LUID=?";
    private static final String STATEMENT_SELECT_TYPMMP_LIST = "SELECT MPA_NUMB,MPA_LUID FROM CAF_RT_TYPMMP WHERE PTY_GUID=? AND MES_LUID=?";
    private static final String STATEMENT_SELECT_TYPMPA_KEY = "SELECT MPA_NAME,STR_CAST,STR_LUID,TEX_LUID FROM CAF_RT_TYPMPA WHERE PTY_GUID=? AND MPA_LUID=?";
    private static final String STATEMENT_SELECT_TYPOFO_LIST = "SELECT FOP_NUMB,FOP_LUID FROM CAF_RT_TYPOFO WHERE PTY_GUID=? AND OPE_LUID=?";
    private static final String STATEMENT_SELECT_TYPOPA_KEY = "SELECT OPA_NAME,MES_LUID,TEX_LUID FROM CAF_RT_TYPOPA WHERE PTY_GUID=? AND OPA_LUID=?";
    private static final String STATEMENT_SELECT_TYPOPE_KEY = "SELECT OPE_NAME,IOP_LUID,OOP_LUID,TEX_LUID FROM CAF_RT_TYPOPE WHERE PTY_GUID=? AND OPE_LUID=?";
    private static final String STATEMENT_SELECT_TYPPOP_LIST = "SELECT OPE_NUMB,OPE_LUID FROM CAF_RT_TYPPOP WHERE PTY_GUID=?";
    private static final String STATEMENT_SELECT_TYPPTY_GUID = "SELECT PTY_GUID,PTY_NAME,TEX_LUID FROM CAF_RT_TYPPTY WHERE PTY_UUID=?";
    private static final String STATEMENT_SELECT_TYPPTY_KEY = "SELECT PTY_UUID,PTY_NAME,TEX_LUID FROM CAF_RT_TYPPTY WHERE PTY_GUID=?";
    private static final String STATEMENT_SELECT_TYPNSP_KEY = "SELECT NSP_PREFIX,NSP_URI FROM CAF_RT_TYPNSP WHERE PTY_GUID=?";
    private static final String STATEMENT_SELECT_TYPSCO_LIST = "SELECT CON_NUMB,CON_DATA FROM CAF_RT_TYPSCO WHERE PTY_GUID=? AND SIT_LUID=?";
    private static final String STATEMENT_SELECT_TYPSIT_KEY = "SELECT SIT_BASE,SIT_SMIN,SIT_SMAX,SIT_DFRA,SIT_DTOT FROM CAF_RT_TYPSIT WHERE PTY_GUID=? AND SIT_LUID=?";
    private static final String STATEMENT_SELECT_TYPSPA_LIST = "SELECT PAT_NUMB,PAT_DATA FROM CAF_RT_TYPSPA WHERE PTY_GUID=? AND SIT_LUID=?";
    private static final String STATEMENT_SELECT_TYPTEN_LIST = "SELECT TEN_LANG,TEN_DATA FROM CAF_RT_TYPTEN WHERE PTY_GUID=? AND TEX_LUID=?";
    private static final String STATEMENT_SELECT_TYPTEX_KEY = "SELECT TEN_LANG FROM CAF_RT_TYPTEX WHERE PTY_GUID=? AND TEX_LUID=?";
    private static final int STRUCTURE_CAST_ELEMENT = 1;
    private static final int STRUCTURE_CAST_TYPE_COMPLEX = 2;
    private static final int STRUCTURE_CAST_TYPE_SIMPLE = 3;
    private static final int TYPE_CAST_COMPLEX = 1;
    private static final int TYPE_CAST_SIMPLE = 2;
    private static final String NUMBERRANGE_PORTTYPE = "CAF_RT_PTY_GUID";
    private ICNConnectionPool m_pool;
    private INumberRange m_numberrange;
    private IBagFactory m_factoryBag;
    private ITypeFactory m_factoryType;
    private ITypeValueFactory m_factoryValue;

    public ServiceDescriptionPersistence(ICoreFactory core) throws InvocationException {
        if (core == null) {
            throw new InvocationException("CoreFactory invalid");
        }
        IPersistenceManagers l_manager = core.getPersistenceManagers();
        this.initialize(l_manager.getConnectionPool(), l_manager.getNumberRange(), core.getBagFactory(), core.getTypeFactory(), core.getTypeValueFactory());
    }

    public ServiceDescriptionPersistence(ICNConnectionPool pool, INumberRange numberrange, IBagFactory bag, ITypeFactory type, ITypeValueFactory value) throws InvocationException {
        this.initialize(pool, numberrange, bag, type, value);
    }

    private void commitContext(PersistenceContext context, boolean success) throws EngineException {
        try {
            Connection l_connection = context.getConnection();
            if (success) {
                l_connection.commit();
            } else {
                l_connection.rollback();
            }
        }
        catch (SQLException l_exception) {
            throw new EngineException("Failed to commit database connection", (Exception)l_exception);
        }
    }

    private void closeContext(PersistenceContext context) throws EngineException {
        try {
            Enumeration l_enumeration = context.getStatementBuffer().elements();
            while (l_enumeration.hasMoreElements()) {
                ((PreparedStatement)l_enumeration.nextElement()).close();
            }
            context.getConnection().close();
        }
        catch (SQLException l_exception) {
            throw new EngineException("Failed to close database connection", (Exception)l_exception);
        }
    }

    private String decodeString(String string) {
        return string.substring(1, string.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void deleteMessage(String uuid) throws EngineException, InvocationException {
        if (uuid != null && uuid.length() == 32) {
            PersistenceContext l_context = this.openContext();
            boolean l_success = false;
            Enumeration l_typmes_enumeration = this.selectTypmes(l_context, uuid).elements();
            while (l_typmes_enumeration.hasMoreElements()) {
                StructTypmes l_typmes_struct = (StructTypmes)l_typmes_enumeration.nextElement();
                int l_guid = l_typmes_struct.pty_guid;
                if (this.selectTyppty(l_context, l_guid).size() > 0) {
                    throw new InvocationException("Message belongs to Porttype");
                }
                this.deletePorttype(l_context, l_guid);
            }
            l_success = true;
            Object var8_8 = null;
            try {
                this.commitContext(l_context, l_success);
            }
            finally {
                this.closeContext(l_context);
            }
            {
                catch (SQLException l_exception) {
                    throw new EngineException("Failed to select components from database", (Exception)l_exception);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    this.commitContext(l_context, l_success);
                }
                finally {
                    this.closeContext(l_context);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void deletePorttype(String uuid) throws EngineException, InvocationException {
        if (uuid != null && uuid.length() == 32) {
            PersistenceContext l_context = this.openContext();
            boolean l_success = false;
            Enumeration l_typpty_enumeration = this.selectTyppty(l_context, uuid).elements();
            while (l_typpty_enumeration.hasMoreElements()) {
                this.deletePorttype(l_context, ((StructTyppty)l_typpty_enumeration.nextElement()).pty_guid);
            }
            l_success = true;
            Object var6_6 = null;
            try {
                this.commitContext(l_context, l_success);
            }
            finally {
                this.closeContext(l_context);
            }
            {
                catch (SQLException l_exception) {
                    throw new EngineException("Failed to select components from database", (Exception)l_exception);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    this.commitContext(l_context, l_success);
                }
                finally {
                    this.closeContext(l_context);
                }
                throw throwable;
            }
        }
    }

    private void deletePorttype(PersistenceContext context, int guid) throws EngineException {
        try {
            this.deleteTyppty(context, guid);
            this.deleteTypnsp(context, guid);
            this.deleteTyppop(context, guid);
            this.deleteTypope(context, guid);
            this.deleteTypofo(context, guid);
            this.deleteTypopa(context, guid);
            this.deleteTypmes(context, guid);
            this.deleteTypmmp(context, guid);
            this.deleteTypmpa(context, guid);
            this.deleteTypele(context, guid);
            this.deleteTypsit(context, guid);
            this.deleteTypspa(context, guid);
            this.deleteTypsco(context, guid);
            this.deleteTypcot(context, guid);
            this.deleteTypcel(context, guid);
            this.deleteTyptex(context, guid);
            this.deleteTypten(context, guid);
        }
        catch (SQLException l_exception) {
            throw new EngineException("Failed to delete components from database", (Exception)l_exception);
        }
    }

    private int deleteTypcel(PersistenceContext context, int porttype) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_DELETE_TYPCEL_PTY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_DELETE_TYPCEL_PTY);
            l_buffer.put(ID_DELETE_TYPCEL_PTY, l_statement);
        }
        l_statement.setInt(1, porttype);
        return l_statement.executeUpdate();
    }

    private int deleteTypcot(PersistenceContext context, int porttype) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_DELETE_TYPCOT_PTY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement("DELETE FROM CAF_RT_TYPSIT WHERE PTY_GUID=?");
            l_buffer.put(ID_DELETE_TYPCOT_PTY, l_statement);
        }
        l_statement.setInt(1, porttype);
        return l_statement.executeUpdate();
    }

    private int deleteTypele(PersistenceContext context, int porttype) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_DELETE_TYPELE_PTY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_DELETE_TYPELE_PTY);
            l_buffer.put(ID_DELETE_TYPELE_PTY, l_statement);
        }
        l_statement.setInt(1, porttype);
        return l_statement.executeUpdate();
    }

    private int deleteTypmes(PersistenceContext context, int porttype) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_DELETE_TYPMES_PTY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_DELETE_TYPMES_PTY);
            l_buffer.put(ID_DELETE_TYPMES_PTY, l_statement);
        }
        l_statement.setInt(1, porttype);
        return l_statement.executeUpdate();
    }

    private int deleteTypmmp(PersistenceContext context, int porttype) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_DELETE_TYPMMP_PTY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_DELETE_TYPMMP_PTY);
            l_buffer.put(ID_DELETE_TYPMMP_PTY, l_statement);
        }
        l_statement.setInt(1, porttype);
        return l_statement.executeUpdate();
    }

    private int deleteTypmpa(PersistenceContext context, int porttype) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_DELETE_TYPMPA_PTY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_DELETE_TYPMPA_PTY);
            l_buffer.put(ID_DELETE_TYPMPA_PTY, l_statement);
        }
        l_statement.setInt(1, porttype);
        return l_statement.executeUpdate();
    }

    private int deleteTypofo(PersistenceContext context, int porttype) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_DELETE_TYPOFO_PTY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_DELETE_TYPOFO_PTY);
            l_buffer.put(ID_DELETE_TYPOFO_PTY, l_statement);
        }
        l_statement.setInt(1, porttype);
        return l_statement.executeUpdate();
    }

    private int deleteTypopa(PersistenceContext context, int porttype) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_DELETE_TYPOPA_PTY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_DELETE_TYPOPA_PTY);
            l_buffer.put(ID_DELETE_TYPOPA_PTY, l_statement);
        }
        l_statement.setInt(1, porttype);
        return l_statement.executeUpdate();
    }

    private int deleteTypope(PersistenceContext context, int porttype) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_DELETE_TYPOPE_PTY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_DELETE_TYPOPE_PTY);
            l_buffer.put(ID_DELETE_TYPOPE_PTY, l_statement);
        }
        l_statement.setInt(1, porttype);
        return l_statement.executeUpdate();
    }

    private int deleteTyppop(PersistenceContext context, int porttype) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_DELETE_TYPPOP_PTY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_DELETE_TYPPOP_PTY);
            l_buffer.put(ID_DELETE_TYPPOP_PTY, l_statement);
        }
        l_statement.setInt(1, porttype);
        return l_statement.executeUpdate();
    }

    private int deleteTyppty(PersistenceContext context, int porttype) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_DELETE_TYPPTY_PTY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_DELETE_TYPPTY_PTY);
            l_buffer.put(ID_DELETE_TYPPTY_PTY, l_statement);
        }
        l_statement.setInt(1, porttype);
        return l_statement.executeUpdate();
    }

    private int deleteTypnsp(PersistenceContext context, int porttype) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_DELETE_TYPNSP_PTY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_DELETE_TYPNSP_PTY);
            l_buffer.put(ID_DELETE_TYPNSP_PTY, l_statement);
        }
        l_statement.setInt(1, porttype);
        return l_statement.executeUpdate();
    }

    private int deleteTypsco(PersistenceContext context, int porttype) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_DELETE_TYPSCO_PTY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_DELETE_TYPSCO_PTY);
            l_buffer.put(ID_DELETE_TYPSCO_PTY, l_statement);
        }
        l_statement.setInt(1, porttype);
        return l_statement.executeUpdate();
    }

    private int deleteTypsit(PersistenceContext context, int porttype) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_DELETE_TYPSIT_PTY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement("DELETE FROM CAF_RT_TYPSIT WHERE PTY_GUID=?");
            l_buffer.put(ID_DELETE_TYPSIT_PTY, l_statement);
        }
        l_statement.setInt(1, porttype);
        return l_statement.executeUpdate();
    }

    private int deleteTypspa(PersistenceContext context, int porttype) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_DELETE_TYPSPA_PTY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_DELETE_TYPSPA_PTY);
            l_buffer.put(ID_DELETE_TYPSPA_PTY, l_statement);
        }
        l_statement.setInt(1, porttype);
        return l_statement.executeUpdate();
    }

    private int deleteTypten(PersistenceContext context, int porttype) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_DELETE_TYPTEN_PTY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_DELETE_TYPTEN_PTY);
            l_buffer.put(ID_DELETE_TYPTEN_PTY, l_statement);
        }
        l_statement.setInt(1, porttype);
        return l_statement.executeUpdate();
    }

    private int deleteTyptex(PersistenceContext context, int porttype) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_DELETE_TYPTEX_PTY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_DELETE_TYPTEX_PTY);
            l_buffer.put(ID_DELETE_TYPTEX_PTY, l_statement);
        }
        l_statement.setInt(1, porttype);
        return l_statement.executeUpdate();
    }

    private String encodeString(String string) {
        return "\"" + string + "\"";
    }

    private void initialize(ICNConnectionPool pool, INumberRange numberrange, IBagFactory bag, ITypeFactory type, ITypeValueFactory value) throws InvocationException {
        if (pool == null) {
            throw new InvocationException("ConnectionPool invalid");
        }
        if (numberrange == null) {
            throw new InvocationException("NumberRange invalid");
        }
        if (bag == null) {
            throw new InvocationException("BagFactory invalid");
        }
        if (type == null) {
            throw new InvocationException("TypeFactory invalid");
        }
        if (value == null) {
            throw new InvocationException("TypeValueFactory invalid");
        }
        this.m_pool = pool;
        this.m_numberrange = numberrange;
        this.m_factoryBag = bag;
        this.m_factoryType = type;
        this.m_factoryValue = value;
    }

    private int insertTypcel(PersistenceContext context, int porttype, int type, int number, int element) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_INSERT_TYPCEL);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_INSERT_TYPCEL);
            l_buffer.put(ID_INSERT_TYPCEL, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, type);
        l_statement.setInt(3, number);
        l_statement.setInt(4, element);
        return l_statement.executeUpdate();
    }

    private int insertTypcot(PersistenceContext context, int porttype, int type, int mode) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_INSERT_TYPCOT);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_INSERT_TYPCOT);
            l_buffer.put(ID_INSERT_TYPCOT, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, type);
        l_statement.setInt(3, mode);
        return l_statement.executeUpdate();
    }

    private int insertTypele(PersistenceContext context, int porttype, int element, String name, int min, int max, int cast, int type, int text) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_INSERT_TYPELE);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_INSERT_TYPELE);
            l_buffer.put(ID_INSERT_TYPELE, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, element);
        l_statement.setString(3, this.encodeString(name));
        l_statement.setInt(4, min);
        l_statement.setInt(5, max);
        l_statement.setInt(6, cast);
        l_statement.setInt(7, type);
        l_statement.setInt(8, text);
        return l_statement.executeUpdate();
    }

    private int insertTypmes(PersistenceContext context, int porttype, int message, String uuid, String name, int text) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_INSERT_TYPMES);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_INSERT_TYPMES);
            l_buffer.put(ID_INSERT_TYPMES, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, message);
        l_statement.setString(3, this.encodeString(uuid));
        l_statement.setString(4, this.encodeString(name));
        l_statement.setInt(5, text);
        return l_statement.executeUpdate();
    }

    private int insertTypmmp(PersistenceContext context, int porttype, int message, int number, int messagepart) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_INSERT_TYPMMP);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_INSERT_TYPMMP);
            l_buffer.put(ID_INSERT_TYPMMP, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, message);
        l_statement.setInt(3, number);
        l_statement.setInt(4, messagepart);
        return l_statement.executeUpdate();
    }

    private int insertTypmpa(PersistenceContext context, int porttype, int messagepart, String name, int cast, int structure, int text) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_INSERT_TYPMPA);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_INSERT_TYPMPA);
            l_buffer.put(ID_INSERT_TYPMPA, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, messagepart);
        l_statement.setString(3, this.encodeString(name));
        l_statement.setInt(4, cast);
        l_statement.setInt(5, structure);
        l_statement.setInt(6, text);
        return l_statement.executeUpdate();
    }

    private int insertTypofo(PersistenceContext context, int porttype, int operation, int number, int fault) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_INSERT_TYPOFO);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_INSERT_TYPOFO);
            l_buffer.put(ID_INSERT_TYPOFO, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, operation);
        l_statement.setInt(3, number);
        l_statement.setInt(4, fault);
        return l_statement.executeUpdate();
    }

    private int insertTypopa(PersistenceContext context, int porttype, int operationpart, String name, int message, int text) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_INSERT_TYPOPA);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_INSERT_TYPOPA);
            l_buffer.put(ID_INSERT_TYPOPA, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, operationpart);
        l_statement.setString(3, this.encodeString(name));
        l_statement.setInt(4, message);
        l_statement.setInt(5, text);
        return l_statement.executeUpdate();
    }

    private int insertTypope(PersistenceContext context, int porttype, int operation, String name, int input, int output, int text) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_INSERT_TYPOPE);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_INSERT_TYPOPE);
            l_buffer.put(ID_INSERT_TYPOPE, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, operation);
        l_statement.setString(3, this.encodeString(name));
        l_statement.setInt(4, input);
        l_statement.setInt(5, output);
        l_statement.setInt(6, text);
        return l_statement.executeUpdate();
    }

    private int insertTyppop(PersistenceContext context, int porttype, int number, int operation) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_INSERT_TYPPOP);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_INSERT_TYPPOP);
            l_buffer.put(ID_INSERT_TYPPOP, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, number);
        l_statement.setInt(3, operation);
        return l_statement.executeUpdate();
    }

    private int insertTyppty(PersistenceContext context, int porttype, String uuid, String name, int text) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_INSERT_TYPPTY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_INSERT_TYPPTY);
            l_buffer.put(ID_INSERT_TYPPTY, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setString(2, this.encodeString(uuid));
        l_statement.setString(3, this.encodeString(name));
        l_statement.setInt(4, text);
        return l_statement.executeUpdate();
    }

    private int insertTypnsp(PersistenceContext context, int porttype, String prefix, String uri) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_INSERT_TYPNSP);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_INSERT_TYPNSP);
            l_buffer.put(ID_INSERT_TYPNSP, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setString(2, this.encodeString(prefix));
        l_statement.setString(3, this.encodeString(uri));
        return l_statement.executeUpdate();
    }

    private int insertTypsco(PersistenceContext context, int porttype, int type, int number, String data) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_INSERT_TYPSCO);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_INSERT_TYPSCO);
            l_buffer.put(ID_INSERT_TYPSCO, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, type);
        l_statement.setInt(3, number);
        l_statement.setString(4, this.encodeString(data));
        return l_statement.executeUpdate();
    }

    private int insertTypsit(PersistenceContext context, int porttype, int type, int base, int min, int max, int fraction, int total) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_INSERT_TYPSIT);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_INSERT_TYPSIT);
            l_buffer.put(ID_INSERT_TYPSIT, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, type);
        l_statement.setInt(3, base);
        l_statement.setInt(4, min);
        l_statement.setInt(5, max);
        l_statement.setInt(6, fraction);
        l_statement.setInt(7, total);
        return l_statement.executeUpdate();
    }

    private int insertTypspa(PersistenceContext context, int porttype, int type, int number, String data) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_INSERT_TYPSPA);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_INSERT_TYPSPA);
            l_buffer.put(ID_INSERT_TYPSPA, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, type);
        l_statement.setInt(3, number);
        l_statement.setString(4, this.encodeString(data));
        return l_statement.executeUpdate();
    }

    private int insertTypten(PersistenceContext context, int porttype, int text, String language, String data) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_INSERT_TYPTEN);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_INSERT_TYPTEN);
            l_buffer.put(ID_INSERT_TYPTEN, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, text);
        l_statement.setString(3, this.encodeString(language));
        l_statement.setString(4, this.encodeString(data));
        return l_statement.executeUpdate();
    }

    private int insertTyptex(PersistenceContext context, int porttype, int text, String language) throws SQLException {
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_INSERT_TYPTEX);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_INSERT_TYPTEX);
            l_buffer.put(ID_INSERT_TYPTEX, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, text);
        l_statement.setString(3, this.encodeString(language));
        return l_statement.executeUpdate();
    }

    private PersistenceContext openContext() throws EngineException {
        PersistenceContext l_context = new PersistenceContext(this.m_pool, this.m_numberrange);
        try {
            l_context.getConnection().setAutoCommit(false);
        }
        catch (SQLException l_exception) {
            throw new EngineException("Failed to open database connection", (Exception)l_exception);
        }
        return l_context;
    }

    private IComplexType readComplexType(PersistenceContext context, int guid, int luid, int depth) throws EngineException {
        Integer l_key;
        Hashtable l_buffer = context.getComponentBuffer();
        IComplexType l_type = (IComplexType)l_buffer.get(l_key = new Integer(luid));
        if (l_type == null) {
            try {
                Enumeration l_typcot_enumeration = this.selectTypcot(context, guid, luid).elements();
                while (l_typcot_enumeration.hasMoreElements()) {
                    StructTypcot l_typcot_struct = (StructTypcot)l_typcot_enumeration.nextElement();
                    l_type = this.m_factoryType.createComplexType();
                    l_type.setMode(l_typcot_struct.cot_mode);
                    if (depth == 0) continue;
                    TreeMap<Integer, IElement> l_element_map = new TreeMap<Integer, IElement>();
                    Enumeration l_typcel_enumeration = this.selectTypcel(context, guid, luid).elements();
                    while (l_typcel_enumeration.hasMoreElements()) {
                        StructTypcel l_typcel_struct = (StructTypcel)l_typcel_enumeration.nextElement();
                        l_element_map.put(new Integer(l_typcel_struct.ele_numb), this.readElement(context, guid, l_typcel_struct.ele_luid, depth > 0 ? depth - 1 : depth));
                    }
                    Iterator l_element_iterator = l_element_map.values().iterator();
                    while (l_element_iterator.hasNext()) {
                        l_type.addElement((IElement)l_element_iterator.next());
                    }
                }
            }
            catch (SQLException l_exception) {
                throw new EngineException("Failed to select ComplexType from database", (Exception)l_exception);
            }
            catch (InvocationException l_exception) {
                throw new EngineException("Failed to populate ComplexType", (Exception)((Object)l_exception));
            }
            l_buffer.put(l_key, l_type);
        }
        return l_type;
    }

    private IElement readElement(PersistenceContext context, int guid, int luid, int depth) throws EngineException {
        Integer l_key;
        Hashtable l_buffer = context.getComponentBuffer();
        IElement l_element = (IElement)l_buffer.get(l_key = new Integer(luid));
        if (l_element == null) {
            try {
                Enumeration l_typele_enumeration = this.selectTypele(context, guid, luid).elements();
                block7: while (l_typele_enumeration.hasMoreElements()) {
                    StructTypele l_typele_struct = (StructTypele)l_typele_enumeration.nextElement();
                    l_element = this.m_factoryType.createElement(l_typele_struct.ele_name);
                    int l_textbag_luid = l_typele_struct.tex_luid;
                    if (l_textbag_luid != 0) {
                        l_element.setTextbag(this.readTextbag(context, guid, l_textbag_luid));
                    }
                    l_element.setMinOccurs(l_typele_struct.ele_omin);
                    l_element.setMaxOccurs(l_typele_struct.ele_omax);
                    if (depth == 0) continue;
                    int l_depth = depth > 0 ? depth - 1 : depth;
                    int l_type_luid = l_typele_struct.typ_luid;
                    switch (l_typele_struct.typ_cast) {
                        case 2: {
                            l_element.setType(this.readSimpleType(context, guid, l_type_luid, l_depth));
                            continue block7;
                        }
                        case 1: {
                            l_element.setType(this.readComplexType(context, guid, l_type_luid, l_depth));
                            continue block7;
                        }
                    }
                    throw new EngineException("Element has unknown Type");
                }
            }
            catch (SQLException l_exception) {
                l_exception.printStackTrace();
                throw new EngineException("Failed to select Element from database", (Exception)l_exception);
            }
            catch (InvocationException l_exception) {
                throw new EngineException("Failed to populate Element", (Exception)((Object)l_exception));
            }
            l_buffer.put(l_key, l_element);
        }
        return l_element;
    }

    public IMessage readMessage(String uuid) throws EngineException, InvocationException {
        return this.readMessage(uuid, -1);
    }

    public IMessage readMessage(String uuid, int depth) throws EngineException, InvocationException {
        IMessage l_message = null;
        if (uuid != null && uuid.length() == 32) {
            PersistenceContext l_context = this.openContext();
            try {
                Vector l_typmes_vector = this.selectTypmes(l_context, uuid);
                if (l_typmes_vector.size() > 1) {
                    throw new EngineException("Same UUID for multiple Messages");
                }
                Enumeration l_typmes_enumeration = l_typmes_vector.elements();
                while (l_typmes_enumeration.hasMoreElements()) {
                    StructTypmes l_typmes_struct = (StructTypmes)l_typmes_enumeration.nextElement();
                    int l_porttype_guid = l_typmes_struct.pty_guid;
                    int l_message_luid = l_typmes_struct.mes_luid;
                    l_message = this.m_factoryType.createMessage(uuid, l_typmes_struct.mes_name);
                    int l_textbag_luid = l_typmes_struct.tex_luid;
                    if (l_textbag_luid != 0) {
                        l_message.setTextbag(this.readTextbag(l_context, l_porttype_guid, l_textbag_luid));
                    }
                    if (depth == 0) continue;
                    TreeMap<Integer, IMessagepart> l_messagepart_map = new TreeMap<Integer, IMessagepart>();
                    Enumeration l_typmmp_enumeration = this.selectTypmmp(l_context, l_porttype_guid, l_message_luid).elements();
                    while (l_typmmp_enumeration.hasMoreElements()) {
                        StructTypmmp l_typmmp_struct = (StructTypmmp)l_typmmp_enumeration.nextElement();
                        l_messagepart_map.put(new Integer(l_typmmp_struct.mpa_numb), this.readMessagepart(l_context, l_porttype_guid, l_typmmp_struct.mpa_luid, depth > 0 ? depth - 1 : depth));
                    }
                    Iterator l_messagepart_iterator = l_messagepart_map.values().iterator();
                    while (l_messagepart_iterator.hasNext()) {
                        l_message.addMessagepart((IMessagepart)l_messagepart_iterator.next());
                    }
                }
            }
            catch (SQLException l_exception) {
                throw new EngineException("Failed to select Message from database", (Exception)l_exception);
            }
            catch (InvocationException l_exception) {
                throw new EngineException("Failed to populate Message", (Exception)((Object)l_exception));
            }
            finally {
                this.closeContext(l_context);
            }
        }
        return l_message;
    }

    private IMessage readMessage(PersistenceContext context, int guid, int luid, int depth) throws EngineException {
        Integer l_key;
        Hashtable l_buffer = context.getComponentBuffer();
        IMessage l_message = (IMessage)l_buffer.get(l_key = new Integer(luid));
        if (l_message == null) {
            try {
                Enumeration l_typmes_enumeration = this.selectTypmes(context, guid, luid).elements();
                while (l_typmes_enumeration.hasMoreElements()) {
                    StructTypmes l_typmes_struct = (StructTypmes)l_typmes_enumeration.nextElement();
                    l_message = this.m_factoryType.createMessage(l_typmes_struct.mes_uuid, l_typmes_struct.mes_name);
                    int l_textbag_luid = l_typmes_struct.tex_luid;
                    if (l_textbag_luid != 0) {
                        l_message.setTextbag(this.readTextbag(context, guid, l_textbag_luid));
                    }
                    if (depth == 0) continue;
                    TreeMap<Integer, IMessagepart> l_messagepart_map = new TreeMap<Integer, IMessagepart>();
                    Enumeration l_typmmp_enumeration = this.selectTypmmp(context, guid, luid).elements();
                    while (l_typmmp_enumeration.hasMoreElements()) {
                        StructTypmmp l_typmmp_struct = (StructTypmmp)l_typmmp_enumeration.nextElement();
                        l_messagepart_map.put(new Integer(l_typmmp_struct.mpa_numb), this.readMessagepart(context, guid, l_typmmp_struct.mpa_luid, depth > 0 ? depth - 1 : depth));
                    }
                    Iterator l_messagepart_iterator = l_messagepart_map.values().iterator();
                    while (l_messagepart_iterator.hasNext()) {
                        l_message.addMessagepart((IMessagepart)l_messagepart_iterator.next());
                    }
                }
            }
            catch (SQLException l_exception) {
                throw new EngineException("Failed to select Message from database", (Exception)l_exception);
            }
            catch (InvocationException l_exception) {
                throw new EngineException("Failed to populate Message", (Exception)((Object)l_exception));
            }
            l_buffer.put(l_key, l_message);
        }
        return l_message;
    }

    public ITypeLayout readMessageLayout(String uuid, int depth) throws EngineException, InvocationException {
        return this.m_factoryType.extractTypeLayout(this.readMessage(uuid, depth));
    }

    private IMessagepart readMessagepart(PersistenceContext context, int guid, int luid, int depth) throws EngineException {
        Integer l_key;
        Hashtable l_buffer = context.getComponentBuffer();
        IMessagepart l_messagepart = (IMessagepart)l_buffer.get(l_key = new Integer(luid));
        if (l_messagepart == null) {
            try {
                Enumeration l_typmpa_enumeration = this.selectTypmpa(context, guid, luid).elements();
                block8: while (l_typmpa_enumeration.hasMoreElements()) {
                    StructTypmpa l_typmpa_struct = (StructTypmpa)l_typmpa_enumeration.nextElement();
                    l_messagepart = this.m_factoryType.createMessagepart(l_typmpa_struct.mpa_name);
                    int l_textbag_luid = l_typmpa_struct.tex_luid;
                    if (l_textbag_luid != 0) {
                        l_messagepart.setTextbag(this.readTextbag(context, guid, l_textbag_luid));
                    }
                    if (depth == 0) continue;
                    int l_depth = depth > 0 ? depth - 1 : depth;
                    int l_structure_luid = l_typmpa_struct.str_luid;
                    switch (l_typmpa_struct.str_cast) {
                        case 1: {
                            l_messagepart.setStructure(this.readElement(context, guid, l_structure_luid, l_depth));
                            continue block8;
                        }
                        case 2: {
                            l_messagepart.setStructure(this.readComplexType(context, guid, l_structure_luid, l_depth));
                            continue block8;
                        }
                        case 3: {
                            l_messagepart.setStructure(this.readSimpleType(context, guid, l_structure_luid, l_depth));
                            continue block8;
                        }
                    }
                    throw new EngineException("Messagepart has unknown Structure");
                }
            }
            catch (SQLException l_exception) {
                throw new EngineException("Failed to select Messagepart from database", (Exception)l_exception);
            }
            catch (InvocationException l_exception) {
                throw new EngineException("Failed to populate Messagepart", (Exception)((Object)l_exception));
            }
            l_buffer.put(l_key, l_messagepart);
        }
        return l_messagepart;
    }

    private IOperation readOperation(PersistenceContext context, int guid, int luid, int depth) throws EngineException {
        Integer l_key;
        Hashtable l_buffer = context.getComponentBuffer();
        Operation l_operation = (Operation)l_buffer.get(l_key = new Integer(luid));
        if (l_operation == null) {
            try {
                Enumeration l_typope_enumeration = this.selectTypope(context, guid, luid).elements();
                while (l_typope_enumeration.hasMoreElements()) {
                    int l_output_luid;
                    StructTypope l_typope_struct = (StructTypope)l_typope_enumeration.nextElement();
                    l_operation = new Operation(l_typope_struct.ope_name);
                    int l_textbag_luid = l_typope_struct.tex_luid;
                    if (l_textbag_luid != 0) {
                        l_operation.setTextbag(this.readTextbag(context, guid, l_textbag_luid));
                    }
                    if (depth == 0) continue;
                    int l_depth = depth > 0 ? depth - 1 : depth;
                    int l_input_luid = l_typope_struct.iop_luid;
                    if (l_input_luid != 0) {
                        l_operation.setInputOperationpart(this.readOperationpart(context, guid, l_input_luid, l_depth));
                    }
                    if ((l_output_luid = l_typope_struct.oop_luid) != 0) {
                        l_operation.setOutputOperationpart(this.readOperationpart(context, guid, l_output_luid, l_depth));
                    }
                    TreeMap<Integer, IOperationpart> l_fault_map = new TreeMap<Integer, IOperationpart>();
                    Enumeration l_typofo_enumeration = this.selectTypofo(context, guid, luid).elements();
                    while (l_typofo_enumeration.hasMoreElements()) {
                        StructTypofo l_typofo_struct = (StructTypofo)l_typofo_enumeration.nextElement();
                        l_fault_map.put(new Integer(l_typofo_struct.fop_numb), this.readOperationpart(context, guid, l_typofo_struct.fop_luid, l_depth));
                    }
                    Iterator l_fault_iterator = l_fault_map.values().iterator();
                    while (l_fault_iterator.hasNext()) {
                        l_operation.addFaultOperationpart((IOperationpart)l_fault_iterator.next());
                    }
                }
            }
            catch (SQLException l_exception) {
                throw new EngineException("Failed to select Operation from database", (Exception)l_exception);
            }
            catch (InvocationException l_exception) {
                throw new EngineException("Failed to populate Operation", (Exception)((Object)l_exception));
            }
            l_buffer.put(l_key, l_operation);
        }
        return l_operation;
    }

    private IOperationpart readOperationpart(PersistenceContext context, int guid, int luid, int depth) throws EngineException {
        Integer l_key;
        Hashtable l_buffer = context.getComponentBuffer();
        Operationpart l_operationpart = (Operationpart)l_buffer.get(l_key = new Integer(luid));
        if (l_operationpart == null) {
            try {
                Enumeration l_typopa_enumeration = this.selectTypopa(context, guid, luid).elements();
                while (l_typopa_enumeration.hasMoreElements()) {
                    StructTypopa l_typopa_struct = (StructTypopa)l_typopa_enumeration.nextElement();
                    l_operationpart = new Operationpart(l_typopa_struct.opa_name);
                    int l_textbag_luid = l_typopa_struct.tex_luid;
                    if (l_textbag_luid != 0) {
                        l_operationpart.setTextbag(this.readTextbag(context, guid, l_textbag_luid));
                    }
                    if (depth == 0) continue;
                    l_operationpart.setMessage(this.readMessage(context, guid, l_typopa_struct.mes_luid, depth > 0 ? depth - 1 : depth));
                }
            }
            catch (SQLException l_exception) {
                throw new EngineException("Failed to select Operationpart from database", (Exception)l_exception);
            }
            catch (InvocationException l_exception) {
                throw new EngineException("Failed to populate Operationpart", (Exception)((Object)l_exception));
            }
            l_buffer.put(l_key, l_operationpart);
        }
        return l_operationpart;
    }

    public IPorttype readPorttype(String uuid) throws EngineException, InvocationException {
        return this.readPorttype(uuid, -1);
    }

    private IPorttype readPorttype(String uuid, int depth) throws EngineException, InvocationException {
        Porttype l_porttype = null;
        if (uuid != null && uuid.length() == 32) {
            PersistenceContext l_context = this.openContext();
            try {
                Vector l_typpty_vector = this.selectTyppty(l_context, uuid);
                if (l_typpty_vector.size() > 1) {
                    throw new EngineException("Same UUID for multiple Porttypes");
                }
                Enumeration l_typpty_enumeration = l_typpty_vector.elements();
                while (l_typpty_enumeration.hasMoreElements()) {
                    StructTyppty l_typpty_struct = (StructTyppty)l_typpty_enumeration.nextElement();
                    int l_porttype_guid = l_typpty_struct.pty_guid;
                    l_porttype = new Porttype(uuid, l_typpty_struct.pty_name);
                    int l_textbag_luid = l_typpty_struct.tex_luid;
                    if (l_textbag_luid != 0) {
                        l_porttype.setTextbag(this.readTextbag(l_context, l_porttype_guid, l_textbag_luid));
                    }
                    Vector l_typnsp_vector = this.selectTypnsp(l_context, l_porttype_guid);
                    Enumeration l_typnsp_enumeration = l_typnsp_vector.elements();
                    while (l_typnsp_enumeration.hasMoreElements()) {
                        StructTypnsp l_typnsp_struct = (StructTypnsp)l_typnsp_enumeration.nextElement();
                        l_porttype.addNamespace(l_typnsp_struct.nsp_prefix, l_typnsp_struct.nsp_uri);
                    }
                    if (depth == 0) continue;
                    TreeMap<Integer, IOperation> l_operation_map = new TreeMap<Integer, IOperation>();
                    Enumeration l_typpop_enumeration = this.selectTyppop(l_context, l_porttype_guid).elements();
                    while (l_typpop_enumeration.hasMoreElements()) {
                        StructTyppop l_typpop_struct = (StructTyppop)l_typpop_enumeration.nextElement();
                        l_operation_map.put(new Integer(l_typpop_struct.ope_numb), this.readOperation(l_context, l_porttype_guid, l_typpop_struct.ope_luid, depth > 0 ? depth - 1 : depth));
                    }
                    Iterator l_operation_iterator = l_operation_map.values().iterator();
                    while (l_operation_iterator.hasNext()) {
                        l_porttype.addOperation((IOperation)l_operation_iterator.next());
                    }
                }
            }
            catch (SQLException l_exception) {
                throw new EngineException("Failed to select Porttype from database", (Exception)l_exception);
            }
            catch (InvocationException l_exception) {
                throw new EngineException("Failed to populate Porttype", (Exception)((Object)l_exception));
            }
            finally {
                this.closeContext(l_context);
            }
        }
        return l_porttype;
    }

    public ITypeLayout readPorttypeLayout(String uuid, int depth) throws EngineException, InvocationException {
        return this.m_factoryType.extractTypeLayout(this.readPorttype(uuid, depth));
    }

    private ISimpleType readSimpleType(PersistenceContext context, int guid, int luid, int depth) throws EngineException {
        Integer l_key;
        Hashtable l_buffer = context.getComponentBuffer();
        ISimpleType l_type = (ISimpleType)l_buffer.get(l_key = new Integer(luid));
        if (l_type == null) {
            try {
                Enumeration l_typsit_enumeration = this.selectTypsit(context, guid, luid).elements();
                while (l_typsit_enumeration.hasMoreElements()) {
                    StructTypsit l_typsit_struct = (StructTypsit)l_typsit_enumeration.nextElement();
                    l_type = this.m_factoryType.createSimpleType(l_typsit_struct.sit_base);
                    l_type.setMinLength(l_typsit_struct.sit_smin);
                    l_type.setMaxLength(l_typsit_struct.sit_smax);
                    l_type.setFractionDigits(l_typsit_struct.sit_dfra);
                    l_type.setTotalDigits(l_typsit_struct.sit_dtot);
                    TreeMap<Integer, String> l_pattern_map = new TreeMap<Integer, String>();
                    Enumeration l_typspa_enumeration = this.selectTypspa(context, guid, luid).elements();
                    while (l_typspa_enumeration.hasMoreElements()) {
                        StructTypspa l_typspa_struct = (StructTypspa)l_typspa_enumeration.nextElement();
                        l_pattern_map.put(new Integer(l_typspa_struct.pat_numb), l_typspa_struct.pat_data);
                    }
                    Iterator l_pattern_iterator = l_pattern_map.values().iterator();
                    while (l_pattern_iterator.hasNext()) {
                        l_type.addPattern((String)l_pattern_iterator.next());
                    }
                    TreeMap<Integer, ISimpleTypeValue> l_constant_map = new TreeMap<Integer, ISimpleTypeValue>();
                    Enumeration l_typsco_enumeration = this.selectTypsco(context, guid, luid).elements();
                    while (l_typsco_enumeration.hasMoreElements()) {
                        StructTypsco l_typsco_struct = (StructTypsco)l_typsco_enumeration.nextElement();
                        ISimpleTypeValue l_simple_type_value = this.m_factoryValue.createSimpleTypeValue(l_type);
                        l_simple_type_value.setValue(l_typsco_struct.con_data);
                        l_constant_map.put(new Integer(l_typsco_struct.con_numb), l_simple_type_value);
                    }
                    Iterator l_constant_iterator = l_constant_map.values().iterator();
                    while (l_constant_iterator.hasNext()) {
                        l_type.addConstant((ISimpleTypeValue)l_constant_iterator.next());
                    }
                }
            }
            catch (SQLException l_exception) {
                throw new EngineException("Failed to select SimpleType from database", (Exception)l_exception);
            }
            catch (InvocationException l_exception) {
                throw new EngineException("Failed to populate SimpleType", (Exception)((Object)l_exception));
            }
            l_buffer.put(l_key, l_type);
        }
        return l_type;
    }

    private ITextbag readTextbag(PersistenceContext context, int guid, int luid) throws EngineException {
        Integer l_key;
        Hashtable l_buffer = context.getComponentBuffer();
        ITextbag l_textbag = (ITextbag)l_buffer.get(l_key = new Integer(luid));
        if (l_textbag == null) {
            try {
                Enumeration l_typtex_enumeration = this.selectTyptex(context, guid, luid).elements();
                while (l_typtex_enumeration.hasMoreElements()) {
                    StructTyptex l_typtex_struct = (StructTyptex)l_typtex_enumeration.nextElement();
                    l_textbag = this.m_factoryBag.createTextbag();
                    l_textbag.setPrimaryLanguage(l_typtex_struct.ten_lang);
                    Enumeration l_typten_enumeration = this.selectTypten(context, guid, luid).elements();
                    while (l_typten_enumeration.hasMoreElements()) {
                        StructTypten l_typten_struct = (StructTypten)l_typten_enumeration.nextElement();
                        ITextbagEntry l_entry = this.m_factoryBag.createTextbagEntry(l_typten_struct.ten_lang);
                        l_entry.setValue(l_typten_struct.ten_data);
                        l_textbag.addTextbagEntry(l_entry);
                    }
                }
            }
            catch (SQLException l_exception) {
                throw new EngineException("Failed to select Text from database", (Exception)l_exception);
            }
            catch (InvocationException l_exception) {
                throw new EngineException("Failed to populate Text", (Exception)((Object)l_exception));
            }
            l_buffer.put(l_key, l_textbag);
        }
        return l_textbag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTypcel(PersistenceContext context, int porttype, int type) throws SQLException {
        Vector<StructTypcel> l_vector = new Vector<StructTypcel>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPCEL_LIST);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPCEL_LIST);
            l_buffer.put(ID_SELECT_TYPCEL_LIST, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, type);
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTypcel l_struct = new StructTypcel();
                l_struct.pty_guid = porttype;
                l_struct.cot_luid = type;
                l_struct.ele_numb = l_result.getInt(FIELD_TYPCEL_ELE_NUMB);
                l_struct.ele_luid = l_result.getInt("ELE_LUID");
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTypcot(PersistenceContext context, int porttype, int type) throws SQLException {
        Vector<StructTypcot> l_vector = new Vector<StructTypcot>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPCOT_KEY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPCOT_KEY);
            l_buffer.put(ID_SELECT_TYPCOT_KEY, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, type);
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTypcot l_struct = new StructTypcot();
                l_struct.pty_guid = porttype;
                l_struct.cot_luid = type;
                l_struct.cot_mode = l_result.getInt(FIELD_TYPCOT_COT_MODE);
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTypele(PersistenceContext context, int porttype, int element) throws SQLException {
        Vector<StructTypele> l_vector = new Vector<StructTypele>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPELE_KEY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPELE_KEY);
            l_buffer.put(ID_SELECT_TYPELE_KEY, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, element);
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTypele l_struct = new StructTypele();
                l_struct.pty_guid = porttype;
                l_struct.ele_luid = element;
                l_struct.ele_name = this.decodeString(l_result.getString(FIELD_TYPELE_ELE_NAME));
                l_struct.ele_omin = l_result.getInt(FIELD_TYPELE_ELE_OMIN);
                l_struct.ele_omax = l_result.getInt(FIELD_TYPELE_ELE_OMAX);
                l_struct.typ_cast = l_result.getInt(FIELD_TYPELE_TYP_CAST);
                l_struct.typ_luid = l_result.getInt(FIELD_TYPELE_TYP_LUID);
                l_struct.tex_luid = l_result.getInt("TEX_LUID");
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTypmes(PersistenceContext context, String uuid) throws SQLException {
        Vector<StructTypmes> l_vector = new Vector<StructTypmes>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPMES_GUID);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPMES_GUID);
            l_buffer.put(ID_SELECT_TYPMES_GUID, l_statement);
        }
        l_statement.setString(1, this.encodeString(uuid));
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTypmes l_struct = new StructTypmes();
                l_struct.pty_guid = l_result.getInt("PTY_GUID");
                l_struct.mes_luid = l_result.getInt("MES_LUID");
                l_struct.mes_uuid = uuid;
                l_struct.mes_name = this.decodeString(l_result.getString(FIELD_TYPMES_MES_NAME));
                l_struct.tex_luid = l_result.getInt("TEX_LUID");
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTypmes(PersistenceContext context, int porttype, int message) throws SQLException {
        Vector<StructTypmes> l_vector = new Vector<StructTypmes>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPMES_KEY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPMES_KEY);
            l_buffer.put(ID_SELECT_TYPMES_KEY, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, message);
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTypmes l_struct = new StructTypmes();
                l_struct.pty_guid = porttype;
                l_struct.mes_luid = message;
                l_struct.mes_uuid = this.decodeString(l_result.getString(FIELD_TYPMES_MES_UUID));
                l_struct.mes_name = this.decodeString(l_result.getString(FIELD_TYPMES_MES_NAME));
                l_struct.tex_luid = l_result.getInt("TEX_LUID");
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTypmmp(PersistenceContext context, int porttype, int message) throws SQLException {
        Vector<StructTypmmp> l_vector = new Vector<StructTypmmp>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPMMP_LIST);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPMMP_LIST);
            l_buffer.put(ID_SELECT_TYPMMP_LIST, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, message);
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTypmmp l_struct = new StructTypmmp();
                l_struct.pty_guid = porttype;
                l_struct.mes_luid = message;
                l_struct.mpa_numb = l_result.getInt(FIELD_TYPMMP_MPA_NUMB);
                l_struct.mpa_luid = l_result.getInt("MPA_LUID");
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTypmpa(PersistenceContext context, int porttype, int messagepart) throws SQLException {
        Vector<StructTypmpa> l_vector = new Vector<StructTypmpa>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPMPA_KEY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPMPA_KEY);
            l_buffer.put(ID_SELECT_TYPMPA_KEY, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, messagepart);
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTypmpa l_struct = new StructTypmpa();
                l_struct.pty_guid = porttype;
                l_struct.mpa_luid = messagepart;
                l_struct.mpa_name = this.decodeString(l_result.getString(FIELD_TYPMPA_MPA_NAME));
                l_struct.str_cast = l_result.getInt(FIELD_TYPMPA_STR_CAST);
                l_struct.str_luid = l_result.getInt(FIELD_TYPMPA_STR_LUID);
                l_struct.tex_luid = l_result.getInt("TEX_LUID");
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTypofo(PersistenceContext context, int porttype, int operation) throws SQLException {
        Vector<StructTypofo> l_vector = new Vector<StructTypofo>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPOFO_LIST);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPOFO_LIST);
            l_buffer.put(ID_SELECT_TYPOFO_LIST, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, operation);
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTypofo l_struct = new StructTypofo();
                l_struct.pty_guid = porttype;
                l_struct.ope_luid = operation;
                l_struct.fop_numb = l_result.getInt(FIELD_TYPOFO_FOP_NUMB);
                l_struct.fop_luid = l_result.getInt(FIELD_TYPOFO_FOP_LUID);
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTypopa(PersistenceContext context, int porttype, int operationpart) throws SQLException {
        Vector<StructTypopa> l_vector = new Vector<StructTypopa>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPOPA_KEY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPOPA_KEY);
            l_buffer.put(ID_SELECT_TYPOPA_KEY, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, operationpart);
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTypopa l_struct = new StructTypopa();
                l_struct.pty_guid = porttype;
                l_struct.opa_luid = operationpart;
                l_struct.opa_name = this.decodeString(l_result.getString(FIELD_TYPOPA_OPA_NAME));
                l_struct.mes_luid = l_result.getInt("MES_LUID");
                l_struct.tex_luid = l_result.getInt("TEX_LUID");
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTypope(PersistenceContext context, int porttype, int operation) throws SQLException {
        Vector<StructTypope> l_vector = new Vector<StructTypope>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPOPE_KEY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPOPE_KEY);
            l_buffer.put(ID_SELECT_TYPOPE_KEY, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, operation);
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTypope l_struct = new StructTypope();
                l_struct.pty_guid = porttype;
                l_struct.ope_luid = operation;
                l_struct.ope_name = this.decodeString(l_result.getString(FIELD_TYPOPE_OPE_NAME));
                l_struct.iop_luid = l_result.getInt(FIELD_TYPOPE_IOP_LUID);
                l_struct.oop_luid = l_result.getInt(FIELD_TYPOPE_OOP_LUID);
                l_struct.tex_luid = l_result.getInt("TEX_LUID");
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTyppop(PersistenceContext context, int porttype) throws SQLException {
        Vector<StructTyppop> l_vector = new Vector<StructTyppop>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPPOP_LIST);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPPOP_LIST);
            l_buffer.put(ID_SELECT_TYPPOP_LIST, l_statement);
        }
        l_statement.setInt(1, porttype);
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTyppop l_struct = new StructTyppop();
                l_struct.pty_guid = porttype;
                l_struct.ope_numb = l_result.getInt(FIELD_TYPPOP_OPE_NUMB);
                l_struct.ope_luid = l_result.getInt("OPE_LUID");
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTyppty(PersistenceContext context, String uuid) throws SQLException {
        Vector<StructTyppty> l_vector = new Vector<StructTyppty>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPPTY_GUID);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPPTY_GUID);
            l_buffer.put(ID_SELECT_TYPPTY_GUID, l_statement);
        }
        l_statement.setString(1, this.encodeString(uuid));
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTyppty l_struct = new StructTyppty();
                l_struct.pty_guid = l_result.getInt("PTY_GUID");
                l_struct.pty_uuid = uuid;
                l_struct.pty_name = this.decodeString(l_result.getString(FIELD_TYPPTY_PTY_NAME));
                l_struct.tex_luid = l_result.getInt("TEX_LUID");
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTyppty(PersistenceContext context, int porttype) throws SQLException {
        Vector<StructTyppty> l_vector = new Vector<StructTyppty>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPPTY_KEY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPPTY_KEY);
            l_buffer.put(ID_SELECT_TYPPTY_KEY, l_statement);
        }
        l_statement.setInt(1, porttype);
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTyppty l_struct = new StructTyppty();
                l_struct.pty_guid = porttype;
                l_struct.pty_uuid = this.decodeString(l_result.getString(FIELD_TYPPTY_PTY_UUID));
                l_struct.pty_name = this.decodeString(l_result.getString(FIELD_TYPPTY_PTY_NAME));
                l_struct.tex_luid = l_result.getInt("TEX_LUID");
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTypnsp(PersistenceContext context, int porttype) throws SQLException {
        Vector<StructTypnsp> l_vector = new Vector<StructTypnsp>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPNSP_KEY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPNSP_KEY);
            l_buffer.put(ID_SELECT_TYPNSP_KEY, l_statement);
        }
        l_statement.setInt(1, porttype);
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTypnsp l_struct = new StructTypnsp();
                l_struct.pty_guid = porttype;
                l_struct.nsp_prefix = this.decodeString(l_result.getString(FIELD_TYPNSP_NSP_PREFIX));
                l_struct.nsp_uri = this.decodeString(l_result.getString(FIELD_TYPNSP_NSP_URI));
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTypsco(PersistenceContext context, int porttype, int type) throws SQLException {
        Vector<StructTypsco> l_vector = new Vector<StructTypsco>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPSCO_LIST);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPSCO_LIST);
            l_buffer.put(ID_SELECT_TYPSCO_LIST, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, type);
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTypsco l_struct = new StructTypsco();
                l_struct.pty_guid = porttype;
                l_struct.sit_luid = type;
                l_struct.con_numb = l_result.getInt(FIELD_TYPSCO_CON_NUMB);
                l_struct.con_data = this.decodeString(l_result.getString(FIELD_TYPSCO_CON_DATA));
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTypsit(PersistenceContext context, int porttype, int type) throws SQLException {
        Vector<StructTypsit> l_vector = new Vector<StructTypsit>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPSIT_KEY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPSIT_KEY);
            l_buffer.put(ID_SELECT_TYPSIT_KEY, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, type);
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTypsit l_struct = new StructTypsit();
                l_struct.pty_guid = porttype;
                l_struct.sit_luid = type;
                l_struct.sit_base = l_result.getInt(FIELD_TYPSIT_SIT_BASE);
                l_struct.sit_smin = l_result.getInt(FIELD_TYPSIT_SIT_SMIN);
                l_struct.sit_smax = l_result.getInt(FIELD_TYPSIT_SIT_SMAX);
                l_struct.sit_dfra = l_result.getInt(FIELD_TYPSIT_SIT_DFRA);
                l_struct.sit_dtot = l_result.getInt(FIELD_TYPSIT_SIT_DTOT);
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTypspa(PersistenceContext context, int porttype, int type) throws SQLException {
        Vector<StructTypspa> l_vector = new Vector<StructTypspa>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPSPA_LIST);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPSPA_LIST);
            l_buffer.put(ID_SELECT_TYPSPA_LIST, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, type);
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTypspa l_struct = new StructTypspa();
                l_struct.pty_guid = porttype;
                l_struct.sit_luid = type;
                l_struct.pat_numb = l_result.getInt(FIELD_TYPSPA_PAT_NUMB);
                l_struct.pat_data = this.decodeString(l_result.getString(FIELD_TYPSPA_PAT_DATA));
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTypten(PersistenceContext context, int porttype, int text) throws SQLException {
        Vector<StructTypten> l_vector = new Vector<StructTypten>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPTEN_LIST);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPTEN_LIST);
            l_buffer.put(ID_SELECT_TYPTEN_LIST, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, text);
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTypten l_struct = new StructTypten();
                l_struct.pty_guid = porttype;
                l_struct.tex_luid = text;
                l_struct.ten_lang = this.decodeString(l_result.getString("TEN_LANG"));
                l_struct.ten_data = this.decodeString(l_result.getString(FIELD_TYPTEN_TEN_DATA));
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector selectTyptex(PersistenceContext context, int porttype, int text) throws SQLException {
        Vector<StructTyptex> l_vector = new Vector<StructTyptex>();
        Hashtable l_buffer = context.getStatementBuffer();
        PreparedStatement l_statement = (PreparedStatement)l_buffer.get(ID_SELECT_TYPTEX_KEY);
        if (l_statement == null) {
            l_statement = context.getConnection().prepareStatement(STATEMENT_SELECT_TYPTEX_KEY);
            l_buffer.put(ID_SELECT_TYPTEX_KEY, l_statement);
        }
        l_statement.setInt(1, porttype);
        l_statement.setInt(2, text);
        ResultSet l_result = l_statement.executeQuery();
        try {
            while (l_result.next()) {
                StructTyptex l_struct = new StructTyptex();
                l_struct.pty_guid = porttype;
                l_struct.tex_luid = text;
                l_struct.ten_lang = this.decodeString(l_result.getString("TEN_LANG"));
                l_vector.add(l_struct);
            }
        }
        finally {
            l_result.close();
        }
        return l_vector;
    }

    private int writeComplexType(PersistenceContext context, int guid, IComplexType type) throws EngineException, InvocationException {
        Hashtable l_buffer = context.getComponentBuffer();
        Integer l_key = (Integer)l_buffer.get(type);
        if (l_key == null) {
            try {
                int l_luid = context.drawLuid();
                this.insertTypcot(context, guid, l_luid, type.getMode());
                Enumeration l_element_enumeration = type.getElementEnumeration();
                if (l_element_enumeration != null) {
                    int l_element_number = 0;
                    while (l_element_enumeration.hasMoreElements()) {
                        IElement l_element = (IElement)l_element_enumeration.nextElement();
                        if (l_element == null) {
                            throw new InvocationException("ComplexType has invalid Element");
                        }
                        this.insertTypcel(context, guid, l_luid, ++l_element_number, this.writeElement(context, guid, l_element));
                    }
                }
                l_key = new Integer(l_luid);
            }
            catch (SQLException l_exception) {
                throw new EngineException("Failed to insert ComplexType into database", (Exception)l_exception);
            }
        }
        return l_key;
    }

    /*
     * WARNING - void declaration
     */
    private int writeElement(PersistenceContext context, int guid, IElement element) throws EngineException, InvocationException {
        Hashtable l_buffer = context.getComponentBuffer();
        Integer l_key = (Integer)l_buffer.get(element);
        if (l_key == null) {
            try {
                void var12_13;
                void var11_12;
                int l_max_occurs;
                int l_luid = context.drawLuid();
                String l_name = element.getName();
                if (l_name == null) {
                    throw new InvocationException("Element has invalid Name");
                }
                int l_min_occurs = element.getMinOccurs();
                if (l_min_occurs > (l_max_occurs = element.getMaxOccurs()) && l_max_occurs > 0) {
                    throw new InvocationException("Element has invalid Occurs");
                }
                IType l_type = element.getType();
                if (l_type == null) {
                    throw new InvocationException("Element has invalid Type");
                }
                switch (l_type.getTypeCast()) {
                    case 1: {
                        int l_type_cast = 1;
                        int l_type_luid = this.writeComplexType(context, guid, (IComplexType)l_type);
                        break;
                    }
                    case 2: {
                        int l_type_cast = 2;
                        int l_type_luid = this.writeSimpleType(context, guid, (ISimpleType)l_type);
                        break;
                    }
                    default: {
                        throw new InvocationException("Element has unknown Type");
                    }
                }
                ITextbag l_textbag = element.getTextbag();
                this.insertTypele(context, guid, l_luid, l_name, l_min_occurs, l_max_occurs, (int)var11_12, (int)var12_13, l_textbag == null ? 0 : this.writeTextbag(context, guid, l_textbag));
                l_key = new Integer(l_luid);
            }
            catch (SQLException l_exception) {
                throw new EngineException("Failed to insert Element into database", (Exception)l_exception);
            }
            l_buffer.put(element, l_key);
        }
        return l_key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessage(IMessage message) throws EngineException, InvocationException {
        if (message == null) {
            throw new InvocationException("Message invalid");
        }
        PersistenceContext l_context = this.openContext();
        boolean l_success = false;
        try {
            this.writeMessage(l_context, l_context.drawNumber(NUMBERRANGE_PORTTYPE), message);
            l_success = true;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this.commitContext(l_context, l_success);
            }
            finally {
                this.closeContext(l_context);
            }
            throw throwable;
        }
        try {
            this.commitContext(l_context, l_success);
        }
        finally {
            this.closeContext(l_context);
        }
    }

    private int writeMessage(PersistenceContext context, int guid, IMessage message) throws EngineException, InvocationException {
        Hashtable l_buffer = context.getComponentBuffer();
        Integer l_key = (Integer)l_buffer.get(message);
        if (l_key == null) {
            try {
                int l_luid = context.drawLuid();
                String l_uuid = message.getUuid();
                if (l_uuid == null) {
                    throw new InvocationException("Message has invalid UUID");
                }
                if (this.selectTypmes(context, l_uuid).size() > 0) {
                    throw new InvocationException("Message has duplicate UUID");
                }
                String l_name = message.getName();
                if (l_name == null) {
                    throw new InvocationException("Message has invalid Name");
                }
                ITextbag l_textbag = message.getTextbag();
                this.insertTypmes(context, guid, l_luid, l_uuid, l_name, l_textbag == null ? 0 : this.writeTextbag(context, guid, l_textbag));
                Enumeration l_messagepart_enumeration = message.getMessagepartEnumeration();
                if (l_messagepart_enumeration != null) {
                    int l_messagepart_number = 0;
                    while (l_messagepart_enumeration.hasMoreElements()) {
                        IMessagepart l_messagepart = (IMessagepart)l_messagepart_enumeration.nextElement();
                        if (l_messagepart == null) {
                            throw new InvocationException("Message has invalid Messagepart");
                        }
                        this.insertTypmmp(context, guid, l_luid, ++l_messagepart_number, this.writeMessagepart(context, guid, l_messagepart));
                    }
                }
                l_key = new Integer(l_luid);
            }
            catch (SQLException l_exception) {
                throw new EngineException("Failed to insert Message into database", (Exception)l_exception);
            }
            l_buffer.put(message, l_key);
        }
        return l_key;
    }

    /*
     * WARNING - void declaration
     */
    private int writeMessagepart(PersistenceContext context, int guid, IMessagepart messagepart) throws EngineException, InvocationException {
        Hashtable l_buffer = context.getComponentBuffer();
        Integer l_key = (Integer)l_buffer.get(messagepart);
        if (l_key == null) {
            try {
                void var10_11;
                void var9_10;
                int l_luid = context.drawLuid();
                String l_name = messagepart.getName();
                if (l_name == null) {
                    throw new InvocationException("Messagepart has invalid Name");
                }
                IStructure l_structure = messagepart.getStructure();
                if (l_structure == null) {
                    throw new InvocationException("Messagepart has invalid Structure");
                }
                block1 : switch (l_structure.getStructureCast()) {
                    case 1: {
                        int l_structure_cast = 1;
                        int l_structure_luid = this.writeElement(context, guid, (IElement)l_structure);
                        break;
                    }
                    case 2: {
                        int l_structure_luid;
                        int l_structure_cast;
                        IType l_type = (IType)l_structure;
                        switch (l_type.getTypeCast()) {
                            case 1: {
                                l_structure_cast = 2;
                                l_structure_luid = this.writeComplexType(context, guid, (IComplexType)l_type);
                                break block1;
                            }
                            case 2: {
                                l_structure_cast = 3;
                                l_structure_luid = this.writeSimpleType(context, guid, (ISimpleType)l_type);
                                break block1;
                            }
                        }
                        throw new InvocationException("Messagepart has unknown Structure");
                    }
                    default: {
                        throw new InvocationException("Messagepart has unknown Structure");
                    }
                }
                ITextbag l_textbag = messagepart.getTextbag();
                this.insertTypmpa(context, guid, l_luid, l_name, (int)var9_10, (int)var10_11, l_textbag == null ? 0 : this.writeTextbag(context, guid, l_textbag));
                l_key = new Integer(l_luid);
            }
            catch (SQLException l_exception) {
                throw new EngineException("Failed to insert Messagepart into database", (Exception)l_exception);
            }
            l_buffer.put(messagepart, l_key);
        }
        return l_key;
    }

    private int writeOperation(PersistenceContext context, int guid, IOperation operation) throws EngineException, InvocationException {
        Hashtable l_buffer = context.getComponentBuffer();
        Integer l_key = (Integer)l_buffer.get(operation);
        if (l_key == null) {
            try {
                int l_luid = context.drawLuid();
                String l_name = operation.getName();
                if (l_name == null) {
                    throw new InvocationException("Operation has invalid Name");
                }
                IOperationpart l_input_operationpart = operation.getInputOperationpart();
                IOperationpart l_output_operationpart = operation.getOutputOperationpart();
                ITextbag l_textbag = operation.getTextbag();
                this.insertTypope(context, guid, l_luid, l_name, l_input_operationpart == null ? 0 : this.writeOperationpart(context, guid, l_input_operationpart), l_output_operationpart == null ? 0 : this.writeOperationpart(context, guid, l_output_operationpart), l_textbag == null ? 0 : this.writeTextbag(context, guid, l_textbag));
                Enumeration l_fault_operationpart_enumeration = operation.getFaultOperationpartEnumeration();
                if (l_fault_operationpart_enumeration != null) {
                    int l_fault_operationpart_number = 0;
                    while (l_fault_operationpart_enumeration.hasMoreElements()) {
                        IOperationpart l_fault_operationpart = (IOperationpart)l_fault_operationpart_enumeration.nextElement();
                        if (l_fault_operationpart == null) {
                            throw new InvocationException("Operation has invalid Operationpart");
                        }
                        this.insertTypofo(context, guid, l_luid, ++l_fault_operationpart_number, this.writeOperationpart(context, guid, l_fault_operationpart));
                    }
                }
                l_key = new Integer(l_luid);
            }
            catch (SQLException l_exception) {
                throw new EngineException("Failed to insert Operation into database", (Exception)l_exception);
            }
            l_buffer.put(operation, l_key);
        }
        return l_key;
    }

    private int writeOperationpart(PersistenceContext context, int guid, IOperationpart operationpart) throws EngineException, InvocationException {
        Hashtable l_buffer = context.getComponentBuffer();
        Integer l_key = (Integer)l_buffer.get(operationpart);
        if (l_key == null) {
            try {
                int l_luid = context.drawLuid();
                String l_name = operationpart.getName();
                if (l_name == null) {
                    throw new InvocationException("Operationpart has invalid Name");
                }
                IMessage l_message = operationpart.getMessage();
                if (l_message == null) {
                    throw new InvocationException("Operationpart has invalid Message");
                }
                ITextbag l_textbag = operationpart.getTextbag();
                this.insertTypopa(context, guid, l_luid, l_name, this.writeMessage(context, guid, l_message), l_textbag == null ? 0 : this.writeTextbag(context, guid, l_textbag));
                l_key = new Integer(l_luid);
            }
            catch (SQLException l_exception) {
                throw new EngineException("Failed to insert Operationpart into database", (Exception)l_exception);
            }
            l_buffer.put(operationpart, l_key);
        }
        return l_key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePorttype(IPorttype porttype) throws EngineException, InvocationException {
        if (porttype == null) {
            throw new InvocationException("Porttype invalid");
        }
        PersistenceContext l_context = this.openContext();
        boolean l_success = false;
        try {
            this.writePorttype(l_context, l_context.drawNumber(NUMBERRANGE_PORTTYPE), porttype);
            l_success = true;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this.commitContext(l_context, l_success);
            }
            finally {
                this.closeContext(l_context);
            }
            throw throwable;
        }
        try {
            this.commitContext(l_context, l_success);
        }
        finally {
            this.closeContext(l_context);
        }
    }

    private void writePorttype(PersistenceContext context, int guid, IPorttype porttype) throws EngineException, InvocationException {
        try {
            String l_uuid = porttype.getUuid();
            if (l_uuid == null) {
                throw new InvocationException("Porttype has invalid UUID");
            }
            if (this.selectTyppty(context, l_uuid).size() > 0) {
                throw new InvocationException("Porttype has duplicate UUID");
            }
            String l_name = porttype.getName();
            if (l_name == null) {
                throw new InvocationException("Porttype has invalid Name");
            }
            ITextbag l_textbag = porttype.getTextbag();
            this.insertTyppty(context, guid, l_uuid, l_name, l_textbag == null ? 0 : this.writeTextbag(context, guid, l_textbag));
            Map l_namespaces = porttype.getNamespaces();
            if (l_namespaces == null) {
                throw new InvocationException("Porttype has invalid Namespaces");
            }
            Iterator l_namespace_iterator = l_namespaces.entrySet().iterator();
            while (l_namespace_iterator.hasNext()) {
                Map.Entry l_namespace = l_namespace_iterator.next();
                String l_prefix = (String)l_namespace.getKey();
                String l_uri = (String)l_namespace.getValue();
                if (l_prefix == null || l_uri == null) {
                    throw new InvocationException("Porttype has invalid Namespace");
                }
                this.insertTypnsp(context, guid, l_prefix, l_uri);
            }
            Enumeration l_operation_enumeration = porttype.getOperationEnumeration();
            if (l_operation_enumeration != null) {
                int l_operation_number = 0;
                while (l_operation_enumeration.hasMoreElements()) {
                    IOperation l_operation = (IOperation)l_operation_enumeration.nextElement();
                    if (l_operation == null) {
                        throw new InvocationException("Porttype has invalid Operation");
                    }
                    this.insertTyppop(context, guid, ++l_operation_number, this.writeOperation(context, guid, l_operation));
                }
            }
        }
        catch (SQLException l_exception) {
            throw new EngineException("Failed to insert Porttype into database", (Exception)l_exception);
        }
    }

    private int writeSimpleType(PersistenceContext context, int guid, ISimpleType type) throws EngineException, InvocationException {
        Hashtable l_buffer = context.getComponentBuffer();
        Integer l_key = (Integer)l_buffer.get(type);
        if (l_key == null) {
            try {
                Enumeration l_constant_enumeration;
                int l_luid = context.drawLuid();
                int l_fraction_digits = type.getFractionDigits();
                if (l_fraction_digits < 0) {
                    throw new InvocationException("SimpleType has invalid FractionDigits");
                }
                int l_total_digits = type.getTotalDigits();
                if (l_total_digits < 0) {
                    throw new InvocationException("SimpleType has invalid TotalDigits");
                }
                if (l_fraction_digits > l_total_digits && l_total_digits > 0) {
                    throw new InvocationException("SimpleType has invalid Digits");
                }
                int l_min_length = type.getMinLength();
                if (l_min_length < 0) {
                    throw new InvocationException("SimpleType has invalid MinLength");
                }
                int l_max_length = type.getMaxLength();
                if (l_max_length < 0) {
                    throw new InvocationException("SimpleType has invalid MaxLength");
                }
                if (l_min_length > l_max_length && l_max_length > 0) {
                    throw new InvocationException("SimpleType has invalid Length");
                }
                this.insertTypsit(context, guid, l_luid, type.getBase(), l_min_length, l_max_length, l_fraction_digits, l_total_digits);
                Enumeration l_pattern_enumeration = type.getPatternEnumeration();
                if (l_pattern_enumeration != null) {
                    int l_pattern_number = 0;
                    while (l_pattern_enumeration.hasMoreElements()) {
                        String l_pattern = (String)l_pattern_enumeration.nextElement();
                        if (l_pattern == null) {
                            throw new InvocationException("SimpleType has invalid Pattern");
                        }
                        this.insertTypspa(context, guid, l_luid, ++l_pattern_number, l_pattern);
                    }
                }
                if ((l_constant_enumeration = type.getConstantEnumeration()) != null) {
                    int l_constant_number = 0;
                    while (l_constant_enumeration.hasMoreElements()) {
                        ISimpleTypeValue l_constant = (ISimpleTypeValue)l_constant_enumeration.nextElement();
                        if (l_constant == null) {
                            throw new InvocationException("SimpleType has invalid Constant");
                        }
                        String l_constant_value = l_constant.getValueString();
                        if (l_constant_value == null) {
                            throw new InvocationException("SimpleType has invalid Constant Value");
                        }
                        this.insertTypsco(context, guid, l_luid, ++l_constant_number, l_constant_value);
                    }
                }
                l_key = new Integer(l_luid);
            }
            catch (SQLException l_exception) {
                throw new EngineException("Failed to insert SimpleType into database", (Exception)l_exception);
            }
            l_buffer.put(type, l_key);
        }
        return l_key;
    }

    private int writeTextbag(PersistenceContext context, int guid, ITextbag textbag) throws EngineException, InvocationException {
        Hashtable l_buffer = context.getComponentBuffer();
        Integer l_key = (Integer)l_buffer.get(textbag);
        if (l_key == null) {
            try {
                int l_luid = context.drawLuid();
                String l_language = textbag.getPrimaryLanguage();
                if (l_language == null || textbag.getTextbagEntry(l_language) == null) {
                    throw new InvocationException("Textbag has invalid PrimaryLanguage");
                }
                this.insertTyptex(context, guid, l_luid, l_language);
                Enumeration l_textentry_enumeration = textbag.getTextbagEntryEnumeration();
                if (l_textentry_enumeration != null) {
                    while (l_textentry_enumeration.hasMoreElements()) {
                        ITextbagEntry l_entry = (ITextbagEntry)l_textentry_enumeration.nextElement();
                        if (l_entry == null) {
                            throw new InvocationException("Textbag has invalid TextbagEntry");
                        }
                        String l_entry_language = l_entry.getLanguage();
                        if (l_entry_language == null) {
                            throw new InvocationException("Textbag had invalid TextbagEntry Language");
                        }
                        String l_entry_value = l_entry.getValue();
                        if (l_entry_value == null) {
                            throw new InvocationException("Text has invalid Textentry Value");
                        }
                        this.insertTypten(context, guid, l_luid, l_entry_language, l_entry_value);
                    }
                }
                l_key = new Integer(l_luid);
            }
            catch (SQLException l_exception) {
                throw new EngineException("Failed to insert Text into database", (Exception)l_exception);
            }
            l_buffer.put(textbag, l_key);
        }
        return l_key;
    }

    public static void main(String[] args) {
        System.out.println("[STARTUP]");
        try {
            Properties props = new Properties();
            props.put("DATABASE_PWD", "sap");
            props.put("DATABASE_URL", "jdbc:sap:sapdb://p77756/C11");
            props.put("DATABASE_USER", "SAPC11DB");
            props.put("POOL_MIN", "1");
            props.put("POOL_MAX", "5");
            ConnectionPoolOpenSQLStandalone l_pool = new ConnectionPoolOpenSQLStandalone();
            l_pool.initialize(props);
            Message l_first_message = new Message("First_Message");
            Messagepart l_first_messagepart = new Messagepart("First_Messagepart");
            l_first_message.addMessagepart(l_first_messagepart);
            ComplexType l_first_complex_type = new ComplexType();
            l_first_messagepart.setStructure(l_first_complex_type);
            SimpleType l_first_simple_type = new SimpleType(12);
            Element l_first_element_one = new Element("First_Element_One");
            l_first_element_one.setType(l_first_simple_type);
            l_first_complex_type.addElement(l_first_element_one);
            Element l_first_element_two = new Element("First_Element_Two");
            l_first_element_two.setType(l_first_simple_type);
            l_first_complex_type.addElement(l_first_element_two);
            System.out.println(MessageUtils.dumpMessageValue(l_first_message));
            ServiceDescriptionPersistence l_persistence = new ServiceDescriptionPersistence(null);
            IMessage l_second_message = l_persistence.readMessage("452BC58603153843A81FFD18DCE5E8A3");
            System.out.println("\n" + (l_second_message == null ? "null\n" : MessageUtils.dumpMessageValue(l_second_message)));
            Porttype l_first_porttype = new Porttype("First_Porttype");
            Operation l_first_operation = new Operation("First Operation");
            l_first_porttype.addOperation(l_first_operation);
            Operationpart l_first_operationpart = new Operationpart("First_Operationpart");
            l_first_operation.setOutputOperationpart(l_first_operationpart);
            l_first_message = new Message("First_Message");
            l_first_operationpart.setMessage(l_first_message);
            l_first_messagepart = new Messagepart("First_Messagepart");
            l_first_message.addMessagepart(l_first_messagepart);
            l_first_complex_type = new ComplexType();
            l_first_messagepart.setStructure(l_first_complex_type);
            l_first_simple_type = new SimpleType(12);
            l_first_element_one = new Element("First_Element_One");
            l_first_element_one.setType(l_first_simple_type);
            l_first_complex_type.addElement(l_first_element_one);
            l_first_element_two = new Element("First_Element_Two");
            l_first_element_two.setType(l_first_simple_type);
            l_first_complex_type.addElement(l_first_element_two);
            System.out.println(MessageUtils.dumpMessageValue(l_first_message));
        }
        catch (Exception l_exception) {
            l_exception.printStackTrace();
        }
        System.out.println("[SHUTDOWN]");
    }

    private static void dumpLayout(ILayoutNode node, int depth) {
        StringBuffer l_buffer = new StringBuffer();
        for (int l_index = 0; l_index < depth; ++l_index) {
            l_buffer.append(" ");
        }
        l_buffer.append(node.getName());
        System.out.println(l_buffer.toString());
        ++depth;
        Enumeration l_enumeration = node.getLayoutNodeEnumeration();
        while (l_enumeration.hasMoreElements()) {
            ServiceDescriptionPersistence.dumpLayout((ILayoutNode)l_enumeration.nextElement(), depth);
        }
    }

    private class StructTyptex {
        public int pty_guid = 0;
        public int tex_luid = 0;
        public String ten_lang = null;
    }

    private class StructTypten {
        public int pty_guid = 0;
        public int tex_luid = 0;
        public String ten_lang = null;
        public String ten_data = null;
    }

    private class StructTypspa {
        public int pty_guid = 0;
        public int sit_luid = 0;
        public int pat_numb = 0;
        public String pat_data = null;
    }

    private class StructTypsco {
        public int pty_guid = 0;
        public int sit_luid = 0;
        public int con_numb = 0;
        public String con_data = null;
    }

    private class StructTypsit {
        public int pty_guid = 0;
        public int sit_luid = 0;
        public int sit_base = 0;
        public int sit_smin = 0;
        public int sit_smax = 0;
        public int sit_dfra = 0;
        public int sit_dtot = 0;
    }

    private class StructTypnsp {
        public int pty_guid = 0;
        public String nsp_prefix = null;
        public String nsp_uri = null;
    }

    private class StructTyppty {
        public int pty_guid = 0;
        public String pty_uuid = null;
        public String pty_name = null;
        public int tex_luid = 0;
    }

    private class StructTyppop {
        public int pty_guid = 0;
        public int ope_numb = 0;
        public int ope_luid = 0;
    }

    private class StructTypope {
        public int pty_guid = 0;
        public int ope_luid = 0;
        public String ope_name = null;
        public int iop_luid = 0;
        public int oop_luid = 0;
        public int tex_luid = 0;
    }

    private class StructTypopa {
        public int pty_guid = 0;
        public int opa_luid = 0;
        public String opa_name = null;
        public int mes_luid = 0;
        public int tex_luid = 0;
    }

    private class StructTypofo {
        public int pty_guid = 0;
        public int ope_luid = 0;
        public int fop_numb = 0;
        public int fop_luid = 0;
    }

    private class StructTypmpa {
        public int pty_guid = 0;
        public int mpa_luid = 0;
        public String mpa_name = null;
        public int str_cast = 0;
        public int str_luid = 0;
        public int tex_luid = 0;
    }

    private class StructTypmmp {
        public int pty_guid = 0;
        public int mes_luid = 0;
        public int mpa_numb = 0;
        public int mpa_luid = 0;
    }

    private class StructTypmes {
        public int pty_guid = 0;
        public int mes_luid = 0;
        public String mes_uuid = null;
        public String mes_name = null;
        public int tex_luid = 0;
    }

    private class StructTypele {
        public int pty_guid = 0;
        public int ele_luid = 0;
        public String ele_name = null;
        public int ele_omin = 0;
        public int ele_omax = 0;
        public int typ_cast = 0;
        public int typ_luid = 0;
        public int tex_luid = 0;
    }

    private class StructTypcot {
        public int pty_guid = 0;
        public int cot_luid = 0;
        public int cot_mode = 0;
    }

    private class StructTypcel {
        public int pty_guid = 0;
        public int cot_luid = 0;
        public int ele_numb = 0;
        public int ele_luid = 0;
    }
}

