/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.mapping.base;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.data.mapping.base.SimpleMappingRule;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.types.base.ComplexType;
import com.sap.caf.mp.core.data.types.base.Element;
import com.sap.caf.mp.core.data.types.base.Message;
import com.sap.caf.mp.core.data.types.base.Messagepart;
import com.sap.caf.mp.core.data.types.base.SimpleType;
import com.sap.caf.mp.core.data.values.api.IComplexTypeValue;
import com.sap.caf.mp.core.data.values.api.IElementValue;
import com.sap.caf.mp.core.data.values.api.IMessageValue;
import com.sap.caf.mp.core.data.values.api.IMessagepartValue;
import com.sap.caf.mp.core.data.values.api.ISimpleTypeValue;
import com.sap.caf.mp.core.data.values.api.IStructureValue;
import com.sap.caf.mp.core.data.values.api.ITypeValue;
import com.sap.caf.mp.core.data.values.base.ComplexTypeValue;
import com.sap.caf.mp.core.data.values.base.ElementValue;
import com.sap.caf.mp.core.data.values.base.MessageValue;
import com.sap.caf.mp.core.data.values.base.MessageValueUtils;
import com.sap.caf.mp.core.data.values.base.MessagepartValue;
import com.sap.caf.mp.core.data.values.base.SimpleTypeValue;
import com.sap.caf.mp.core.data.values.base.StructureValue;
import com.sap.caf.mp.core.data.values.base.TypeValue;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class SimpleMapping {
    private static final String PATH_TOKEN_DELIMETER = "/";
    private Vector m_vector = new Vector();

    public void addMappingRule(SimpleMappingRule rule) throws InvocationException {
        if (rule == null) {
            throw new InvocationException("Invalid mapping rule");
        }
        this.m_vector.add(rule);
    }

    private ComplexTypeValue createComplexTypeValue(IComplexType type) throws InvocationException {
        return new ComplexTypeValue(type);
    }

    private ElementValue createElementValue(IElement element) throws InvocationException {
        ElementValue l_element_value = new ElementValue(element);
        l_element_value.addTypeValue(this.createTypeValue(element.getType()));
        return l_element_value;
    }

    private MessagepartValue createMessagepartValue(IMessagepart messagepart) throws InvocationException {
        MessagepartValue l_messagepart_value = new MessagepartValue(messagepart);
        l_messagepart_value.setStructureValue(this.createStructureValue(messagepart.getStructure()));
        return l_messagepart_value;
    }

    private SimpleTypeValue createSimpleTypeValue(ISimpleType type) throws InvocationException {
        return new SimpleTypeValue(type);
    }

    private StructureValue createStructureValue(IStructure structure) throws InvocationException {
        switch (structure.getStructureCast()) {
            case 1: {
                return this.createElementValue((IElement)structure);
            }
            case 2: {
                return this.createTypeValue((IType)structure);
            }
        }
        throw new InvocationException("Unknown Structure extension");
    }

    private TypeValue createTypeValue(IType type) throws InvocationException {
        switch (type.getTypeCast()) {
            case 1: {
                return this.createComplexTypeValue((IComplexType)type);
            }
            case 2: {
                return this.createSimpleTypeValue((ISimpleType)type);
            }
        }
        throw new InvocationException("Unknown Type extension");
    }

    public IMessageValue map(IMessage type, IMessageValue value) throws InvocationException {
        if (type == null) {
            throw new InvocationException("Reference type must not be null");
        }
        MessageValue l_message_value = new MessageValue(type);
        Enumeration l_enumeration = this.m_vector.elements();
        while (l_enumeration.hasMoreElements()) {
            String l_value_string;
            SimpleMappingRule l_rule = (SimpleMappingRule)l_enumeration.nextElement();
            String l_source = l_rule.getSource();
            if (l_source != null) {
                if (value == null) {
                    throw new InvocationException("Source path requires valid source MessageValue");
                }
                ISimpleTypeValue l_source_value = this.locateSimpleTypeValue(value, this.tokenizePath(l_rule.getSource()));
                l_value_string = l_source_value != null ? l_source_value.getValue() : l_rule.getValue();
            } else {
                l_value_string = l_rule.getValue();
            }
            if (l_value_string == null) continue;
            this.prepareSimpleTypeValue(l_message_value, this.tokenizePath(l_rule.getTarget())).setValue(l_value_string);
        }
        return l_message_value;
    }

    private SimpleTypeValue prepareSimpleTypeValue(ComplexTypeValue value, Stack path) throws InvocationException {
        if (path.empty()) {
            throw new InvocationException("Path ends in ComplexType");
        }
        String l_token = (String)path.pop();
        ElementValue l_element_value = (ElementValue)value.getElementValue(l_token);
        if (l_element_value == null) {
            IElement l_element = value.getComplexType().getElement(l_token);
            if (l_element == null) {
                throw new InvocationException("Unknown path component \"" + l_token + "\" in ComplexType");
            }
            l_element_value = this.createElementValue(l_element);
            value.addElementValue(l_element_value);
        }
        return this.prepareSimpleTypeValue(l_element_value, path);
    }

    private SimpleTypeValue prepareSimpleTypeValue(ElementValue value, Stack path) throws InvocationException {
        if (value.getTypeValueCount() != 1) {
            throw new InvocationException("Element not single value");
        }
        return this.prepareSimpleTypeValue((TypeValue)value.getTypeValue(0), path);
    }

    private SimpleTypeValue prepareSimpleTypeValue(MessageValue value, Stack path) throws InvocationException {
        if (path.empty()) {
            throw new InvocationException("Path ends in Message");
        }
        String l_token = (String)path.pop();
        IMessagepartValue l_messagepart_value = value.getMessagepartValue(l_token);
        if (l_messagepart_value == null) {
            IMessagepart l_messagepart = value.getMessage().getMessagepart(l_token);
            if (l_messagepart == null) {
                throw new InvocationException("Unknown path component \"" + l_token + "\" in Message");
            }
            l_messagepart_value = this.createMessagepartValue(l_messagepart);
            value.addMessagepartValue(l_messagepart_value);
        }
        return this.prepareSimpleTypeValue((StructureValue)l_messagepart_value.getStructureValue(), path);
    }

    private SimpleTypeValue prepareSimpleTypeValue(SimpleTypeValue value, Stack path) throws InvocationException {
        if (!path.isEmpty()) {
            throw new InvocationException("Path too long");
        }
        return value;
    }

    private SimpleTypeValue prepareSimpleTypeValue(StructureValue value, Stack path) throws InvocationException {
        switch (value.getStructure().getStructureCast()) {
            case 1: {
                ElementValue l_element_value = (ElementValue)value;
                if (path.empty()) {
                    throw new InvocationException("Path ends in Messagepart");
                }
                String l_token = (String)path.pop();
                if (!l_element_value.getElement().getName().equals(l_token)) {
                    throw new InvocationException("Unknown path component \"" + l_token + "\" in Messagepart");
                }
                return this.prepareSimpleTypeValue(l_element_value, path);
            }
            case 2: {
                return this.prepareSimpleTypeValue((TypeValue)value, path);
            }
        }
        throw new InvocationException("Unknown Structure extension");
    }

    private SimpleTypeValue prepareSimpleTypeValue(TypeValue value, Stack path) throws InvocationException {
        switch (value.getType().getTypeCast()) {
            case 1: {
                return this.prepareSimpleTypeValue((ComplexTypeValue)value, path);
            }
            case 2: {
                return this.prepareSimpleTypeValue((SimpleTypeValue)value, path);
            }
        }
        throw new InvocationException("Unknown Type extension");
    }

    private ISimpleTypeValue locateSimpleTypeValue(IComplexTypeValue value, Stack path) throws InvocationException {
        if (path.empty()) {
            throw new InvocationException("Path ends in ComplexType");
        }
        String l_token = (String)path.pop();
        IElementValue l_element_value = value.getElementValue(l_token);
        if (l_element_value == null) {
            if (value.getComplexType().getElement(l_token) == null) {
                throw new InvocationException("Unknown path component \"" + l_token + "\" in ComplexType");
            }
            return null;
        }
        return this.locateSimpleTypeValue(l_element_value, path);
    }

    private ISimpleTypeValue locateSimpleTypeValue(IElementValue value, Stack path) throws InvocationException {
        switch (value.getTypeValueCount()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.locateSimpleTypeValue(value.getTypeValue(0), path);
            }
        }
        throw new InvocationException("Element has multiple values");
    }

    private ISimpleTypeValue locateSimpleTypeValue(IMessageValue value, Stack path) throws InvocationException {
        if (path.empty()) {
            throw new InvocationException("Path ends in Message");
        }
        String l_token = (String)path.pop();
        IMessagepartValue l_messagepart_value = value.getMessagepartValue(l_token);
        if (l_messagepart_value == null) {
            if (value.getMessage().getMessagepart(l_token) == null) {
                throw new InvocationException("Unknown path component \"" + l_token + "\" in Message");
            }
            return null;
        }
        IStructureValue l_structure_value = l_messagepart_value.getStructureValue();
        if (l_structure_value == null) {
            return null;
        }
        return this.locateSimpleTypeValue(l_structure_value, path);
    }

    private ISimpleTypeValue locateSimpleTypeValue(ISimpleTypeValue value, Stack path) throws InvocationException {
        if (!path.isEmpty()) {
            throw new InvocationException("Path too long");
        }
        return value;
    }

    private ISimpleTypeValue locateSimpleTypeValue(IStructureValue value, Stack path) throws InvocationException {
        switch (value.getStructure().getStructureCast()) {
            case 1: {
                IElementValue l_element_value = (IElementValue)value;
                if (path.empty()) {
                    throw new InvocationException("Path ends in Messagepart");
                }
                String l_token = (String)path.pop();
                if (!l_element_value.getElement().getName().equals(l_token)) {
                    throw new InvocationException("Unknown path component \"" + l_token + "\" in Messagepart");
                }
                return this.locateSimpleTypeValue(l_element_value, path);
            }
            case 2: {
                return this.locateSimpleTypeValue((ITypeValue)value, path);
            }
        }
        throw new InvocationException("Unknown Structure extension");
    }

    private ISimpleTypeValue locateSimpleTypeValue(ITypeValue value, Stack path) throws InvocationException {
        switch (value.getType().getTypeCast()) {
            case 1: {
                return this.locateSimpleTypeValue((IComplexTypeValue)value, path);
            }
            case 2: {
                return this.locateSimpleTypeValue((ISimpleTypeValue)value, path);
            }
        }
        throw new InvocationException("Unknown Type extension");
    }

    private Stack tokenizePath(String path) {
        Stack<String> l_forward_stack = new Stack<String>();
        StringTokenizer l_tokenizer = new StringTokenizer(path, PATH_TOKEN_DELIMETER);
        while (l_tokenizer.hasMoreElements()) {
            String l_token = l_tokenizer.nextToken();
            if (l_token.length() <= 0) continue;
            l_forward_stack.push(l_token);
        }
        Stack l_backward_stack = new Stack();
        while (!l_forward_stack.empty()) {
            l_backward_stack.push(l_forward_stack.pop());
        }
        return l_backward_stack;
    }

    public static void main(String[] args) {
        try {
            Message l_first_message = new Message("First_Message");
            Messagepart l_first_messagepart = new Messagepart("First_Messagepart");
            l_first_message.addMessagepart(l_first_messagepart);
            ComplexType l_first_complex_type = new ComplexType();
            l_first_messagepart.setStructure(l_first_complex_type);
            SimpleType l_first_simple_type = new SimpleType(12);
            Element l_first_element_one = new Element("First_Element_One");
            l_first_element_one.setType(l_first_simple_type);
            l_first_complex_type.addElement(l_first_element_one);
            Element l_first_element_two = new Element("First_Element_Two");
            l_first_element_two.setType(l_first_simple_type);
            l_first_complex_type.addElement(l_first_element_two);
            MessageValue l_first_message_value = new MessageValue(l_first_message);
            MessagepartValue l_first_messagepart_value = new MessagepartValue(l_first_messagepart);
            l_first_message_value.addMessagepartValue(l_first_messagepart_value);
            ComplexTypeValue l_first_complex_type_value = new ComplexTypeValue(l_first_complex_type);
            l_first_messagepart_value.setStructureValue(l_first_complex_type_value);
            ElementValue l_first_element_value_two = new ElementValue(l_first_element_two);
            l_first_complex_type_value.addElementValue(l_first_element_value_two);
            SimpleTypeValue l_first_string_value_two = new SimpleTypeValue(l_first_simple_type);
            l_first_element_value_two.addTypeValue(l_first_string_value_two);
            l_first_string_value_two.setValue("xyz");
            Message l_second_message = new Message("Second_Message");
            Messagepart l_second_messagepart = new Messagepart("Second_Messagepart");
            l_second_message.addMessagepart(l_second_messagepart);
            ComplexType l_second_complex_type = new ComplexType();
            l_second_messagepart.setStructure(l_second_complex_type);
            SimpleType l_second_simple_type = new SimpleType(12);
            Element l_second_element_one = new Element("Second_Element_One");
            l_second_element_one.setType(l_second_simple_type);
            l_second_complex_type.addElement(l_second_element_one);
            Element l_second_element_two = new Element("Second_Element_Two");
            l_second_element_two.setType(l_second_simple_type);
            l_second_complex_type.addElement(l_second_element_two);
            System.out.println(MessageValueUtils.dumpMessageValue(l_first_message_value));
            SimpleMapping l_mapping = new SimpleMapping();
            l_mapping.addMappingRule(new SimpleMappingRule("Second_Messagepart/Second_Element_One", null, "Default 1"));
            l_mapping.addMappingRule(new SimpleMappingRule("Second_Messagepart/Second_Element_Two", null, "Default 2"));
            IMessageValue l_second_message_value = l_mapping.map(l_second_message, null);
            System.out.println(MessageValueUtils.dumpMessageValue(l_second_message_value));
        }
        catch (Exception l_exception) {
            l_exception.printStackTrace();
        }
    }
}

