/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.reader;

import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.FileLogInfoData;
import com.sap.tc.logging.HelperLib;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.LogEvents;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.exceptions.CloseException;
import com.sap.tc.logging.exceptions.DataException;
import com.sap.tc.logging.exceptions.FileCloseException;
import com.sap.tc.logging.exceptions.FileDataException;
import com.sap.tc.logging.exceptions.FileOpenException;
import com.sap.tc.logging.exceptions.OpenException;
import com.sap.tc.logging.interfaces.IFilter;
import com.sap.tc.logging.interfaces.ILoggingResultSet;
import com.sap.tc.logging.reader.LocalBuffer;
import com.sap.tc.logging.reader.LogRecordResultSet;
import com.sap.tc.logging.reader.ReadFileSetLog;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.ParseException;
import java.util.Arrays;

public final class FileReadLog
extends ReadFileSetLog {
    private static String strLoc = "FileReadLog";
    private static final int DIRECTION_NEXT = 1;
    private static final int DIRECTION_PREVIOUS = -1;
    private RandomAccessFile source;
    private int fileHeaderSize;
    private int fileFooterSize;
    private int delimiterSize;
    private int[] delimiter;
    private int[] delimiterEmpty;
    private boolean isDelSorted = true;
    private boolean isBookMarkSet = false;
    private int lastChunksSize;
    private static int MAX_GUARDIAN_SIZE = 5000;
    private int guardianCounter;
    private String lastMessageID = "";
    private LogEvents logEvents;
    private LocalBuffer buffData;

    public FileReadLog(String fileName) throws FileDataException {
        super(fileName);
    }

    public FileReadLog(String fileName, int size, int limit) throws FileDataException {
        super(fileName, size, limit);
        if (fileName == null) {
            throw new NullPointerException();
        }
    }

    public FileReadLog(FileLog fileLog) {
        super(fileLog.getPattern(), fileLog.getCnt(), fileLog.getLimit());
        if (fileLog == null) {
            throw new NullPointerException();
        }
    }

    public void registerForLogEvents(LogEvents logEvents) {
        this.logEvents = logEvents;
    }

    public boolean isBOF() throws DataException {
        String rbSource = this.getSource();
        boolean result = true;
        try {
            result = this.isBOFInt();
            if (result && this.isInFileSet()) {
                this.previous();
                if (!rbSource.equalsIgnoreCase(this.getSource()) && new File(this.getSource()).exists()) {
                    this.closeInt();
                    this.openInt();
                    this.setFilePointer(this.source.length());
                    result = this.isBOFInt();
                }
            }
        }
        catch (Exception ex) {
            this.setSource(rbSource);
            throw new FileDataException(this.getSource(), ex);
        }
        return result;
    }

    public boolean isEOF() throws DataException {
        String rbSource = this.getSource();
        boolean result = true;
        try {
            result = this.isEOFInt();
            if (result && this.isInFileSet()) {
                this.next();
                if (!rbSource.equalsIgnoreCase(this.getSource()) && new File(this.getSource()).exists()) {
                    this.closeInt();
                    this.openInt();
                    result = this.isEOFInt();
                }
            }
        }
        catch (Exception ex) {
            this.setSource(rbSource);
            throw new FileDataException(this.getSource(), ex);
        }
        return result;
    }

    public void moveToBOF() throws DataException {
        String rbSource = this.getSource();
        try {
            if (this.isInFileSet()) {
                this.moveToBOFS();
                if (!rbSource.equalsIgnoreCase(this.getSource())) {
                    this.closeInt();
                    this.setSource(this.getSource());
                    this.openInt();
                }
            }
            if (this.source != null) {
                this.setBookMarkInt(0L);
                this.buffData.reInit();
                this.isBookMarkSet = false;
            }
            this.buffData.setLatestDirection(1);
        }
        catch (CloseException ex) {
            this.setSource(rbSource);
        }
        catch (OpenException ex) {
            this.setSource(rbSource);
        }
    }

    public void moveToEOF() throws DataException {
        String rbSource = this.getSource();
        try {
            if (this.isInFileSet()) {
                this.moveToEOFS();
                if (!rbSource.equalsIgnoreCase(this.getSource())) {
                    this.closeInt();
                    this.setSource(this.getSource());
                    this.openInt();
                }
            }
            if (this.source != null) {
                this.setBookMarkInt(this.source.length());
                this.buffData.reInit();
                this.isBookMarkSet = false;
            }
        }
        catch (CloseException ex) {
            this.setSource(rbSource);
        }
        catch (OpenException ex) {
            this.setSource(rbSource);
        }
        catch (IOException ex) {
            throw new FileDataException(this.getSource(), ex);
        }
    }

    public ILoggingResultSet readNext(int numberOfRecords) throws DataException {
        if (numberOfRecords < 0) {
            numberOfRecords = 0;
        }
        LogRecordResultSet resultSet = new LogRecordResultSet();
        IFilter fileFilter = this.getFilter(0);
        boolean readContinue = true;
        try {
            this.openInt();
            if (!this.isEOF()) {
                int i = 0;
                while (i < numberOfRecords) {
                    if (this.isEOF()) {
                        return resultSet;
                    }
                    do {
                        byte[] result = this.readNextInt();
                        if (fileFilter != null && fileFilter.isFilterEnabled()) {
                            readContinue = fileFilter.beRead(result);
                        }
                        if (!readContinue) continue;
                        LogRecord lr = this.getFormatter().parseMsg(result);
                        if (lr == null) break;
                        lr.setBookMark(this.getBookMark());
                        resultSet.add(lr);
                    } while (!readContinue && !this.isEOF());
                    ++i;
                }
            } else {
                this.moveToEOF();
            }
        }
        catch (Exception ex) {
            throw new FileDataException(this.getSource(), ex);
        }
        return resultSet;
    }

    public ILoggingResultSet readPrevious(int numberOfRecords) throws DataException {
        if (numberOfRecords < 0) {
            numberOfRecords = 0;
        }
        LogRecordResultSet resultSet = new LogRecordResultSet();
        IFilter fileFilter = this.getFilter(0);
        boolean readContinue = true;
        try {
            this.openInt();
            if (!this.isBOF()) {
                int i = 0;
                while (i < numberOfRecords) {
                    if (this.isBOF()) {
                        return resultSet;
                    }
                    do {
                        byte[] result = this.readPreviousInt();
                        if (fileFilter != null && fileFilter.isFilterEnabled()) {
                            readContinue = fileFilter.beRead(result);
                        }
                        if (!readContinue) continue;
                        LogRecord lr = this.getFormatter().parseMsg(result);
                        if (lr == null) break;
                        lr.setBookMark(this.getBookMark());
                        resultSet.add(lr);
                    } while (!readContinue && !this.isBOF());
                    ++i;
                }
            } else {
                this.moveToBOF();
            }
        }
        catch (Exception ex) {
            resultSet.setStatus(-1);
            resultSet.setException(new FileDataException(this.getSource(), ex));
        }
        return resultSet;
    }

    public boolean isPartOfFileSet() {
        return this.isInFileSet();
    }

    public void seek(long filePointer) throws DataException {
        try {
            this.source.seek(filePointer);
        }
        catch (IOException ex) {
            throw new FileDataException(this.getSource(), ex);
        }
    }

    public long find(String condition) throws DataException {
        int operaterID = 0;
        String operater = null;
        int i = 0;
        while (i < condition.length()) {
            operater = condition.substring(i, i + 1);
            operaterID = HelperLib.parseOperator(operater);
            if (operaterID > 0 && i + 1 < condition.length()) {
                String multiOperater = condition.substring(i, i + 2);
                int multiOperaterID = HelperLib.parseOperator(multiOperater);
                if (multiOperaterID <= 0) break;
                operaterID = multiOperaterID;
                operater = multiOperater;
                break;
            }
            ++i;
        }
        if (operaterID < 0) {
            return -1L;
        }
        int endFieldNamePos = condition.indexOf(operater);
        if (!(this.getFormatter() instanceof ListFormatter)) {
            return -1L;
        }
        int fieldIndex = 0;
        String fieldName = condition.substring(0, endFieldNamePos).trim();
        if (!ListFormatter.getFields().containsKey(fieldName)) {
            return -1L;
        }
        fieldIndex = (Integer)ListFormatter.getFields().get(fieldName);
        String compareStr = condition.substring(endFieldNamePos + operater.length());
        while (!this.isEOF()) {
            String filedStr;
            byte[] msgChunk = this.readNextInt();
            if (msgChunk == null || msgChunk.length == 0) continue;
            int startFieldPos = this.delimiter[fieldIndex];
            int endFieldPos = 0;
            if (fieldIndex + 1 < this.delimiterSize) {
                endFieldPos = this.delimiter[fieldIndex + 1];
            }
            if (endFieldPos == 0) {
                endFieldPos = msgChunk.length;
            }
            if (!ListFormatter.compareField(fieldIndex, operaterID, (filedStr = new String(msgChunk, startFieldPos, endFieldPos = endFieldPos - startFieldPos - 1)).trim(), compareStr.trim())) continue;
            return this.getBookMark();
        }
        return -1L;
    }

    public ILoggingResultSet search(String condition) throws DataException {
        return null;
    }

    protected void openInt() throws OpenException {
        if (this.isClosed() && this.source == null) {
            try {
                this.loadDataFromFileHeader(new FileLogInfoData(this.getSource()));
                this.source = new RandomAccessFile(this.getSource(), "r");
                this.buffData = new LocalBuffer();
                this.delimiter = new int[150];
                this.delimiterEmpty = new int[150];
                this.setFilePointer(0L);
                this.setStatus(2);
                if (this.logEvents != null) {
                    this.logEvents.eventLogIsOpen(this);
                }
            }
            catch (Exception ex) {
                this.source = null;
                throw new FileOpenException(this.getSource(), ex);
            }
        }
    }

    protected void closeInt() throws CloseException {
        if (this.isOpened() && this.source != null) {
            try {
                this.source.close();
                this.setStatus(1);
                if (this.logEvents != null) {
                    this.logEvents.eventLogIsClosed(this);
                }
            }
            catch (IOException ex) {
                this.source = null;
                throw new FileCloseException(this.getSource(), ex);
            }
            this.source = null;
        }
    }

    public ILoggingResultSet searchNext(String[] searchTokens, boolean isCaseSensitive) throws DataException {
        LogRecordResultSet resultSet = new LogRecordResultSet();
        if (searchTokens == null || searchTokens.length == 0) {
            return resultSet;
        }
        this.moveToBOF();
        String token = null;
        try {
            this.openInt();
            while (!this.isEOF()) {
                byte[] resultChunk = this.readNextInt();
                String resultStr = new String(resultChunk, 0, this.buffData.getChunksSize());
                if (!isCaseSensitive) {
                    resultStr = resultStr.toUpperCase();
                }
                int i = 0;
                while (i < searchTokens.length) {
                    token = searchTokens[i];
                    if (!isCaseSensitive) {
                        token = token.toUpperCase();
                    }
                    if (resultStr.indexOf(token) > 0) {
                        LogRecord lr = this.getFormatter().parseMsg(resultChunk);
                        if (lr != null) {
                            resultSet.add(lr);
                        } else {
                            throw new FileDataException(this.getSource(), new ParseException("Parsing error...", 0));
                        }
                    }
                    ++i;
                }
            }
        }
        catch (DataException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new FileDataException(this.getSource(), ex);
        }
        return resultSet;
    }

    protected void setBookMarkInt(long value) throws DataException {
        try {
            this.setFilePointer(value);
            this.isBookMarkSet = true;
        }
        catch (IOException ex) {
            throw new FileDataException(this.getSource(), ex);
        }
    }

    protected long getBookMarkInt() throws DataException {
        try {
            return this.source.getFilePointer() - (long)this.buffData.getBookMark();
        }
        catch (IOException ex) {
            throw new FileDataException(this.getSource(), ex);
        }
    }

    private void loadDataFromFileHeader(FileLogInfoData fileHeader) {
        if (fileHeader.getHeader() != null && fileHeader.getHeader().length() > 0) {
            this.setName(fileHeader.getName());
            this.setDescription(fileHeader.getDescription());
            this.setFormatter(fileHeader.getFormatter());
            this.setEncoding(fileHeader.getEncoding());
            this.setHeader(fileHeader.getHeader());
            this.setFooter(fileHeader.getFooter());
            this.fileHeaderSize = this.getHeader().length();
            this.fileFooterSize = this.getFooter().length();
        }
    }

    private byte[] readNextInt() throws DataException {
        Object finalChunk = null;
        this.guardianCounter = 0;
        this.delimiterSize = 0;
        System.arraycopy(this.delimiterEmpty, 0, this.delimiter, 0, this.delimiterEmpty.length);
        try {
            if (this.buffData.isLatestDirectionEqual(-1)) {
                this.setBookMarkInt(this.getBookMarkInt() + (long)this.lastChunksSize);
                this.buffData.reInit();
            }
            this.isBookMarkSet = false;
            byte[] chunk = this.readNextChunk();
            if (this.buffData.getChunksSize() > 0) {
                this.findStartMsgByteChunks(chunk);
                this.findEndMsgByteChunks(chunk);
            }
            this.lastChunksSize = this.buffData.getChunksSize();
        }
        catch (DataException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new FileDataException(this.getSource(), ex);
        }
        return this.buffData.getChunks();
    }

    private byte[] readPreviousInt() throws DataException {
        Object finalChunk = null;
        this.guardianCounter = 0;
        this.delimiterSize = 0;
        System.arraycopy(this.delimiterEmpty, 0, this.delimiter, 0, this.delimiterEmpty.length);
        try {
            block8: {
                block7: {
                    if (this.isBookMarkSet) break block7;
                    if (!this.buffData.isLatestDirectionEqual(1)) break block8;
                }
                this.setBookMarkInt(this.getBookMarkInt() - 1L);
                this.buffData.reInit();
            }
            this.isBookMarkSet = false;
            byte[] chunk = this.readPreviousChunk();
            if (this.buffData.getChunksSize() > 0) {
                this.findStartMsgByteChunks(chunk);
                this.findEndMsgByteChunks(chunk);
            }
            this.lastChunksSize = this.buffData.getChunksSize();
        }
        catch (DataException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new FileDataException(this.getSource(), ex);
        }
        return this.buffData.getChunks();
    }

    private void findStartMsgByteChunks(byte[] chunk) throws Exception {
        int rightDirection = this.buffData.getLatestDirection();
        while (!this.getFormatter().isStartMsg(this.buffData.getChunksSize(), chunk)) {
            int chunkSize = this.buffData.getChunksSize();
            chunk = this.buffData.isLatestDirectionEqual(1) && this.buffData.getChunksSize() < 6 ? this.readNextChunk() : this.readPreviousChunk();
            if (chunk == null || chunkSize == this.buffData.getChunksSize()) break;
        }
        this.buffData.setLatestDirection(rightDirection);
        this.sortingDelimiters();
    }

    private void findEndMsgByteChunks(byte[] chunk) throws Exception {
        int rightDirection = this.buffData.getLatestDirection();
        while (!this.getFormatter().isCompleteMessage(this.buffData.getChunksSize(), chunk, this.delimiterSize, this.delimiter)) {
            int chunkSize = this.buffData.getChunksSize();
            chunk = this.readNextChunk();
            if (chunk == null || chunkSize == this.buffData.getChunksSize()) break;
        }
        this.buffData.setLatestDirection(rightDirection);
    }

    private byte[] readNextChunk() throws Exception {
        boolean isMasked = false;
        if (this.guardianCounter++ >= MAX_GUARDIAN_SIZE) {
            this.closeInt();
            throw new FileDataException(this.getName());
        }
        do {
            if (!this.buffData.hasNext()) {
                if (this.buffData.getChunkSize() > 0) {
                    return this.buffData.getChunk();
                }
                this.fillBufferForward();
            }
            while (this.buffData.hasNext()) {
                byte value = this.buffData.next();
                if (this.buffData.isChunkComplete()) {
                    return this.buffData.getChunk();
                }
                switch (value) {
                    case 92: {
                        isMasked = true;
                        break;
                    }
                    case 35: {
                        if (!isMasked) {
                            this.delimiter[this.delimiterSize++] = this.buffData.getChunkSize() + this.buffData.getChunksSize();
                        }
                        isMasked = false;
                        break;
                    }
                    default: {
                        isMasked = false;
                    }
                }
            }
        } while (!this.isEOFInt());
        return this.buffData.getChunk();
    }

    private byte[] readPreviousChunk() throws Exception {
        boolean isMasked = false;
        if (this.guardianCounter++ >= MAX_GUARDIAN_SIZE) {
            this.closeInt();
            throw new FileDataException(this.getName());
        }
        do {
            if (!this.buffData.hasPrevious()) {
                if (this.buffData.getChunkSize() > 0) {
                    return this.buffData.getChunk();
                }
                this.fillBufferBackward();
            }
            while (this.buffData.hasPrevious()) {
                byte value = this.buffData.previous();
                if (this.buffData.isChunkComplete()) {
                    return this.buffData.getChunk();
                }
                switch (value) {
                    case 92: {
                        isMasked = true;
                        break;
                    }
                    case 35: {
                        if (!isMasked) {
                            this.delimiter[this.delimiterSize++] = (this.buffData.getChunkSize() - 1 + this.buffData.getChunksSize()) * -1;
                        }
                        isMasked = false;
                        this.isDelSorted = false;
                        break;
                    }
                    default: {
                        isMasked = false;
                    }
                }
            }
        } while (!this.isBOFInt());
        return this.buffData.getChunk();
    }

    private void fillBufferForward() throws IOException, DataException {
        if (this.isEOFInt()) {
            return;
        }
        this.buffData.setLatestDirection(1);
        this.buffData.loadBuffer(this.source.read(this.buffData.getBuffHelper(), 0, 8128));
    }

    private void fillBufferBackward() throws IOException, DataException {
        if (this.isBOFInt()) {
            return;
        }
        int tmpBufferSize = 8128;
        long currFilePointer = this.getFilePointer() - (long)this.buffData.getBuffSize();
        if (currFilePointer - (long)tmpBufferSize <= 0L) {
            tmpBufferSize = (int)currFilePointer - this.fileHeaderSize;
            currFilePointer = 0L;
            this.setFilePointer(currFilePointer);
        } else {
            this.setFilePointer(currFilePointer -= 8128L);
        }
        this.buffData.setLatestDirection(-1);
        this.buffData.loadBuffer(this.source.read(this.buffData.getBuffHelper(), 0, tmpBufferSize));
    }

    private void setFilePointer(long value) throws IOException {
        if (value <= 0L) {
            value = this.fileHeaderSize;
        } else if (value >= this.source.length() - (long)this.fileFooterSize) {
            value = this.source.length() - (long)this.fileFooterSize;
        }
        this.source.seek(value);
    }

    private long getFilePointer() throws IOException {
        return this.source.getFilePointer();
    }

    private long getReadPointer() throws IOException {
        return this.source.getFilePointer() - (long)this.buffData.getCurrPos();
    }

    private boolean isBOFInt() throws IOException {
        if (this.source == null) {
            return true;
        }
        return this.getReadPointer() - (long)this.fileHeaderSize <= 0L;
    }

    private boolean isEOFInt() throws IOException {
        if (this.source == null) {
            return true;
        }
        return this.source.length() - (long)this.fileFooterSize == this.getReadPointer();
    }

    private void sortingDelimiters() {
        if (this.isDelSorted) {
            return;
        }
        int i = 0;
        while (i < this.delimiterSize) {
            if (this.delimiter[i] < 0) {
                this.delimiter[i] = this.buffData.getChunksSize() - this.delimiter[i] * -1;
            }
            ++i;
        }
        Arrays.sort(this.delimiter);
        System.arraycopy(this.delimiter, this.delimiter.length - this.delimiterSize, this.delimiter, 0, this.delimiterSize);
    }
}

