/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.FormatterType;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogRecord;
import java.text.ParseException;

public abstract class Formatter {
    private FormatterType mFormatType;
    private String formatterName = "";
    protected static final String EOL = System.getProperty("line.separator");
    static final String NULL_STRING = "<null>";
    static final String EMPTY_STRING = "";

    protected Formatter() {
        String fullClass = this.getClass().getName();
        this.mFormatType = fullClass.equals("com.sap.tc.logging.ListFormatter") ? FormatterType.LISTFORMAT : (fullClass.equals("com.sap.tc.logging.XMLFormatter") ? FormatterType.XMLFORMAT : (fullClass.equals("com.sap.tc.logging.TraceFormatter") ? FormatterType.TRACEFORMAT : (fullClass.equals("com.sap.tc.logging.perf.PerfFormatter") ? FormatterType.PERFFORMAT : new FormatterType(fullClass))));
    }

    protected Formatter(FormatterType aType) {
        this.mFormatType = aType != null ? aType : FormatterType.UNDEFINEDFORMAT;
    }

    public abstract String format(LogRecord var1);

    public String getHeader(Log log) {
        return EMPTY_STRING;
    }

    public String getFooter(Log log) {
        return EMPTY_STRING;
    }

    public final FormatterType getFormatterType() {
        return this.mFormatType;
    }

    public synchronized String getFormatterName() {
        return this.formatterName;
    }

    public synchronized void setFormatterName(String name) {
        this.formatterName = name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Formatter) {
            return this.mFormatType.toString().equalsIgnoreCase(((Formatter)obj).getFormatterType().toString()) & this.formatterName.equalsIgnoreCase(((Formatter)obj).getFormatterName());
        }
        return false;
    }

    public boolean isParsable() {
        return false;
    }

    public LogRecord parseMsg(String completeMsgData) throws ParseException {
        return null;
    }

    public LogRecord parseMsg(byte[] msgChunk) throws ParseException {
        return null;
    }

    public boolean isCompleteMessage(String msg) {
        return false;
    }

    public boolean isStartMessage(String msg) {
        return false;
    }

    public boolean isStartMsg(int messageSize, byte[] message) {
        return true;
    }

    public boolean isCompleteMessage(int messageSize, byte[] message, int delimiterSize, int[] delimiter) {
        return true;
    }
}

