/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.css2;

import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.LengthManager;
import org.apache.batik.css.engine.value.StringMap;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class FontSizeManager
extends LengthManager {
    protected static final StringMap values = new StringMap();

    public boolean isInheritedProperty() {
        return true;
    }

    public String getPropertyName() {
        return "font-size";
    }

    public Value getDefaultValue() {
        return ValueConstants.MEDIUM_VALUE;
    }

    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT_VALUE;
            }
            case 35: {
                String string = lexicalUnit.getStringValue().toLowerCase().intern();
                Object object = values.get(string);
                if (object == null) {
                    throw this.createInvalidIdentifierDOMException(string);
                }
                return (Value)object;
            }
        }
        return super.createValue(lexicalUnit, cSSEngine);
    }

    public Value createStringValue(short s, String string, CSSEngine cSSEngine) throws DOMException {
        if (s != 21) {
            throw this.createInvalidStringTypeDOMException(s);
        }
        Object object = values.get(string.toLowerCase().intern());
        if (object == null) {
            throw this.createInvalidIdentifierDOMException(string);
        }
        return (Value)object;
    }

    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        switch (value.getPrimitiveType()) {
            case 1: 
            case 5: {
                return value;
            }
            case 7: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f = value.getFloatValue();
                return new FloatValue(1, f / cSSContext.getPixelToMillimeters());
            }
            case 6: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f = value.getFloatValue();
                return new FloatValue(1, f * 10.0f / cSSContext.getPixelToMillimeters());
            }
            case 8: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f = value.getFloatValue();
                return new FloatValue(1, f * 25.4f / cSSContext.getPixelToMillimeters());
            }
            case 9: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f = value.getFloatValue();
                return new FloatValue(1, f * 25.4f / (72.0f * cSSContext.getPixelToMillimeters()));
            }
            case 10: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f = value.getFloatValue();
                return new FloatValue(1, f * 25.4f / (6.0f * cSSContext.getPixelToMillimeters()));
            }
            case 3: {
                float f;
                styleMap.putParentRelative(n, true);
                float f2 = value.getFloatValue();
                CSSStylableElement cSSStylableElement2 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
                if (cSSStylableElement2 == null) {
                    CSSContext cSSContext = cSSEngine.getCSSContext();
                    f = cSSContext.getMediumFontSize();
                } else {
                    f = cSSEngine.getComputedStyle(cSSStylableElement2, null, n).getFloatValue();
                }
                return new FloatValue(1, f2 * f);
            }
            case 4: {
                float f;
                styleMap.putParentRelative(n, true);
                float f3 = value.getFloatValue();
                CSSStylableElement cSSStylableElement3 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
                if (cSSStylableElement3 == null) {
                    CSSContext cSSContext = cSSEngine.getCSSContext();
                    f = cSSContext.getMediumFontSize();
                } else {
                    f = cSSEngine.getComputedStyle(cSSStylableElement3, null, n).getFloatValue();
                }
                return new FloatValue(1, f3 * f * 0.5f);
            }
            case 2: {
                float f;
                styleMap.putParentRelative(n, true);
                float f4 = value.getFloatValue();
                CSSStylableElement cSSStylableElement4 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
                if (cSSStylableElement4 == null) {
                    CSSContext cSSContext = cSSEngine.getCSSContext();
                    f = cSSContext.getMediumFontSize();
                } else {
                    f = cSSEngine.getComputedStyle(cSSStylableElement4, null, n).getFloatValue();
                }
                return new FloatValue(1, f4 * f / 100.0f);
            }
        }
        if (value == ValueConstants.LARGER_VALUE) {
            float f;
            styleMap.putParentRelative(n, true);
            CSSStylableElement cSSStylableElement5 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
            if (cSSStylableElement5 == null) {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                f = cSSContext.getMediumFontSize();
            } else {
                f = cSSEngine.getComputedStyle(cSSStylableElement5, null, n).getFloatValue();
            }
            return new FloatValue(1, f * 1.2f);
        }
        if (value == ValueConstants.SMALLER_VALUE) {
            float f;
            styleMap.putParentRelative(n, true);
            CSSStylableElement cSSStylableElement6 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
            if (cSSStylableElement6 == null) {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                f = cSSContext.getMediumFontSize();
            } else {
                f = cSSEngine.getComputedStyle(cSSStylableElement6, null, n).getFloatValue();
            }
            return new FloatValue(1, f / 1.2f);
        }
        CSSContext cSSContext = cSSEngine.getCSSContext();
        float f = cSSContext.getMediumFontSize();
        String string2 = value.getStringValue();
        block11 : switch (string2.charAt(0)) {
            case 'm': {
                break;
            }
            case 's': {
                f = (float)((double)f / 1.2);
                break;
            }
            case 'l': {
                f = (float)((double)f * 1.2);
                break;
            }
            default: {
                switch (string2.charAt(1)) {
                    case 'x': {
                        switch (string2.charAt(3)) {
                            case 's': {
                                f = (float)((double)f / 1.2 / 1.2 / 1.2);
                                break block11;
                            }
                        }
                        f = (float)((double)f * 1.2 * 1.2 * 1.2);
                        break block11;
                    }
                }
                switch (string2.charAt(2)) {
                    case 's': {
                        f = (float)((double)f / 1.2 / 1.2);
                        break block11;
                    }
                }
                f = (float)((double)f * 1.2 * 1.2);
            }
        }
        return new FloatValue(1, f);
    }

    protected int getOrientation() {
        return 1;
    }

    static {
        values.put("large", ValueConstants.LARGE_VALUE);
        values.put("larger", ValueConstants.LARGER_VALUE);
        values.put("medium", ValueConstants.MEDIUM_VALUE);
        values.put("small", ValueConstants.SMALL_VALUE);
        values.put("smaller", ValueConstants.SMALLER_VALUE);
        values.put("x-large", ValueConstants.X_LARGE_VALUE);
        values.put("x-small", ValueConstants.X_SMALL_VALUE);
        values.put("xx-large", ValueConstants.XX_LARGE_VALUE);
        values.put("xx-small", ValueConstants.XX_SMALL_VALUE);
    }
}

