/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.cxm;

import com.sap.tc.col.cxa.IEventCallback;
import com.sap.tc.col.cxa.ResourceParameters;
import com.sap.tc.col.cxm.ContextMonitor;
import com.sap.tc.col.cxm.IResourceInstance;
import com.sap.tc.col.cxm.IResourceProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class InternalContext {
    String nameSession = null;
    HashMap mapSlots = new HashMap(64);
    HashMap mapResources = new HashMap(256);
    HashMap mapProvider = new HashMap(32);
    HashMap mapEvents = new HashMap(32);
    boolean active = false;

    InternalContext(String nameSession) {
        this.nameSession = nameSession;
    }

    void destroy() {
        Iterator iterator1 = this.mapResources.values().iterator();
        if (iterator1 != null) {
            while (iterator1.hasNext()) {
                IResourceInstance resource = (IResourceInstance)iterator1.next();
                if (resource == null || resource.isDisposed()) continue;
                resource.dispose();
            }
        }
        this.mapResources.clear();
        Iterator iterator2 = this.mapProvider.values().iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                IResourceProvider provider = (IResourceProvider)iterator2.next();
                if (provider == null) continue;
                provider.destroy();
            }
        }
        this.mapProvider.clear();
        this.mapSlots.clear();
        this.deactivate();
    }

    synchronized void activate() {
        if (this.active) {
            System.out.println("waiting ...");
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("running ...");
        }
        if (this.active) {
            System.out.println("big big problem ...");
        }
        this.active = true;
    }

    synchronized void deactivate() {
        this.active = false;
        this.notify();
    }

    public boolean createSlot(String name, Object value) {
        if (!this.active) {
            return false;
        }
        if (this.mapSlots.containsKey(name)) {
            return false;
        }
        this.mapSlots.put(name, value);
        return true;
    }

    public void setSlotData(String name, Object value) {
        if (!this.active) {
            return;
        }
        this.mapSlots.put(name, value);
    }

    public Object getSlotData(String name) {
        if (!this.active) {
            return null;
        }
        return this.mapSlots.get(name);
    }

    public void removeSlot(String name) {
        if (!this.active) {
            return;
        }
        this.mapSlots.remove(name);
    }

    public Object getResource(String type, ResourceParameters parameters) {
        IResourceInstance resource;
        if (!this.active) {
            return null;
        }
        IResourceProvider provider = (IResourceProvider)this.mapProvider.get(type);
        if (provider == null) {
            provider = ContextMonitor.getResourceProvider(type);
            if (provider == null) {
                return null;
            }
            this.mapProvider.put(type, provider);
        }
        if ((resource = provider.getResource(parameters)) != null) {
            this.mapResources.put(resource, resource);
        }
        return resource;
    }

    public Object getResource(String type, String parameter) {
        IResourceInstance resource;
        if (!this.active) {
            return null;
        }
        IResourceProvider provider = (IResourceProvider)this.mapProvider.get(type);
        if (provider == null) {
            provider = ContextMonitor.getResourceProvider(type);
            if (provider == null) {
                return null;
            }
            this.mapProvider.put(type, provider);
        }
        if ((resource = provider.getResource(parameter)) != null) {
            this.mapResources.put(resource, resource);
        }
        return resource;
    }

    public boolean disposeResource(Object resource) {
        IResourceInstance instance = (IResourceInstance)this.mapResources.get(resource);
        if (instance == null) {
            return false;
        }
        instance.dispose();
        this.mapResources.remove(instance);
        return true;
    }

    public void subscribeEvent(String event, IEventCallback callback) {
        ArrayList<IEventCallback> subscribers = (ArrayList<IEventCallback>)this.mapEvents.get(event);
        if (subscribers == null) {
            subscribers = new ArrayList<IEventCallback>();
            this.mapEvents.put(event, subscribers);
        }
        subscribers.add(callback);
    }

    public void unsubscribeEvent(String event, IEventCallback callback) {
        ArrayList subscribers = (ArrayList)this.mapEvents.get(event);
        if (subscribers == null) {
            return;
        }
        int i = 0;
        while (i < subscribers.size()) {
            if (subscribers.get(i) == callback) {
                subscribers.remove(i);
                return;
            }
            ++i;
        }
    }

    public void raiseEvent(String event, Object param) {
        ArrayList subscribers = (ArrayList)this.mapEvents.get(event);
        if (subscribers == null) {
            return;
        }
        int i = 0;
        while (i < subscribers.size()) {
            IEventCallback subscriber = (IEventCallback)subscribers.get(i);
            if (subscriber != null) {
                subscriber.onEvent(event, param);
            }
            ++i;
        }
    }
}

