/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.cxm;

import com.sap.tc.col.cxa.IEventCallback;
import com.sap.tc.col.cxm.IResourceProvider;
import com.sap.tc.col.cxm.InternalContext;
import java.util.HashMap;
import java.util.Iterator;

public class ContextMonitor {
    static ContextMonitor globalMonitor = new ContextMonitor();
    HashMap mapContexts = new HashMap(32);
    HashMap mapPClasses = new HashMap(32);
    ThreadLocal tlsTStorage = new ThreadLocal();

    private ContextMonitor() {
    }

    public static synchronized void createContext(String nameSession) {
        if (ContextMonitor.globalMonitor.mapContexts.get(nameSession) != null) {
            return;
        }
        InternalContext context = new InternalContext(nameSession);
        if (context == null) {
            return;
        }
        ContextMonitor.globalMonitor.mapContexts.put(nameSession, context);
    }

    public static synchronized void destroyContext(String nameSession) {
        InternalContext context = (InternalContext)ContextMonitor.globalMonitor.mapContexts.get(nameSession);
        if (context == null) {
            return;
        }
        context.destroy();
        ContextMonitor.globalMonitor.mapContexts.remove(nameSession);
    }

    public static synchronized void cleanup() {
        Iterator iterator = ContextMonitor.globalMonitor.mapContexts.values().iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                InternalContext context = (InternalContext)iterator.next();
                if (context == null) continue;
                context.destroy();
            }
        }
        ContextMonitor.globalMonitor.mapContexts.clear();
    }

    public static synchronized void activateContext(String nameSession) {
        InternalContext context = (InternalContext)ContextMonitor.globalMonitor.mapContexts.get(nameSession);
        if (context == null) {
            return;
        }
        context.activate();
        ContextMonitor.globalMonitor.tlsTStorage.set(context);
    }

    public static void deactivateContext() {
        InternalContext context = ContextMonitor.getActiveContext();
        if (context == null) {
            return;
        }
        context.deactivate();
        ContextMonitor.globalMonitor.tlsTStorage.set(null);
    }

    public static InternalContext getActiveContext() {
        return (InternalContext)ContextMonitor.globalMonitor.tlsTStorage.get();
    }

    public static synchronized void setResourceProvider(String nameResource, String nameClass) {
        ContextMonitor.globalMonitor.mapPClasses.put(nameResource, nameClass);
    }

    static synchronized String getResourceProviderClass(String type) {
        String nameClass = (String)ContextMonitor.globalMonitor.mapPClasses.get(type);
        return nameClass;
    }

    static IResourceProvider getResourceProvider(String type) {
        String nameClass = ContextMonitor.getResourceProviderClass(type);
        if (nameClass == null) {
            return null;
        }
        try {
            Class<?> classProvider = Class.forName(nameClass);
            IResourceProvider provider = (IResourceProvider)classProvider.newInstance();
            return provider;
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        return null;
    }

    public static void subscribeEvent(String event, IEventCallback callback) {
        InternalContext context = ContextMonitor.getActiveContext();
        if (context == null) {
            return;
        }
        context.subscribeEvent(event, callback);
    }

    public static void unsubscribeEvent(String event, IEventCallback callback) {
        InternalContext context = ContextMonitor.getActiveContext();
        if (context == null) {
            return;
        }
        context.unsubscribeEvent(event, callback);
    }

    public static void raiseEvent(String event, Object param) {
        InternalContext context = ContextMonitor.getActiveContext();
        if (context == null) {
            return;
        }
        context.raiseEvent(event, param);
    }
}

