/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.result.model;

import com.sap.ip.bi.sdk.dac.result.IBIAxisCursor;
import com.sap.ip.bi.sdk.dac.result.IBICursorColumn;
import com.sap.ip.bi.sdk.dac.result.IBIDataSet;
import com.sap.ip.bi.sdk.dac.result.IBIDimensionAttributeCursor;
import com.sap.ip.bi.sdk.dac.result.IBIDimensionCursor;
import com.sap.ip.bi.sdk.dac.result.model.BICellData;
import com.sap.ip.bi.sdk.dac.result.model.BITableItem;
import com.sap.ip.bi.sdk.exception.BISQLException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class BIDataSetTableModel {
    public static final int SECTION_CELLS = 0;
    public static final int SECTION_COLUMN_HEADERS = 1;
    public static final int SECTION_ROW_HEADERS = 2;
    public static final int SECTION_LABELS = 3;
    private static final int MEMBER_CAPTION = -1;
    private IBIDataSet _dataset = null;
    private IBIAxisCursor _cols = null;
    private IBIAxisCursor _rows = null;
    private int _dimCols = 0;
    private int _dimRows = 0;
    private int[] _colPropCount = null;
    private int[] _rowPropCount = null;
    private int _nHeaderCols = 0;
    private int _nHeaderRows = 0;
    private int _nTotalCols = 0;
    private int _nTotalRows = 0;
    private int _actualCol = 0;
    private int _actualRow = 0;
    private int[][] _colInfo = null;
    private int[][] _rowInfo = null;
    private boolean _isDisplayingHierarchy;
    private int[][] _colLvlInfo = null;
    private int[][] _rowLvlInfo = null;
    private static final Location loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$result$model$BIDataSetTableModel == null ? (class$com$sap$ip$bi$sdk$dac$result$model$BIDataSetTableModel = BIDataSetTableModel.class$("com.sap.ip.bi.sdk.dac.result.model.BIDataSetTableModel")) : class$com$sap$ip$bi$sdk$dac$result$model$BIDataSetTableModel).getName());
    private static final Category cat = BILoggingSetup.QUERY.getCategory();
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$result$model$BIDataSetTableModel;

    public BIDataSetTableModel(IBIDataSet dataset, boolean isDisplayingHierarchy) throws BISQLException {
        this._dataset = dataset;
        this._isDisplayingHierarchy = isDisplayingHierarchy;
        try {
            IBIDimensionCursor dim;
            Iterator h;
            if (dataset.getAxisCursor().size() == 0) {
                this._cols = null;
                this._rows = null;
                this._isDisplayingHierarchy = false;
                this._nTotalCols = 1;
                this._nTotalRows = 1;
                this._nHeaderCols = 0;
                this._nHeaderRows = 0;
                return;
            }
            if (dataset.getAxisCursor().size() == 1) {
                this._cols = dataset.getAxisCursor(0);
                this._rows = null;
                this._isDisplayingHierarchy = false;
            } else {
                this._cols = dataset.getAxisCursor(0);
                this._rows = dataset.getAxisCursor(1);
            }
            int colNum = 0;
            int rowNum = 0;
            this._cols.last();
            colNum = this._cols.getRow();
            this._nHeaderRows = this._dimCols = this._cols.getDimensionCursor().size();
            if (this._rows != null) {
                this._rows.last();
                rowNum = this._rows.getRow();
                this._nHeaderCols = this._dimRows = this._rows.getDimensionCursor().size();
            }
            this._colPropCount = new int[this._dimCols];
            this._rowPropCount = new int[this._dimRows];
            int dimNum = 0;
            if (this._rows != null) {
                h = this._rows.getDimensionCursor().iterator();
                while (h.hasNext()) {
                    dim = (IBIDimensionCursor)h.next();
                    this._rowPropCount[dimNum] = dim.getDimensionAttributeCursor().size();
                    this._nHeaderCols += this._rowPropCount[dimNum];
                    ++dimNum;
                }
            }
            dimNum = 0;
            h = this._cols.getDimensionCursor().iterator();
            while (h.hasNext()) {
                dim = (IBIDimensionCursor)h.next();
                this._colPropCount[dimNum] = dim.getDimensionAttributeCursor().size();
                this._nHeaderRows += this._colPropCount[dimNum];
                ++dimNum;
            }
            this._colLvlInfo = this.getLevelInfo(this._dimCols, this._cols, null);
            if (this._rows != null) {
                this._rowLvlInfo = this.getLevelInfo(this._dimRows, this._rows, null);
            }
            if (this._isDisplayingHierarchy) {
                int i = 0;
                while (i < this._dimCols) {
                    this._nHeaderRows += this._colLvlInfo[i][1];
                    ++i;
                }
            }
            if (this._nHeaderCols > 0) {
                this._colInfo = new int[this._nHeaderCols][2];
                this._nTotalRows = rowNum + this._nHeaderRows;
            }
            if (this._nHeaderRows > 0) {
                this._rowInfo = new int[this._nHeaderRows][2];
                this._nTotalCols = colNum + this._nHeaderCols;
            }
            if (this._nTotalRows == 0) {
                this._nTotalRows = 2;
            }
            if (this._nTotalCols == 0) {
                this._nTotalCols = 1;
                this._nTotalRows = 1;
            }
            loc.debugT(cat, "_cols.getMetaData().getColumnCount()=" + this._cols.getMetaData().getColumnCount());
            if (this._rows != null) {
                loc.debugT(cat, "_rows.getMetaData().getColumnCount()=" + this._rows.getMetaData().getColumnCount());
            }
            loc.debugT(cat, "TotalCols = " + this._nTotalCols);
            loc.debugT(cat, "TotalRows = " + this._nTotalRows);
            loc.debugT(cat, "HeaderCols = " + this._nHeaderCols);
            loc.debugT(cat, "HeaderRows = " + this._nHeaderRows);
        }
        catch (SQLException e) {
            cat.errorT(loc, "Error in Dataset" + e.toString());
            throw new BISQLException(Locale.getDefault(), (Throwable)e);
        }
        this._rowInfo = this.setHeaderPositionInfo(this._rowInfo, this._colPropCount, this._dimCols, true);
        this._colInfo = this.setHeaderPositionInfo(this._colInfo, this._rowPropCount, this._dimRows, false);
    }

    private int[][] getLevelInfo(int dimensionsOnAxis, IBIAxisCursor axisCursor, int[] dimPropertyCount) throws SQLException {
        int[][] lvlInfo = new int[dimensionsOnAxis][4];
        int lvl = 0;
        int accumulatedHeaderPositions = 0;
        IBIDimensionCursor dim = null;
        Object dimCursorIterator = null;
        int i = 0;
        while (i < dimensionsOnAxis) {
            lvlInfo[i][3] = accumulatedHeaderPositions;
            axisCursor.beforeFirst();
            while (axisCursor.next()) {
                dim = (IBIDimensionCursor)axisCursor.getDimensionCursor().get(i);
                lvl = dim.getInt(IBICursorColumn.LEVEL_NUMBER.toString());
                if (axisCursor.isFirst()) {
                    lvlInfo[i][0] = lvl;
                }
                lvlInfo[i][0] = lvl < lvlInfo[i][0] ? lvl : lvlInfo[i][0];
                int n = lvlInfo[i][1] = lvl > lvlInfo[i][1] ? lvl : lvlInfo[i][1];
            }
            lvlInfo[i][1] = lvlInfo[i][1] - lvlInfo[i][0];
            lvlInfo[i][2] = lvlInfo[i][1] + 1;
            accumulatedHeaderPositions += lvlInfo[i][2];
            ++i;
        }
        return lvlInfo;
    }

    private int[][] setHeaderPositionInfo(int[][] positionInfo, int[] dimensionPropertyCount, int dimensionsOnAxis, boolean isColumnHeaderInfo) {
        int position = 0;
        int i = 0;
        while (i < dimensionsOnAxis) {
            int j;
            positionInfo[position][0] = i;
            positionInfo[position++][1] = -1;
            if (isColumnHeaderInfo && this._isDisplayingHierarchy) {
                j = 0;
                while (j < this._colLvlInfo[i][1]) {
                    positionInfo[position][0] = i;
                    positionInfo[position++][1] = -1;
                    ++j;
                }
            }
            j = 0;
            while (j < dimensionPropertyCount[i]) {
                positionInfo[position][0] = i;
                positionInfo[position++][1] = j++;
            }
            ++i;
        }
        return positionInfo;
    }

    private int getSection(int rowIndex, int columnIndex) {
        if (rowIndex < this._nHeaderRows && columnIndex >= this._nHeaderCols) {
            return 1;
        }
        if (columnIndex < this._nHeaderCols && rowIndex >= this._nHeaderRows) {
            return 2;
        }
        if (rowIndex >= this._nHeaderRows && columnIndex >= this._nHeaderCols) {
            return 0;
        }
        return 3;
    }

    public int getColumnCount() {
        return this._nTotalCols;
    }

    public int getRowCount() {
        return this._nTotalRows;
    }

    public BITableItem getValueAt(int rowIndex, int colIndex) throws BISQLException {
        this._actualCol = colIndex - this._nHeaderCols;
        this._actualRow = rowIndex - this._nHeaderRows;
        IBIDimensionCursor dim = null;
        Iterator dimCursorIterator = null;
        try {
            switch (this.getSection(rowIndex, colIndex)) {
                case 0: {
                    if (this._cols != null) {
                        this._cols.absolute(this._actualCol + 1);
                    }
                    if (this._rows != null) {
                        this._rows.absolute(this._actualRow + 1);
                    }
                    String formattedValue = "";
                    Object value = null;
                    int type = 0;
                    try {
                        formattedValue = this._dataset.getString(IBICursorColumn.FORMATTED_VALUE.toString());
                        type = this._dataset.getInt(IBICursorColumn.DATATYPE.toString());
                        value = this._dataset.getObject(IBICursorColumn.VALUE.toString());
                    }
                    catch (SQLException e) {
                        formattedValue = "";
                        value = "";
                        type = 0;
                    }
                    return new BITableItem(0, new BICellData(formattedValue, type, value));
                }
                case 2: {
                    this._rows.absolute(this._actualRow + 1);
                    dimCursorIterator = this._rows.getDimensionCursor().iterator();
                    int i = 0;
                    while (dimCursorIterator.hasNext()) {
                        dim = (IBIDimensionCursor)dimCursorIterator.next();
                        if (i == this._colInfo[colIndex][0]) break;
                        ++i;
                    }
                    switch (this._colInfo[colIndex][1]) {
                        case -1: {
                            return new BITableItem(2, dim, this._rowLvlInfo[this._colInfo[colIndex][0]]);
                        }
                    }
                    List rc = dim.getDimensionAttributeCursor();
                    Iterator rci = rc.iterator();
                    IBIDimensionAttributeCursor ac = null;
                    int j = 0;
                    while (rci.hasNext()) {
                        ac = (IBIDimensionAttributeCursor)rci.next();
                        if (j == this._colInfo[colIndex][1]) break;
                        ++j;
                    }
                    return new BITableItem(2, ac.getString(IBICursorColumn.VALUE.toString()), this._rowLvlInfo[this._colInfo[colIndex][0]]);
                }
                case 1: {
                    this._cols.absolute(this._actualCol + 1);
                    dimCursorIterator = this._cols.getDimensionCursor().iterator();
                    int i = 0;
                    while (dimCursorIterator.hasNext()) {
                        dim = (IBIDimensionCursor)dimCursorIterator.next();
                        if (i == this._rowInfo[rowIndex][0]) break;
                        ++i;
                    }
                    switch (this._rowInfo[rowIndex][1]) {
                        case -1: {
                            return new BITableItem(1, dim, this._colLvlInfo[this._rowInfo[rowIndex][0]]);
                        }
                    }
                    List rc = dim.getDimensionAttributeCursor();
                    Iterator rci = rc.iterator();
                    IBIDimensionAttributeCursor ac = null;
                    int j = 0;
                    while (rci.hasNext()) {
                        ac = (IBIDimensionAttributeCursor)rci.next();
                        if (j == this._rowInfo[rowIndex][1]) break;
                        ++j;
                    }
                    return new BITableItem(2, ac.getString(IBICursorColumn.VALUE.toString()), this._colLvlInfo[this._rowInfo[rowIndex][0]]);
                }
                case 3: {
                    return new BITableItem(3, "");
                }
            }
        }
        catch (SQLException e) {
            cat.errorT(loc, "getValueAt: " + e.getMessage());
            throw new BISQLException(Locale.getDefault(), (Throwable)e);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

