/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.result.impl.filter;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.IBISynchronizedResultSetFilter;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.exception.BISQLException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;

public class BIRemappingResultSetFilter
implements IBISynchronizedResultSetFilter {
    private static final String FILTER_NAME = "RemappingResultSetFilter";
    private static final String FILTER_DESCRIPTION = "Subset of existing ResultSet columns based on index-map";
    private IBIResultSet source = null;
    private ResultSetMetaData resultMeta = null;
    private final int[] indexMap;
    private int[] reverseMap = null;
    private final String prefix;
    protected IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;

    protected BIRemappingResultSetFilter() {
        this.indexMap = new int[0];
        this.prefix = null;
    }

    public BIRemappingResultSetFilter(IBIResultSet source, String prefix, int[] indexMap) throws SQLException {
        if (source == null) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2016");
        }
        this.source = source;
        this.indexMap = indexMap;
        this.prefix = prefix;
        this.resultMeta = new BIRemappingResultSetFilterMetaData();
        this.checkRemapping();
    }

    public BIRemappingResultSetFilter(IBIConnectionInfo connectionInfo, IBIResultSet source, String prefix, int[] indexMap) throws SQLException {
        this.connectionInfo = connectionInfo;
        this.assertConnectionInfo();
        if (source == null) {
            throw new BISQLException(connectionInfo.getLocale(), "sdk.dac.rel.result_2016");
        }
        this.source = source;
        this.indexMap = indexMap;
        this.prefix = prefix;
        this.resultMeta = new BIRemappingResultSetFilterMetaData();
        this.checkRemapping();
    }

    public String getFilterName() {
        return FILTER_NAME;
    }

    public String getFilterDescription() {
        return FILTER_DESCRIPTION;
    }

    public void setSourceResultSet(IBIResultSet source) throws SQLException {
        if (source == null) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2016");
        }
        this.source = source;
        this.resultMeta = new BIRemappingResultSetFilterMetaData();
        this.checkRemapping();
    }

    public void setAdditionalDataResultSet(IBIResultSet additional) throws SQLException {
        if (additional == null) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2016");
        }
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void setSynchronized(boolean synchronize) throws SQLException {
        this.source.setSynchronized(synchronize);
    }

    public boolean isSynchronized() throws SQLException {
        return this.source.isSynchronized();
    }

    public void synchronize() throws SQLException {
        this.source.synchronize();
    }

    public boolean synchAbsolute(int arg0) throws SQLException {
        return this.source.synchAbsolute(arg0);
    }

    public boolean synchRelative(int arg0) throws SQLException {
        return this.source.synchRelative(arg0);
    }

    public void synchBeforeFirst() throws SQLException {
        this.source.synchBeforeFirst();
    }

    public void synchAfterLast() throws SQLException {
        this.source.synchAfterLast();
    }

    public int synchGetRow() throws SQLException {
        return this.source.synchGetRow();
    }

    public int synchGetColumnCount() throws SQLException {
        return this.indexMap.length - 1;
    }

    public int synchGetRowCount() throws SQLException {
        return this.source.synchGetRowCount();
    }

    public boolean next() throws SQLException {
        return this.source.next();
    }

    public void close() throws SQLException {
        this.source.close();
    }

    public boolean wasNull() throws SQLException {
        return this.source.wasNull();
    }

    public String getString(int arg0) throws SQLException {
        return this.source.getString(this.remap(arg0));
    }

    public boolean getBoolean(int arg0) throws SQLException {
        return this.source.getBoolean(this.remap(arg0));
    }

    public byte getByte(int arg0) throws SQLException {
        return this.source.getByte(this.remap(arg0));
    }

    public short getShort(int arg0) throws SQLException {
        return this.source.getShort(this.remap(arg0));
    }

    public int getInt(int arg0) throws SQLException {
        return this.source.getInt(this.remap(arg0));
    }

    public long getLong(int arg0) throws SQLException {
        return this.source.getLong(this.remap(arg0));
    }

    public float getFloat(int arg0) throws SQLException {
        return this.source.getFloat(this.remap(arg0));
    }

    public double getDouble(int arg0) throws SQLException {
        return this.source.getDouble(this.remap(arg0));
    }

    public BigDecimal getBigDecimal(int arg0, int arg1) throws SQLException {
        return this.source.getBigDecimal(this.remap(arg0));
    }

    public byte[] getBytes(int arg0) throws SQLException {
        return this.source.getBytes(this.remap(arg0));
    }

    public Date getDate(int arg0) throws SQLException {
        return this.source.getDate(this.remap(arg0));
    }

    public Time getTime(int arg0) throws SQLException {
        return this.source.getTime(this.remap(arg0));
    }

    public Timestamp getTimestamp(int arg0) throws SQLException {
        return this.source.getTimestamp(this.remap(arg0));
    }

    public InputStream getAsciiStream(int arg0) throws SQLException {
        return this.source.getAsciiStream(this.remap(arg0));
    }

    public InputStream getUnicodeStream(int arg0) throws SQLException {
        return this.source.getUnicodeStream(this.remap(arg0));
    }

    public InputStream getBinaryStream(int arg0) throws SQLException {
        return this.source.getBinaryStream(this.remap(arg0));
    }

    public String getString(String arg0) throws SQLException {
        return this.source.getString(this.addNamePrefix(arg0));
    }

    public boolean getBoolean(String arg0) throws SQLException {
        return this.source.getBoolean(this.addNamePrefix(arg0));
    }

    public byte getByte(String arg0) throws SQLException {
        return this.source.getByte(this.addNamePrefix(arg0));
    }

    public short getShort(String arg0) throws SQLException {
        return this.source.getShort(this.addNamePrefix(arg0));
    }

    public int getInt(String arg0) throws SQLException {
        return this.source.getInt(this.addNamePrefix(arg0));
    }

    public long getLong(String arg0) throws SQLException {
        return this.source.getLong(this.addNamePrefix(arg0));
    }

    public float getFloat(String arg0) throws SQLException {
        return this.source.getFloat(this.addNamePrefix(arg0));
    }

    public double getDouble(String arg0) throws SQLException {
        return this.source.getDouble(this.addNamePrefix(arg0));
    }

    public BigDecimal getBigDecimal(String arg0, int arg1) throws SQLException {
        return this.source.getBigDecimal(this.addNamePrefix(arg0), arg1);
    }

    public byte[] getBytes(String arg0) throws SQLException {
        return this.source.getBytes(this.addNamePrefix(arg0));
    }

    public Date getDate(String arg0) throws SQLException {
        return this.source.getDate(this.addNamePrefix(arg0));
    }

    public Time getTime(String arg0) throws SQLException {
        return this.source.getTime(this.addNamePrefix(arg0));
    }

    public Timestamp getTimestamp(String arg0) throws SQLException {
        return this.source.getTimestamp(this.addNamePrefix(arg0));
    }

    public InputStream getAsciiStream(String arg0) throws SQLException {
        return this.source.getAsciiStream(this.addNamePrefix(arg0));
    }

    public InputStream getUnicodeStream(String arg0) throws SQLException {
        return this.source.getUnicodeStream(this.addNamePrefix(arg0));
    }

    public InputStream getBinaryStream(String arg0) throws SQLException {
        return this.source.getBinaryStream(this.addNamePrefix(arg0));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.source.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.source.clearWarnings();
    }

    public String getCursorName() throws SQLException {
        return this.source.getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultMeta;
    }

    public Object getObject(int arg0) throws SQLException {
        return this.source.getObject(this.remap(arg0));
    }

    public Object getObject(String arg0) throws SQLException {
        return this.source.getObject(this.addNamePrefix(arg0));
    }

    public int findColumn(String arg0) throws SQLException {
        return this.reverseMap(this.source.findColumn(this.addNamePrefix(arg0)));
    }

    public Reader getCharacterStream(int arg0) throws SQLException {
        return this.source.getCharacterStream(this.remap(arg0));
    }

    public Reader getCharacterStream(String arg0) throws SQLException {
        return this.source.getCharacterStream(this.addNamePrefix(arg0));
    }

    public BigDecimal getBigDecimal(int arg0) throws SQLException {
        return this.source.getBigDecimal(this.remap(arg0));
    }

    public BigDecimal getBigDecimal(String arg0) throws SQLException {
        return this.source.getBigDecimal(this.addNamePrefix(arg0));
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.source.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        return this.source.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        return this.source.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.source.isLast();
    }

    public void beforeFirst() throws SQLException {
        this.source.beforeFirst();
    }

    public void afterLast() throws SQLException {
        this.source.afterLast();
    }

    public boolean first() throws SQLException {
        return this.source.first();
    }

    public boolean last() throws SQLException {
        return this.source.last();
    }

    public int getRow() throws SQLException {
        return this.source.getRow();
    }

    public boolean absolute(int arg0) throws SQLException {
        return this.source.absolute(this.remap(arg0));
    }

    public boolean relative(int arg0) throws SQLException {
        return this.source.relative(this.remap(arg0));
    }

    public boolean previous() throws SQLException {
        return this.source.previous();
    }

    public void setFetchDirection(int arg0) throws SQLException {
        this.source.setFetchDirection(this.remap(arg0));
    }

    public int getFetchDirection() throws SQLException {
        return this.source.getFetchDirection();
    }

    public void setFetchSize(int arg0) throws SQLException {
        this.source.setFetchSize(arg0);
    }

    public int getFetchSize() throws SQLException {
        return this.source.getFetchSize();
    }

    public int getType() throws SQLException {
        return this.source.getType();
    }

    public int getConcurrency() throws SQLException {
        return this.source.getType();
    }

    public boolean rowUpdated() throws SQLException {
        return this.source.rowUpdated();
    }

    public boolean rowInserted() throws SQLException {
        return this.source.rowInserted();
    }

    public boolean rowDeleted() throws SQLException {
        return this.source.rowDeleted();
    }

    public void updateNull(int arg0) throws SQLException {
        this.source.updateNull(this.remap(arg0));
    }

    public void updateBoolean(int arg0, boolean arg1) throws SQLException {
        this.source.updateBoolean(this.remap(arg0), arg1);
    }

    public void updateByte(int arg0, byte arg1) throws SQLException {
        this.source.updateByte(this.remap(arg0), arg1);
    }

    public void updateShort(int arg0, short arg1) throws SQLException {
        this.source.updateShort(this.remap(arg0), arg1);
    }

    public void updateInt(int arg0, int arg1) throws SQLException {
        this.source.updateInt(this.remap(arg0), arg1);
    }

    public void updateLong(int arg0, long arg1) throws SQLException {
        this.source.updateLong(this.remap(arg0), arg1);
    }

    public void updateFloat(int arg0, float arg1) throws SQLException {
        this.source.updateFloat(this.remap(arg0), arg1);
    }

    public void updateDouble(int arg0, double arg1) throws SQLException {
        this.source.updateDouble(this.remap(arg0), arg1);
    }

    public void updateBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        this.source.updateBigDecimal(this.remap(arg0), arg1);
    }

    public void updateString(int arg0, String arg1) throws SQLException {
        this.source.updateString(this.remap(arg0), arg1);
    }

    public void updateBytes(int arg0, byte[] arg1) throws SQLException {
        this.source.updateBytes(this.remap(arg0), arg1);
    }

    public void updateDate(int arg0, Date arg1) throws SQLException {
        this.source.updateDate(this.remap(arg0), arg1);
    }

    public void updateTime(int arg0, Time arg1) throws SQLException {
        this.source.updateTime(arg0, arg1);
    }

    public void updateTimestamp(int arg0, Timestamp arg1) throws SQLException {
        this.source.updateTimestamp(this.remap(arg0), arg1);
    }

    public void updateAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.source.updateAsciiStream(this.remap(arg0), arg1, arg2);
    }

    public void updateBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.source.updateBinaryStream(this.remap(arg0), arg1, arg2);
    }

    public void updateCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        this.source.updateCharacterStream(this.remap(arg0), arg1, arg2);
    }

    public void updateObject(int arg0, Object arg1, int arg2) throws SQLException {
        this.source.updateObject(this.remap(arg0), arg1, arg2);
    }

    public void updateObject(int arg0, Object arg1) throws SQLException {
        this.source.updateObject(this.remap(arg0), arg1);
    }

    public void updateNull(String arg0) throws SQLException {
        this.source.updateNull(this.addNamePrefix(arg0));
    }

    public void updateBoolean(String arg0, boolean arg1) throws SQLException {
        this.source.updateBoolean(this.addNamePrefix(arg0), arg1);
    }

    public void updateByte(String arg0, byte arg1) throws SQLException {
        this.source.updateByte(this.addNamePrefix(arg0), arg1);
    }

    public void updateShort(String arg0, short arg1) throws SQLException {
        this.source.updateShort(this.addNamePrefix(arg0), arg1);
    }

    public void updateInt(String arg0, int arg1) throws SQLException {
        this.source.updateInt(this.addNamePrefix(arg0), arg1);
    }

    public void updateLong(String arg0, long arg1) throws SQLException {
        this.source.updateLong(this.addNamePrefix(arg0), arg1);
    }

    public void updateFloat(String arg0, float arg1) throws SQLException {
        this.source.updateFloat(this.addNamePrefix(arg0), arg1);
    }

    public void updateDouble(String arg0, double arg1) throws SQLException {
        this.source.updateDouble(this.addNamePrefix(arg0), arg1);
    }

    public void updateBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
        this.source.updateBigDecimal(this.addNamePrefix(arg0), arg1);
    }

    public void updateString(String arg0, String arg1) throws SQLException {
        this.source.updateString(this.addNamePrefix(arg0), arg1);
    }

    public void updateBytes(String arg0, byte[] arg1) throws SQLException {
        this.source.updateBytes(this.addNamePrefix(arg0), arg1);
    }

    public void updateDate(String arg0, Date arg1) throws SQLException {
        this.source.updateDate(this.addNamePrefix(arg0), arg1);
    }

    public void updateTime(String arg0, Time arg1) throws SQLException {
        this.source.updateTime(this.addNamePrefix(arg0), arg1);
    }

    public void updateTimestamp(String arg0, Timestamp arg1) throws SQLException {
        this.source.updateTimestamp(this.addNamePrefix(arg0), arg1);
    }

    public void updateAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        this.source.updateAsciiStream(this.addNamePrefix(arg0), arg1, arg2);
    }

    public void updateBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        this.source.updateBinaryStream(this.addNamePrefix(arg0), arg1, arg2);
    }

    public void updateCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException {
        this.source.updateCharacterStream(this.addNamePrefix(arg0), arg1, arg2);
    }

    public void updateObject(String arg0, Object arg1, int arg2) throws SQLException {
        this.source.updateObject(this.addNamePrefix(arg0), arg1, arg2);
    }

    public void updateObject(String arg0, Object arg1) throws SQLException {
        this.source.updateObject(this.addNamePrefix(arg0), arg1);
    }

    public void insertRow() throws SQLException {
        this.source.insertRow();
    }

    public void updateRow() throws SQLException {
        this.source.updateRow();
    }

    public void deleteRow() throws SQLException {
        this.source.deleteRow();
    }

    public void refreshRow() throws SQLException {
        this.source.refreshRow();
    }

    public void cancelRowUpdates() throws SQLException {
        this.source.cancelRowUpdates();
    }

    public void moveToInsertRow() throws SQLException {
        this.source.moveToInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.source.moveToCurrentRow();
    }

    public Statement getStatement() throws SQLException {
        return this.source.getStatement();
    }

    public Object getObject(int arg0, Map arg1) throws SQLException {
        return this.source.getObject(this.remap(arg0), arg1);
    }

    public Ref getRef(int arg0) throws SQLException {
        return this.source.getRef(this.remap(arg0));
    }

    public Blob getBlob(int arg0) throws SQLException {
        return this.source.getBlob(this.remap(arg0));
    }

    public Clob getClob(int arg0) throws SQLException {
        return this.source.getClob(this.remap(arg0));
    }

    public Array getArray(int arg0) throws SQLException {
        return this.source.getArray(this.remap(arg0));
    }

    public Object getObject(String arg0, Map arg1) throws SQLException {
        return this.source.getObject(this.addNamePrefix(arg0), arg1);
    }

    public Ref getRef(String arg0) throws SQLException {
        return this.source.getRef(this.addNamePrefix(arg0));
    }

    public Blob getBlob(String arg0) throws SQLException {
        return this.source.getBlob(this.addNamePrefix(arg0));
    }

    public Clob getClob(String arg0) throws SQLException {
        return this.source.getClob(this.addNamePrefix(arg0));
    }

    public Array getArray(String arg0) throws SQLException {
        return this.source.getArray(this.addNamePrefix(arg0));
    }

    public Date getDate(int arg0, Calendar arg1) throws SQLException {
        return this.source.getDate(this.remap(arg0), arg1);
    }

    public Date getDate(String arg0, Calendar arg1) throws SQLException {
        return this.source.getDate(this.addNamePrefix(arg0), arg1);
    }

    public Time getTime(int arg0, Calendar arg1) throws SQLException {
        return this.source.getTime(this.remap(arg0), arg1);
    }

    public Time getTime(String arg0, Calendar arg1) throws SQLException {
        return this.source.getTime(this.addNamePrefix(arg0), arg1);
    }

    public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException {
        return this.source.getTimestamp(this.remap(arg0), arg1);
    }

    public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException {
        return this.source.getTimestamp(this.addNamePrefix(arg0), arg1);
    }

    public URL getURL(int arg0) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public URL getURL(String arg0) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateRef(int arg0, Ref arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateRef(String arg0, Ref arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateBlob(int arg0, Blob arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateBlob(String arg0, Blob arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateClob(int arg0, Clob arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateClob(String arg0, Clob arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateArray(int arg0, Array arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateArray(String arg0, Array arg1) throws SQLException {
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    private String addNamePrefix(String name) {
        if (name.startsWith(this.prefix)) {
            return name;
        }
        return this.prefix.concat(name);
    }

    private String removeNamePrefix(String name) {
        if (name.startsWith(this.prefix)) {
            return name.substring(this.prefix.length());
        }
        return name;
    }

    private void checkRemapping() throws SQLException {
        if (this.indexMap == null) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_7008", new Object[]{this.indexMap});
        }
        int colCount = this.source.getMetaData().getColumnCount();
        int i = 1;
        while (i < this.indexMap.length) {
            if (this.indexMap[i] > colCount || this.indexMap[i] < 1) {
                throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_7008", new Object[]{this.indexMap});
            }
            ++i;
        }
    }

    private int remap(int arg0) throws SQLException {
        try {
            if (arg0 < 1) {
                throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2011", new Object[]{new Integer(arg0)});
            }
            return this.indexMap[arg0];
        }
        catch (IndexOutOfBoundsException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2011", new Object[]{new Integer(arg0)});
        }
    }

    private int reverseMap(int arg0) throws SQLException {
        if (this.reverseMap == null) {
            if (this.resultMeta == null) {
                throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2010");
            }
            this.reverseMap = new int[this.source.getMetaData().getColumnCount() + 1];
            int i = 0;
            while (i < this.reverseMap.length) {
                this.reverseMap[i] = -1;
                ++i;
            }
            int i2 = 0;
            while (i2 < this.indexMap.length) {
                this.reverseMap[this.indexMap[i2]] = i2;
                ++i2;
            }
        }
        try {
            return this.reverseMap[arg0];
        }
        catch (IndexOutOfBoundsException ex) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2011", new Object[]{new Integer(arg0)});
        }
    }

    private void assertConnectionInfo() {
        if (this.connectionInfo == null) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk_0000");
        }
    }

    private class BIRemappingResultSetFilterMetaData
    implements ResultSetMetaData {
        private ResultSetMetaData sourceMeta = null;

        private BIRemappingResultSetFilterMetaData() throws SQLException {
            this.sourceMeta = BIRemappingResultSetFilter.this.source.getMetaData();
        }

        public int getColumnCount() throws SQLException {
            return BIRemappingResultSetFilter.this.indexMap.length - 1;
        }

        public boolean isAutoIncrement(int arg0) throws SQLException {
            return this.sourceMeta.isAutoIncrement(BIRemappingResultSetFilter.this.remap(arg0));
        }

        public boolean isCaseSensitive(int arg0) throws SQLException {
            return this.sourceMeta.isCaseSensitive(BIRemappingResultSetFilter.this.remap(arg0));
        }

        public boolean isSearchable(int arg0) throws SQLException {
            return this.sourceMeta.isSearchable(BIRemappingResultSetFilter.this.remap(arg0));
        }

        public boolean isCurrency(int arg0) throws SQLException {
            return this.sourceMeta.isCurrency(BIRemappingResultSetFilter.this.remap(arg0));
        }

        public int isNullable(int arg0) throws SQLException {
            return this.sourceMeta.isNullable(BIRemappingResultSetFilter.this.remap(arg0));
        }

        public boolean isSigned(int arg0) throws SQLException {
            return this.sourceMeta.isSigned(BIRemappingResultSetFilter.this.remap(arg0));
        }

        public int getColumnDisplaySize(int arg0) throws SQLException {
            return this.sourceMeta.getColumnDisplaySize(BIRemappingResultSetFilter.this.remap(arg0));
        }

        public String getColumnLabel(int arg0) throws SQLException {
            return this.sourceMeta.getColumnLabel(BIRemappingResultSetFilter.this.remap(arg0));
        }

        public String getColumnName(int arg0) throws SQLException {
            return BIRemappingResultSetFilter.this.removeNamePrefix(this.sourceMeta.getColumnName(BIRemappingResultSetFilter.this.remap(arg0)));
        }

        public String getSchemaName(int arg0) throws SQLException {
            return this.sourceMeta.getSchemaName(BIRemappingResultSetFilter.this.remap(arg0));
        }

        public int getPrecision(int arg0) throws SQLException {
            return this.sourceMeta.getPrecision(BIRemappingResultSetFilter.this.remap(arg0));
        }

        public int getScale(int arg0) throws SQLException {
            return this.sourceMeta.getScale(BIRemappingResultSetFilter.this.remap(arg0));
        }

        public String getTableName(int arg0) throws SQLException {
            return this.sourceMeta.getTableName(BIRemappingResultSetFilter.this.remap(arg0));
        }

        public String getCatalogName(int arg0) throws SQLException {
            return this.sourceMeta.getCatalogName(BIRemappingResultSetFilter.this.remap(arg0));
        }

        public int getColumnType(int arg0) throws SQLException {
            return this.sourceMeta.getColumnType(BIRemappingResultSetFilter.this.remap(arg0));
        }

        public String getColumnTypeName(int arg0) throws SQLException {
            return BIRemappingResultSetFilter.this.removeNamePrefix(this.sourceMeta.getColumnTypeName(BIRemappingResultSetFilter.this.remap(arg0)));
        }

        public boolean isReadOnly(int arg0) throws SQLException {
            return this.sourceMeta.isReadOnly(BIRemappingResultSetFilter.this.remap(arg0));
        }

        public boolean isWritable(int arg0) throws SQLException {
            return this.sourceMeta.isWritable(BIRemappingResultSetFilter.this.remap(arg0));
        }

        public boolean isDefinitelyWritable(int arg0) throws SQLException {
            return this.sourceMeta.isDefinitelyWritable(BIRemappingResultSetFilter.this.remap(arg0));
        }

        public String getColumnClassName(int arg0) throws SQLException {
            return this.sourceMeta.getColumnClassName(BIRemappingResultSetFilter.this.remap(arg0));
        }
    }
}

