/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.result.impl.filter;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.IBISynchronizedResultSetFilter;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.exception.BISQLException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;

public abstract class BIDimensionCursorFilter
implements IBISynchronizedResultSetFilter {
    private static final String FILTER_NAME = "MaskResultSetFilter";
    private static final String FILTER_DESCRIPTION = "Subset of existing ResultSet columns based on offset and length";
    private IBIResultSet source = null;
    private ResultSetMetaData resultMeta = null;
    private static final IBIResultSet.Type resultSetType = IBIResultSet.Type.ACCESS;
    private final boolean resultSetUpdateable;
    private final int offset;
    private final int length;
    private final String prefix;
    protected IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;

    private BIDimensionCursorFilter() {
        this.offset = 0;
        this.length = 0;
        this.prefix = null;
        this.resultSetUpdateable = false;
    }

    public BIDimensionCursorFilter(IBIResultSet source, String prefix, int offset, int length) throws SQLException {
        this.resultSetUpdateable = false;
        this.prefix = prefix + ".";
        this.offset = offset;
        this.length = length;
        if (source == null) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2016");
        }
        this.source = source;
        this.resultMeta = new BIDimensionCursorFilterMetaData();
        this.checkOffsetLength();
    }

    public BIDimensionCursorFilter(IBIConnectionInfo connectionInfo, IBIResultSet source, String prefix, int offset, int length) throws SQLException {
        this.connectionInfo = connectionInfo;
        this.assertConnectionInfo();
        this.resultSetUpdateable = false;
        this.prefix = prefix + ".";
        this.offset = offset;
        this.length = length;
        if (source == null) {
            throw new BISQLException(connectionInfo.getLocale(), "sdk.dac.rel.result_2016");
        }
        this.source = source;
        this.resultMeta = new BIDimensionCursorFilterMetaData();
        this.checkOffsetLength();
    }

    public String getFilterName() {
        return FILTER_NAME;
    }

    public String getFilterDescription() {
        return FILTER_DESCRIPTION;
    }

    public void setSourceResultSet(IBIResultSet source) throws SQLException {
        if (source == null) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2016");
        }
        this.source = source;
        this.resultMeta = new BIDimensionCursorFilterMetaData();
        this.checkOffsetLength();
    }

    public void setAdditionalDataResultSet(IBIResultSet additional) throws SQLException {
        if (additional == null) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2016");
        }
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void setSynchronized(boolean synchronize) throws SQLException {
        if (this.resultMeta == null) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2010");
        }
        this.source.setSynchronized(synchronize);
    }

    public boolean isSynchronized() throws SQLException {
        if (this.resultMeta == null) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2010");
        }
        return this.source.isSynchronized();
    }

    public void synchronize() throws SQLException {
        this.source.synchronize();
    }

    public boolean synchAbsolute(int arg0) throws SQLException {
        return this.source.synchAbsolute(arg0);
    }

    public boolean synchRelative(int arg0) throws SQLException {
        return this.source.synchRelative(arg0);
    }

    public void synchBeforeFirst() throws SQLException {
        this.source.synchBeforeFirst();
    }

    public void synchAfterLast() throws SQLException {
        this.source.synchAfterLast();
    }

    public int synchGetRow() throws SQLException {
        return this.source.synchGetRow();
    }

    public int synchGetColumnCount() throws SQLException {
        if (this.resultMeta == null) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2010");
        }
        return this.length;
    }

    public int synchGetRowCount() throws SQLException {
        return this.source.synchGetRowCount();
    }

    public boolean next() throws SQLException {
        this.assertNavigation();
        return this.source.next();
    }

    public void close() throws SQLException {
        this.source.close();
    }

    public boolean wasNull() throws SQLException {
        return this.source.wasNull();
    }

    public String getString(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getString(arg0 + this.offset);
    }

    public boolean getBoolean(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getBoolean(arg0 + this.offset);
    }

    public byte getByte(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getByte(arg0 + this.offset);
    }

    public short getShort(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getShort(arg0 + this.offset);
    }

    public int getInt(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getInt(arg0 + this.offset);
    }

    public long getLong(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getLong(arg0 + this.offset);
    }

    public float getFloat(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getFloat(arg0 + this.offset);
    }

    public double getDouble(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getDouble(arg0 + this.offset);
    }

    public BigDecimal getBigDecimal(int arg0, int arg1) throws SQLException {
        this.assertAccess();
        return this.source.getBigDecimal(arg0 + this.offset);
    }

    public byte[] getBytes(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getBytes(arg0 + this.offset);
    }

    public Date getDate(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getDate(arg0 + this.offset);
    }

    public Time getTime(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getTime(arg0 + this.offset);
    }

    public Timestamp getTimestamp(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getTimestamp(arg0 + this.offset);
    }

    public InputStream getAsciiStream(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getAsciiStream(arg0 + this.offset);
    }

    public InputStream getUnicodeStream(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getUnicodeStream(arg0 + this.offset);
    }

    public InputStream getBinaryStream(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getBinaryStream(arg0 + this.offset);
    }

    public String getString(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getString(this.addNamePrefix(arg0));
    }

    public boolean getBoolean(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getBoolean(this.addNamePrefix(arg0));
    }

    public byte getByte(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getByte(this.addNamePrefix(arg0));
    }

    public short getShort(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getShort(this.addNamePrefix(arg0));
    }

    public int getInt(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getInt(this.addNamePrefix(arg0));
    }

    public long getLong(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getLong(this.addNamePrefix(arg0));
    }

    public float getFloat(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getFloat(this.addNamePrefix(arg0));
    }

    public double getDouble(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getDouble(this.addNamePrefix(arg0));
    }

    public BigDecimal getBigDecimal(String arg0, int arg1) throws SQLException {
        this.assertAccess();
        return this.source.getBigDecimal(this.addNamePrefix(arg0), arg1);
    }

    public byte[] getBytes(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getBytes(this.addNamePrefix(arg0));
    }

    public Date getDate(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getDate(this.addNamePrefix(arg0));
    }

    public Time getTime(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getTime(this.addNamePrefix(arg0));
    }

    public Timestamp getTimestamp(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getTimestamp(this.addNamePrefix(arg0));
    }

    public InputStream getAsciiStream(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getAsciiStream(this.addNamePrefix(arg0));
    }

    public InputStream getUnicodeStream(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getUnicodeStream(this.addNamePrefix(arg0));
    }

    public InputStream getBinaryStream(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getBinaryStream(this.addNamePrefix(arg0));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.source.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.source.clearWarnings();
    }

    public String getCursorName() throws SQLException {
        return this.source.getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultMeta;
    }

    public Object getObject(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getObject(arg0 + this.offset);
    }

    public Object getObject(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getObject(this.addNamePrefix(arg0));
    }

    public int findColumn(String arg0) throws SQLException {
        return this.source.findColumn(this.addNamePrefix(arg0)) - this.offset;
    }

    public Reader getCharacterStream(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getCharacterStream(arg0 + this.offset);
    }

    public Reader getCharacterStream(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getCharacterStream(this.addNamePrefix(arg0));
    }

    public BigDecimal getBigDecimal(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getBigDecimal(arg0 + this.offset);
    }

    public BigDecimal getBigDecimal(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getBigDecimal(this.addNamePrefix(arg0));
    }

    public boolean isBeforeFirst() throws SQLException {
        this.assertNavigation();
        return this.source.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        this.assertNavigation();
        return this.source.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        this.assertNavigation();
        return this.source.isFirst();
    }

    public boolean isLast() throws SQLException {
        this.assertNavigation();
        return this.source.isLast();
    }

    public void beforeFirst() throws SQLException {
        this.assertNavigation();
        this.source.beforeFirst();
    }

    public void afterLast() throws SQLException {
        this.assertNavigation();
        this.source.afterLast();
    }

    public boolean first() throws SQLException {
        this.assertNavigation();
        return this.source.first();
    }

    public boolean last() throws SQLException {
        this.assertNavigation();
        return this.source.last();
    }

    public int getRow() throws SQLException {
        this.assertNavigation();
        return this.source.getRow();
    }

    public boolean absolute(int arg0) throws SQLException {
        this.assertNavigation();
        return this.source.absolute(arg0 + this.offset);
    }

    public boolean relative(int arg0) throws SQLException {
        this.assertNavigation();
        return this.source.relative(arg0 + this.offset);
    }

    public boolean previous() throws SQLException {
        this.assertNavigation();
        return this.source.previous();
    }

    public void setFetchDirection(int arg0) throws SQLException {
        this.source.setFetchDirection(arg0 + this.offset);
    }

    public int getFetchDirection() throws SQLException {
        return this.source.getFetchDirection();
    }

    public void setFetchSize(int arg0) throws SQLException {
        this.source.setFetchSize(arg0);
    }

    public int getFetchSize() throws SQLException {
        return this.source.getFetchSize();
    }

    public int getType() throws SQLException {
        return this.source.getType();
    }

    public int getConcurrency() throws SQLException {
        return this.source.getConcurrency();
    }

    public boolean rowUpdated() throws SQLException {
        this.assertUpdate();
        return this.source.rowUpdated();
    }

    public boolean rowInserted() throws SQLException {
        this.assertUpdate();
        return this.source.rowInserted();
    }

    public boolean rowDeleted() throws SQLException {
        this.assertUpdate();
        return this.source.rowDeleted();
    }

    public void updateNull(int arg0) throws SQLException {
        this.assertUpdate();
        this.source.updateNull(arg0 + this.offset);
    }

    public void updateBoolean(int arg0, boolean arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateBoolean(arg0 + this.offset, arg1);
    }

    public void updateByte(int arg0, byte arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateByte(arg0 + this.offset, arg1);
    }

    public void updateShort(int arg0, short arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateShort(arg0 + this.offset, arg1);
    }

    public void updateInt(int arg0, int arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateInt(arg0 + this.offset, arg1);
    }

    public void updateLong(int arg0, long arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateLong(arg0 + this.offset, arg1);
    }

    public void updateFloat(int arg0, float arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateFloat(arg0 + this.offset, arg1);
    }

    public void updateDouble(int arg0, double arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateDouble(arg0 + this.offset, arg1);
    }

    public void updateBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateBigDecimal(arg0 + this.offset, arg1);
    }

    public void updateString(int arg0, String arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateString(arg0 + this.offset, arg1);
    }

    public void updateBytes(int arg0, byte[] arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateBytes(arg0 + this.offset, arg1);
    }

    public void updateDate(int arg0, Date arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateDate(arg0 + this.offset, arg1);
    }

    public void updateTime(int arg0, Time arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateTime(arg0, arg1);
    }

    public void updateTimestamp(int arg0, Timestamp arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateTimestamp(arg0 + this.offset, arg1);
    }

    public void updateAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.source.updateAsciiStream(arg0 + this.offset, arg1, arg2);
    }

    public void updateBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.source.updateBinaryStream(arg0 + this.offset, arg1, arg2);
    }

    public void updateCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.source.updateCharacterStream(arg0 + this.offset, arg1, arg2);
    }

    public void updateObject(int arg0, Object arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.source.updateObject(arg0 + this.offset, arg1, arg2);
    }

    public void updateObject(int arg0, Object arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateObject(arg0 + this.offset, arg1);
    }

    public void updateNull(String arg0) throws SQLException {
        this.assertUpdate();
        this.source.updateNull(this.addNamePrefix(arg0));
    }

    public void updateBoolean(String arg0, boolean arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateBoolean(this.addNamePrefix(arg0), arg1);
    }

    public void updateByte(String arg0, byte arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateByte(this.addNamePrefix(arg0), arg1);
    }

    public void updateShort(String arg0, short arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateShort(this.addNamePrefix(arg0), arg1);
    }

    public void updateInt(String arg0, int arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateInt(this.addNamePrefix(arg0), arg1);
    }

    public void updateLong(String arg0, long arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateLong(this.addNamePrefix(arg0), arg1);
    }

    public void updateFloat(String arg0, float arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateFloat(this.addNamePrefix(arg0), arg1);
    }

    public void updateDouble(String arg0, double arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateDouble(this.addNamePrefix(arg0), arg1);
    }

    public void updateBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateBigDecimal(this.addNamePrefix(arg0), arg1);
    }

    public void updateString(String arg0, String arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateString(this.addNamePrefix(arg0), arg1);
    }

    public void updateBytes(String arg0, byte[] arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateBytes(this.addNamePrefix(arg0), arg1);
    }

    public void updateDate(String arg0, Date arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateDate(this.addNamePrefix(arg0), arg1);
    }

    public void updateTime(String arg0, Time arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateTime(this.addNamePrefix(arg0), arg1);
    }

    public void updateTimestamp(String arg0, Timestamp arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateTimestamp(this.addNamePrefix(arg0), arg1);
    }

    public void updateAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.source.updateAsciiStream(this.addNamePrefix(arg0), arg1, arg2);
    }

    public void updateBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.source.updateBinaryStream(this.addNamePrefix(arg0), arg1, arg2);
    }

    public void updateCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.source.updateCharacterStream(this.addNamePrefix(arg0), arg1, arg2);
    }

    public void updateObject(String arg0, Object arg1, int arg2) throws SQLException {
        this.assertUpdate();
        this.source.updateObject(this.addNamePrefix(arg0), arg1, arg2);
    }

    public void updateObject(String arg0, Object arg1) throws SQLException {
        this.assertUpdate();
        this.source.updateObject(this.addNamePrefix(arg0), arg1);
    }

    public void insertRow() throws SQLException {
        this.assertUpdate();
        this.source.insertRow();
    }

    public void updateRow() throws SQLException {
        this.assertUpdate();
        this.source.updateRow();
    }

    public void deleteRow() throws SQLException {
        this.assertUpdate();
        this.source.deleteRow();
    }

    public void refreshRow() throws SQLException {
        this.assertUpdate();
        this.source.refreshRow();
    }

    public void cancelRowUpdates() throws SQLException {
        this.assertUpdate();
        this.source.cancelRowUpdates();
    }

    public void moveToInsertRow() throws SQLException {
        this.assertUpdate();
        this.source.moveToInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.assertUpdate();
        this.source.moveToCurrentRow();
    }

    public Statement getStatement() throws SQLException {
        return this.source.getStatement();
    }

    public Object getObject(int arg0, Map arg1) throws SQLException {
        this.assertAccess();
        return this.source.getObject(arg0 + this.offset, arg1);
    }

    public Ref getRef(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getRef(arg0 + this.offset);
    }

    public Blob getBlob(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getBlob(arg0 + this.offset);
    }

    public Clob getClob(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getClob(arg0 + this.offset);
    }

    public Array getArray(int arg0) throws SQLException {
        this.assertAccess();
        return this.source.getArray(arg0 + this.offset);
    }

    public Object getObject(String arg0, Map arg1) throws SQLException {
        this.assertAccess();
        return this.source.getObject(this.addNamePrefix(arg0), arg1);
    }

    public Ref getRef(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getRef(this.addNamePrefix(arg0));
    }

    public Blob getBlob(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getBlob(this.addNamePrefix(arg0));
    }

    public Clob getClob(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getClob(this.addNamePrefix(arg0));
    }

    public Array getArray(String arg0) throws SQLException {
        this.assertAccess();
        return this.source.getArray(this.addNamePrefix(arg0));
    }

    public Date getDate(int arg0, Calendar arg1) throws SQLException {
        this.assertAccess();
        return this.source.getDate(arg0 + this.offset, arg1);
    }

    public Date getDate(String arg0, Calendar arg1) throws SQLException {
        this.assertAccess();
        return this.source.getDate(this.addNamePrefix(arg0), arg1);
    }

    public Time getTime(int arg0, Calendar arg1) throws SQLException {
        this.assertAccess();
        return this.source.getTime(arg0 + this.offset, arg1);
    }

    public Time getTime(String arg0, Calendar arg1) throws SQLException {
        this.assertAccess();
        return this.source.getTime(this.addNamePrefix(arg0), arg1);
    }

    public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException {
        this.assertAccess();
        return this.source.getTimestamp(arg0 + this.offset, arg1);
    }

    public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException {
        this.assertAccess();
        return this.source.getTimestamp(this.addNamePrefix(arg0), arg1);
    }

    public URL getURL(int arg0) throws SQLException {
        this.assertAccess();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public URL getURL(String arg0) throws SQLException {
        this.assertAccess();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateRef(int arg0, Ref arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateRef(String arg0, Ref arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateBlob(int arg0, Blob arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateBlob(String arg0, Blob arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateClob(int arg0, Clob arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateClob(String arg0, Clob arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateArray(int arg0, Array arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    public void updateArray(String arg0, Array arg1) throws SQLException {
        this.assertUpdate();
        throw new BISQLException(this.connectionInfo.getLocale(), "sdk_1000");
    }

    private String addNamePrefix(String name) {
        if (name.startsWith(this.prefix)) {
            return name;
        }
        return this.prefix.concat(name);
    }

    private String removeNamePrefix(String name) {
        if (name.startsWith(this.prefix)) {
            return name.substring(this.prefix.length());
        }
        return name;
    }

    private void checkOffsetLength() throws SQLException {
        if (this.source.getMetaData().getColumnCount() < this.offset + this.length) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sum of offset and length too large");
        }
    }

    private IBIResultSet.Type getResultSetType() {
        return resultSetType;
    }

    private boolean getResultSetUpdateable() {
        return this.resultSetUpdateable;
    }

    private void assertResultSetType(IBIResultSet.Type resultSetType) throws SQLException {
        if (resultSetType == null || resultSetType != IBIResultSet.Type.ACCESS && resultSetType != IBIResultSet.Type.NAVIGATION && resultSetType != IBIResultSet.Type.UNRESTRICTED) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2012", new Object[]{resultSetType});
        }
    }

    private void assertUpdate() throws SQLException {
        if (!this.getResultSetUpdateable()) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_1001");
        }
        this.assertAccess();
    }

    private void assertAccess() throws SQLException {
        if (this.getResultSetType() != IBIResultSet.Type.ACCESS && this.getResultSetType() != IBIResultSet.Type.UNRESTRICTED) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2013");
        }
    }

    private void assertNavigation() throws SQLException {
        if (this.getResultSetType() != IBIResultSet.Type.NAVIGATION && this.getResultSetType() != IBIResultSet.Type.UNRESTRICTED) {
            throw new BISQLException(this.connectionInfo.getLocale(), "sdk.dac.rel.result_2014");
        }
    }

    private void assertAccessNavigation() throws SQLException {
        this.assertAccess();
        this.assertNavigation();
    }

    private void assertConnectionInfo() {
        if (this.connectionInfo == null) {
            throw new BIRuntimeException(Locale.getDefault(), "sdk_0000");
        }
    }

    static /* synthetic */ int access$100(BIDimensionCursorFilter x0) {
        return x0.length;
    }

    static /* synthetic */ int access$200(BIDimensionCursorFilter x0) {
        return x0.offset;
    }

    private class BIDimensionCursorFilterMetaData
    implements ResultSetMetaData {
        private ResultSetMetaData sourceMeta = null;
        private int length = BIDimensionCursorFilter.access$100(BIDimensionCursorFilter.this);
        private int offset = BIDimensionCursorFilter.access$200(BIDimensionCursorFilter.this);

        private BIDimensionCursorFilterMetaData() throws SQLException {
            this.sourceMeta = BIDimensionCursorFilter.this.source.getMetaData();
        }

        public int getColumnCount() throws SQLException {
            return this.length;
        }

        public boolean isAutoIncrement(int arg0) throws SQLException {
            return this.sourceMeta.isAutoIncrement(arg0 + this.offset);
        }

        public boolean isCaseSensitive(int arg0) throws SQLException {
            return this.sourceMeta.isCaseSensitive(arg0 + this.offset);
        }

        public boolean isSearchable(int arg0) throws SQLException {
            return this.sourceMeta.isSearchable(arg0 + this.offset);
        }

        public boolean isCurrency(int arg0) throws SQLException {
            return this.sourceMeta.isCurrency(arg0 + this.offset);
        }

        public int isNullable(int arg0) throws SQLException {
            return this.sourceMeta.isNullable(arg0 + this.offset);
        }

        public boolean isSigned(int arg0) throws SQLException {
            return this.sourceMeta.isSigned(arg0 + this.offset);
        }

        public int getColumnDisplaySize(int arg0) throws SQLException {
            return this.sourceMeta.getColumnDisplaySize(arg0 + this.offset);
        }

        public String getColumnLabel(int arg0) throws SQLException {
            return this.sourceMeta.getColumnLabel(arg0 + this.offset);
        }

        public String getColumnName(int arg0) throws SQLException {
            return BIDimensionCursorFilter.this.removeNamePrefix(this.sourceMeta.getColumnName(arg0 + this.offset));
        }

        public String getSchemaName(int arg0) throws SQLException {
            return this.sourceMeta.getSchemaName(arg0 + this.offset);
        }

        public int getPrecision(int arg0) throws SQLException {
            return this.sourceMeta.getPrecision(arg0 + this.offset);
        }

        public int getScale(int arg0) throws SQLException {
            return this.sourceMeta.getScale(arg0 + this.offset);
        }

        public String getTableName(int arg0) throws SQLException {
            return this.sourceMeta.getTableName(arg0 + this.offset);
        }

        public String getCatalogName(int arg0) throws SQLException {
            return this.sourceMeta.getCatalogName(arg0 + this.offset);
        }

        public int getColumnType(int arg0) throws SQLException {
            return this.sourceMeta.getColumnType(arg0 + this.offset);
        }

        public String getColumnTypeName(int arg0) throws SQLException {
            return this.sourceMeta.getColumnTypeName(arg0 + this.offset);
        }

        public boolean isReadOnly(int arg0) throws SQLException {
            return this.sourceMeta.isReadOnly(arg0 + this.offset);
        }

        public boolean isWritable(int arg0) throws SQLException {
            return this.sourceMeta.isWritable(arg0 + this.offset);
        }

        public boolean isDefinitelyWritable(int arg0) throws SQLException {
            return this.sourceMeta.isDefinitelyWritable(arg0 + this.offset);
        }

        public String getColumnClassName(int arg0) throws SQLException {
            return this.sourceMeta.getColumnClassName(arg0 + this.offset);
        }
    }
}

