/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.providers.ws;

import com.tssap.j2ee.core.providers.ws.WsdModelMetaInfo;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import org.eclipse.core.resources.IFile;

public class WsModelMetaInfo {
    private static final String WEBSERVICE_LIST_DOMAIN = "com.sap.ide.ws.ejbjar";
    private static final String WEBSERVICE_LIST_SUBDOMAIN = "com.sap.ide.ws.webservice.list";
    private static final String WEBSERVICE_METACLASS = "com.sap.ide.ws.webservice_METACLASS";
    private static final String WEBSERVICE_DEFINITION_REFLIST_METACLASS = "com.sap.ide.ws.webservice.list_METACLASS";
    private static final String WEBSERVICE_DIAGRAM_METACLASS = "WsDiagram";
    public static final String FILE = "ws-deployment-descriptor.xml";
    public static final String SAP_WS_DD_FILE = "META-INF/ws-deployment-descriptor.xml";
    public static final String SOURCE_WSD_ENTITY = "definition";
    public static final String BEAN_NAME = "beanName";
    public static final String WSD_REFERENCE_NAME = "refName";
    private static final String SOURCE_WSD = "sourceWsd";

    public static ReferenceCollection getAssociatedReferenceCollection(Entity wsdJar) {
        String diagramUIN = wsdJar.getPropertyValue("DiagramUIN");
        if (diagramUIN == null) {
            return null;
        }
        UniqueName uin = ModelAccess.createUniqueName((String)diagramUIN);
        return wsdJar.getModel().findReferenceCollection(uin);
    }

    public static Entity getSourceWsd(Entity template) {
        return (Entity)template.getObjectPropertyValue(SOURCE_WSD);
    }

    public static boolean addWsdReference(ReferenceCollection ejbJar, Entity wsd, Entity template, String wsdReferenceName, String beanName) {
        Entity parent = ejbJar.getParent();
        template.setObjectPropertyValue(SOURCE_WSD, (Object)wsd);
        template.setObjectPropertyValue(SOURCE_WSD_ENTITY, (Object)wsd);
        template.setObjectPropertyValue(BEAN_NAME, (Object)beanName);
        template.setObjectPropertyValue(WSD_REFERENCE_NAME, (Object)wsdReferenceName);
        Entity child = parent.createChildEntity(wsd.getPropertyValue("$metaclass"), template);
        return child != null && !child.isDeleted();
    }

    public static boolean isWsdRefList(UniqueName uniqueName) {
        return uniqueName.getDomain().equals(WEBSERVICE_LIST_DOMAIN) && uniqueName.getSubDomain().equals(WEBSERVICE_LIST_SUBDOMAIN);
    }

    public static boolean isWsdReference(UniqueName uniqueName) {
        Entity source;
        return uniqueName.getDomain().equals("com.tssap.selena.proxy") && (source = ProxyMetaInfo.getSourceEntity((UniqueName)uniqueName)).getUniqueName().getSubDomain().equals(WsdModelMetaInfo.getSubDomain());
    }

    public static String getSourceWsdGuid(UniqueName wsReferenceProxyUniqueName) {
        return ProxyMetaInfo.getParameter((UniqueName)wsReferenceProxyUniqueName, (int)0);
    }

    public static String getWsReferenceName(UniqueName wsReferenceProxyUniqueName) {
        return ProxyMetaInfo.getParameter((UniqueName)wsReferenceProxyUniqueName, (int)1);
    }

    public static String getMetaclassForWebServiceDiagram() {
        return WEBSERVICE_DIAGRAM_METACLASS;
    }

    public static String getMetaclassForWebService() {
        return WEBSERVICE_METACLASS;
    }

    public static String getMetaclassForWebServiceList() {
        return WEBSERVICE_DEFINITION_REFLIST_METACLASS;
    }

    public static String getDomainForWebServiceList() {
        return WEBSERVICE_LIST_DOMAIN;
    }

    public static String getSubDomainForWebServiceList() {
        return WEBSERVICE_LIST_SUBDOMAIN;
    }

    public static UniqueName getWsdRefListUniqueName(IFile file) {
        String fileName = file.getProjectRelativePath().toOSString();
        return ModelAccess.createUniqueName((String)WEBSERVICE_LIST_DOMAIN, (String)WEBSERVICE_LIST_SUBDOMAIN, (String)fileName, (String)fileName, null);
    }
}

