/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.techdev.webassembly;

import com.sap.tc.buildplugin.api.BuildActionResult;
import com.sap.tc.buildplugin.api.BuildActionSeverity;
import com.sap.tc.buildplugin.api.IBuildAction;
import com.sap.tc.buildplugin.api.IBuildInfo;
import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildplugin.pputil.PPCollector;
import com.sap.tc.buildplugin.techdev.ant.util.DirsAndFiles;
import com.sap.tc.buildplugin.techdev.ant.util.FileCreator;
import com.sap.tc.buildtool.LogFile;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CreateBuildFileAction
implements IBuildAction {
    BuildActionResult result;
    BuildActionSeverity severity;
    File pluginRoot;
    DirsAndFiles daf;
    ArrayList wars = new ArrayList();
    int br = 0;
    private IBuildInfo buildInfo;
    Location loc = Location.getLocation((Class)(class$com$sap$tc$buildplugin$techdev$webassembly$CreateBuildFileAction == null ? (class$com$sap$tc$buildplugin$techdev$webassembly$CreateBuildFileAction = CreateBuildFileAction.class$("com.sap.tc.buildplugin.techdev.webassembly.CreateBuildFileAction")) : class$com$sap$tc$buildplugin$techdev$webassembly$CreateBuildFileAction));
    static /* synthetic */ Class class$com$sap$tc$buildplugin$techdev$webassembly$CreateBuildFileAction;

    CreateBuildFileAction(DirsAndFiles pdaf, File root, IBuildInfo buildInfo) {
        this.daf = pdaf;
        this.pluginRoot = root;
        this.buildInfo = buildInfo;
        this.result = new BuildActionResult();
        this.severity = new BuildActionSeverity();
        this.severity.setStopOnError();
    }

    public BuildActionResult execute() {
        this.loc.infoT("Web Assembly Plugin starts creating the build file");
        IDevelopmentComponentInfo componentInfo = this.buildInfo.getDevelopmentComponentInfo();
        String warDirName = "";
        FileCreator fCreator = new FileCreator();
        fCreator.setDaf(this.daf);
        fCreator.setPluginRoot(this.pluginRoot);
        fCreator.setStrContext("dc_root_Dir", this.daf.getRootDir());
        Map ppMap = this.daf.getPublicParts();
        if (ppMap != null) {
            PPCollector pp = new PPCollector(componentInfo);
            this.br = pp.addData(ppMap);
            fCreator.setListContext("dc_public_parts", pp.getList());
        }
        List sourceDirs = this.daf.getSourceDirs();
        fCreator.setListContext("dc_source_dirs", sourceDirs);
        int i = 0;
        while (i < sourceDirs.size()) {
            String sourceFolderName = (String)sourceDirs.get(i);
            if (sourceFolderName.equalsIgnoreCase("WEB-INF")) {
                fCreator.setStrContext("dc_web_inf_dir", sourceFolderName);
            } else {
                this.loc.infoT("error: only WEB-INF beneath the root is allowed!");
            }
            ++i;
        }
        fCreator.setStrContext("dc_gen_publicDir", this.daf.getGenDirPublic());
        fCreator.setStrContext("dc_gen_tempDir", this.daf.getTempDir());
        List assDep = this.daf.getAssemblyDirs();
        fCreator.setListContext("dc_depend_assemblyDirs", assDep);
        fCreator.setStrContext("dc_deployFile", this.daf.getDcFile());
        try {
            fCreator.setStrContext("compiler_executable_path", this.buildInfo.getCompilerExecutable());
        }
        catch (NoSuchMethodError ex) {
            String msg = "pluginhandler does not supply getCompilerExecutable";
            this.loc.traceThrowableT(300, msg, (Throwable)ex);
        }
        if (this.br != 2 && this.br != 3 && this.daf.checkAssDependencies()) {
            fCreator.createBuildFile();
        } else {
            String errMsg = "";
            LogFile log = new LogFile();
            if (!this.daf.checkAssDependencies()) {
                errMsg = this.daf.getErrorMsgAss();
                this.br = 2;
            }
            log.setErrorMessage(errMsg);
            log.writeLogFile(this.daf.getLogFile());
        }
        this.result.setBuildLogPath(this.daf.getLogFile());
        this.result.setBuildActionRC(this.br);
        return this.result;
    }

    public BuildActionResult getBuildActionResult() {
        return this.result;
    }

    public BuildActionSeverity getBuildActionSeverity() {
        return this.severity;
    }

    public void setBuildActionSeverity(BuildActionSeverity _severity) {
        this.severity = _severity;
    }

    public String getCaption() {
        return "Create Build file";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

