/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.ui.preferences;

import com.sap.ide.eclipse.j2ee.engine.EnginePlugin;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.upload.UsernamePasswordHandler;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WebServicePreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String UDDI_CLIENT_URL = "UDDI Client Context Root URL";
    private static final String UPLOAD_SERVER_URL = "UPLOAD Servlet Context Root URL";
    private static final String ENABLE_AUTO_UPLOAD = "auto_upload";
    private static final String SOAP_VI = "Soap in the vi";
    private static final String HTTP_PROPTOCOL = "http://";
    private static final String HOST_PORT_SEPARATOR = ":";
    private static final String DEFAULT_UDDI_CLIENT_URL = "/uddiclient/tools";
    private static final String DEFAULT_UPLOAD_SERVER_URL = "/dtr_lite/upload";
    private static final boolean DEFAULT_ENABLE_AUTO_UPLOAD = false;
    private static final boolean DEFAULT_SOAP_VI = false;
    private Text mUDDIClientUrlField = null;
    private Text mUploadServletUrl = null;
    private Button enableAutomaticUpload = null;
    private Button resetUsernamePassword = null;
    private Button soapExtensionsInVi = null;
    private static IPreferenceStore store = WebServiceCorePlugin.getDefault().getPreferenceStore();

    public static String getAppServerHost() {
        return HTTP_PROPTOCOL + EnginePlugin.getDefault().getHttpHost() + HOST_PORT_SEPARATOR + EnginePlugin.getDefault().getHttpPort();
    }

    public static String getUDDIClientURL() {
        String uddiclient = null;
        uddiclient = store.getString(UDDI_CLIENT_URL) == null || store.getString(UDDI_CLIENT_URL).length() < 1 ? store.getDefaultString(UDDI_CLIENT_URL) : store.getString(UDDI_CLIENT_URL);
        return WebServicePreferences.getAppServerHost() + uddiclient;
    }

    public static String getUploadServletURL() {
        String uploadclient = null;
        uploadclient = store.getString(UPLOAD_SERVER_URL) == null || store.getString(UPLOAD_SERVER_URL).length() < 1 ? store.getDefaultString(UPLOAD_SERVER_URL) : store.getString(UPLOAD_SERVER_URL);
        return WebServicePreferences.getAppServerHost() + uploadclient;
    }

    public static boolean isAutoUploadEnabled() {
        IPreferenceStore store = WebServiceCorePlugin.getDefault().getPreferenceStore();
        return store.getBoolean(ENABLE_AUTO_UPLOAD);
    }

    public static boolean soapToShowInVi() {
        IPreferenceStore store = WebServiceCorePlugin.getDefault().getPreferenceStore();
        return store.getBoolean(SOAP_VI);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.storeValues();
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)root, (int)1);
        mainPane.setLayoutData((Object)new GridData(1808));
        IGridLayoutPane settingsPane = mainPane.addGridLayoutPane(1);
        settingsPane.setLayoutData((Object)new GridData(768));
        IGridLayoutPane upLoadPane = settingsPane.addGridLayoutPane(2);
        upLoadPane.setLayoutData((Object)new GridData(768));
        upLoadPane.addPlaceholder(2, 1);
        upLoadPane.addTextLabel(WsCoreUiTexts.getString("WebServicePreferences.uddiClientRootLabel"), upLoadPane.createGridLayoutData(1, 1, false, false));
        this.mUDDIClientUrlField = upLoadPane.addTextField("", false, upLoadPane.createGridLayoutData(4, 1, true, false));
        this.mUDDIClientUrlField.setData((Object)UDDI_CLIENT_URL);
        this.mUDDIClientUrlField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebServicePreferences.this.handleContextRootFieldChanged((Text)e.widget);
            }
        });
        upLoadPane.addTextLabel(WsCoreUiTexts.getString("WebServicePreferences.uploadClientRootLabel"), upLoadPane.createGridLayoutData(1, 1, false, false));
        this.mUploadServletUrl = upLoadPane.addTextField("", false, upLoadPane.createGridLayoutData(4, 1, true, false));
        this.mUploadServletUrl.setData((Object)UPLOAD_SERVER_URL);
        this.mUploadServletUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebServicePreferences.this.handleContextRootFieldChanged((Text)e.widget);
            }
        });
        upLoadPane.addPlaceholder(2, 1);
        this.enableAutomaticUpload = upLoadPane.addCheckBox(WsCoreUiTexts.getString("WebServicePreferences.enableAutoUploadLabel"));
        upLoadPane.addPlaceholder(1, 1);
        upLoadPane.addPlaceholder(2, 1);
        this.resetUsernamePassword = upLoadPane.addPushButton(WsCoreUiTexts.getString("WebServicePreferences.resetPasswordLabel"));
        this.resetUsernamePassword.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UsernamePasswordHandler.reSetUsernamePassword();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        upLoadPane.addPlaceholder(2, 1);
        upLoadPane.addHorizontalSeparator();
        upLoadPane.addPlaceholder(2, 1);
        IGridLayoutPane soapInViPane = settingsPane.addGridLayoutPane(1);
        this.soapExtensionsInVi = soapInViPane.addCheckBox(WsCoreUiTexts.getString("WebServicePreferences.SoapVi"));
        IGridLayoutPane browserPane = mainPane.addGridLayoutPane(3);
        browserPane.setLayoutData((Object)new GridData(768));
        browserPane.addPlaceholder(3, 1);
        this.initializeValues();
        return root;
    }

    private String handleFileSystemBrowse() {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell());
        return fileDialog.open();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return WebServiceCorePlugin.getDefault().getPreferenceStore();
    }

    protected void performApply() {
        this.storeValues();
        super.performApply();
    }

    protected void performDefaults() {
        this.initializeDefaults();
        super.performDefaults();
    }

    private void setApplyStatus() {
        this.setValid(this.getErrorMessage() == null);
    }

    private void handleContextRootFieldChanged(Text field) {
        if (field.getText().length() < 1) {
            this.setErrorMessage(WsCoreUiTexts.getString("WsErrors.enterValueMessage") + " " + (String)field.getData());
        } else if (!field.getText().startsWith("/")) {
            this.setErrorMessage((String)field.getData() + " " + WsCoreUiTexts.getString("WebServicePreferences.urlFormatError"));
        } else {
            this.setErrorMessage(null);
        }
        this.setApplyStatus();
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.getString(UDDI_CLIENT_URL).length() < 1) {
            this.mUDDIClientUrlField.setText(store.getDefaultString(UDDI_CLIENT_URL));
        } else {
            this.mUDDIClientUrlField.setText(store.getString(UDDI_CLIENT_URL));
        }
        if (store.getString(UPLOAD_SERVER_URL).length() < 1) {
            this.mUploadServletUrl.setText(store.getDefaultString(UPLOAD_SERVER_URL));
        } else {
            this.mUploadServletUrl.setText(store.getString(UPLOAD_SERVER_URL));
        }
        if (!store.getBoolean(ENABLE_AUTO_UPLOAD)) {
            this.enableAutomaticUpload.setSelection(false);
        } else {
            this.enableAutomaticUpload.setSelection(true);
        }
        if (!store.getBoolean(SOAP_VI)) {
            this.soapExtensionsInVi.setSelection(false);
        } else {
            this.soapExtensionsInVi.setSelection(true);
        }
        this.storeValues();
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(UDDI_CLIENT_URL, this.mUDDIClientUrlField.getText());
        store.setValue(UPLOAD_SERVER_URL, this.mUploadServletUrl.getText());
        store.setValue(ENABLE_AUTO_UPLOAD, this.enableAutomaticUpload.getSelection());
        store.setValue(SOAP_VI, this.soapExtensionsInVi.getSelection());
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.mUDDIClientUrlField.setText(store.getDefaultString(UDDI_CLIENT_URL));
        this.mUploadServletUrl.setText(store.getDefaultString(UPLOAD_SERVER_URL));
        this.enableAutomaticUpload.setSelection(store.getDefaultBoolean(ENABLE_AUTO_UPLOAD));
        this.soapExtensionsInVi.setSelection(store.getDefaultBoolean(SOAP_VI));
    }

    static {
        store.setDefault(UDDI_CLIENT_URL, DEFAULT_UDDI_CLIENT_URL);
        store.setDefault(UPLOAD_SERVER_URL, DEFAULT_UPLOAD_SERVER_URL);
        store.setDefault(ENABLE_AUTO_UPLOAD, false);
        store.setDefault(SOAP_VI, false);
    }
}

