/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.services.upload;

import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.upload.MultipartRequest;
import com.sap.ide.ws.core.services.upload.Part;
import com.sap.ide.ws.core.services.upload.UsernamePasswordHandler;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.sap.ide.ws.core.ui.preferences.WebServicePreferences;
import com.sun.mail.util.BASE64EncoderStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public abstract class WsMdoUploadClient {
    public static final String UPLOAD_OK = "OK";
    private static final String BOUNDARY = "----------------qwAbc4sd56t4REf7utrR";
    private static final String LANGUAGE_ID = "documentation";
    protected static final String UPLOADED_YES = "YES";
    protected static final String COMMS_FAILURE = "FAILED";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    static /* synthetic */ Class class$com$sap$ide$ws$core$services$upload$WsMdoUploadClient;

    public abstract String getGuidForMdo(MainDevelopmentObject var1);

    public abstract String getIdForMdo(MainDevelopmentObject var1);

    public void uploadMdo(MainDevelopmentObject mdo, String userName, String password) {
        this.uploadMdo(this.getFileForMdo(mdo), this.getLanguageFilesForMdo(mdo), this.getGuidForMdo(mdo), this.getIdForMdo(mdo), userName, password);
    }

    public boolean mdoExistsOnServer(MainDevelopmentObject mdo, final String userName, final String password) {
        String temp = WebServicePreferences.getUploadServletURL();
        if (!this.checkUrl(temp)) {
            return false;
        }
        final String urlString = temp + "?" + this.getIdForMdo(mdo) + "=" + this.getGuidForMdo(mdo);
        final boolean[] returns = new boolean[]{false};
        IRunnableWithProgress check = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                String key = WsMdoUploadClient.this.checkMdoExists(urlString, monitor, userName, password);
                monitor.worked(80);
                if (key != null && key.length() > 0 && key.equals(WsMdoUploadClient.UPLOADED_YES)) {
                    returns[0] = true;
                }
                monitor.worked(100);
            }
        };
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            dialog.run(false, true, check);
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError(e, class$com$sap$ide$ws$core$services$upload$WsMdoUploadClient == null ? (class$com$sap$ide$ws$core$services$upload$WsMdoUploadClient = WsMdoUploadClient.class$("com.sap.ide.ws.core.services.upload.WsMdoUploadClient")) : class$com$sap$ide$ws$core$services$upload$WsMdoUploadClient);
        }
        return returns[0];
    }

    /*
     * WARNING - void declaration
     */
    protected final String checkMdoExists(String urlString, IProgressMonitor monitor, String userName, String passWord) {
        monitor.beginTask(WsCoreUiTexts.getString("WsMdoUploadClient.checkMdoUploadStatusMessage"), 100);
        monitor.worked(20);
        String key = "";
        try {
            String line;
            monitor.subTask(WsCoreUiTexts.getString("WsMdoUploadClient.connectToServerMessage"));
            URL key_url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)key_url.openConnection();
            connection.setRequestProperty(HEADER_AUTHORIZATION, this.encodeAuth(userName, passWord));
            monitor.worked(40);
            monitor.subTask(WsCoreUiTexts.getString("WsMdoUploadClient.waitingForReplyMessage"));
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            monitor.subTask(WsCoreUiTexts.getString("WsMdoUploadClient.readingReplyMessage"));
            while ((line = in.readLine()) != null) {
                void var9_11;
                key = key + (String)var9_11;
            }
        }
        catch (MalformedURLException e) {
            this.requestErrorHandler(e, WsCoreUiTexts.getString("WsMdoUploadClient.dtrLiteUrlNotValidError"));
            key = COMMS_FAILURE;
        }
        catch (IOException e) {
            this.requestErrorHandler(e, WsCoreUiTexts.getString("WsMdoUploadClient.commsError"));
            key = COMMS_FAILURE;
        }
        monitor.worked(60);
        return key;
    }

    private String encodeAuth(String userName, String password) {
        byte[] result = BASE64EncoderStream.encode((byte[])(userName + ":" + password).getBytes());
        String encdUP = new String(result, 0, result.length);
        return "Basic " + encdUP;
    }

    /*
     * WARNING - void declaration
     */
    protected final String uploadMdo(File mdoFile, Hashtable mdoLanguages, String mdoGuid, String mdoId, String userName, String password) {
        String urlString = WebServicePreferences.getUploadServletURL();
        if (!this.checkUrl(urlString)) {
            return null;
        }
        byte[] payLoad = this.createPostRequest(mdoFile, mdoLanguages, mdoGuid, mdoId);
        String ack = "";
        HttpURLConnection connection = null;
        try {
            String line;
            URL key_url = new URL(urlString);
            connection = (HttpURLConnection)key_url.openConnection();
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=----------------qwAbc4sd56t4REf7utrR");
            connection.setDoOutput(true);
            OutputStream os = connection.getOutputStream();
            os.write(payLoad);
            os.flush();
            os.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                void var14_17;
                ack = ack + (String)var14_17;
            }
        }
        catch (IOException e) {
            try {
                if (connection != null && connection.getResponseCode() == 401) {
                    ack = "";
                    ack = this.doRequest(urlString, connection, true, payLoad, userName, password);
                }
                throw e;
            }
            catch (IOException ex) {
                this.requestErrorHandler(ex, WsCoreUiTexts.getString("WsMdoUploadClient.commsFailureError"));
            }
        }
        catch (Exception e) {
            this.requestErrorHandler(e, WsCoreUiTexts.getString("WsMdoUploadClient.commsFailureError"));
        }
        if (ack.equals(UPLOAD_OK)) {
            return ack;
        }
        return COMMS_FAILURE;
    }

    /*
     * WARNING - void declaration
     */
    private String doRequest(String urlString, HttpURLConnection connection, boolean authorize, byte[] payLoad, String userName, String password) throws IOException {
        String line;
        String ack = "";
        URL key_url = new URL(urlString);
        connection = (HttpURLConnection)key_url.openConnection();
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=----------------qwAbc4sd56t4REf7utrR");
        if (authorize) {
            connection.setRequestProperty(HEADER_AUTHORIZATION, this.encodeAuth(userName, password));
        }
        connection.setDoOutput(true);
        OutputStream os = connection.getOutputStream();
        os.write(payLoad);
        os.flush();
        os.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        while ((line = in.readLine()) != null) {
            void var11_11;
            ack = ack + (String)var11_11;
        }
        return ack;
    }

    protected final void requestErrorHandler(Exception e, String message) {
        UsernamePasswordHandler.reSetUsernamePassword();
        WebServiceCorePlugin.logWarning(e, class$com$sap$ide$ws$core$services$upload$WsMdoUploadClient == null ? (class$com$sap$ide$ws$core$services$upload$WsMdoUploadClient = WsMdoUploadClient.class$("com.sap.ide.ws.core.services.upload.WsMdoUploadClient")) : class$com$sap$ide$ws$core$services$upload$WsMdoUploadClient);
        MessageDialog dlg = new MessageDialog(Display.getCurrent().getActiveShell(), WsCoreUiTexts.getString("DialogTitles.warning"), null, message + e.getMessage(), 4, new String[]{"Ok"}, 0);
        dlg.open();
    }

    protected final boolean checkUrl(String urlString) {
        try {
            URL url = new URL(urlString);
        }
        catch (Exception e) {
            MessageDialog dlg = new MessageDialog(Display.getCurrent().getActiveShell(), WsCoreUiTexts.getString("DialogTitles.warning"), null, WsCoreUiTexts.getString("WsMdoUploadClient.invalidUploadUrlError"), 4, new String[0], 0);
            dlg.open();
            return false;
        }
        return true;
    }

    private byte[] createPostRequest(File devlObject, Hashtable devlObjectLanguages, String fileGuid, String fileTypeId) {
        MultipartRequest request = new MultipartRequest(BOUNDARY);
        request.addPart(new Part(devlObject, fileTypeId, fileGuid, request.getBoundary()));
        Enumeration keys = devlObjectLanguages.keys();
        while (keys.hasMoreElements()) {
            String language = (String)keys.nextElement();
            request.addPart(new Part((File)devlObjectLanguages.get(language), LANGUAGE_ID, language, request.getBoundary()));
        }
        return request.toByteArray();
    }

    protected final Hashtable getLanguageFilesForMdo(MainDevelopmentObject object) {
        Hashtable<String, File> list = new Hashtable<String, File>();
        String[] languages = object.getTextPool().getAvailableLanguages();
        int i = 0;
        while (i < languages.length) {
            list.put(languages[i], new File(object.getTextPool().getAbsolutePath(languages[i])));
            ++i;
        }
        return list;
    }

    protected final File getFileForMdo(MainDevelopmentObject object) {
        String path = object.getAbsolutePath();
        return new File(path);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

