/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.services.upload;

import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class Part {
    private final String CONTENT_DISP = "Content-Disposition:";
    private final String CONTENT_DISP_NAME = "name=";
    private final String CONTENT_DISP_FNAME = "filename=";
    private final String CONTENT_TYPE = "Content-Type:";
    private final String BOUNDARY_START = "--";
    private final String CONTENT_DISP_TYPE = "form-data;";
    private final String TEXT_PLAIN_TYPE = "text/plain";
    private File file;
    private String fileName;
    private String fileID;
    private String boundary;
    private String partHeaderString;
    private int size;

    public Part(File file, String fileName, String fileGUID, String boundary) {
        this.file = file;
        this.fileName = fileName;
        this.fileID = fileGUID;
        this.boundary = boundary;
        this.partHeaderString = this.createPartHeaderString();
        this.size = this.computePartSize();
    }

    public byte[] toByteArray() {
        byte[] fileContents = null;
        try {
            FileInputStream inStr = new FileInputStream(this.file);
            fileContents = new byte[((InputStream)inStr).available()];
            if (((InputStream)inStr).available() > 0) {
                ((InputStream)inStr).read(fileContents);
            }
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError(e, this.getClass());
        }
        byte[] completePart = null;
        if (fileContents != null) {
            completePart = fileContents[fileContents.length - 1] != "\n".getBytes()[0] ? new byte[this.partHeaderString.length() + fileContents.length + 2] : new byte[this.partHeaderString.length() + fileContents.length + 1];
            byte[] headerBytes = this.partHeaderString.getBytes();
            int i = 0;
            while (i < headerBytes.length) {
                completePart[i] = headerBytes[i];
                ++i;
            }
            while (i < fileContents.length + headerBytes.length) {
                completePart[i] = fileContents[i - headerBytes.length];
                ++i;
            }
            if (fileContents[fileContents.length - 1] != "\n".getBytes()[0]) {
                completePart[i] = "\n".getBytes()[0];
                ++i;
            }
            completePart[i] = "\n".getBytes()[0];
        } else {
            completePart = new byte[this.partHeaderString.length()];
        }
        return completePart;
    }

    public int getPartSize() {
        return this.size;
    }

    private String createPartHeaderString() {
        return "--" + this.boundary + "\n" + "Content-Disposition:" + " " + "form-data;" + " " + "name=" + "\"" + this.fileName + "\"; " + "filename=" + "\"" + this.fileID + "\";\n\n";
    }

    private int computePartSize() {
        int size = this.partHeaderString.length();
        try {
            size += new FileInputStream(this.file).available();
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError(e, this.getClass());
        }
        return ++size;
    }
}

