/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.services.selena;

import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.tssap.selena.model.elements.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;

public class SelenaResourceAdapter {
    public static IFile getFile(Element element) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(element.getModel().getUniqueName().getName());
        IFile file = project.getFile(new Path(element.getUniqueName().getLocation()).removeFirstSegments(1));
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static IFolder getFolder(Element element) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(element.getModel().getUniqueName().getName());
        if (element.getUniqueName().getLocation() == null || element.getUniqueName().getLocation().length() == 0) {
            return null;
        }
        try {
            IFolder folder = project.getFolder(new Path(element.getUniqueName().getLocation()).removeFirstSegments(1));
            if (folder.exists()) {
                return folder;
            }
        }
        catch (Exception e) {
            WebServiceCorePlugin.logErrorSimulated(e);
        }
        return null;
    }

    public static IProject getProject(Element element) {
        IProject project;
        if (element.getUniqueName().getDomain().equals("model") && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(element.getUniqueName().getName())).exists()) {
            return project;
        }
        return null;
    }
}

