/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.services.selena;

import com.tssap.selena.model.elements.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;

public class SelenaFileAdapter {
    public static boolean isEarFile(Element element) {
        return element.getUniqueName().getName().toLowerCase().endsWith(".ear");
    }

    public static boolean isClientAPIJarFile(Element element) {
        return element.getUniqueName().getName().startsWith(element.getModel().getUniqueName().getName()) && element.getUniqueName().getName().toLowerCase().endsWith(".jar");
    }

    public static boolean isJ2eeDescriptor(Element element) {
        return element.getUniqueName().getName().endsWith("ejb-j2ee-engine.xml") || element.getUniqueName().getName().endsWith("application-j2ee-engine.xml");
    }

    public static IFile getFile(Element element) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(element.getModel().getUniqueName().getName());
        IFile file = project.getFile(new Path(element.getUniqueName().getLocation()).removeFirstSegments(1));
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static boolean isFileElement(Element element) {
        if (element instanceof Element) {
            return SelenaFileAdapter.isEarFile(element) || SelenaFileAdapter.isClientAPIJarFile(element);
        }
        return false;
    }
}

