/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.services.resources;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class EclipseProjectService {
    private static final int SOURCE_PATH = 0;
    private static final int FILE_PATH = 1;
    static /* synthetic */ Class class$com$sap$ide$ws$core$services$resources$EclipseProjectService;

    public static void createFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                EclipseProjectService.createFolder((IFolder)parent, force, local, null);
            }
            folder.create(force, local, monitor);
        }
    }

    public static boolean checkFileExistsInProject(String projectName, String filePath) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists() && project.isAccessible()) {
            IFile file = project.getFile(filePath);
            return file.exists();
        }
        return false;
    }

    public static ICompilationUnit getCompilationUnit(String projectName, String relativeLocation, String fileName) {
        IClasspathEntry[] classpaths = MetamodelManager.getJavaProjectClassPaths((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
        int i = 0;
        while (i < classpaths.length) {
            String completePath = classpaths[i].getPath().toOSString() + File.separator + relativeLocation + File.separator + fileName;
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(completePath));
            if (file.exists()) {
                return JavaCore.createCompilationUnitFrom((IFile)file);
            }
            ++i;
        }
        return null;
    }

    public static String makeAbsolutePathProjectRelativ(String absolutePath, IProject project) {
        Path lAbsolutePath = new Path(absolutePath);
        IPath lRelativePath = lAbsolutePath.removeFirstSegments(lAbsolutePath.matchingFirstSegments((IPath)new Path(project.getLocation().toOSString())));
        return lRelativePath.setDevice(null).toString();
    }

    public static String getAbsolutePathForFileAcrossAllSourcePaths(String projectName, String relativeLocation, String fileName) {
        return EclipseProjectService.getPathForFile(projectName, relativeLocation, fileName, 1);
    }

    public static String getSourcePathForFile(String projectName, String relativeLocation, String fileName) {
        return EclipseProjectService.getPathForFile(projectName, relativeLocation, fileName, 0);
    }

    private static String getPathForFile(String projectName, String relativeLocation, String fileName, int fileOrSourcePath) {
        MetamodelManager manager = MetamodelManager.getMetamodelManager((String)projectName);
        ArrayList sourcePaths = manager.getProjectSourcePaths();
        String absolutePath = null;
        int i = 0;
        while (i < sourcePaths.size()) {
            Object sourcePath = sourcePaths.get(i);
            absolutePath = sourcePath + "\\" + relativeLocation + "\\" + fileName;
            File f = new File(absolutePath);
            if (f.exists()) {
                if (fileOrSourcePath == 0) {
                    return (String)sourcePath;
                }
                if (fileOrSourcePath == 1) {
                    return absolutePath;
                }
            }
            ++i;
        }
        return null;
    }

    public static void setNewClpEntry(Path[] libPath, IJavaProject javaProject, int type) {
        IClasspathEntry[] classPath;
        try {
            classPath = javaProject.getRawClasspath();
        }
        catch (JavaModelException jme) {
            WebServiceCorePlugin.logError(jme, class$com$sap$ide$ws$core$services$resources$EclipseProjectService == null ? (class$com$sap$ide$ws$core$services$resources$EclipseProjectService = EclipseProjectService.class$("com.sap.ide.ws.core.services.resources.EclipseProjectService")) : class$com$sap$ide$ws$core$services$resources$EclipseProjectService);
            return;
        }
        ArrayList<IClasspathEntry> newEntryList = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < libPath.length) {
            IClasspathEntry varEntryNotExported = null;
            IClasspathEntry varEntryExported = null;
            switch (type) {
                case 4: {
                    varEntryNotExported = JavaCore.newVariableEntry((IPath)libPath[i], null, null);
                    varEntryExported = JavaCore.newVariableEntry((IPath)libPath[i], null, null, (boolean)true);
                    break;
                }
                case 1: {
                    varEntryNotExported = JavaCore.newLibraryEntry((IPath)libPath[i], null, null);
                    varEntryExported = JavaCore.newLibraryEntry((IPath)libPath[i], null, null, (boolean)true);
                    break;
                }
                case 2: {
                    varEntryNotExported = JavaCore.newProjectEntry((IPath)libPath[i]);
                    break;
                }
                case 3: {
                    varEntryNotExported = JavaCore.newSourceEntry((IPath)libPath[i]);
                }
            }
            if (!(EclipseProjectService.isInClasspath(classPath, varEntryNotExported) || varEntryExported != null && EclipseProjectService.isInClasspath(classPath, varEntryExported))) {
                newEntryList.add(varEntryNotExported);
            }
            ++i;
        }
        IClasspathEntry[] newClassPath = new IClasspathEntry[classPath.length + newEntryList.size()];
        System.arraycopy(classPath, 0, newClassPath, 0, classPath.length);
        System.arraycopy(newEntryList.toArray(new IClasspathEntry[newEntryList.size()]), 0, newClassPath, classPath.length, newEntryList.size());
        try {
            javaProject.setRawClasspath(newClassPath, null);
        }
        catch (JavaModelException jme) {
            WebServiceCorePlugin.logError(jme, class$com$sap$ide$ws$core$services$resources$EclipseProjectService == null ? (class$com$sap$ide$ws$core$services$resources$EclipseProjectService = EclipseProjectService.class$("com.sap.ide.ws.core.services.resources.EclipseProjectService")) : class$com$sap$ide$ws$core$services$resources$EclipseProjectService);
        }
    }

    public static boolean isInClasspath(IClasspathEntry[] prevCp, IClasspathEntry newCpe) {
        int i = 0;
        while (i < prevCp.length) {
            if (prevCp[i].equals(newCpe) || JavaCore.getResolvedVariablePath((IPath)prevCp[i].getPath()) != null && JavaCore.getResolvedVariablePath((IPath)prevCp[i].getPath()).equals((Object)JavaCore.getResolvedVariablePath((IPath)newCpe.getPath()))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

