/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.services.filter.projects;

import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.filter.projects.JavaProjectFilter;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class JavaProjectRestrictiveFilter
extends JavaProjectFilter {
    private boolean requiresDCNature = false;
    private static final Hashtable allowedAdditionalNatures = new Hashtable();

    public JavaProjectRestrictiveFilter() {
    }

    public JavaProjectRestrictiveFilter(boolean requiresDCNature) {
        this.requiresDCNature = requiresDCNature;
    }

    protected boolean isDesiredProject(IProject project) {
        boolean foundJavaNature = false;
        boolean foundDCNature = false;
        try {
            String[] natureIds = project.getDescription().getNatureIds();
            int i = 0;
            while (i < natureIds.length) {
                if (natureIds[i].equals("org.eclipse.jdt.core.javanature")) {
                    foundJavaNature = true;
                } else {
                    boolean natureOkFlag = false;
                    if (allowedAdditionalNatures.containsKey(natureIds[i])) {
                        natureOkFlag = true;
                    }
                    if (this.requiresDCNature && natureIds[i].equals("com.sap.ide.eclipse.component.provider.dcnature")) {
                        natureOkFlag = true;
                        foundDCNature = true;
                    }
                    if (!natureOkFlag) {
                        return false;
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            WebServiceCorePlugin.logError(e, ((Object)((Object)this)).getClass());
        }
        if (this.requiresDCNature) {
            return foundDCNature && foundJavaNature;
        }
        return foundJavaNature;
    }

    static {
        allowedAdditionalNatures.put("com.tssap.selena.cmf.PatternNature", "");
        allowedAdditionalNatures.put("com.tssap.selena.cmf.TemplateNature", "");
        allowedAdditionalNatures.put("com.sap.dictionary.tools.sqlj.SQLJNature", "");
    }
}

