/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.services.filter;

import com.sap.ide.ws.core.services.filter.projects.DcProjectFilter;
import com.sap.ide.ws.core.services.filter.projects.EarProjectWsFilter;
import com.sap.ide.ws.core.services.filter.projects.EjbAssProjectWsFilter;
import com.sap.ide.ws.core.services.filter.projects.EjbProjectWsFilter;
import com.sap.ide.ws.core.services.filter.projects.JavaProjectRestrictiveFilter;
import com.sap.ide.ws.core.services.filter.projects.PortalProjectWsFilter;
import com.sap.ide.ws.core.services.filter.projects.ProxyProjectDeployableFilter;
import com.sap.ide.ws.core.services.filter.projects.ProxyProjectStandaloneFilter;
import com.sap.ide.ws.core.services.filter.projects.WebProjectWsFilter;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.filter.FilterFactory;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.filter.IMutableFilterSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class WebServiceFilterFactory {
    private static final IMutableFilterSet JAVA_NATURE_ONLY_FILTER_SET = FilterFactory.createAndFilterSet((IFilter[])new IFilter[]{new JavaProjectRestrictiveFilter()});
    private static final IMutableFilterSet JAVA_DC_NATURE_ONLY_FILTER_SET = FilterFactory.createAndFilterSet((IFilter[])new IFilter[]{new JavaProjectRestrictiveFilter(true)});
    private static final IMutableFilterSet J2EE_NATURES_ONLY_FILTER_SET = FilterFactory.createAndFilterSet((IFilter[])new IFilter[]{FilterFactory.createOrFilterSet((IFilter[])new IFilter[]{new EjbProjectWsFilter(), new EarProjectWsFilter()}), FilterFactory.createInvertingFilter((IFilter)new DcProjectFilter())});
    private static final IMutableFilterSet J2EE_DC_NATURES_ONLY_FILTER_SET = FilterFactory.createAndFilterSet((IFilter[])new IFilter[]{FilterFactory.createOrFilterSet((IFilter[])new IFilter[]{new EjbProjectWsFilter(), new EarProjectWsFilter()}), new DcProjectFilter()});
    private static final IMutableFilterSet JAVA_NATURE_OR_EJB_NATURE_SET = FilterFactory.createOrFilterSet((IFilter[])new IFilter[]{new EjbProjectWsFilter(), JAVA_NATURE_ONLY_FILTER_SET});
    private static final IMutableFilterSet JAVA_DC_NATURE_OR_EJB_DC_NATURE_SET = FilterFactory.createAndFilterSet((IFilter[])new IFilter[]{FilterFactory.createOrFilterSet((IFilter[])new IFilter[]{new EjbProjectWsFilter(), JAVA_DC_NATURE_ONLY_FILTER_SET}), new DcProjectFilter()});
    private static final IMutableFilterSet WEB_AND_DC_NATURE_SET = FilterFactory.createAndFilterSet((IFilter[])new IFilter[]{new WebProjectWsFilter(), new DcProjectFilter()});
    private static final IMutableFilterSet WEB_NATURE_SET = FilterFactory.createAndFilterSet((IFilter[])new IFilter[]{new WebProjectWsFilter()});
    private static final IMutableFilterSet EJB_JAR_NATURE_SET = FilterFactory.createOrFilterSet((IFilter[])new IFilter[]{new EjbAssProjectWsFilter()});
    private static final IMutableFilterSet EJB_NATURE_SET = FilterFactory.createAndFilterSet((IFilter[])new IFilter[]{new EjbProjectWsFilter()});
    private static final IMutableFilterSet EJB_DC_NATURE_SET = FilterFactory.createAndFilterSet((IFilter[])new IFilter[]{new EjbProjectWsFilter(), new DcProjectFilter()});
    private static final IMutableFilterSet EAR_NATURE_SET = FilterFactory.createAndFilterSet((IFilter[])new IFilter[]{new EarProjectWsFilter()});
    private static final IMutableFilterSet EAR_DC_NATURE_SET = FilterFactory.createAndFilterSet((IFilter[])new IFilter[]{new EarProjectWsFilter(), new DcProjectFilter()});
    private static final IMutableFilterSet DC_NATURE_SET = FilterFactory.createOrFilterSet((IFilter[])new IFilter[]{new DcProjectFilter()});
    private static final IMutableFilterSet DEPLOYABLE_PROXY_NATURE_SET = FilterFactory.createOrFilterSet((IFilter[])new IFilter[]{new ProxyProjectDeployableFilter()});
    private static final IMutableFilterSet STANDALONE_PROXY_NATURE_SET = FilterFactory.createOrFilterSet((IFilter[])new IFilter[]{new ProxyProjectStandaloneFilter()});
    private static final IMutableFilterSet STANDALONE_AND_DEPLOYABLE_NATURE_SET = FilterFactory.createOrFilterSet((IFilter[])new IFilter[]{new ProxyProjectStandaloneFilter(), new ProxyProjectDeployableFilter()});
    private static final IMutableFilterSet PORTAL_NATURE_SET = FilterFactory.createOrFilterSet((IFilter[])new IFilter[]{new PortalProjectWsFilter()});

    public static boolean isJavaOrEjbModuleProject(IProject project) {
        return WebServiceFilterFactory.isJavaOrEjbModuleProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isJavaOrEjbModuleProject(UniqueName uniqueName) {
        return JAVA_NATURE_OR_EJB_NATURE_SET.isAvailable(uniqueName) && !WebServiceFilterFactory.isDcProject(uniqueName);
    }

    public static boolean isJavaDcOrEjbModuleDcProject(UniqueName uniqueName) {
        return JAVA_DC_NATURE_OR_EJB_DC_NATURE_SET.isAvailable(uniqueName);
    }

    public static boolean isJavaDcOrEjbModuleDcProject(IProject project) {
        return WebServiceFilterFactory.isJavaDcOrEjbModuleDcProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isJavaOrJavaDcProject(String projectName) {
        return WebServiceFilterFactory.isJavaOrJavaDcProject(ModelAccess.createModelUniqueName((String)projectName));
    }

    public static boolean isJavaOrJavaDcProject(IProject project) {
        return WebServiceFilterFactory.isJavaOrJavaDcProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isJavaOrJavaDcProject(UniqueName uniqueName) {
        return WebServiceFilterFactory.isJavaProject(uniqueName) || WebServiceFilterFactory.isJavaDcProject(uniqueName);
    }

    public static boolean isJavaProject(UniqueName uniqueName) {
        return JAVA_NATURE_ONLY_FILTER_SET.isAvailable(uniqueName);
    }

    public static boolean isJavaProject(IProject project) {
        return WebServiceFilterFactory.isJavaProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isJavaDcProject(UniqueName uniqueName) {
        return JAVA_DC_NATURE_ONLY_FILTER_SET.isAvailable(uniqueName);
    }

    public static boolean isJavaDcProject(IProject project) {
        return WebServiceFilterFactory.isJavaDcProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isJavaDcProject(String projectName) {
        return WebServiceFilterFactory.isJavaDcProject(ModelAccess.createModelUniqueName((String)projectName));
    }

    public static boolean isEjbModuleProject(UniqueName uniqueName) {
        return EJB_NATURE_SET.isAvailable(uniqueName) && !WebServiceFilterFactory.isDcProject(uniqueName);
    }

    public static boolean isEjbModuleProject(IProject project) {
        return WebServiceFilterFactory.isEjbModuleProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isEjbModuleDcProject(UniqueName uniqueName) {
        return EJB_DC_NATURE_SET.isAvailable(uniqueName);
    }

    public static boolean isEjbModuleDcProject(IProject project) {
        return WebServiceFilterFactory.isEjbModuleDcProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isEjbModuleOrEjbModuleDcProject(String projectName) {
        return WebServiceFilterFactory.isEjbModuleOrEjbModuleDcProject(ModelAccess.createModelUniqueName((String)projectName));
    }

    public static boolean isEjbModuleOrEjbModuleDcProject(IProject project) {
        return WebServiceFilterFactory.isEjbModuleOrEjbModuleDcProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isEjbModuleOrEjbModuleDcProject(UniqueName uniqueName) {
        return WebServiceFilterFactory.isEjbModuleDcProject(uniqueName) || WebServiceFilterFactory.isEjbModuleProject(uniqueName);
    }

    public static boolean isEarProject(UniqueName uniqueName) {
        return EAR_NATURE_SET.isAvailable(uniqueName) && !WebServiceFilterFactory.isDcProject(uniqueName);
    }

    public static boolean isEarProject(IProject project) {
        return WebServiceFilterFactory.isEarProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isEarDCProject(UniqueName uniqueName) {
        return EAR_DC_NATURE_SET.isAvailable(uniqueName);
    }

    public static boolean isEarDCProject(IProject project) {
        return WebServiceFilterFactory.isEarDCProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isEarOrEarDCProject(UniqueName uniqueName) {
        return WebServiceFilterFactory.isEarDCProject(uniqueName) || WebServiceFilterFactory.isEarProject(uniqueName);
    }

    public static boolean isEarOrEarDCProject(IProject project) {
        return WebServiceFilterFactory.isEarOrEarDCProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isWebModuleProject(UniqueName uniqueName) {
        return WEB_NATURE_SET.isAvailable(uniqueName) && !WebServiceFilterFactory.isDcProject(uniqueName);
    }

    public static boolean isWebModuleProject(IProject project) {
        return WebServiceFilterFactory.isWebModuleProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isWebModuleDcProject(UniqueName uniqueName) {
        return WEB_AND_DC_NATURE_SET.isAvailable(uniqueName);
    }

    public static boolean isWebModuleDcProject(IProject project) {
        return WebServiceFilterFactory.isWebModuleDcProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isWebModuleOrWebModuleDcProject(UniqueName uniqueName) {
        return WebServiceFilterFactory.isWebModuleProject(uniqueName) || WebServiceFilterFactory.isWebModuleDcProject(uniqueName);
    }

    public static boolean isWebModuleOrWebModuleDcProject(IProject project) {
        return WebServiceFilterFactory.isWebModuleOrWebModuleDcProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isDeployableProxyProject(UniqueName uniqueName) {
        return DEPLOYABLE_PROXY_NATURE_SET.isAvailable(uniqueName) && !WebServiceFilterFactory.isDcProject(uniqueName);
    }

    public static boolean isDeployableProxyProject(IProject project) {
        return WebServiceFilterFactory.isDeployableProxyProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isDeployableProxyDCProject(UniqueName uniqueName) {
        return DEPLOYABLE_PROXY_NATURE_SET.isAvailable(uniqueName) && WebServiceFilterFactory.isDcProject(uniqueName);
    }

    public static boolean isDeployableProxyDCProject(IProject project) {
        return WebServiceFilterFactory.isDeployableProxyDCProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isDeployableProxyOrDeployableProxyDCProject(UniqueName uniqueName) {
        return WebServiceFilterFactory.isDeployableProxyProject(uniqueName) || WebServiceFilterFactory.isDeployableProxyDCProject(uniqueName);
    }

    public static boolean isDeployableProxyOrDeployableProxyDCProject(IProject project) {
        return WebServiceFilterFactory.isDeployableProxyOrDeployableProxyDCProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isStandaloneProxyProject(UniqueName uniqueName) {
        return STANDALONE_PROXY_NATURE_SET.isAvailable(uniqueName) && !WebServiceFilterFactory.isDcProject(uniqueName);
    }

    public static boolean isStandaloneProxyProject(IProject project) {
        return WebServiceFilterFactory.isStandaloneProxyProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isStandaloneProxyDCProject(UniqueName uniqueName) {
        return STANDALONE_PROXY_NATURE_SET.isAvailable(uniqueName) && WebServiceFilterFactory.isDcProject(uniqueName);
    }

    public static boolean isStandaloneProxyDCProject(IProject project) {
        return WebServiceFilterFactory.isStandaloneProxyDCProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isStandaloneProxyOrStandaloneProxyDCProject(UniqueName uniqueName) {
        return WebServiceFilterFactory.isStandaloneProxyDCProject(uniqueName) || WebServiceFilterFactory.isStandaloneProxyProject(uniqueName);
    }

    public static boolean isStandaloneProxyOrStandaloneProxyDCProject(IProject project) {
        return WebServiceFilterFactory.isStandaloneProxyOrStandaloneProxyDCProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isProxyProject(UniqueName uniqueName) {
        return WebServiceFilterFactory.isStandaloneProxyProject(uniqueName) || WebServiceFilterFactory.isDeployableProxyProject(uniqueName);
    }

    public static boolean isProxyProject(IProject project) {
        return WebServiceFilterFactory.isProxyProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isProxyDCProject(UniqueName uniqueName) {
        return WebServiceFilterFactory.isStandaloneProxyDCProject(uniqueName) || WebServiceFilterFactory.isDeployableProxyDCProject(uniqueName);
    }

    public static boolean isProxyDCProject(IProject project) {
        return WebServiceFilterFactory.isProxyDCProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isProxyOrProxyDCProject(UniqueName uniqueName) {
        return WebServiceFilterFactory.isProxyDCProject(uniqueName) || WebServiceFilterFactory.isProxyProject(uniqueName);
    }

    public static boolean isProxyOrProxyDCProject(IProject project) {
        return WebServiceFilterFactory.isProxyOrProxyDCProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isDcProject(UniqueName uniqueName) {
        return DC_NATURE_SET.isAvailable(uniqueName);
    }

    public static boolean isDcProject(IProject project) {
        return WebServiceFilterFactory.isDcProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static boolean isDcProject(String projectName) {
        return WebServiceFilterFactory.isDcProject(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
    }

    public static boolean isEndpointProject(IProject project) {
        return WebServiceFilterFactory.isJavaOrEjbModuleProject(project) || WebServiceFilterFactory.isJavaDcOrEjbModuleDcProject(project) || WebServiceFilterFactory.isPortalProject(project);
    }

    public static boolean isPortalProject(UniqueName uniqueName) {
        return PORTAL_NATURE_SET.isAvailable(uniqueName);
    }

    public static boolean isPortalProject(IProject project) {
        return WebServiceFilterFactory.isPortalProject(ModelAccess.createModelUniqueName((String)project.getName()));
    }

    public static IMutableFilterSet getJavaProjectFilterSet() {
        return JAVA_NATURE_ONLY_FILTER_SET;
    }

    public static IMutableFilterSet getJavaDcProjectFilterSet() {
        return JAVA_DC_NATURE_ONLY_FILTER_SET;
    }

    public static IMutableFilterSet getJ2eeProjectFilterSet() {
        return J2EE_NATURES_ONLY_FILTER_SET;
    }

    public static IMutableFilterSet getJ2eeDcProjectFilterSet() {
        return J2EE_DC_NATURES_ONLY_FILTER_SET;
    }

    public static IMutableFilterSet getJavaProjectOrEjbProjectFilterSet() {
        return JAVA_NATURE_OR_EJB_NATURE_SET;
    }

    public static IMutableFilterSet getStandaloneAndDeployableProxyProjectFilterSet() {
        return STANDALONE_AND_DEPLOYABLE_NATURE_SET;
    }
}

