/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.services.editors;

import com.sap.ide.metamodel.core.editor.IDevelopmentObjectEditor;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.resources.EclipseProjectService;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class MdoEditorUtils {
    static /* synthetic */ Class class$com$sap$ide$ws$core$services$editors$MdoEditorUtils;

    public static void closeEditor(MainDevelopmentObject mdo) {
        IEditorPart mdoPart = MdoEditorUtils.findEditorPartForMdo(mdo);
        MdoEditorUtils.closeEditor(mdoPart);
    }

    private static void closeEditor(IEditorPart mdoPart) {
        if (mdoPart != null) {
            mdoPart.getEditorSite().getPage().closeEditor(mdoPart, true);
        }
    }

    public static void closeInvalidMdoParts(final String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists() || !project.isOpen()) {
            new EditorGetter(){

                public IEditorPart checkEditor(IEditorPart editor) {
                    DevelopmentObject editorMdo = ((IDevelopmentObjectEditor)editor).getDevelopmentObject();
                    if (editorMdo.getMetamodel().getName().equals(projectName)) {
                        MdoEditorUtils.closeEditor(editor);
                    }
                    return null;
                }
            }.traverse();
        }
    }

    public static IEditorPart findEditorPartForMdo(final MainDevelopmentObject mdo) {
        return new EditorGetter(){

            public IEditorPart checkEditor(IEditorPart editor) {
                DevelopmentObject editorMdo = ((IDevelopmentObjectEditor)editor).getDevelopmentObject();
                if (editorMdo == mdo) {
                    return editor;
                }
                return null;
            }
        }.traverse();
    }

    public static void start(MainDevelopmentObject mdo, String editorID) {
        if (mdo == null || mdo.getName() == null || mdo.getName().length() == 0) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)WsCoreUiTexts.getString("MdoEditorUtils.notEditableError"), (String)WsCoreUiTexts.getString("MdoEditorUtils.notEditableReason"));
            return;
        }
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(mdo.getMetamodel().getName());
            IFile file = project.getFile((IPath)new Path(EclipseProjectService.makeAbsolutePathProjectRelativ(mdo.getAbsolutePath(), project)));
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null) {
                page.openEditor((IEditorInput)new FileEditorInput(file), editorID, true);
            }
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError(e, class$com$sap$ide$ws$core$services$editors$MdoEditorUtils == null ? (class$com$sap$ide$ws$core$services$editors$MdoEditorUtils = MdoEditorUtils.class$("com.sap.ide.ws.core.services.editors.MdoEditorUtils")) : class$com$sap$ide$ws$core$services$editors$MdoEditorUtils);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static abstract class EditorGetter {
        static /* synthetic */ Class class$com$sap$ide$ws$core$services$editors$MdoEditorUtils;

        private EditorGetter() {
        }

        public abstract IEditorPart checkEditor(IEditorPart var1);

        public IEditorPart traverse() {
            IEditorPart resultEditor = null;
            IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (dwindow != null) {
                try {
                    IWorkbenchPage[] pages = dwindow.getPages();
                    int i = 0;
                    while (i < pages.length) {
                        IEditorReference[] editors = pages[i].getEditorReferences();
                        int j = 0;
                        while (j < editors.length) {
                            IEditorPart editor = editors[j].getEditor(false);
                            if (editor instanceof IDevelopmentObjectEditor && (resultEditor = this.checkEditor(editor)) != null) {
                                return resultEditor;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    WebServiceCorePlugin.logError(e, class$com$sap$ide$ws$core$services$editors$MdoEditorUtils == null ? (class$com$sap$ide$ws$core$services$editors$MdoEditorUtils = EditorGetter.class$("com.sap.ide.ws.core.services.editors.MdoEditorUtils")) : class$com$sap$ide$ws$core$services$editors$MdoEditorUtils);
                }
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

