/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.services.dtr;

import com.sap.ide.metamodel.core.plugin.DtrHelper;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.dtr.CheckOutInfo;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.tssap.dii.dtri.DtriCheckedObjects;
import com.tssap.dii.dtri.DtriUtil;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class WsDtrService {
    static /* synthetic */ Class class$com$sap$ide$ws$core$services$dtr$WsDtrService;

    public static boolean isDtrRelevant(String absolutePath) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(absolutePath));
        DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)file);
        return teamProvider != null;
    }

    public static boolean checkOutFile(String absolutePath) {
        return WsDtrService.checkOutFile(absolutePath, WsDtrService.getActivityForFile(absolutePath));
    }

    public static boolean checkOutFile(String absolutePath, IVfsActivity vfsActivity) {
        return WsDtrService.checkOutFile(absolutePath, vfsActivity, (IProgressMonitor)new NullProgressMonitor());
    }

    public static boolean checkOutFile(String absolutePath, IVfsActivity vfsActivity, IProgressMonitor progressMonitor) {
        WsDtrService.refreshAllFiles(new String[]{absolutePath});
        if (vfsActivity != null) {
            return !WsDtrService.checkOutFile(new String[]{absolutePath}, vfsActivity, false, progressMonitor).hasFailedFilePaths();
        }
        return false;
    }

    public static boolean checkOutAndDelete(String absolutePath) {
        return WsDtrService.checkOutAndDelete(absolutePath, WsDtrService.getActivityForFile(absolutePath));
    }

    public static boolean checkOutAndDelete(String absolutePath, IVfsActivity vfsActivity) {
        return WsDtrService.checkOutAndDelete(absolutePath, vfsActivity, (IProgressMonitor)new NullProgressMonitor());
    }

    public static boolean checkOutAndDelete(String absolutePath, IVfsActivity vfsActivity, IProgressMonitor progressMonitor) {
        WsDtrService.refreshAllFiles(new String[]{absolutePath});
        if (vfsActivity != null) {
            return !WsDtrService.checkOutFile(new String[]{absolutePath}, vfsActivity, true, progressMonitor).hasFailedFilePaths();
        }
        return false;
    }

    public static CheckOutInfo checkOutFiles(String[] filePaths) {
        if (filePaths.length > 0) {
            return WsDtrService.checkOutFiles(filePaths, WsDtrService.getActivityForFile(filePaths[0]));
        }
        return new CheckOutInfo(new ArrayList(), new ArrayList(), null);
    }

    public static CheckOutInfo checkOutFiles(String[] filePaths, IVfsActivity vfsActivity) {
        return WsDtrService.checkOutFile(filePaths, vfsActivity, false, (IProgressMonitor)new NullProgressMonitor());
    }

    public static CheckOutInfo checkOutFiles(String[] filePaths, IVfsActivity vfsActivity, IProgressMonitor monitor) {
        if (vfsActivity == null) {
            ArrayList<String> allFailed = new ArrayList<String>();
            int i = 0;
            while (i < filePaths.length) {
                allFailed.add(filePaths[i]);
                ++i;
            }
            return new CheckOutInfo(allFailed, new ArrayList(), null);
        }
        WsDtrService.refreshAllFiles(filePaths);
        return WsDtrService.checkOutFile(filePaths, vfsActivity, false, monitor);
    }

    public static CheckOutInfo checkOutFilesAndDelete(String[] filePaths) {
        if (filePaths.length > 0) {
            return WsDtrService.checkOutFilesAndDelete(filePaths, WsDtrService.getActivityForFile(filePaths[0]));
        }
        return new CheckOutInfo(new ArrayList(), new ArrayList(), null);
    }

    public static CheckOutInfo checkOutFilesAndDelete(String[] filePaths, IVfsActivity vfsActivity) {
        if (vfsActivity == null) {
            ArrayList<String> allFailed = new ArrayList<String>();
            int i = 0;
            while (i < filePaths.length) {
                allFailed.add(filePaths[i]);
                ++i;
            }
            return new CheckOutInfo(allFailed, new ArrayList(), null);
        }
        WsDtrService.refreshAllFiles(filePaths);
        return WsDtrService.checkOutFile(filePaths, vfsActivity, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static CheckOutInfo checkOutFilesAndDelete(String[] filePaths, IVfsActivity vfsActivity, IProgressMonitor progressMonitor) {
        if (vfsActivity == null) {
            ArrayList<String> allFailed = new ArrayList<String>();
            int i = 0;
            while (i < filePaths.length) {
                allFailed.add(filePaths[i]);
                ++i;
            }
            return new CheckOutInfo(allFailed, new ArrayList(), null);
        }
        WsDtrService.refreshAllFiles(filePaths);
        return WsDtrService.checkOutFile(filePaths, vfsActivity, true, progressMonitor);
    }

    private static CheckOutInfo checkOutFile(String[] filePaths, IVfsActivity vfsActivity, boolean checkOutAndDelete, IProgressMonitor monitor) {
        List ret = null;
        ArrayList<IFile> dtrList = new ArrayList<IFile>();
        int i = 0;
        while (i < filePaths.length) {
            Path path = new Path(filePaths[i]);
            dtrList.add(ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path));
            ++i;
        }
        monitor.subTask("Checking repository objects...");
        CheckOutInfo checkOutInfo = new CheckOutInfo(vfsActivity);
        DtriCheckedObjects dtrCheckedObjects = DtriUtil.getDtrCheckedObjects(dtrList);
        if (dtrCheckedObjects.hasDtrRelevantObjects()) {
            ret = dtrCheckedObjects.getDtrRelevantObjectList();
            int i2 = 0;
            while (i2 < ret.size()) {
                block10: {
                    Object vfsObject = ret.get(i2);
                    if (vfsObject instanceof IVfsActivityRecordedFolderItem) {
                        IVfsActivityRecordedFolderItem vfsFile = (IVfsActivityRecordedFolderItem)vfsObject;
                        monitor.subTask("Checking activity and sync status of repository objects...");
                        try {
                            if (checkOutAndDelete && WsDtrService.isInCheckOutForDeleteState(vfsFile)) {
                                monitor.subTask("Attempting check out for delete...");
                                vfsFile.checkOutAndDelete(vfsActivity);
                            } else if (WsDtrService.isInCheckOutForEditState(vfsFile)) {
                                monitor.subTask("Attempting check out for edit...");
                                vfsFile.checkOutForEdit(vfsActivity);
                            }
                            checkOutInfo.addSucceededFilePath(vfsFile.getLocalPath());
                            monitor.subTask("Success! Processing next file...");
                            break block10;
                        }
                        catch (VfsException e) {
                            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Check Out Information", (String)("Detailed Message: " + e.getLocalizedMessage()));
                            WebServiceCorePlugin.logError(e, class$com$sap$ide$ws$core$services$dtr$WsDtrService == null ? WsDtrService.class$("com.sap.ide.ws.core.services.dtr.WsDtrService") : class$com$sap$ide$ws$core$services$dtr$WsDtrService);
                        }
                        catch (UnsupportedOperationException e) {
                            MessageDialog.openInformation((Shell)new Shell(), (String)WsCoreUiTexts.getString("MainObjects.virtualInterfaces"), (String)WsCoreUiTexts.getString("WsDtrService.warning.fileNotSyncedToHeadRev", vfsFile.getLocalPath()));
                        }
                        checkOutInfo.addFailedFilePath(vfsFile.getLocalPath());
                    }
                }
                ++i2;
            }
        }
        return checkOutInfo;
    }

    private static IVfsActivity getActivityForFile(String workspaceFilePath) {
        SelectActivityDialog selectActivityDialog = null;
        Path path = new Path(workspaceFilePath);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)file);
        if (teamProvider != null && !WsDtrService.isUserLoggedOn((IResource)file) && !DtrHelper.logon((IProject)file.getProject())) {
            return null;
        }
        IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem = DtrHelper.getVfsActivityRecordedFolderItem((DAVTeamProvider)teamProvider, (IFile)file);
        if (vfsActivityRecordedFolderItem != null) {
            IVfsWorkspace workspace = vfsActivityRecordedFolderItem.getWorkspace();
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            selectActivityDialog = new SelectActivityDialog(shell, workspace);
            if (selectActivityDialog.open() == 0) {
                IVfsActivity[] activities = selectActivityDialog.getActivitySelection();
                if (activities.length > 0) {
                    return activities[0];
                }
                return null;
            }
        }
        return null;
    }

    private static boolean isUserLoggedOn(IResource resource) {
        if (resource == null) {
            return false;
        }
        DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)resource);
        if (teamProvider == null) {
            return false;
        }
        IVersionedFileSystemManager vfsManager = teamProvider.getVFSManager();
        if (vfsManager == null) {
            return false;
        }
        IVfsContext vfsContext = vfsManager.getCurrentContext();
        if (vfsContext == null) {
            return false;
        }
        String absoluteProjectPath = teamProvider.getProject().getLocation().toOSString();
        IVfsRemoteLocator vfsRemoteLocator = vfsContext.getRemoteLocator(absoluteProjectPath);
        boolean isUserLoggedOn = vfsContext.ping(vfsRemoteLocator, 2, 2000, 20000);
        if (!isUserLoggedOn) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"DTR Log on Status Information", (String)"You are not logged on to the DTR, therefore the file cannot be checked out. If this file is not under source control, please modify the read only flag manually.");
        }
        return isUserLoggedOn;
    }

    private static boolean isInCheckOutForDeleteState(IVfsActivityRecordedFolderItem vfsRecordedItem) {
        VfsFolderItemActivityState activityState = vfsRecordedItem.getActivityState();
        if (vfsRecordedItem instanceof IVfsFolder) {
            try {
                if (!((IVfsFolder)vfsRecordedItem).isEmpty()) {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Check Out Information", (String)"The Folder you are trying to check out for delete is not empty. Check out for delete request is denied.");
                    return false;
                }
            }
            catch (VfsException e) {
                e.printStackTrace();
            }
        }
        if (vfsRecordedItem.isCheckedOutByOthers()) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Check Out Information", (String)"The File you are trying to check out/check out for delete is checked out by another user. Check out for delete request is denied.");
            return false;
        }
        if (activityState == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            return true;
        }
        if (activityState == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) {
            try {
                vfsRecordedItem.uncheckout();
                WsDtrService.deleteLocalFile(ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(vfsRecordedItem.getLocalPath())));
                return false;
            }
            catch (VfsException e) {
                WebServiceCorePlugin.logError(e, class$com$sap$ide$ws$core$services$dtr$WsDtrService == null ? (class$com$sap$ide$ws$core$services$dtr$WsDtrService = WsDtrService.class$("com.sap.ide.ws.core.services.dtr.WsDtrService")) : class$com$sap$ide$ws$core$services$dtr$WsDtrService);
            }
        } else if (activityState == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT) {
            try {
                vfsRecordedItem.uncheckout();
                return true;
            }
            catch (VfsException e) {
                WebServiceCorePlugin.logError(e, class$com$sap$ide$ws$core$services$dtr$WsDtrService == null ? (class$com$sap$ide$ws$core$services$dtr$WsDtrService = WsDtrService.class$("com.sap.ide.ws.core.services.dtr.WsDtrService")) : class$com$sap$ide$ws$core$services$dtr$WsDtrService);
            }
        }
        return true;
    }

    private static boolean isInCheckOutForEditState(IVfsActivityRecordedFolderItem vfsRecordedItem) {
        VfsFolderItemLocationState locationState = vfsRecordedItem.getLocationState();
        if (locationState != VfsFolderItemLocationState.SYNCED_TO_LATEST) {
            return false;
        }
        if (locationState == VfsFolderItemLocationState.LOCAL_ONLY) {
            return false;
        }
        VfsFolderItemActivityState activityState = vfsRecordedItem.getActivityState();
        try {
            if (vfsRecordedItem.isExclusiveCheckedOutByOthers() || vfsRecordedItem.isCheckedOutByOthers()) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Check Out Information", (String)"The File you are trying to check out/check out for edit is checked out by another user. Check out for edit request is denied.");
                return false;
            }
        }
        catch (VfsException e1) {
            WebServiceCorePlugin.logError(e1, class$com$sap$ide$ws$core$services$dtr$WsDtrService == null ? (class$com$sap$ide$ws$core$services$dtr$WsDtrService = WsDtrService.class$("com.sap.ide.ws.core.services.dtr.WsDtrService")) : class$com$sap$ide$ws$core$services$dtr$WsDtrService);
            return false;
        }
        if (activityState == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            return true;
        }
        if (activityState == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) {
            return false;
        }
        return activityState != VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT;
    }

    private static void refreshAllFiles(String[] filePaths) {
        IFile[] allFilesAsIFile = new IFile[filePaths.length];
        int i = 0;
        while (i < filePaths.length) {
            IFile file;
            allFilesAsIFile[i] = file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(filePaths[i]));
            ++i;
        }
        WsDtrService.refreshFiles(allFilesAsIFile);
    }

    private static void refreshFiles(IFile[] files) {
        if (files.length > 0) {
            DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)files[0]);
            DtrHelper.refreshFiles((DAVTeamProvider)teamProvider, (IFile[])files);
        }
    }

    private static void deleteLocalFile(IFile file) {
        if (file.isReadOnly()) {
            return;
        }
        try {
            file.delete(true, false, null);
        }
        catch (CoreException e) {
            WebServiceCorePlugin.logError(e, class$com$sap$ide$ws$core$services$dtr$WsDtrService == null ? (class$com$sap$ide$ws$core$services$dtr$WsDtrService = WsDtrService.class$("com.sap.ide.ws.core.services.dtr.WsDtrService")) : class$com$sap$ide$ws$core$services$dtr$WsDtrService);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

