/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.services.dtr;

import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.ws.core.services.dtr.CheckOutInfo;
import com.sap.ide.ws.core.services.dtr.WsDtrService;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MdoDtrService {
    public static boolean isMdoOrLanguageFileReadOnly(MainDevelopmentObject mdo) {
        if (mdo.isReadOnly()) {
            return true;
        }
        String[] languages = mdo.getTextPool().getAvailableLanguages();
        int j = 0;
        while (j < languages.length) {
            if (MdoDtrService.getLanguageFile(mdo, languages[j]).isReadOnly()) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private static IResource getLanguageFile(MainDevelopmentObject mdo, String language) {
        String languageFilePath = mdo.getTextPool().getAbsolutePath(language);
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(languageFilePath));
    }

    public static List getMdoAndLanguageFilePaths(MainDevelopmentObject mdo) {
        ArrayList<String> filePathList = new ArrayList<String>();
        filePathList.add(mdo.getAbsolutePath());
        String[] languages = mdo.getTextPool().getAvailableLanguages();
        int i = 0;
        while (i < languages.length) {
            filePathList.add(mdo.getTextPool().getAbsolutePath(languages[i]));
            ++i;
        }
        return filePathList;
    }

    public static CheckOutInfo checkOutMdoAndLanguageFiles(MainDevelopmentObject mdo) {
        List filePathList = MdoDtrService.getMdoAndLanguageFilePaths(mdo);
        return WsDtrService.checkOutFiles(filePathList.toArray(new String[filePathList.size()]));
    }
}

