/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.services.check;

import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.SeverityEnum;
import com.sap.ide.metamodel.general.i18n.I18NProblem;
import com.sap.ide.metamodel.general.i18n.I18NTextProblem;
import com.sap.ide.metamodel.general.i18n.TextPool;
import com.sap.ide.metamodel.util.RawLanguageConverter;
import com.sap.ide.ws.core.adapter.MetamodelResourceAdapter;
import com.sap.ide.ws.core.builder.result.BuildResult;

public class MdoTextChecker {
    private MdoTextChecker() {
    }

    public static void doCheck(MainDevelopmentObject[] mdos, BuildResult checkResult) {
        int i = 0;
        while (i < mdos.length) {
            TextPool lTextPool = mdos[i].getTextPool();
            if (!lTextPool.isEmpty()) {
                String lOriginalLanguage = "";
                I18NProblem[] lI18NProblems = lTextPool.validateLanguages();
                int j = 0;
                while (j < lI18NProblems.length) {
                    I18NProblem lI18NProblem = lI18NProblems[j];
                    int lSeverity = 2;
                    if (lI18NProblem.getSeverity() == SeverityEnum.WARNING) {
                        lSeverity = 1;
                    } else if (lI18NProblem.getSeverity() == SeverityEnum.ERROR || lI18NProblem.getSeverity() == SeverityEnum.FATAL) {
                        lSeverity = 0;
                    }
                    checkResult.addEntry(MetamodelResourceAdapter.mdoToResource(mdos[i]), lSeverity, "", lI18NProblem.getMessage(), "");
                    ++j;
                }
                if (RawLanguageConverter.isRawLanguageMissing((MainDevelopmentObject)mdos[i])) {
                    checkResult.addEntry(MetamodelResourceAdapter.mdoToResource(mdos[i]), 1, "", "Raw language version is missing", "Activate raw language support for project " + mdos[i].getRoot().getMetamodel().getName());
                    lOriginalLanguage = mdos[i].getMasterLanguage();
                }
                I18NTextProblem[] lI18NTextProblems = lTextPool.validateTexts(lOriginalLanguage);
                int j2 = 0;
                while (j2 < lI18NTextProblems.length) {
                    I18NTextProblem lI18NProblem = lI18NTextProblems[j2];
                    int lSeverity = 2;
                    if (lI18NProblem.getSeverity() == SeverityEnum.WARNING) {
                        lSeverity = 1;
                    } else if (lI18NProblem.getSeverity() == SeverityEnum.ERROR || lI18NProblem.getSeverity() == SeverityEnum.FATAL) {
                        lSeverity = 0;
                    }
                    checkResult.addEntry(MetamodelResourceAdapter.mdoToResource(lI18NProblem.getText().getDevelopmentObject().getMDO()), lSeverity, lI18NProblem.getText().getAttributeName(), lI18NProblem.getMessage(), "");
                    ++j2;
                }
            }
            ++i;
        }
    }
}

